/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.font;

import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.util.TextUtil;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.layout.font.FontInfo;
import com.itextpdf.layout.font.FontProvider;
import com.itextpdf.layout.font.FontSelector;
import com.itextpdf.layout.font.FontSelectorStrategy;
import com.itextpdf.layout.font.FontSet;
import java.util.ArrayList;
import java.util.List;

public class ComplexFontSelectorStrategy
extends FontSelectorStrategy {
    private PdfFont font = null;
    private FontSelector selector;

    public ComplexFontSelectorStrategy(String text, FontSelector selector, FontProvider provider, FontSet tempFonts) {
        super(text, provider, tempFonts);
        this.selector = selector;
    }

    public ComplexFontSelectorStrategy(String text, FontSelector selector, FontProvider provider) {
        super(text, provider, null);
        this.selector = selector;
    }

    @Override
    public PdfFont getCurrentFont() {
        return this.font;
    }

    @Override
    public List<Glyph> nextGlyphs() {
        this.font = null;
        int nextUnignorable = this.nextSignificantIndex();
        if (nextUnignorable < this.text.length()) {
            for (FontInfo f : this.selector.getFonts()) {
                PdfFont currentFont = this.getPdfFont(f);
                if (!currentFont.containsGlyph(this.text, nextUnignorable)) continue;
                this.font = currentFont;
                break;
            }
        }
        ArrayList<Glyph> glyphs = new ArrayList<Glyph>();
        boolean anyGlyphsAppended = false;
        if (this.font != null) {
            int codePoint;
            Character.UnicodeScript currScript;
            Character.UnicodeScript unicodeScript = this.nextSignificantUnicodeScript(nextUnignorable);
            int to = nextUnignorable;
            for (int i = nextUnignorable; !(i >= this.text.length() || ComplexFontSelectorStrategy.isSignificantUnicodeScript(currScript = Character.UnicodeScript.of(codePoint = ComplexFontSelectorStrategy.isSurrogatePair(this.text, i) ? TextUtil.convertToUtf32((String)this.text, (int)i) : (int)this.text.charAt(i))) && currScript != unicodeScript); ++i) {
                if (codePoint > 65535) {
                    // empty if block
                }
                to = ++i;
            }
            int numOfAppendedGlyphs = this.font.appendGlyphs(this.text, this.index, to, glyphs);
            boolean bl = anyGlyphsAppended = numOfAppendedGlyphs > 0;
            assert (anyGlyphsAppended);
            this.index += numOfAppendedGlyphs;
        }
        if (!anyGlyphsAppended) {
            this.font = this.getPdfFont(this.selector.bestMatch());
            if (this.index != nextUnignorable) {
                this.index += this.font.appendGlyphs(this.text, this.index, nextUnignorable - 1, glyphs);
            }
            while (this.index <= nextUnignorable && this.index < this.text.length()) {
                this.index += this.font.appendAnyGlyph(this.text, this.index, glyphs);
            }
        }
        return glyphs;
    }

    private int nextSignificantIndex() {
        int nextValidChar;
        for (nextValidChar = this.index; nextValidChar < this.text.length() && TextUtil.isWhitespaceOrNonPrintable((int)this.text.charAt(nextValidChar)); ++nextValidChar) {
        }
        return nextValidChar;
    }

    private Character.UnicodeScript nextSignificantUnicodeScript(int from) {
        for (int i = from; i < this.text.length(); ++i) {
            int codePoint;
            if (ComplexFontSelectorStrategy.isSurrogatePair(this.text, i)) {
                codePoint = TextUtil.convertToUtf32((String)this.text, (int)i);
                ++i;
            } else {
                codePoint = this.text.charAt(i);
            }
            Character.UnicodeScript unicodeScript = Character.UnicodeScript.of(codePoint);
            if (!ComplexFontSelectorStrategy.isSignificantUnicodeScript(unicodeScript)) continue;
            return unicodeScript;
        }
        return Character.UnicodeScript.COMMON;
    }

    private static boolean isSignificantUnicodeScript(Character.UnicodeScript unicodeScript) {
        return unicodeScript != Character.UnicodeScript.COMMON && unicodeScript != Character.UnicodeScript.INHERITED;
    }

    private static boolean isSurrogatePair(String text, int idx) {
        return TextUtil.isSurrogateHigh((char)text.charAt(idx)) && idx < text.length() - 1 && TextUtil.isSurrogateLow((char)text.charAt(idx + 1));
    }
}

