/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.element.Div;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.margincollapse.MarginsCollapseHandler;
import com.itextpdf.layout.margincollapse.MarginsCollapseInfo;
import com.itextpdf.layout.minmaxwidth.MinMaxWidth;
import com.itextpdf.layout.minmaxwidth.MinMaxWidthUtils;
import com.itextpdf.layout.property.OverflowPropertyValue;
import com.itextpdf.layout.property.UnitValue;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.AbstractWidthHandler;
import com.itextpdf.layout.renderer.DivRenderer;
import com.itextpdf.layout.renderer.FlexItemInfo;
import com.itextpdf.layout.renderer.FlexUtil;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.MaxMaxWidthHandler;
import com.itextpdf.layout.renderer.RotationUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FlexContainerRenderer
extends DivRenderer {
    private List<List<FlexItemInfo>> lines;

    public FlexContainerRenderer(Div modelElement) {
        super(modelElement);
    }

    @Override
    public IRenderer getNextRenderer() {
        this.logWarningIfGetNextRendererNotOverridden(FlexContainerRenderer.class, this.getClass());
        return new FlexContainerRenderer((Div)this.modelElement);
    }

    @Override
    public LayoutResult layout(LayoutContext layoutContext) {
        Rectangle layoutContextRectangle = layoutContext.getArea().getBBox();
        this.setThisAsParent(this.getChildRenderers());
        this.lines = FlexUtil.calculateChildrenRectangles(layoutContextRectangle, this);
        ArrayList previousWidths = new ArrayList();
        ArrayList previousHeights = new ArrayList();
        ArrayList previousMinHeights = new ArrayList();
        for (List<FlexItemInfo> line : this.lines) {
            for (FlexItemInfo flexItemInfo : line) {
                Rectangle rectangleWithoutBordersMarginsPaddings = AbstractRenderer.isBorderBoxSizing(flexItemInfo.getRenderer()) ? flexItemInfo.getRenderer().applyMargins(flexItemInfo.getRectangle().clone(), false) : flexItemInfo.getRenderer().applyMarginsBordersPaddings(flexItemInfo.getRectangle().clone(), false);
                previousWidths.add(flexItemInfo.getRenderer().getProperty(77));
                previousHeights.add(flexItemInfo.getRenderer().getProperty(27));
                previousMinHeights.add(flexItemInfo.getRenderer().getProperty(85));
                flexItemInfo.getRenderer().setProperty(77, UnitValue.createPointValue(rectangleWithoutBordersMarginsPaddings.getWidth()));
                flexItemInfo.getRenderer().setProperty(27, UnitValue.createPointValue(rectangleWithoutBordersMarginsPaddings.getHeight()));
                flexItemInfo.getRenderer().setProperty(85, UnitValue.createPointValue(rectangleWithoutBordersMarginsPaddings.getHeight()));
            }
        }
        LayoutResult result = super.layout(layoutContext);
        int counter = 0;
        for (List list : this.lines) {
            for (FlexItemInfo itemInfo : list) {
                itemInfo.getRenderer().setProperty(77, previousWidths.get(counter));
                itemInfo.getRenderer().setProperty(27, previousHeights.get(counter));
                itemInfo.getRenderer().setProperty(85, previousMinHeights.get(counter));
                ++counter;
            }
        }
        return result;
    }

    @Override
    public MinMaxWidth getMinMaxWidth() {
        MinMaxWidth minMaxWidth = new MinMaxWidth(FlexContainerRenderer.calculateAdditionalWidth(this));
        MaxMaxWidthHandler minMaxWidthHandler = new MaxMaxWidthHandler(minMaxWidth);
        if (!this.setMinMaxWidthBasedOnFixedWidth(minMaxWidth)) {
            Float maxWidth;
            Float minWidth = this.hasAbsoluteUnitValue(80) ? this.retrieveMinWidth(0.0f) : null;
            Float f = maxWidth = this.hasAbsoluteUnitValue(79) ? this.retrieveMaxWidth(0.0f) : null;
            if (minWidth == null || maxWidth == null) {
                this.findMinMaxWidthIfCorrespondingPropertiesAreNotSet(minMaxWidth, minMaxWidthHandler);
            }
            if (minWidth != null) {
                minMaxWidth.setChildrenMinWidth(minWidth.floatValue());
            }
            if (maxWidth == null) {
                if (minMaxWidth.getChildrenMinWidth() > minMaxWidth.getChildrenMaxWidth()) {
                    minMaxWidth.setChildrenMaxWidth(minMaxWidth.getChildrenMinWidth());
                }
            } else {
                minMaxWidth.setChildrenMaxWidth(maxWidth.floatValue());
            }
        }
        if (this.getPropertyAsFloat(55) != null) {
            return RotationUtils.countRotationMinMaxWidth(minMaxWidth, this);
        }
        return minMaxWidth;
    }

    @Override
    AbstractRenderer[] createSplitAndOverflowRenderers(int childPos, int layoutStatus, LayoutResult childResult, Map<Integer, IRenderer> waitingFloatsSplitRenderers, List<IRenderer> waitingOverflowFloatRenderers) {
        AbstractRenderer splitRenderer = this.createSplitRenderer(layoutStatus);
        AbstractRenderer overflowRenderer = this.createOverflowRenderer(layoutStatus);
        IRenderer childRenderer = this.getChildRenderers().get(childPos);
        boolean forcedPlacement = Boolean.TRUE.equals(this.getProperty(26));
        boolean metChildRenderer = false;
        for (List<FlexItemInfo> line : this.lines) {
            metChildRenderer = metChildRenderer || line.stream().anyMatch(flexItem -> flexItem.getRenderer() == childRenderer);
            for (FlexItemInfo itemInfo : line) {
                if (metChildRenderer && !forcedPlacement) {
                    overflowRenderer.addChildRenderer(itemInfo.getRenderer());
                    continue;
                }
                splitRenderer.addChildRenderer(itemInfo.getRenderer());
            }
        }
        overflowRenderer.deleteOwnProperty(26);
        return new AbstractRenderer[]{splitRenderer, overflowRenderer};
    }

    @Override
    LayoutResult processNotFullChildResult(LayoutContext layoutContext, Map<Integer, IRenderer> waitingFloatsSplitRenderers, List<IRenderer> waitingOverflowFloatRenderers, boolean wasHeightClipped, List<Rectangle> floatRendererAreas, boolean marginsCollapsingEnabled, float clearHeightCorrection, Border[] borders, UnitValue[] paddings, List<Rectangle> areas, int currentAreaPos, Rectangle layoutBox, Set<Rectangle> nonChildFloatingRendererAreas, IRenderer causeOfNothing, boolean anythingPlaced, int childPos, LayoutResult result) {
        boolean keepTogether = this.isKeepTogether(causeOfNothing);
        AbstractRenderer[] splitAndOverflowRenderers = this.createSplitAndOverflowRenderers(childPos, result.getStatus(), result, waitingFloatsSplitRenderers, waitingOverflowFloatRenderers);
        AbstractRenderer splitRenderer = splitAndOverflowRenderers[0];
        AbstractRenderer overflowRenderer = splitAndOverflowRenderers[1];
        overflowRenderer.deleteOwnProperty(26);
        if (this.isRelativePosition() && !this.positionedRenderers.isEmpty()) {
            overflowRenderer.positionedRenderers = new ArrayList<IRenderer>(this.positionedRenderers);
        }
        if (keepTogether) {
            splitRenderer = null;
            overflowRenderer.setChildRenderers(this.getChildRenderers());
        }
        this.correctFixedLayout(layoutBox);
        this.applyAbsolutePositionIfNeeded(layoutContext);
        if (Boolean.TRUE.equals(this.getPropertyAsBoolean(26)) || wasHeightClipped) {
            if (splitRenderer != null) {
                splitRenderer.setChildRenderers(this.getChildRenderers());
            }
            return new LayoutResult(1, this.getOccupiedAreaInCaseNothingWasWrappedWithFull(result, splitRenderer), splitRenderer, null, null);
        }
        this.applyPaddings(this.occupiedArea.getBBox(), paddings, true);
        this.applyBorderBox(this.occupiedArea.getBBox(), borders, true);
        this.applyMargins(this.occupiedArea.getBBox(), true);
        if (splitRenderer == null || splitRenderer.getChildRenderers().isEmpty()) {
            return new LayoutResult(3, null, null, overflowRenderer, result.getCauseOfNothing()).setAreaBreak(result.getAreaBreak());
        }
        return new LayoutResult(2, layoutContext.getArea(), splitRenderer, overflowRenderer, null).setAreaBreak(result.getAreaBreak());
    }

    LayoutArea getOccupiedAreaInCaseNothingWasWrappedWithFull(LayoutResult result, IRenderer splitRenderer) {
        return null != result.getOccupiedArea() ? result.getOccupiedArea() : splitRenderer.getOccupiedArea();
    }

    @Override
    boolean stopLayoutingChildrenIfChildResultNotFull(LayoutResult returnResult) {
        return returnResult.getStatus() != 1;
    }

    @Override
    void recalculateOccupiedAreaAfterChildLayout(Rectangle resultBBox, Float blockMaxHeight) {
        Rectangle oldBBox = this.occupiedArea.getBBox().clone();
        Rectangle recalculatedRectangle = Rectangle.getCommonRectangle((Rectangle[])new Rectangle[]{this.occupiedArea.getBBox(), resultBBox});
        this.occupiedArea.getBBox().setY(recalculatedRectangle.getY());
        this.occupiedArea.getBBox().setHeight(recalculatedRectangle.getHeight());
        if (oldBBox.getTop() < this.occupiedArea.getBBox().getTop()) {
            this.occupiedArea.getBBox().decreaseHeight(this.occupiedArea.getBBox().getTop() - oldBBox.getTop());
        }
        if (null != blockMaxHeight && this.occupiedArea.getBBox().getHeight() > blockMaxHeight.floatValue()) {
            this.occupiedArea.getBBox().moveUp(this.occupiedArea.getBBox().getHeight() - blockMaxHeight.floatValue());
            this.occupiedArea.getBBox().setHeight(blockMaxHeight.floatValue());
        }
    }

    @Override
    MarginsCollapseInfo startChildMarginsHandling(IRenderer childRenderer, Rectangle layoutBox, MarginsCollapseHandler marginsCollapseHandler) {
        return marginsCollapseHandler.startChildMarginsHandling(null, layoutBox);
    }

    @Override
    void decreaseLayoutBoxAfterChildPlacement(Rectangle layoutBox, LayoutResult result, IRenderer childRenderer) {
        layoutBox.decreaseWidth(result.getOccupiedArea().getBBox().getRight() - layoutBox.getLeft());
        layoutBox.setX(result.getOccupiedArea().getBBox().getRight());
    }

    @Override
    Rectangle recalculateLayoutBoxBeforeChildLayout(Rectangle layoutBox, IRenderer childRenderer, Rectangle initialLayoutBox) {
        FlexItemInfo childFlexItemInfo;
        Rectangle layoutBoxCopy = layoutBox.clone();
        if (childRenderer instanceof AbstractRenderer && (childFlexItemInfo = this.findFlexItemInfo((AbstractRenderer)childRenderer)) != null) {
            layoutBoxCopy.decreaseWidth(childFlexItemInfo.getRectangle().getX());
            layoutBoxCopy.moveRight(childFlexItemInfo.getRectangle().getX());
            layoutBoxCopy.decreaseHeight(childFlexItemInfo.getRectangle().getY());
        }
        return layoutBoxCopy;
    }

    private FlexItemInfo findFlexItemInfo(AbstractRenderer renderer) {
        for (List<FlexItemInfo> line : this.lines) {
            for (FlexItemInfo itemInfo : line) {
                if (!itemInfo.getRenderer().equals(renderer)) continue;
                return itemInfo;
            }
        }
        return null;
    }

    @Override
    void fixOccupiedAreaIfOverflowedX(OverflowPropertyValue overflowX, Rectangle layoutBox) {
    }

    @Override
    public void addChild(IRenderer renderer) {
        renderer.setProperty(103, (Object)OverflowPropertyValue.VISIBLE);
        super.addChild(renderer);
    }

    private void findMinMaxWidthIfCorrespondingPropertiesAreNotSet(MinMaxWidth minMaxWidth, AbstractWidthHandler minMaxWidthHandler) {
        this.setThisAsParent(this.getChildRenderers());
        for (IRenderer childRenderer : this.getChildRenderers()) {
            childRenderer.setParent(this);
            MinMaxWidth childMinMaxWidth = childRenderer instanceof AbstractRenderer ? ((AbstractRenderer)childRenderer).getMinMaxWidth() : MinMaxWidthUtils.countDefaultMinMaxWidth(childRenderer);
            minMaxWidthHandler.updateMaxChildWidth(childMinMaxWidth.getMaxWidth() + minMaxWidth.getMaxWidth());
            minMaxWidthHandler.updateMinChildWidth(childMinMaxWidth.getMinWidth() + minMaxWidth.getMinWidth());
        }
    }
}

