/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.cms;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Encodable;
import com.itextpdf.commons.bouncycastle.asn1.IASN1ObjectIdentifier;
import com.itextpdf.commons.bouncycastle.asn1.IASN1OctetString;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Sequence;
import com.itextpdf.commons.bouncycastle.asn1.IASN1TaggedObject;

public class EncapsulatedContentInfo {
    private static final IBouncyCastleFactory BC_FACTORY = BouncyCastleFactoryCreator.getFactory();
    private String eContentType = "1.2.840.113549.1.7.1";
    private IASN1OctetString eContent;

    public EncapsulatedContentInfo(String eContentType, IASN1OctetString eContent) {
        this.eContentType = eContentType;
        this.eContent = eContent;
    }

    public EncapsulatedContentInfo(String eContentType) {
        this.eContentType = eContentType;
    }

    public EncapsulatedContentInfo() {
    }

    EncapsulatedContentInfo(IASN1Sequence lencapContentInfo) {
        IASN1TaggedObject taggedElement;
        IASN1ObjectIdentifier eContentTypeOid = BC_FACTORY.createASN1ObjectIdentifier(lencapContentInfo.getObjectAt(0));
        IASN1OctetString eContentElem = null;
        if (lencapContentInfo.size() > 1 && (eContentElem = BC_FACTORY.createASN1OctetString((IASN1Encodable)(taggedElement = BC_FACTORY.createASN1TaggedObject(lencapContentInfo.getObjectAt(1))).getObject())) != null) {
            this.eContent = eContentElem;
        }
        this.eContentType = eContentTypeOid.getId();
    }

    public String getContentType() {
        return this.eContentType;
    }

    public IASN1OctetString getContent() {
        return this.eContent;
    }
}

