/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation;

import com.itextpdf.signatures.ICrlClient;
import com.itextpdf.signatures.validation.RevocationDataValidator;
import com.itextpdf.signatures.validation.context.TimeBasedContext;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ValidationCrlClient
implements ICrlClient {
    private final Map<X509CRL, RevocationDataValidator.CrlValidationInfo> crls = new HashMap<X509CRL, RevocationDataValidator.CrlValidationInfo>();

    public void addCrl(X509CRL response, Date date, TimeBasedContext context) {
        this.crls.put(response, new RevocationDataValidator.CrlValidationInfo(response, date, context));
    }

    public Map<X509CRL, RevocationDataValidator.CrlValidationInfo> getCrls() {
        return Collections.unmodifiableMap(this.crls);
    }

    @Override
    public Collection<byte[]> getEncoded(X509Certificate checkCert, String url) throws CertificateEncodingException {
        ArrayList<byte[]> byteResponses = new ArrayList<byte[]>();
        for (X509CRL response : this.crls.keySet()) {
            try {
                byteResponses.add(response.getEncoded());
            }
            catch (RuntimeException | CRLException exception) {}
        }
        return byteResponses;
    }
}

