/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.lotl;

import com.itextpdf.commons.utils.DateTimeUtil;
import com.itextpdf.signatures.validation.lotl.IServiceContext;
import com.itextpdf.signatures.validation.lotl.ServiceChronologicalInfo;
import java.security.cert.Certificate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

class CountryServiceContext
implements IServiceContext {
    private final List<Certificate> certificates = new ArrayList<Certificate>();
    private final List<ServiceChronologicalInfo> serviceChronologicalInfos = new ArrayList<ServiceChronologicalInfo>();
    private String serviceType;

    CountryServiceContext() {
    }

    @Override
    public List<Certificate> getCertificates() {
        return new ArrayList<Certificate>(this.certificates);
    }

    @Override
    public void addCertificate(Certificate certificate) {
        this.certificates.add(certificate);
    }

    String getServiceType() {
        return this.serviceType;
    }

    void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    void addServiceChronologicalInfo(ServiceChronologicalInfo serviceChronologicalInfo) {
        this.serviceChronologicalInfos.add(serviceChronologicalInfo);
    }

    ServiceChronologicalInfo getServiceChronologicalInfoByDate(long milliseconds) {
        return this.getServiceChronologicalInfoByDate(DateTimeUtil.getTimeFromMillis((long)milliseconds));
    }

    ServiceChronologicalInfo getServiceChronologicalInfoByDate(LocalDateTime time) {
        for (ServiceChronologicalInfo serviceChronologicalInfo : this.serviceChronologicalInfos) {
            if (!serviceChronologicalInfo.getServiceStatusStartingTime().isBefore(time)) continue;
            return serviceChronologicalInfo;
        }
        return null;
    }

    ServiceChronologicalInfo getCurrentChronologicalInfo() {
        return this.serviceChronologicalInfos.get(0);
    }

    int getServiceChronologicalInfosSize() {
        return this.serviceChronologicalInfos.size();
    }
}

