/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.lotl;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.commons.utils.TimerUtil;
import com.itextpdf.io.resolver.resource.DefaultResourceRetriever;
import com.itextpdf.io.resolver.resource.IResourceRetriever;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.signatures.validation.TrustedCertificatesStore;
import com.itextpdf.signatures.validation.lotl.CountrySpecificLotlFetcher;
import com.itextpdf.signatures.validation.lotl.EuropeanLotlFetcher;
import com.itextpdf.signatures.validation.lotl.EuropeanResourceFetcher;
import com.itextpdf.signatures.validation.lotl.InMemoryLotlServiceCache;
import com.itextpdf.signatures.validation.lotl.LotlFetchingProperties;
import com.itextpdf.signatures.validation.lotl.LotlServiceCache;
import com.itextpdf.signatures.validation.lotl.LotlValidator;
import com.itextpdf.signatures.validation.lotl.PivotFetcher;
import com.itextpdf.signatures.validation.lotl.XmlSignatureValidator;
import com.itextpdf.signatures.validation.report.ReportItem;
import com.itextpdf.signatures.validation.report.ValidationReport;
import java.io.IOException;
import java.net.URL;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.function.Function;
import java.util.function.LongUnaryOperator;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LotlService
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(LotlService.class);
    private LotlServiceCache cache;
    private EuropeanResourceFetcher europeanResourceFetcher = new EuropeanResourceFetcher();
    private EuropeanLotlFetcher lotlByteFetcher;
    private PivotFetcher pivotFetcher;
    private CountrySpecificLotlFetcher countrySpecificLotlFetcher;
    private boolean cacheInitialized = false;
    private Timer cacheTimer = null;
    private IResourceRetriever resourceRetriever = new LoggableResourceRetriever();
    private Function<TrustedCertificatesStore, XmlSignatureValidator> xmlSignatureValidatorFactory;
    private Supplier<LotlValidator> lotlValidatorFactory;
    private final LotlFetchingProperties lotlFetchingProperties;
    static LotlService GLOBAL_SERVICE;
    private static final Object GLOBAL_SERVICE_LOCK;

    public LotlService(LotlFetchingProperties lotlFetchingProperties) {
        this.lotlFetchingProperties = lotlFetchingProperties;
        this.cache = new InMemoryLotlServiceCache(lotlFetchingProperties.getCacheStalenessInMilliseconds(), lotlFetchingProperties.getOnCountryFetchFailureStrategy());
        this.lotlByteFetcher = new EuropeanLotlFetcher(this);
        this.pivotFetcher = new PivotFetcher(this);
        this.countrySpecificLotlFetcher = new CountrySpecificLotlFetcher(this);
        this.xmlSignatureValidatorFactory = trustedCertificatesStore -> LotlService.buildXmlSignatureValidator(trustedCertificatesStore);
        this.lotlValidatorFactory = () -> this.buildLotlValidator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeGlobalCache(LotlFetchingProperties lotlFetchingProperties) {
        Object object = GLOBAL_SERVICE_LOCK;
        synchronized (object) {
            if (GLOBAL_SERVICE != null) {
                throw new PdfException("Global LOTL service has already been initialized. You cannot initialize it again. If you want to use a different configuration, please create a new instance of LotlService with the desired properties and use it in ValidatorChainBuilder.");
            }
            GLOBAL_SERVICE = new LotlService(lotlFetchingProperties);
            GLOBAL_SERVICE.initializeCache();
        }
    }

    public static LotlService getGlobalService() {
        return GLOBAL_SERVICE;
    }

    public LotlService withLotlServiceCache(LotlServiceCache cache) {
        this.cache = cache;
        return this;
    }

    public final LotlService withCustomResourceRetriever(IResourceRetriever resourceRetriever) {
        this.resourceRetriever = resourceRetriever;
        return this;
    }

    public void initializeCache() {
        this.setupTimer();
        EuropeanLotlFetcher.Result mainLotlResult = this.lotlByteFetcher.fetch();
        if (!mainLotlResult.getLocalReport().getFailures().isEmpty()) {
            ReportItem reportItem = mainLotlResult.getLocalReport().getFailures().get(0);
            throw new PdfException(reportItem.getMessage(), (Throwable)reportItem.getExceptionCause());
        }
        EuropeanResourceFetcher.Result europeanResourceFetcherEUJournalCertificates = this.europeanResourceFetcher.getEUJournalCertificates();
        PivotFetcher.Result pivotsResult = this.pivotFetcher.downloadAndValidatePivotFiles(mainLotlResult.getLotlXml(), europeanResourceFetcherEUJournalCertificates.getCertificates());
        if (!pivotsResult.getLocalReport().getFailures().isEmpty()) {
            ReportItem failure = pivotsResult.getLocalReport().getFailures().get(0);
            throw new PdfException(failure.getMessage(), (Throwable)failure.getExceptionCause());
        }
        Map<String, CountrySpecificLotlFetcher.Result> countrySpecificResults = this.countrySpecificLotlFetcher.getAndValidateCountrySpecificLotlFiles(mainLotlResult.getLotlXml(), this);
        HashMap<String, CountrySpecificLotlFetcher.Result> resultToAddToCache = new HashMap<String, CountrySpecificLotlFetcher.Result>(countrySpecificResults.size());
        for (Map.Entry<String, CountrySpecificLotlFetcher.Result> entry : countrySpecificResults.entrySet()) {
            CountrySpecificLotlFetcher.Result countrySpecificResult = entry.getValue();
            if (countrySpecificResult.getLocalReport().getValidationResult() != ValidationReport.ValidationResult.VALID) {
                for (ReportItem log : countrySpecificResult.getLocalReport().getLogs()) {
                    log.setStatus(ReportItem.ReportItemStatus.INFO);
                }
                this.lotlFetchingProperties.getOnCountryFetchFailureStrategy().onCountryFailure(countrySpecificResult);
            }
            resultToAddToCache.put(entry.getKey(), countrySpecificResult);
        }
        this.cache.setAllValues(mainLotlResult, europeanResourceFetcherEUJournalCertificates, pivotsResult, resultToAddToCache);
        this.cacheInitialized = true;
    }

    public LotlService withPivotFetcher(PivotFetcher pivotFetcher) {
        this.pivotFetcher = pivotFetcher;
        return this;
    }

    public LotlService withCountrySpecificLotlFetcher(CountrySpecificLotlFetcher countrySpecificLotlFetcher) {
        this.countrySpecificLotlFetcher = countrySpecificLotlFetcher;
        return this;
    }

    public LotlService withEuropeanLotlFetcher(EuropeanLotlFetcher fetcher) {
        this.lotlByteFetcher = fetcher;
        return this;
    }

    public LotlService withXmlSignatureValidator(Function<TrustedCertificatesStore, XmlSignatureValidator> xmlSignatureValidatorFactory) {
        this.xmlSignatureValidatorFactory = xmlSignatureValidatorFactory;
        return this;
    }

    public LotlService withLotlValidator(Supplier<LotlValidator> lotlValidatorFactory) {
        this.lotlValidatorFactory = lotlValidatorFactory;
        return this;
    }

    public LotlService withEuropeanResourceFetcher(EuropeanResourceFetcher europeanResourceFetcher) {
        this.europeanResourceFetcher = europeanResourceFetcher;
        return this;
    }

    @Override
    public void close() {
        this.cancelTimer();
    }

    protected void setupTimer() {
        long staleNessInMillis = this.lotlFetchingProperties.getCacheStalenessInMilliseconds();
        TimerUtil.stopTimer((Timer)this.cacheTimer);
        LongUnaryOperator cacheRefreshTimer = this.lotlFetchingProperties.getRefreshIntervalCalculator();
        long refreshInterval = cacheRefreshTimer.applyAsLong(staleNessInMillis);
        this.cacheTimer = TimerUtil.newTimerWithRecurringTask(() -> this.tryAndRefreshCache(), (long)refreshInterval, (long)refreshInterval);
    }

    protected void cancelTimer() {
        if (this.cacheTimer != null) {
            TimerUtil.stopTimer((Timer)this.cacheTimer);
        }
    }

    protected void tryAndRefreshCache() {
        Map<String, CountrySpecificLotlFetcher.Result> allCountries;
        EuropeanLotlFetcher.Result mainLotlResult = null;
        boolean mainLotlFetchSuccessful = false;
        Exception mainLotlFetchException = null;
        try {
            EuropeanResourceFetcher.Result europeanResourceFetcherEUJournalCertificates = this.europeanResourceFetcher.getEUJournalCertificates();
            if (europeanResourceFetcherEUJournalCertificates.getLocalReport().getValidationResult() != ValidationReport.ValidationResult.VALID) {
                throw new PdfException(MessageFormatUtil.format((String)"Problem occurred while fetching EU Journal certificates.\n{0}", (Object[])new Object[]{europeanResourceFetcherEUJournalCertificates.getLocalReport().getFailures().get(0).getMessage()}));
            }
            this.cache.setEuropeanResourceFetcherResult(europeanResourceFetcherEUJournalCertificates);
        }
        catch (Exception e) {
            LOGGER.warn(MessageFormatUtil.format((String)"Problem occurred while fetching EU Journal certificates.\n{0}", (Object[])new Object[]{e.getMessage()}));
            return;
        }
        try {
            mainLotlResult = this.lotlByteFetcher.fetch();
            mainLotlFetchSuccessful = mainLotlResult.hasValidXml() && mainLotlResult.getLocalReport().getFailures().isEmpty();
        }
        catch (Exception e) {
            mainLotlFetchException = e;
        }
        boolean fetchPivotFilesSuccessful = false;
        PivotFetcher.Result pivotResult = null;
        Exception pivotFetchException = null;
        if (mainLotlFetchSuccessful) {
            try {
                pivotResult = this.pivotFetcher.downloadAndValidatePivotFiles(mainLotlResult.getLotlXml(), this.europeanResourceFetcher.getEUJournalCertificates().getCertificates());
                fetchPivotFilesSuccessful = pivotResult.getLocalReport().getValidationResult() == ValidationReport.ValidationResult.VALID;
            }
            catch (Exception e) {
                pivotFetchException = e;
            }
        } else {
            LOGGER.warn(MessageFormatUtil.format((String)"Unable to update cache with main Lotl file. Downloading of the main Lotl file failed.\n{0}", (Object[])new Object[]{mainLotlFetchException == null ? "" : mainLotlFetchException.getMessage()}));
        }
        if (fetchPivotFilesSuccessful) {
            this.cache.setLotlResult(mainLotlResult);
            this.cache.setPivotResult(pivotResult);
        } else {
            LOGGER.warn(MessageFormatUtil.format((String)"Unable to pivot files because of pivot file fetching failure.\n{0}", (Object[])new Object[]{pivotFetchException == null ? "" : pivotFetchException.getMessage()}));
        }
        mainLotlResult = this.cache.getLotlResult();
        try {
            allCountries = this.countrySpecificLotlFetcher.getAndValidateCountrySpecificLotlFiles(mainLotlResult.getLotlXml(), this);
        }
        catch (Exception e) {
            LOGGER.warn(MessageFormatUtil.format((String)"Problem occurred while fetching country specific Lotl files.\n{0}", (Object[])new Object[]{e.getMessage()}));
            return;
        }
        if (allCountries == null || allCountries.isEmpty()) {
            LOGGER.warn("Zero country specific Lotl files were fetched.");
            return;
        }
        for (CountrySpecificLotlFetcher.Result countrySpecificResult : allCountries.values()) {
            boolean wasCountryFetchedSuccessfully = countrySpecificResult.getLocalReport().getFailures().isEmpty();
            if (!wasCountryFetchedSuccessfully) {
                LOGGER.warn(MessageFormatUtil.format((String)"Country specific Lotl fetching with schema name \"{0}\" failed because of:\n \"{1}\"", (Object[])new Object[]{countrySpecificResult.getCountrySpecificLotl().getSchemeTerritory(), countrySpecificResult.getLocalReport()}));
                continue;
            }
            this.cache.setCountrySpecificLotlResult(countrySpecificResult);
        }
    }

    PivotFetcher.Result getAndValidatePivotFiles(byte[] lotlXml, List<Certificate> certificates) {
        PivotFetcher.Result result = this.cache.getPivotResult();
        if (result != null) {
            return result;
        }
        PivotFetcher.Result newResult = this.pivotFetcher.downloadAndValidatePivotFiles(lotlXml, certificates);
        this.cache.setPivotResult(newResult);
        return newResult;
    }

    List<CountrySpecificLotlFetcher.Result> getCountrySpecificLotlFiles(byte[] lotlXml) {
        Map<String, CountrySpecificLotlFetcher.Result> result = this.cache.getCountrySpecificLotls();
        if (result != null) {
            return new ArrayList<CountrySpecificLotlFetcher.Result>(result.values());
        }
        Map<String, CountrySpecificLotlFetcher.Result> countrySpecificLotlResults = this.countrySpecificLotlFetcher.getAndValidateCountrySpecificLotlFiles(lotlXml, this);
        for (Map.Entry<String, CountrySpecificLotlFetcher.Result> s : countrySpecificLotlResults.entrySet()) {
            boolean successful;
            boolean bl = successful = s.getValue().getLocalReport().getValidationResult() == ValidationReport.ValidationResult.VALID;
            if (!successful && !s.getValue().getLocalReport().getLogs().isEmpty()) continue;
            this.cache.setCountrySpecificLotlResult(s.getValue());
        }
        return new ArrayList<CountrySpecificLotlFetcher.Result>(countrySpecificLotlResults.values());
    }

    boolean isCacheInitialized() {
        return this.cacheInitialized;
    }

    EuropeanLotlFetcher.Result getLotlBytes() {
        EuropeanLotlFetcher.Result cachedData = this.cache.getLotlResult();
        if (cachedData != null) {
            return cachedData;
        }
        EuropeanLotlFetcher.Result data = this.lotlByteFetcher.fetch();
        this.cache.setLotlResult(data);
        return data;
    }

    EuropeanResourceFetcher.Result getEUJournalCertificates() {
        EuropeanResourceFetcher.Result cachedResult = this.cache.getEUJournalCertificates();
        if (cachedResult != null) {
            return cachedResult;
        }
        EuropeanResourceFetcher.Result result = this.europeanResourceFetcher.getEUJournalCertificates();
        this.cache.setEuropeanResourceFetcherResult(result);
        return result;
    }

    IResourceRetriever getResourceRetriever() {
        return this.resourceRetriever;
    }

    XmlSignatureValidator getXmlSignatureValidator(TrustedCertificatesStore trustedCertificatesStore) {
        return this.xmlSignatureValidatorFactory.apply(trustedCertificatesStore);
    }

    LotlFetchingProperties getLotlFetchingProperties() {
        return this.lotlFetchingProperties;
    }

    LotlValidator getLotlValidator() {
        return this.lotlValidatorFactory.get();
    }

    private static XmlSignatureValidator buildXmlSignatureValidator(TrustedCertificatesStore trustedCertificatesStore) {
        return new XmlSignatureValidator(trustedCertificatesStore);
    }

    private LotlValidator buildLotlValidator() {
        return new LotlValidator(this);
    }

    static {
        GLOBAL_SERVICE_LOCK = new Object();
    }

    private static final class LoggableResourceRetriever
    extends DefaultResourceRetriever {
        private static final Logger LOGGER = LoggerFactory.getLogger(LotlService.class);

        public byte[] getByteArrayByUrl(URL url) throws IOException {
            LOGGER.info(MessageFormatUtil.format((String)"Fetching resource from URL: {0}", (Object[])new Object[]{url}));
            return super.getByteArrayByUrl(url);
        }
    }
}

