/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.lotl;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.signatures.validation.SafeCalling;
import com.itextpdf.signatures.validation.TrustedCertificatesStore;
import com.itextpdf.signatures.validation.lotl.LotlService;
import com.itextpdf.signatures.validation.lotl.XmlCertificateRetriever;
import com.itextpdf.signatures.validation.lotl.XmlDefaultCertificateHandler;
import com.itextpdf.signatures.validation.lotl.XmlPivotsHandler;
import com.itextpdf.signatures.validation.lotl.XmlSignatureValidator;
import com.itextpdf.signatures.validation.lotl.xml.XmlSaxProcessor;
import com.itextpdf.signatures.validation.report.ReportItem;
import com.itextpdf.signatures.validation.report.ValidationReport;
import java.io.ByteArrayInputStream;
import java.net.URL;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PivotFetcher {
    private final LotlService service;

    public PivotFetcher(LotlService service) {
        this.service = service;
    }

    public Result downloadAndValidatePivotFiles(byte[] lotlXml, List<Certificate> certificates) {
        if (lotlXml == null) {
            throw new PdfException("Unable to retrieve main Lotl file. Lotl validation isn't successful.");
        }
        XmlPivotsHandler pivotsHandler = new XmlPivotsHandler();
        new XmlSaxProcessor().process(new ByteArrayInputStream(lotlXml), pivotsHandler);
        Result result = new Result();
        List<String> pivotsUrlList = pivotsHandler.getPivots();
        result.setPivotUrls(pivotsUrlList);
        ArrayList<byte[]> pivotFiles = new ArrayList<byte[]>();
        for (int i = pivotsUrlList.size() - 1; i >= 0; --i) {
            String pivotUrl = pivotsUrlList.get(i);
            SafeCalling.onExceptionLog(() -> pivotFiles.add(this.service.getResourceRetriever().getByteArrayByUrl(new URL(pivotUrl))), result.getLocalReport(), e -> new ReportItem("Lotl validation.", MessageFormatUtil.format((String)"Unable to retrieve pivot Lotl with {0} url. Lotl validation isn't successful.", (Object[])new Object[]{pivotUrl}), (Exception)e, ReportItem.ReportItemStatus.INVALID));
            if (result.getLocalReport().getValidationResult() == ValidationReport.ValidationResult.VALID) continue;
            return result;
        }
        List<Certificate> trustedCertificates = certificates;
        pivotFiles.add(lotlXml);
        for (byte[] pivotFile : pivotFiles) {
            TrustedCertificatesStore trustedCertificatesStore = new TrustedCertificatesStore();
            trustedCertificatesStore.addGenerallyTrustedCertificates(trustedCertificates);
            if (pivotFile == null) {
                result.getLocalReport().addReportItem(new ReportItem("Lotl validation.", "Lotl chain validation wasn't successful, trusted certificates were not parsed.", ReportItem.ReportItemStatus.INVALID));
                return result;
            }
            XmlSignatureValidator xmlSignatureValidator = this.service.getXmlSignatureValidator(trustedCertificatesStore);
            ValidationReport localReport = xmlSignatureValidator.validate(new ByteArrayInputStream(pivotFile));
            if (localReport.getValidationResult() != ValidationReport.ValidationResult.VALID) {
                result.getLocalReport().addReportItem(new ReportItem("Lotl validation.", "Lotl chain validation wasn't successful, trusted certificates were not parsed.", ReportItem.ReportItemStatus.INVALID));
                result.getLocalReport().merge(localReport);
                return result;
            }
            XmlCertificateRetriever certificateRetriever = new XmlCertificateRetriever(new XmlDefaultCertificateHandler());
            trustedCertificates = certificateRetriever.getCertificates(new ByteArrayInputStream(pivotFile));
        }
        return result;
    }

    public static class Result {
        private ValidationReport localReport = new ValidationReport();
        private List<String> pivotsUrlList = new ArrayList<String>();

        public ValidationReport getLocalReport() {
            return this.localReport;
        }

        public void setLocalReport(ValidationReport localReport) {
            this.localReport = localReport;
        }

        public List<String> getPivotUrls() {
            return Collections.unmodifiableList(this.pivotsUrlList);
        }

        public void setPivotUrls(List<String> pivotsUrlList) {
            this.pivotsUrlList = pivotsUrlList;
        }

        public String generateUniqueIdentifier() {
            return String.join((CharSequence)"_", this.pivotsUrlList);
        }
    }
}

