/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.svg;

import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.tool.xml.XMLWorker;
import com.itextpdf.tool.xml.XMLWorkerHelper;
import com.itextpdf.tool.xml.css.CSSFileWrapper;
import com.itextpdf.tool.xml.css.CssFile;
import com.itextpdf.tool.xml.css.CssFileProcessor;
import com.itextpdf.tool.xml.css.CssFilesImpl;
import com.itextpdf.tool.xml.css.StyleAttrCSSResolver;
import com.itextpdf.tool.xml.exceptions.RuntimeWorkerException;
import com.itextpdf.tool.xml.html.TagProcessorFactory;
import com.itextpdf.tool.xml.parser.XMLParser;
import com.itextpdf.tool.xml.pipeline.css.CSSResolver;
import com.itextpdf.tool.xml.pipeline.css.CssResolverPipeline;
import com.itextpdf.tool.xml.svg.PdfTemplatePipeline;
import com.itextpdf.tool.xml.svg.SvgPipeline;
import com.itextpdf.tool.xml.svg.SvgPipelineContext;
import com.itextpdf.tool.xml.svg.SvgTags;
import com.itextpdf.tool.xml.svg.css.StyleAttrSvgCSSResolver;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class XMLHelperForSVG {
    private static XMLHelperForSVG myself = new XMLHelperForSVG();
    private TagProcessorFactory tpf;
    private CssFile defaultCssFile;

    public static synchronized XMLHelperForSVG getInstance() {
        return myself;
    }

    private XMLHelperForSVG() {
    }

    public synchronized CssFile getDefaultCSS() {
        InputStream in;
        if (null == this.defaultCssFile && null != (in = XMLWorkerHelper.class.getResourceAsStream("/default.css"))) {
            CssFileProcessor cssFileProcessor = new CssFileProcessor();
            int i = -1;
            try {
                while (-1 != (i = in.read())) {
                    cssFileProcessor.process((char)i);
                }
                this.defaultCssFile = new CSSFileWrapper(cssFileProcessor.getCss(), true);
            }
            catch (IOException e) {
                throw new RuntimeWorkerException(e);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new RuntimeWorkerException(e);
                }
            }
        }
        return this.defaultCssFile;
    }

    public PdfTemplate parseToTemplate(PdfContentByte cb, Reader in) throws IOException {
        CssFilesImpl cssFiles = new CssFilesImpl();
        cssFiles.add(this.getDefaultCSS());
        StyleAttrSvgCSSResolver cssResolver = new StyleAttrSvgCSSResolver(cssFiles);
        SvgPipelineContext hpc = new SvgPipelineContext();
        hpc.setTagFactory(this.getDefaultTagProcessorFactory());
        PdfTemplatePipeline templatePipeline = new PdfTemplatePipeline(cb);
        CssResolverPipeline pipeline = new CssResolverPipeline(cssResolver, new SvgPipeline(hpc, templatePipeline));
        XMLWorker worker = new XMLWorker(pipeline, true);
        XMLParser p = new XMLParser();
        p.addListener(worker);
        p.parse(in);
        return templatePipeline.getTemplate();
    }

    public CSSResolver getDefaultCssResolver(boolean addDefaultCss) {
        StyleAttrCSSResolver resolver = new StyleAttrCSSResolver();
        if (addDefaultCss) {
            resolver.addCss(this.getDefaultCSS());
        }
        return resolver;
    }

    protected synchronized TagProcessorFactory getDefaultTagProcessorFactory() {
        if (null == this.tpf) {
            this.tpf = SvgTags.getSvgTagProcessorFactory();
        }
        return this.tpf;
    }
}

