/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.svg;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathItem {
    public static final char LINE = 'L';
    public static final char MOVE = 'M';
    public static final char LINE_RELATIVE = 'l';
    public static final char CUBIC_BEZIER = 'C';
    public static final char QUADRATIC_BEZIER = 'Q';
    public static final char ARC = 'A';
    private char type;
    private List<Float> coordinates;

    public PathItem(List<Float> coordinates, char type) {
        this.type = type;
        this.coordinates = coordinates;
    }

    public boolean isMoveTo() {
        return this.type == 'M' || this.type == 'm';
    }

    public boolean isCubicBezier() {
        return this.type == 'C' || this.type == 'c';
    }

    public boolean isCubicBezierShorthand() {
        return this.type == 'S' || this.type == 's';
    }

    public boolean isQuadraticBezier() {
        return this.type == 'Q' || this.type == 'q';
    }

    public boolean isQuadraticBezierShorthand() {
        return this.type == 'T' || this.type == 't';
    }

    public boolean isArcTo() {
        return this.type == 'A' || this.type == 'a';
    }

    public boolean isLineTo() {
        return this.type == 'L' || this.type == 'l';
    }

    public boolean isVerticalLineTo() {
        return this.type == 'V' || this.type == 'v';
    }

    public boolean isHorizontalLineTo() {
        return this.type == 'H' || this.type == 'h';
    }

    public boolean isClosePath() {
        return this.type == 'z' || this.type == 'Z';
    }

    public boolean isRelative() {
        return Character.isLowerCase(this.type);
    }

    public char getType() {
        return this.type;
    }

    public List<Float> getCoordinates() {
        return this.coordinates;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append(this.type).append(this.coordinates);
        return str.toString();
    }

    public static class Builder {
        private char type;
        private List<Float> coordinates = new ArrayList<Float>();

        public void addCoordinate(String number) {
            try {
                this.coordinates.add(Float.valueOf(Float.parseFloat(number)));
            }
            catch (Exception exp) {
                this.coordinates.add(Float.valueOf(0.0f));
            }
        }

        public void setType(char type) {
            this.type = type;
        }

        public PathItem build() {
            return new PathItem(this.coordinates, this.type);
        }
    }
}

