/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.css;

import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.css.CssInheritanceRules;
import java.util.Arrays;
import java.util.List;

public class DefaultCssInheritanceRules
implements CssInheritanceRules {
    private static final List<String> GLOBAL = Arrays.asList("width", "height", "min-width", "max-width", "min-height", "max-height", "margin", "margin-left", "margin-right", "margin-top", "margin-bottom", "padding", "padding-left", "padding-right", "padding-top", "padding-bottom", "border-top-width", "border-top-style", "border-top-color", "border-bottom-width", "border-bottom-style", "border-bottom-color", "border-left-width", "border-left-style", "border-left-color", "border-right-width", "border-right-style", "border-right-color", "page-break-before", "page-break-after", "left", "top", "right", "bottom", "position");
    private static final List<String> PARENT_TO_TABLE = Arrays.asList("line-height", "font-size", "font-style", "font-weight", "text-indent", "cellpadding", "cellpadding-left", "cellpadding-top", "cellpadding-right", "cellpadding-bottom");
    private static final List<String> TABLE_IN_ROW = Arrays.asList("background-color");
    private static final List<String> DIV_TO_CONTENT = Arrays.asList("background", "background-color", "float");
    private static final List<String> TD_TO_CONTENT = Arrays.asList("vertical-align");

    public boolean inheritCssTag(String tag) {
        return true;
    }

    public boolean inheritCssSelector(Tag tag, String key) {
        if (GLOBAL.contains(key)) {
            return false;
        }
        if ("table".equals(tag.getName())) {
            return !PARENT_TO_TABLE.contains(key);
        }
        if ("table".equals(tag.getParent().getName())) {
            return !TABLE_IN_ROW.contains(key);
        }
        if ("td".equalsIgnoreCase(tag.getParent().getName())) {
            return !TD_TO_CONTENT.contains(key);
        }
        if ("div".equalsIgnoreCase(tag.getParent().getName())) {
            return !DIV_TO_CONTENT.contains(key);
        }
        return true;
    }
}

