/*
 * Decompiled with CFR 0.152.
 */
package com.j256.testcheckpublisher.plugin;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.j256.testcheckpublisher.plugin.PublishedTestResults;
import com.j256.testcheckpublisher.plugin.ResultPoster;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.maven.plugin.logging.Log;

public class ServerResultPoster
implements ResultPoster {
    private final String serverUrl;
    private final Log log;

    public ServerResultPoster(String serverUrl, Log log) {
        this.serverUrl = serverUrl;
        this.log = log;
    }

    @Override
    public void postResults(PublishedTestResults results) throws IOException {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        Gson gson = new GsonBuilder().create();
        HttpPost post = new HttpPost(this.serverUrl);
        post.setEntity((HttpEntity)new StringEntity(gson.toJson((Object)results)));
        try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)post);
             BufferedReader reader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));){
            if (response.getStatusLine().getStatusCode() == 200) {
                this.log.info((CharSequence)("Posted test-check-publisher plugin results to server: " + results.asString()));
            } else {
                String line;
                this.log.error((CharSequence)("Posting test-check-publisher plugin results has failed: " + response.getStatusLine()));
                while ((line = reader.readLine()) != null) {
                    if (line.length() <= 0) continue;
                    this.log.error((CharSequence)("Server response: " + line));
                }
                this.log.error((CharSequence)("Test results were: " + results.asString()));
            }
        }
    }
}

