/*
 * Decompiled with CFR 0.152.
 */
package com.j256.testcheckpublisher.plugin;

import com.j256.testcheckpublisher.plugin.PublishedTestResults;
import com.j256.testcheckpublisher.plugin.ResultPoster;
import com.j256.testcheckpublisher.plugin.ServerResultPoster;
import com.j256.testcheckpublisher.plugin.frameworks.FrameworkCheckGenerator;
import com.j256.testcheckpublisher.plugin.frameworks.FrameworkCheckGeneratorFactory;
import com.j256.testcheckpublisher.plugin.frameworks.FrameworkTestResults;
import com.j256.testcheckpublisher.plugin.frameworks.TestFileResult;
import com.j256.testcheckpublisher.plugin.gitcontext.GitContextFinder;
import com.j256.testcheckpublisher.plugin.gitcontext.GitContextFinderType;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="publish", requiresOnline=true)
public class TestCheckPubMojo
extends AbstractMojo {
    private static final String DEFAULT_SERVER_URL = "https://testcheckpublisher.256stuff.com/results";
    public static final String DEFAULT_SECRET_ENV_NAME = "TEST_CHECK_PUBLISHER_SECRET";
    private static final int DEFAULT_MAX_NUM_RESULTS = 50;
    private static final String MAX_NUM_RESULTS_STR = "50";
    private static final int ULTIMATE_MAX_NUM_RESULTS = 500;
    private static final String DEFAULT_SECRET_VALUE = "This setting should probably not be used for security reasons.  Use the secretEnvName instead.";
    @Parameter(defaultValue="https://testcheckpublisher.256stuff.com/results")
    private String serverUrl = "https://testcheckpublisher.256stuff.com/results";
    @Parameter(defaultValue="50")
    private int maxNumResults = 50;
    @Parameter(defaultValue="TEST_CHECK_PUBLISHER_SECRET")
    private String secretEnvName = "TEST_CHECK_PUBLISHER_SECRET";
    @Parameter(defaultValue="This setting should probably not be used for security reasons.  Use the secretEnvName instead.")
    private String secretValue;
    @Parameter(defaultValue="SUREFIRE")
    private FrameworkCheckGeneratorFactory framework = FrameworkCheckGeneratorFactory.SUREFIRE;
    @Parameter
    private GitContextFinderType context;
    @Parameter
    private File testReportDir;
    @Parameter(defaultValue=".")
    private File sourceDir;
    @Parameter
    private boolean verbose;
    @Parameter
    private String format;
    @Parameter
    private boolean ignorePass;
    private ResultPoster resultPoster;
    private boolean throwOnError;

    public void execute() throws MojoExecutionException {
        Log log = this.getLog();
        log.info((CharSequence)"Posting test-check-publisher plugin results to server...");
        try {
            this.publish(log);
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("IOException trying to publish our test checks to github", (Exception)ioe);
        }
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public void setMaxNumResults(int maxNumResults) {
        this.maxNumResults = maxNumResults;
    }

    public void setSecretEnvName(String secretEnvName) {
        this.secretEnvName = secretEnvName;
    }

    public void setSecretValue(String secretValue) {
        this.secretValue = secretValue;
    }

    public void setFramework(FrameworkCheckGeneratorFactory framework) {
        this.framework = framework;
    }

    public void setContext(GitContextFinderType context) {
        this.context = context;
    }

    public void setTestReportDir(File testReportDir) {
        this.testReportDir = testReportDir;
    }

    public void setSourceDir(File sourceDir) {
        this.sourceDir = sourceDir;
    }

    void setResultPoster(ResultPoster resultPoster) {
        this.resultPoster = resultPoster;
    }

    void setThrowOnError(boolean throwOnError) {
        this.throwOnError = throwOnError;
    }

    private void publish(Log log) throws IOException {
        GitContextFinder.GitContext gitContext;
        GitContextFinderType contextFinderType;
        String secret = this.secretValue;
        if ((secret == null || secret.equals(DEFAULT_SECRET_VALUE)) && (secret = System.getenv(this.secretEnvName)) == null) {
            log.error((CharSequence)("Could not find required env variable: " + this.secretEnvName));
            this.throwOrExit();
        }
        if ((contextFinderType = this.context) == null) {
            for (GitContextFinderType type : GitContextFinderType.values()) {
                if (!type.isRunning()) continue;
                contextFinderType = type;
                break;
            }
        }
        if ((gitContext = this.findGitContext(contextFinderType, log)) == null) {
            log.error((CharSequence)"Unable to determine git context");
            this.throwOrExit();
        }
        FrameworkCheckGenerator frameworkGenerator = this.framework.create(log);
        if (this.maxNumResults > 500) {
            this.maxNumResults = 500;
        }
        FrameworkTestResults frameworkResults = new FrameworkTestResults();
        log.debug((CharSequence)("Loading tests results from framework generator " + (Object)((Object)this.framework)));
        try {
            frameworkGenerator.loadTestResults(frameworkResults, this.testReportDir, this.sourceDir, log);
        }
        catch (Exception e) {
            log.error((CharSequence)("Problems loading test results with framework: " + (Object)((Object)this.framework)), (Throwable)e);
            this.throwOrExit();
        }
        frameworkResults.limitFileResults(this.maxNumResults, this.ignorePass);
        if (this.verbose) {
            for (TestFileResult result : frameworkResults.getFileResults()) {
                log.debug((CharSequence)("result: " + result));
            }
        }
        PublishedTestResults results = new PublishedTestResults(gitContext.getOwner(), gitContext.getRepository(), gitContext.getCommitSha(), secret, this.format, frameworkResults);
        log.debug((CharSequence)("Posting test-check-publisher plugin results to server..." + frameworkResults.asString()));
        long before = System.currentTimeMillis();
        if (this.resultPoster == null) {
            this.resultPoster = new ServerResultPoster(this.serverUrl, log);
        }
        this.resultPoster.postResults(results);
        log.debug((CharSequence)("Posting took " + (System.currentTimeMillis() - before) + " ms"));
    }

    private GitContextFinder.GitContext findGitContext(GitContextFinderType finderType, Log log) {
        GitContextFinder.GitContext gitContext = finderType.findContext(log);
        if (gitContext != null) {
            return gitContext;
        }
        GitContextFinderType defaultType = GitContextFinderType.getDefault();
        if (finderType == defaultType) {
            return null;
        }
        gitContext = defaultType.findContext(log);
        return gitContext;
    }

    private void throwOrExit() {
        if (this.throwOnError) {
            throw new IllegalStateException("Got error during testing.  See error logs.");
        }
        System.exit(1);
    }
}

