/*
 * Decompiled with CFR 0.152.
 */
package com.j256.testcheckpublisher.plugin.frameworks;

import com.j256.testcheckpublisher.plugin.frameworks.TestFileResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class FrameworkTestResults {
    private String name;
    private int numTests;
    private int numFailures;
    private int numErrors;
    private int numSkipped;
    @Deprecated
    private String format;
    private List<TestFileResult> fileResults;

    public FrameworkTestResults() {
    }

    public FrameworkTestResults(String name, int numTests, int numFailures, int numErrors, int numSkipped, List<TestFileResult> fileResults) {
        this.name = name;
        this.numTests = numTests;
        this.numFailures = numFailures;
        this.numErrors = numErrors;
        this.numSkipped = numSkipped;
        this.fileResults = fileResults;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getNumTests() {
        return this.numTests;
    }

    public int getNumFailures() {
        return this.numFailures;
    }

    public int getNumErrors() {
        return this.numErrors;
    }

    public int getNumSkipped() {
        return this.numSkipped;
    }

    @Deprecated
    public String getFormat() {
        return this.format;
    }

    @Deprecated
    public void setFormat(String format) {
        this.format = format;
    }

    public void limitFileResults(int maxNumResults, boolean ignorePass) {
        if (this.fileResults == null || this.fileResults.size() == 0) {
            return;
        }
        Collections.sort(this.fileResults);
        int count = 0;
        Iterator<TestFileResult> iterator = this.fileResults.iterator();
        while (iterator.hasNext()) {
            TestFileResult result = iterator.next();
            if (count >= maxNumResults || ignorePass && result.getTestLevel() == TestFileResult.TestLevel.NOTICE) {
                iterator.remove();
                continue;
            }
            ++count;
        }
    }

    public Collection<TestFileResult> getFileResults() {
        return this.fileResults;
    }

    public void addCounts(int numTests, int numFailures, int numErrors, int numSkipped) {
        this.numTests += numTests;
        this.numFailures += numFailures;
        this.numErrors += numErrors;
        this.numSkipped += numSkipped;
    }

    public void addFileResult(TestFileResult result) {
        if (this.fileResults == null) {
            this.fileResults = new ArrayList<TestFileResult>();
        }
        this.fileResults.add(result);
    }

    public String asString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name).append(": ");
        sb.append(this.numTests).append(" tests, ");
        sb.append(this.numFailures).append(" failures, ");
        if (this.numErrors > 0) {
            sb.append(this.numErrors).append(" errors, ");
        }
        if (this.numSkipped > 0) {
            sb.append(this.numSkipped).append(" skipped, ");
        }
        if (this.fileResults == null) {
            sb.append('0');
        } else {
            sb.append(this.fileResults.size());
        }
        sb.append(" file-results");
        return sb.toString();
    }

    public String toString() {
        return "FrameworkTestResults [name=" + this.name + ", numTests=" + this.numTests + ", numFailures=" + this.numFailures + ", numErrors=" + this.numErrors + ", numSkipped=" + this.numSkipped + ", numFileResults=" + (this.fileResults == null ? 0 : this.fileResults.size()) + "]";
    }
}

