/*
 * Decompiled with CFR 0.152.
 */
package com.j256.testcheckpublisher.plugin.frameworks;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.j256.testcheckpublisher.plugin.frameworks.FrameworkCheckGenerator;
import com.j256.testcheckpublisher.plugin.frameworks.FrameworkTestResults;
import com.j256.testcheckpublisher.plugin.frameworks.SurefireTestSuite;
import com.j256.testcheckpublisher.plugin.frameworks.TestFileResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.logging.Log;

public class SurefireFrameworkCheckGenerator
implements FrameworkCheckGenerator {
    private final ObjectMapper xmlMapper = new XmlMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private final String SUREFIRE_DIR = "target/surefire-reports";
    private final Pattern XML_PATTERN = Pattern.compile("TEST-(.*?([^.]+))\\.xml");
    private final boolean SHOW_NOTICE = true;
    private final int DEFAULT_LINE_NUMBER = 1;
    private final int DEFAULT_MAX_LINES_READ = 5000;
    private int maxLinesRead = 5000;

    @Override
    public void loadTestResults(FrameworkTestResults testResults, File testReportDir, File sourceDir, Log log) {
        if ((testReportDir = this.checkDir("Surefire test report", testReportDir, "target/surefire-reports", log)) == null) {
            return;
        }
        Map<Object, Object> fileNameMap = (sourceDir = this.checkDir("Source", sourceDir, ".", log)) == null ? Collections.emptyMap() : this.getFileNameMap(sourceDir);
        File[] files = testReportDir.listFiles();
        if (files == null || files.length == 0) {
            log.warn((CharSequence)("The surefire test report directory has no files in it: " + testReportDir));
            return;
        }
        testResults.setName("Surefire test results");
        for (File file : files) {
            SurefireTestSuite suite;
            Matcher matcher = this.XML_PATTERN.matcher(file.getName());
            if (!matcher.matches()) continue;
            String className = matcher.group(1);
            String fileName = matcher.group(2) + ".java";
            String path = className.replace('.', '/');
            try (FileReader reader = new FileReader(file);){
                suite = (SurefireTestSuite)this.xmlMapper.readValue((Reader)reader, SurefireTestSuite.class);
            }
            catch (Exception e) {
                log.error((CharSequence)("Could not parse surefire XML file: " + file), (Throwable)e);
                continue;
            }
            this.addTestSuite(testResults, suite, className, path, fileName, (File)fileNameMap.get(fileName), log);
        }
        log.debug((CharSequence)("Added results: " + testResults));
    }

    public void setMaxLinesRead(int maxLinesRead) {
        this.maxLinesRead = maxLinesRead;
    }

    private File checkDir(String label, File dir, String defaultPath, Log log) {
        if (dir == null) {
            dir = new File(defaultPath);
        }
        if (!dir.exists()) {
            log.error((CharSequence)(label + " dir does not exist: " + dir));
            return null;
        }
        if (!dir.isDirectory()) {
            log.error((CharSequence)(label + " dir is not a directory: " + dir));
            return null;
        }
        return dir;
    }

    private Map<String, File> getFileNameMap(File sourceDir) {
        HashMap<String, File> fileNameMap = new HashMap<String, File>();
        LinkedList<File> dirQueue = new LinkedList<File>();
        dirQueue.add(sourceDir);
        while (dirQueue.size() > 0) {
            File dir = (File)dirQueue.poll();
            for (File file : dir.listFiles()) {
                if (file.isDirectory()) {
                    dirQueue.add(file);
                    continue;
                }
                fileNameMap.put(file.getName(), file);
            }
        }
        return fileNameMap;
    }

    private void addTestSuite(FrameworkTestResults testResults, SurefireTestSuite suite, String className, String path, String fileName, File sourceFile, Log log) {
        testResults.addCounts(suite.getNumTests(), suite.getNumFailures(), suite.getNumErrors(), suite.getNumSkipped());
        MutableInteger sourceFileMissingCounter = new MutableInteger();
        MutableInteger tooLongCounter = new MutableInteger();
        for (SurefireTestSuite.TestCase test : suite.getTestcases()) {
            int lineNumber;
            TestFileResult.TestLevel level;
            SurefireTestSuite.Problem problem;
            SurefireTestSuite.Problem failure = test.getFailure();
            SurefireTestSuite.Problem error = test.getError();
            if (failure != null) {
                problem = failure;
                level = TestFileResult.TestLevel.FAILURE;
            } else if (error != null) {
                problem = error;
                level = TestFileResult.TestLevel.ERROR;
            } else {
                lineNumber = this.findMethodLineNumber(fileName, test.getName(), sourceFile, tooLongCounter, sourceFileMissingCounter, log);
                testResults.addFileResult(new TestFileResult(path, lineNumber, lineNumber, TestFileResult.TestLevel.NOTICE, test.timeSeconds, className + "." + test.getName(), "succeeded, no errors", null));
                continue;
            }
            lineNumber = this.findErrorLineNumber(className, problem.body);
            if (lineNumber == 1) {
                lineNumber = this.findMethodLineNumber(fileName, test.getName(), sourceFile, tooLongCounter, sourceFileMissingCounter, log);
            }
            testResults.addFileResult(new TestFileResult(path, lineNumber, lineNumber, level, test.timeSeconds, className + "." + test.getName(), problem.type + ": " + problem.message, problem.body));
        }
        if (tooLongCounter.count > 0) {
            log.debug((CharSequence)("Stopped looking for " + tooLongCounter.count + " methods after processing " + this.maxLinesRead + " lines from " + sourceFile));
        }
    }

    private int findErrorLineNumber(String className, String body) {
        int lineNum;
        if (body == null) {
            return 1;
        }
        int index = 0;
        block0: do {
            if ((index = body.indexOf(className, index)) < 0) {
                return 1;
            }
            index += className.length();
            boolean number = false;
            lineNum = 0;
            while (index < body.length()) {
                char ch = body.charAt(index++);
                if (number) {
                    if (!Character.isDigit(ch)) continue block0;
                    lineNum = lineNum * 10 + (ch - 48);
                    continue;
                }
                if (ch == ':') {
                    number = true;
                    continue;
                }
                if (!Character.isWhitespace(ch)) continue;
                continue block0;
            }
        } while (lineNum <= 0);
        return lineNum;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int findMethodLineNumber(String fileName, String methodName, File sourceFile, MutableInteger tooLongCounter, MutableInteger sourceFileMissingCounter, Log log) {
        if (sourceFile == null) {
            if (sourceFileMissingCounter.count != 0) return 1;
            log.debug((CharSequence)("Unknown test source-file name: " + fileName));
            sourceFileMissingCounter.count = 1;
            return 1;
        }
        if (!sourceFile.isFile() && sourceFileMissingCounter.count == 0) {
            log.debug((CharSequence)("Source-file is not a file: " + sourceFile));
            sourceFileMissingCounter.count = 1;
        }
        if (!sourceFile.canRead() && sourceFileMissingCounter.count == 0) {
            log.debug((CharSequence)("Source-file is not readable: " + sourceFile));
            sourceFileMissingCounter.count = 1;
        }
        Pattern methodPattern = Pattern.compile("(^|[^\\*]*\\s)" + methodName + "\\s*\\(.*");
        try {
            int lineNumber = 0;
            try (BufferedReader reader = new BufferedReader(new FileReader(sourceFile));){
                while (true) {
                    String line;
                    if ((line = reader.readLine()) == null) {
                        int n = 1;
                        return n;
                    }
                    ++lineNumber;
                    Matcher matcher = methodPattern.matcher(line);
                    if (matcher.matches()) {
                        int n = lineNumber;
                        return n;
                    }
                    if (lineNumber > this.maxLinesRead) {
                        ++tooLongCounter.count;
                        int n = 1;
                        return n;
                    }
                    continue;
                    break;
                }
            }
        }
        catch (IOException ioe) {
            log.error((CharSequence)("Could not read source-file " + sourceFile + " to find method: " + methodName), (Throwable)ioe);
            return 1;
        }
    }

    private static class MutableInteger {
        int count;

        private MutableInteger() {
        }
    }
}

