/*
 * Decompiled with CFR 0.152.
 */
package com.j256.testcheckpublisher.plugin.frameworks;

public class TestFileResult
implements Comparable<TestFileResult> {
    private final String path;
    @Deprecated
    private int lineNumber;
    private final int startLineNumber;
    private final int endLineNumber;
    private final TestLevel testLevel;
    private final float timeSeconds;
    private final String testName;
    private final String message;
    private final String details;

    public TestFileResult(String path, int startLineNumber, int endLineNumber, TestLevel testLevel, float timeSeconds, String testName, String message, String details) {
        this.path = path;
        this.startLineNumber = startLineNumber;
        this.endLineNumber = endLineNumber;
        this.testLevel = testLevel;
        this.timeSeconds = timeSeconds;
        this.testName = testName;
        this.message = message;
        this.details = details;
    }

    public String getPath() {
        return this.path;
    }

    public int getStartLineNumber() {
        if (this.startLineNumber == 0) {
            return this.lineNumber;
        }
        return this.startLineNumber;
    }

    public int getEndLineNumber() {
        if (this.endLineNumber == 0) {
            return this.lineNumber;
        }
        return this.endLineNumber;
    }

    void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public TestLevel getTestLevel() {
        return this.testLevel;
    }

    public float getTimeSeconds() {
        return this.timeSeconds;
    }

    public String getTestName() {
        return this.testName;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDetails() {
        return this.details;
    }

    @Override
    public int compareTo(TestFileResult other) {
        if (other.testLevel == null) {
            if (this.testLevel == null) {
                return 0;
            }
            return -1;
        }
        if (this.testLevel == null) {
            return 1;
        }
        int result = other.testLevel.compareValue(this.testLevel);
        if (result != 0) {
            return result;
        }
        if (this.path == null) {
            if (other.path == null) {
                return 0;
            }
            return -1;
        }
        if (other.path == null) {
            return 1;
        }
        return this.path.compareTo(other.path);
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + (this.details == null ? 0 : this.details.hashCode());
        result = 31 * result + this.getStartLineNumber();
        result = 31 * result + this.getEndLineNumber();
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.testLevel == null ? 0 : this.testLevel.hashCode());
        result = 31 * result + (this.testName == null ? 0 : this.testName.hashCode());
        result = 31 * result + Float.floatToIntBits(this.timeSeconds);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TestFileResult other = (TestFileResult)obj;
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        if (this.getStartLineNumber() != other.getStartLineNumber()) {
            return false;
        }
        if (this.getEndLineNumber() != other.getEndLineNumber()) {
            return false;
        }
        if (this.testLevel != other.testLevel) {
            return false;
        }
        if (Float.floatToIntBits(this.timeSeconds) != Float.floatToIntBits(other.timeSeconds)) {
            return false;
        }
        if (this.testName == null ? other.testName != null : !this.testName.equals(other.testName)) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        return !(this.details == null ? other.details != null : !this.details.equals(other.details));
    }

    public String toString() {
        return "TestFileResult [path=" + this.path + ", startLine=" + this.getStartLineNumber() + ", endLine=" + this.getEndLineNumber() + ", level=" + (Object)((Object)this.testLevel) + ", time=" + this.timeSeconds + ", test" + this.testName + ", message=" + this.message + ", details=" + this.details + "]";
    }

    public static enum TestLevel {
        NOTICE(1, "Notice"),
        FAILURE(2, "Failure"),
        ERROR(3, "Error");

        private final int value;
        private final String prettyString;

        private TestLevel(int value, String prettyString) {
            this.value = value;
            this.prettyString = prettyString;
        }

        public int compareValue(TestLevel other) {
            return this.value - other.value;
        }

        public String getPrettyString() {
            return this.prettyString;
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

