/*
 * Decompiled with CFR 0.152.
 */
package com.j256.testcheckpublisher.plugin.gitcontext;

import com.j256.testcheckpublisher.plugin.gitcontext.GitContextFinder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommandLineGitContextFinder
implements GitContextFinder {
    private static final Pattern REMOTE_ORGIN_URL_PATTERN = Pattern.compile("(.*:|.*://[^/]+/)([^/]+)/(.+).git");
    private static final Pattern LOG_PATTERN = Pattern.compile("commit ([^ ]+) ?.*");
    private Queue<String> testFirstLines;

    @Override
    public boolean isRunning() {
        return true;
    }

    @Override
    public GitContextFinder.GitContext findContext() {
        Object[] command = new String[]{"git", "config", "--get", "remote.origin.url"};
        String line = this.getFirstLineOfCommand((String[])command);
        if (line == null) {
            return null;
        }
        Matcher matcher = REMOTE_ORGIN_URL_PATTERN.matcher(line);
        if (!matcher.matches()) {
            System.err.println("Git config line not in correct format: " + line);
            System.err.println("Command: " + Arrays.toString(command));
            return null;
        }
        String owner = matcher.group(2);
        String repository = matcher.group(3);
        command = new String[]{"git", "log", "-1"};
        line = this.getFirstLineOfCommand((String[])command);
        if (line == null) {
            return null;
        }
        matcher = LOG_PATTERN.matcher(line);
        if (!matcher.matches()) {
            System.err.println("Git log command output not in correct format: " + line);
            System.err.println("Command: " + Arrays.toString(command));
            return null;
        }
        String commitSha = matcher.group(1);
        return new GitContextFinder.GitContext(owner, repository, commitSha);
    }

    public void setTestFirstLines(Queue<String> testFirstLines) {
        this.testFirstLines = testFirstLines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String getFirstLineOfCommand(String[] command) {
        if (this.testFirstLines != null) {
            return this.testFirstLines.poll();
        }
        Process process = null;
        try {
            String string;
            Throwable throwable;
            BufferedReader reader;
            block20: {
                block21: {
                    process = Runtime.getRuntime().exec(command);
                    reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    throwable = null;
                    String first = reader.readLine();
                    while (reader.readLine() != null) {
                    }
                    string = first;
                    if (reader == null) break block20;
                    if (throwable == null) break block21;
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block20;
                }
                reader.close();
            }
            return string;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (reader != null) {
                            if (throwable != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                reader.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (IOException ioe) {
                    System.err.println("Problems running command: " + Arrays.toString(command));
                    ioe.printStackTrace();
                    throwable = null;
                    return throwable;
                }
            }
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
    }
}

