/*
 * Decompiled with CFR 0.152.
 */
package com.j256.testcheckpublisher.plugin.gitcontext;

import com.j256.testcheckpublisher.plugin.gitcontext.CircleCiGitContextFinder;
import com.j256.testcheckpublisher.plugin.gitcontext.CommandLineGitContextFinder;
import com.j256.testcheckpublisher.plugin.gitcontext.GitContextFinder;
import com.j256.testcheckpublisher.plugin.gitcontext.TravisCiGitContextFinder;
import org.apache.maven.plugin.logging.Log;

public enum GitContextFinderType {
    CIRCLE_CI(new CircleCiGitContextFinder()),
    TRAVIS_CI(new TravisCiGitContextFinder()),
    GIT_COMMAND(new CommandLineGitContextFinder());

    private final GitContextFinder contextFinder;

    private GitContextFinderType(GitContextFinder contextFinder) {
        this.contextFinder = contextFinder;
    }

    public boolean isRunning() {
        return this.contextFinder.isRunning();
    }

    public static GitContextFinderType getDefault() {
        return GIT_COMMAND;
    }

    public GitContextFinder.GitContext findContext(Log log) {
        try {
            log.debug((CharSequence)("Finding git context using finder type: " + (Object)((Object)this)));
            GitContextFinder.GitContext context = this.contextFinder.findContext();
            if (context == null) {
                log.error((CharSequence)("Could not find context using: " + (Object)((Object)this)));
            } else {
                log.debug((CharSequence)("Git context: " + context));
            }
            return context;
        }
        catch (Exception e) {
            log.error((CharSequence)("Finding context threw with: " + (Object)((Object)this)), (Throwable)e);
            return null;
        }
    }
}

