/*
 * Decompiled with CFR 0.152.
 */
package com.jameskleeh.excel;

import com.jameskleeh.excel.Excel;
import com.jameskleeh.excel.Font;
import com.jameskleeh.excel.WorkbookCache;
import com.jameskleeh.excel.style.BorderStyleApplier;
import com.jameskleeh.excel.style.CellRangeBorderStyleApplier;
import com.jameskleeh.excel.style.CellStyleBorderStyleApplier;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.awt.Color;
import java.lang.ref.SoftReference;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellBorder;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

public class CellStyleBuilder
implements GroovyObject {
    private XSSFWorkbook workbook;
    private static final Map<XSSFWorkbook, WorkbookCache> WORKBOOK_CACHE;
    protected static final String FORMAT = "format";
    protected static final String HIDDEN = "hidden";
    protected static final String LOCKED = "locked";
    protected static final String HORIZONTAL_ALIGNMENT = "alignment";
    protected static final String VERTICAL_ALIGNMENT = "verticalAlignment";
    protected static final String WRAPPED = "wrapped";
    protected static final String ROTATION = "rotation";
    protected static final String INDENT = "indent";
    protected static final String BORDER = "border";
    protected static final String LEFT = "left";
    protected static final String RIGHT = "right";
    protected static final String TOP = "top";
    protected static final String BOTTOM = "bottom";
    protected static final String COLOR = "color";
    protected static final String STYLE = "style";
    protected static final String FONT = "font";
    protected static final String FONT_BOLD = "bold";
    protected static final String FONT_ITALIC = "italic";
    protected static final String FONT_STRIKEOUT = "strikeout";
    protected static final String FONT_UNDERLINE = "underline";
    protected static final String FONT_COLOR = "color";
    protected static final String FONT_NAME = "name";
    protected static final String FONT_SIZE = "size";
    protected static final String FILL = "fill";
    protected static final String BACKGROUND_COLOR = "backgroundColor";
    protected static final String FOREGROUND_COLOR = "foregroundColor";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    /*
     * WARNING - void declaration
     */
    public CellStyleBuilder(XSSFWorkbook xSSFWorkbook) {
        void workbook;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        void var3_3 = workbook;
        this.workbook = var3_3;
        if (!WORKBOOK_CACHE.containsKey(workbook)) {
            WORKBOOK_CACHE.put((XSSFWorkbook)workbook, new WorkbookCache((XSSFWorkbook)workbook));
        }
    }

    private static void convertBorderOptions(Map options, String key) {
        if (options.containsKey(key) && DefaultGroovyMethods.getAt((Map)options, (Object)key) instanceof BorderStyle) {
            BorderStyle border = (BorderStyle)ShortTypeHandling.castToEnum(options.remove(key), BorderStyle.class);
            options.put(key, ScriptBytecodeAdapter.createMap((Object[])new Object[]{STYLE, border}));
        }
    }

    public static void convertSimpleOptions(Map options) {
        if (DefaultTypeTransformation.booleanUnbox((Object)options)) {
            if (options.containsKey(BORDER) && DefaultGroovyMethods.getAt((Map)options, (Object)BORDER) instanceof BorderStyle) {
                BorderStyle border = (BorderStyle)ShortTypeHandling.castToEnum(options.remove(BORDER), BorderStyle.class);
                options.put(BORDER, ScriptBytecodeAdapter.createMap((Object[])new Object[]{STYLE, border}));
            }
            if (options.containsKey(FONT) && DefaultGroovyMethods.getAt((Map)options, (Object)FONT) instanceof Font) {
                Font font = (Font)ShortTypeHandling.castToEnum(options.remove(FONT), Font.class);
                LinkedHashMap fontOptions = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
                boolean bl = ScriptBytecodeAdapter.compareEqual((Object)((Object)font), (Object)((Object)Font.BOLD));
                DefaultGroovyMethods.putAt((Map)fontOptions, (Object)FONT_BOLD, (Object)bl);
                boolean bl2 = ScriptBytecodeAdapter.compareEqual((Object)((Object)font), (Object)((Object)Font.ITALIC));
                DefaultGroovyMethods.putAt((Map)fontOptions, (Object)FONT_ITALIC, (Object)bl2);
                boolean bl3 = ScriptBytecodeAdapter.compareEqual((Object)((Object)font), (Object)((Object)Font.STRIKEOUT));
                DefaultGroovyMethods.putAt((Map)fontOptions, (Object)FONT_STRIKEOUT, (Object)bl3);
                byte by = ScriptBytecodeAdapter.compareEqual((Object)((Object)font), (Object)((Object)Font.UNDERLINE)) ? (byte)1 : (byte)0;
                DefaultGroovyMethods.putAt((Map)fontOptions, (Object)FONT_UNDERLINE, (Object)by);
                LinkedHashMap linkedHashMap = fontOptions;
                DefaultGroovyMethods.putAt((Map)options, (Object)FONT, (Object)linkedHashMap);
            }
            if (options.containsKey(BORDER)) {
                Map border = (Map)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((Map)options, (Object)BORDER), Map.class);
                CellStyleBuilder.convertBorderOptions(border, LEFT);
                CellStyleBuilder.convertBorderOptions(border, RIGHT);
                CellStyleBuilder.convertBorderOptions(border, TOP);
                CellStyleBuilder.convertBorderOptions(border, BOTTOM);
            }
        }
    }

    private void setFormat(XSSFCellStyle cellStyle, Object format) {
        if (format instanceof Integer) {
            cellStyle.setDataFormat(((Integer)ScriptBytecodeAdapter.castToType((Object)format, Integer.class)).intValue());
        } else if (format instanceof String) {
            cellStyle.setDataFormat(this.workbook.getCreationHelper().createDataFormat().getFormat(ShortTypeHandling.castToString((Object)format)));
        } else {
            throw (Throwable)new IllegalArgumentException("The cell format must be an Integer or String");
        }
    }

    private void setBooleanFont(Map options, String key, Closure callable) {
        if (options.containsKey(key)) {
            if (DefaultGroovyMethods.getAt((Map)options, (Object)key) instanceof Boolean) {
                callable.call((Object)((Boolean)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((Map)options, (Object)key), Boolean.class)));
            } else {
                throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{key}, new String[]{"[font: [", ": <>]] must be a boolean"})));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setFont(XSSFCellStyle cellStyle, Object fontOptions) {
        WorkbookCache workbookCache = (WorkbookCache)ScriptBytecodeAdapter.castToType((Object)WORKBOOK_CACHE.get(this.workbook), WorkbookCache.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)workbookCache.containsFont(fontOptions))) {
            XSSFFont font = this.workbook.createFont();
            if (!(fontOptions instanceof Map)) throw (Throwable)new IllegalArgumentException("The font option must be an instance of a Map");
            Map fontMap = (Map)ScriptBytecodeAdapter.castToType((Object)fontOptions, Map.class);
            this.setBooleanFont(fontMap, FONT_BOLD, ScriptBytecodeAdapter.getMethodPointer((Object)font, (String)"setBold"));
            this.setBooleanFont(fontMap, FONT_ITALIC, ScriptBytecodeAdapter.getMethodPointer((Object)font, (String)"setItalic"));
            this.setBooleanFont(fontMap, FONT_STRIKEOUT, ScriptBytecodeAdapter.getMethodPointer((Object)font, (String)"setStrikeout"));
            if (fontMap.containsKey(FONT_UNDERLINE)) {
                Object underlineOption = DefaultGroovyMethods.getAt((Map)fontMap, (Object)FONT_UNDERLINE);
                byte underline = 0;
                if (underlineOption instanceof Byte) {
                    byte by = DefaultTypeTransformation.byteUnbox((Object)underlineOption);
                    underline = by;
                } else if (underlineOption instanceof Boolean) {
                    byte by = org.apache.poi.ss.usermodel.Font.U_SINGLE;
                    underline = by;
                } else {
                    if (!(underlineOption instanceof String)) throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{FONT_UNDERLINE}, new String[]{"[font: [", ": <>]] must be a boolean or string"})));
                    Object object = underlineOption;
                    if (ScriptBytecodeAdapter.isCase((Object)object, (Object)"single")) {
                        byte by;
                        underline = by = org.apache.poi.ss.usermodel.Font.U_SINGLE;
                    } else if (ScriptBytecodeAdapter.isCase((Object)object, (Object)"singleAccounting")) {
                        byte by;
                        underline = by = org.apache.poi.ss.usermodel.Font.U_SINGLE_ACCOUNTING;
                    } else if (ScriptBytecodeAdapter.isCase((Object)object, (Object)"double")) {
                        byte by;
                        underline = by = org.apache.poi.ss.usermodel.Font.U_DOUBLE;
                    } else {
                        byte by;
                        if (!ScriptBytecodeAdapter.isCase((Object)object, (Object)"doubleAccounting")) throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{FONT_UNDERLINE, DefaultGroovyMethods.getAt((Map)fontMap, (Object)FONT_UNDERLINE)}, new String[]{"[font: [", ": ", "]] is not a supported value"})));
                        underline = by = org.apache.poi.ss.usermodel.Font.U_DOUBLE_ACCOUNTING;
                    }
                }
                font.setUnderline(underline);
            }
            if (fontMap.containsKey(FONT_COLOR)) {
                font.setColor(this.getColor(DefaultGroovyMethods.getAt((Map)fontMap, (Object)FONT_COLOR)));
            }
            if (fontMap.containsKey(FONT_SIZE)) {
                font.setFontHeight(((Double)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((Map)fontMap, (Object)FONT_SIZE), Double.class)).doubleValue());
            }
            if (fontMap.containsKey(FONT_NAME)) {
                font.setFontName(ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt((Map)fontMap, (Object)FONT_NAME)));
            }
            workbookCache.putFont(fontOptions, font);
        }
        cellStyle.setFont((org.apache.poi.ss.usermodel.Font)workbookCache.getFont(fontOptions));
    }

    private XSSFColor getColor(Object obj) {
        Color color = null;
        if (obj instanceof Color) {
            Color color2;
            color = color2 = (Color)ScriptBytecodeAdapter.castToType((Object)obj, Color.class);
        } else if (obj instanceof String) {
            Color color3;
            Color color4;
            String hex = ShortTypeHandling.castToString((Object)obj);
            color = hex.startsWith("#") ? (color4 = Color.decode(hex)) : (color3 = Color.decode(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{obj}, new String[]{"#", ""}))));
        } else {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{obj, Color.class.getCanonicalName(), String.class.getCanonicalName()}, new String[]{"", " must be an instance of ", " or a hex ", ""})));
        }
        return new XSSFColor(color);
    }

    private BorderStyle getBorderStyle(Object obj) {
        if (obj instanceof BorderStyle) {
            return (BorderStyle)ShortTypeHandling.castToEnum((Object)obj, BorderStyle.class);
        }
        throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{BorderStyle.class.getCanonicalName()}, new String[]{"The border style must be an instance of ", ""})));
    }

    private void setBorder(Map border, XSSFCellBorder.BorderSide side, BorderStyleApplier styleApplier) {
        String KEY = side.name().toLowerCase();
        if (border.containsKey(KEY)) {
            if (DefaultGroovyMethods.getAt((Map)border, (Object)KEY) instanceof Map) {
                Map edge = (Map)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((Map)border, (Object)KEY), Map.class);
                if (edge.containsKey(COLOR)) {
                    styleApplier.applyColor(side, this.getColor(DefaultGroovyMethods.getAt((Map)edge, (Object)COLOR)));
                }
                if (edge.containsKey(STYLE)) {
                    styleApplier.applyStyle(side, this.getBorderStyle(DefaultGroovyMethods.getAt((Map)edge, (Object)STYLE)));
                }
            } else {
                styleApplier.applyStyle(side, this.getBorderStyle(DefaultGroovyMethods.getAt((Map)border, (Object)KEY)));
            }
        }
    }

    private void setHorizontalAlignment(XSSFCellStyle cellStyle, Object horizontalAlignment) {
        HorizontalAlignment hAlign = null;
        if (horizontalAlignment instanceof HorizontalAlignment) {
            HorizontalAlignment horizontalAlignment2;
            hAlign = horizontalAlignment2 = (HorizontalAlignment)ShortTypeHandling.castToEnum((Object)horizontalAlignment, HorizontalAlignment.class);
        } else if (horizontalAlignment instanceof String) {
            HorizontalAlignment horizontalAlignment3;
            hAlign = horizontalAlignment3 = HorizontalAlignment.valueOf((String)ShortTypeHandling.castToString((Object)horizontalAlignment).toUpperCase());
        }
        if (!(hAlign != null)) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{HorizontalAlignment.class.getCanonicalName()}, new String[]{"The horizontal alignment must be an instance of ", ""})));
        }
        cellStyle.setAlignment(hAlign);
    }

    private void setVerticalAlignment(XSSFCellStyle cellStyle, Object verticalAlignment) {
        VerticalAlignment vAlign = null;
        if (verticalAlignment instanceof VerticalAlignment) {
            VerticalAlignment verticalAlignment2;
            vAlign = verticalAlignment2 = (VerticalAlignment)ShortTypeHandling.castToEnum((Object)verticalAlignment, VerticalAlignment.class);
        } else if (verticalAlignment instanceof String) {
            VerticalAlignment verticalAlignment3;
            vAlign = verticalAlignment3 = VerticalAlignment.valueOf((String)ShortTypeHandling.castToString((Object)verticalAlignment).toUpperCase());
        }
        if (!(vAlign != null)) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{VerticalAlignment.class.getCanonicalName()}, new String[]{"The vertical alignment must be an instance of ", ""})));
        }
        cellStyle.setVerticalAlignment(vAlign);
    }

    private void setWrapped(XSSFCellStyle cellStyle, Object wrapped) {
        if (!(wrapped instanceof Boolean)) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{Boolean.class.getCanonicalName()}, new String[]{"The wrapped option must be an instance of ", ""})));
        }
        cellStyle.setWrapText(DefaultTypeTransformation.booleanUnbox((Object)((Boolean)ScriptBytecodeAdapter.castToType((Object)wrapped, Boolean.class))));
    }

    private void setLocked(XSSFCellStyle cellStyle, Object locked) {
        if (!(locked instanceof Boolean)) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{Boolean.class.getCanonicalName()}, new String[]{"The wrapped option must be an instance of ", ""})));
        }
        cellStyle.setLocked(DefaultTypeTransformation.booleanUnbox((Object)((Boolean)ScriptBytecodeAdapter.castToType((Object)locked, Boolean.class))));
    }

    private void setHidden(XSSFCellStyle cellStyle, Object hidden) {
        if (!(hidden instanceof Boolean)) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{Boolean.class.getCanonicalName()}, new String[]{"The wrapped option must be an instance of ", ""})));
        }
        cellStyle.setHidden(DefaultTypeTransformation.booleanUnbox((Object)((Boolean)ScriptBytecodeAdapter.castToType((Object)hidden, Boolean.class))));
    }

    private void setBorder(BorderStyleApplier styleApplier, Map border) {
        if (border.containsKey(STYLE)) {
            BorderStyle style = this.getBorderStyle(DefaultGroovyMethods.getAt((Map)border, (Object)STYLE));
            styleApplier.applyStyle(style);
        }
        if (border.containsKey(COLOR)) {
            XSSFColor color = this.getColor(DefaultGroovyMethods.getAt((Map)border, (Object)COLOR));
            styleApplier.applyColor(color);
        }
        this.setBorder(border, XSSFCellBorder.BorderSide.LEFT, styleApplier);
        this.setBorder(border, XSSFCellBorder.BorderSide.RIGHT, styleApplier);
        this.setBorder(border, XSSFCellBorder.BorderSide.BOTTOM, styleApplier);
        this.setBorder(border, XSSFCellBorder.BorderSide.TOP, styleApplier);
    }

    private void setFill(XSSFCellStyle cellStyle, Object fill) {
        FillPatternType fillPattern = null;
        if (fill instanceof FillPatternType) {
            FillPatternType fillPatternType;
            fillPattern = fillPatternType = (FillPatternType)ShortTypeHandling.castToEnum((Object)fill, FillPatternType.class);
        } else if (fill instanceof String) {
            FillPatternType fillPatternType;
            fillPattern = fillPatternType = FillPatternType.valueOf((String)ShortTypeHandling.castToString((Object)fill).toUpperCase());
        }
        if (!(fillPattern != null)) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{Short.class.getCanonicalName()}, new String[]{"The fill pattern must be an instance of ", ""})));
        }
        cellStyle.setFillPattern(fillPattern);
    }

    private void setForegroundColor(XSSFCellStyle cellStyle, Object foregroundColor) {
        if (ScriptBytecodeAdapter.compareEqual((Object)cellStyle.getFillPatternEnum(), (Object)FillPatternType.NO_FILL)) {
            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        }
        cellStyle.setFillForegroundColor(this.getColor(foregroundColor));
    }

    private void setBackgroundColor(XSSFCellStyle cellStyle, Object backgroundColor) {
        if (ScriptBytecodeAdapter.compareEqual((Object)cellStyle.getFillPatternEnum(), (Object)FillPatternType.NO_FILL)) {
            this.setForegroundColor(cellStyle, backgroundColor);
        } else {
            cellStyle.setFillBackgroundColor(this.getColor(backgroundColor));
        }
    }

    public XSSFCellStyle buildStyle(Object value, Map options) {
        XSSFCellStyle cellStyle = this.workbook.createCellStyle();
        if (options.containsKey(FORMAT)) {
            this.setFormat(cellStyle, DefaultGroovyMethods.getAt((Map)options, (Object)FORMAT));
        }
        if (options.containsKey(FONT)) {
            this.setFont(cellStyle, DefaultGroovyMethods.getAt((Map)options, (Object)FONT));
        }
        if (options.containsKey(HIDDEN)) {
            this.setHidden(cellStyle, DefaultGroovyMethods.getAt((Map)options, (Object)HIDDEN));
        }
        if (options.containsKey(LOCKED)) {
            this.setLocked(cellStyle, DefaultGroovyMethods.getAt((Map)options, (Object)LOCKED));
        }
        if (options.containsKey(WRAPPED)) {
            this.setWrapped(cellStyle, DefaultGroovyMethods.getAt((Map)options, (Object)WRAPPED));
        }
        if (options.containsKey(HORIZONTAL_ALIGNMENT)) {
            this.setHorizontalAlignment(cellStyle, DefaultGroovyMethods.getAt((Map)options, (Object)HORIZONTAL_ALIGNMENT));
        }
        if (options.containsKey(VERTICAL_ALIGNMENT)) {
            this.setVerticalAlignment(cellStyle, DefaultGroovyMethods.getAt((Map)options, (Object)VERTICAL_ALIGNMENT));
        }
        if (options.containsKey(ROTATION)) {
            cellStyle.setRotation(DefaultTypeTransformation.shortUnbox((Object)DefaultGroovyMethods.getAt((Map)options, (Object)ROTATION)));
        }
        if (options.containsKey(INDENT)) {
            cellStyle.setIndention(DefaultTypeTransformation.shortUnbox((Object)DefaultGroovyMethods.getAt((Map)options, (Object)INDENT)));
        }
        if (options.containsKey(BORDER)) {
            this.setBorder(new CellStyleBorderStyleApplier(cellStyle), (Map)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((Map)options, (Object)BORDER), Map.class));
        }
        if (options.containsKey(FILL)) {
            this.setFill(cellStyle, DefaultGroovyMethods.getAt((Map)options, (Object)FILL));
        }
        if (options.containsKey(FOREGROUND_COLOR)) {
            this.setForegroundColor(cellStyle, DefaultGroovyMethods.getAt((Map)options, (Object)FOREGROUND_COLOR));
        }
        if (options.containsKey(BACKGROUND_COLOR)) {
            this.setBackgroundColor(cellStyle, DefaultGroovyMethods.getAt((Map)options, (Object)BACKGROUND_COLOR));
        }
        return cellStyle;
    }

    private XSSFCellStyle getStyle(Object value, Map options, Map defaultOptions) {
        Map map;
        CellStyleBuilder.convertSimpleOptions(options);
        CellStyleBuilder.convertSimpleOptions(defaultOptions);
        options = map = this.merge(defaultOptions, options);
        if (!options.containsKey(FORMAT) && value != null) {
            Object format = Excel.getFormat(value.getClass());
            if (format != null) {
                options.put(FORMAT, format);
            }
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)options)) {
            WorkbookCache workbookCache = (WorkbookCache)ScriptBytecodeAdapter.castToType((Object)WORKBOOK_CACHE.get(this.workbook), WorkbookCache.class);
            Boolean bl = workbookCache.containsStyle(options);
            if (bl == null ? false : bl) {
                return workbookCache.getStyle(options);
            }
            XSSFCellStyle style = this.buildStyle(value, options);
            workbookCache.putStyle(options, style);
            return style;
        }
        return (XSSFCellStyle)ScriptBytecodeAdapter.castToType(null, XSSFCellStyle.class);
    }

    public void setStyle(Object value, XSSFCell cell, Map options, Map defaultOptions) {
        XSSFCellStyle cellStyle = this.getStyle(value, options, defaultOptions);
        if (cellStyle != null) {
            XSSFCellStyle xSSFCellStyle = cellStyle;
            cell.setCellStyle((CellStyle)xSSFCellStyle);
        }
    }

    public void setStyle(XSSFRow row, Map options, Map defaultOptions) {
        XSSFCellStyle cellStyle = this.getStyle(null, options, defaultOptions);
        if (cellStyle != null) {
            row.setRowStyle((CellStyle)cellStyle);
        }
    }

    public Map merge(Map ... sources) {
        CallSite[] callSiteArray = CellStyleBuilder.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty((Object)sources), (Object)0)) {
            return ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        }
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[1].callGetProperty((Object)sources), (Object)1)) {
                return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].call((Object)sources, (Object)0), Map.class);
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[3].callGetProperty((Object)sources), (Object)1)) {
            return (Map)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])sources, (int)0), Map.class);
        }
        public class _merge_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _merge_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _merge_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object result, Object source) {
                Reference result2 = new Reference(result);
                CallSite[] callSiteArray = _merge_closure1.$getCallSiteArray();
                public class _closure2
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference result;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure2(Object _outerInstance, Object _thisObject, Reference result) {
                        Reference reference;
                        CallSite[] callSiteArray = _closure2.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.result = reference = result;
                    }

                    public Object doCall(Object k, Object v) {
                        CallSite[] callSiteArray = _closure2.$getCallSiteArray();
                        Object object = callSiteArray[0].call(this.result.get(), k) instanceof Map ? callSiteArray[1].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].call(this.result.get(), k), Map.class)), Map.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Map)ScriptBytecodeAdapter.castToType((Object)v, Map.class)), Map.class)) : v;
                        callSiteArray[3].call(this.result.get(), k, object);
                        return object;
                    }

                    public Object call(Object k, Object v) {
                        CallSite[] callSiteArray = _closure2.$getCallSiteArray();
                        return callSiteArray[4].callCurrent((GroovyObject)this, k, v);
                    }

                    public Object getResult() {
                        CallSite[] callSiteArray = _closure2.$getCallSiteArray();
                        return this.result.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure2.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "getAt";
                        stringArray[1] = "merge";
                        stringArray[2] = "getAt";
                        stringArray[3] = "putAt";
                        stringArray[4] = "doCall";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[5];
                        _closure2.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure2.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure2.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                callSiteArray[0].call(source, (Object)new _closure2((Object)this, this.getThisObject(), result2));
                return result2.get();
            }

            public Object call(Object result, Object source) {
                Reference result2 = new Reference(result);
                CallSite[] callSiteArray = _merge_closure1.$getCallSiteArray();
                return callSiteArray[1].callCurrent((GroovyObject)this, result2.get(), source);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _merge_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "each";
                stringArray[1] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _merge_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_merge_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _merge_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[4].call((Object)sources, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), (Object)new _merge_closure1(this, this)), Map.class);
    }

    public void applyBorderToRegion(CellRangeBorderStyleApplier borderStyleApplier, Map border) {
        this.setBorder(borderStyleApplier, border);
        borderStyleApplier.setStyles();
    }

    private XSSFCellStyle getStyle(Object value, Map options) {
        return this.getStyle(value, options, null);
    }

    public void setStyle(Object value, XSSFCell cell, Map options) {
        this.setStyle(value, cell, options, null);
    }

    public void setStyle(XSSFRow row, Map options) {
        this.setStyle(row, options, null);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != CellStyleBuilder.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Map map;
        WORKBOOK_CACHE = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
    }

    public XSSFWorkbook getWorkbook() {
        return this.workbook;
    }

    public void setWorkbook(XSSFWorkbook xSSFWorkbook) {
        this.workbook = xSSFWorkbook;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "length";
        stringArray[1] = "length";
        stringArray[2] = "getAt";
        stringArray[3] = "length";
        stringArray[4] = "inject";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[5];
        CellStyleBuilder.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(CellStyleBuilder.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = CellStyleBuilder.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

