/*
 * Decompiled with CFR 0.152.
 */
package com.jameskleeh.excel.internal;

import com.jameskleeh.excel.CellFinder;
import com.jameskleeh.excel.CellStyleBuilder;
import com.jameskleeh.excel.Excel;
import com.jameskleeh.excel.Font;
import com.jameskleeh.excel.style.CellRangeBorderStyleApplier;
import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.lang.GroovyObject;
import groovy.lang.IntRange;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.awt.Color;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFHyperlink;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

public abstract class CreatesCells
implements GroovyObject {
    protected final XSSFWorkbook workbook;
    protected final XSSFSheet sheet;
    protected Map defaultOptions;
    protected final Map<Object, Integer> columnIndexes;
    protected final CellStyleBuilder styleBuilder;
    protected static final Map LINK_OPTIONS;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    /*
     * WARNING - void declaration
     */
    public CreatesCells(XSSFSheet xSSFSheet, Map map, Map<Object, Integer> map2, CellStyleBuilder cellStyleBuilder) {
        void styleBuilder;
        void columnIndexes;
        void defaultOptions;
        void sheet;
        XSSFWorkbook xSSFWorkbook;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.workbook = xSSFWorkbook = sheet.getWorkbook();
        void var7_7 = sheet;
        this.sheet = var7_7;
        void var8_8 = defaultOptions;
        this.defaultOptions = var8_8;
        void var9_9 = columnIndexes;
        this.columnIndexes = var9_9;
        void var10_10 = styleBuilder;
        this.styleBuilder = var10_10;
    }

    public void defaultStyle(Map options) {
        Map map;
        LinkedHashMap linkedHashMap;
        LinkedHashMap linkedHashMap2;
        options = linkedHashMap2 = new LinkedHashMap(options);
        CellStyleBuilder.convertSimpleOptions(options);
        this.defaultOptions = this.defaultOptions == null ? (linkedHashMap = options) : (map = this.styleBuilder.merge(this.defaultOptions, options));
    }

    protected abstract XSSFCell nextCell();

    public abstract void skipCells(int var1);

    protected void setStyle(Object value, XSSFCell cell, Map options) {
        this.styleBuilder.setStyle(value, cell, options, this.defaultOptions);
    }

    public XSSFCell column(String value, Object id, Map style) {
        XSSFCell col = this.cell(value, style);
        int n = col.getColumnIndex();
        DefaultGroovyMethods.putAt(this.columnIndexes, (Object)id, (Object)n);
        return col;
    }

    public XSSFCell formula(String formulaString, Map style) {
        XSSFCell cell = this.nextCell();
        if (formulaString.startsWith("=")) {
            String string;
            formulaString = string = StringGroovyMethods.getAt((String)formulaString, (IntRange)new IntRange(true, 1, Integer.valueOf(-1).intValue()));
        }
        cell.setCellFormula(formulaString);
        this.setStyle(null, cell, style);
        return cell;
    }

    public XSSFCell formula(String formulaString) {
        return this.formula(formulaString, null);
    }

    public XSSFCell formula(@DelegatesTo(strategy=1, value=CellFinder.class) Closure callable) {
        return this.formula(null, callable);
    }

    public XSSFCell formula(Map style, @DelegatesTo(strategy=1, value=CellFinder.class) Closure callable) {
        String string;
        String string2;
        XSSFCell cell = this.nextCell();
        int n = Closure.DELEGATE_FIRST;
        callable.setResolveStrategy(n);
        CellFinder cellFinder = new CellFinder(cell, this.columnIndexes);
        callable.setDelegate((Object)cellFinder);
        String formula = null;
        formula = callable.getMaximumNumberOfParameters() == 1 ? (string2 = ShortTypeHandling.castToString((Object)callable.call((Object)cell))) : (string = ShortTypeHandling.castToString((Object)callable.call()));
        if (formula.startsWith("=")) {
            String string3;
            formula = string3 = StringGroovyMethods.getAt((String)formula, (IntRange)new IntRange(true, 1, Integer.valueOf(-1).intValue()));
        }
        cell.setCellFormula(formula);
        this.setStyle(null, cell, style);
        return cell;
    }

    public XSSFCell cell() {
        return this.cell(null);
    }

    public XSSFCell cell(Object value) {
        return this.cell(value, null);
    }

    public XSSFCell cell(Object value, Map style) {
        XSSFCell cell = this.nextCell();
        this.setStyle(value, cell, style);
        if (value == null) {
            return cell;
        }
        Closure callable = Excel.getRenderer(value.getClass());
        if (callable != null) {
            Object object;
            value = object = callable.call(value);
        }
        if (value instanceof String) {
            cell.setCellValue(ShortTypeHandling.castToString((Object)value));
        } else if (value instanceof Calendar) {
            cell.setCellValue((Calendar)ScriptBytecodeAdapter.castToType((Object)value, Calendar.class));
        } else if (value instanceof Date) {
            cell.setCellValue((Date)ScriptBytecodeAdapter.castToType((Object)value, Date.class));
        } else if (value instanceof Number) {
            cell.setCellValue(((Number)ScriptBytecodeAdapter.castToType((Object)value, Number.class)).doubleValue());
        } else if (value instanceof Boolean) {
            cell.setCellValue(DefaultTypeTransformation.booleanUnbox((Object)((Boolean)ScriptBytecodeAdapter.castToType((Object)value, Boolean.class))));
        } else {
            cell.setCellValue(DefaultGroovyMethods.toString((Object)value));
        }
        return cell;
    }

    protected XSSFCell handleLink(XSSFCell cell, String address, HyperlinkType linkType) {
        XSSFHyperlink link = this.workbook.getCreationHelper().createHyperlink(linkType);
        String string = address;
        link.setAddress(string);
        XSSFHyperlink xSSFHyperlink = link;
        cell.setHyperlink((Hyperlink)xSSFHyperlink);
        return cell;
    }

    @Deprecated
    public XSSFCell link(Object value, String address, int linkType) {
        return this.link(value, address, HyperlinkType.forInt((int)linkType));
    }

    public XSSFCell link(Object value, String address, HyperlinkType linkType) {
        XSSFCell cell = this.cell(value, LINK_OPTIONS);
        return this.handleLink(cell, address, linkType);
    }

    public XSSFCell link(Object value, @DelegatesTo(strategy=1, value=CellFinder.class) Closure callable) {
        XSSFCell cell = this.cell(value, LINK_OPTIONS);
        int n = Closure.DELEGATE_FIRST;
        callable.setResolveStrategy(n);
        CellFinder cellFinder = new CellFinder(cell, this.columnIndexes);
        callable.setDelegate((Object)cellFinder);
        return this.handleLink(cell, DefaultGroovyMethods.toString((Object)callable.call()), HyperlinkType.DOCUMENT);
    }

    public void merge(Map style, Closure callable) {
        this.merge(this.getProperty("value"), (Integer)ScriptBytecodeAdapter.castToType((Object)this.getProperty("count"), Integer.class), null);
    }

    public abstract void merge(Closure var1);

    /*
     * WARNING - void declaration
     */
    public void merge(Object value, Integer count, Map style) {
        void var2_2;
        Reference value2 = new Reference(value);
        Reference count2 = new Reference((Object)var2_2);
        public class _merge_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference count;
            private /* synthetic */ Reference value;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _merge_closure1(Object _outerInstance, Object _thisObject, Reference count, Reference value) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.count = reference2 = count;
                this.value = reference = value;
            }

            public Object doCall(Object it) {
                ((CreatesCells)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), CreatesCells.class)).cell(this.value.get());
                ((CreatesCells)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), CreatesCells.class)).skipCells(DefaultTypeTransformation.intUnbox((Object)this.count.get()));
                return null;
            }

            public Integer getCount() {
                return (Integer)ScriptBytecodeAdapter.castToType((Object)this.count.get(), Integer.class);
            }

            public Object getValue() {
                return this.value.get();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _merge_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        this.merge(style, new _merge_closure1(this, this, count2, value2));
    }

    protected void performMerge(Map style, Closure callable) {
        Map map;
        Map map2;
        Map existingDefaultOptions = this.defaultOptions;
        if (style != null && !style.isEmpty()) {
            Map map3;
            Map newDefaultOptions = new LinkedHashMap(style);
            CellStyleBuilder.convertSimpleOptions(newDefaultOptions);
            Map map4 = this.styleBuilder.merge(this.defaultOptions, newDefaultOptions);
            newDefaultOptions = map4;
            this.defaultOptions = map3 = newDefaultOptions;
        }
        Boolean bl = (map2 = this.defaultOptions) != null ? Boolean.valueOf(map2.containsKey("border")) : null;
        Map borderOptions = (bl == null ? false : bl) ? (Map)ScriptBytecodeAdapter.castToType(this.defaultOptions.remove("border"), Map.class) : Collections.emptyMap();
        int n = Closure.DELEGATE_FIRST;
        callable.setResolveStrategy(n);
        CreatesCells createsCells = this;
        callable.setDelegate((Object)createsCells);
        int startingIndex = this.getMergeIndex();
        callable.call();
        int endingIndex = this.getMergeIndex() - 1;
        if (endingIndex > startingIndex) {
            CellRangeAddress range = this.getRange(startingIndex, endingIndex);
            this.sheet.addMergedRegion(range);
            if (!borderOptions.isEmpty()) {
                this.styleBuilder.applyBorderToRegion(this.getBorderStyleApplier(range, this.sheet), borderOptions);
            }
        }
        this.defaultOptions = map = existingDefaultOptions;
    }

    protected abstract CellRangeAddress getRange(int var1, int var2);

    protected abstract int getMergeIndex();

    protected abstract CellRangeBorderStyleApplier getBorderStyleApplier(CellRangeAddress var1, XSSFSheet var2);

    public XSSFCell column(String value, Object id) {
        return this.column(value, id, null);
    }

    /*
     * WARNING - void declaration
     */
    public void merge(Object value, Integer count) {
        void var2_2;
        Reference value2 = new Reference(value);
        Reference count2 = new Reference((Object)var2_2);
        this.merge(value2.get(), (Integer)count2.get(), null);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != CreatesCells.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Map map;
        LINK_OPTIONS = map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"font", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"style", Font.UNDERLINE, "color", Color.BLUE})});
    }
}

