/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.common;

import com.jayway.maven.plugins.android.common.MavenToPlexusLogAdapter;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.codehaus.plexus.components.io.fileselectors.FileInfo;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.logging.Logger;

public final class ZipExtractor {
    private final Log log;

    public ZipExtractor(Log log) {
        this.log = log;
    }

    public void extract(File zipFile, File targetFolder, final String suffixToExclude) throws MojoExecutionException {
        ZipUnArchiver unArchiver = new ZipUnArchiver(zipFile){

            protected Logger getLogger() {
                return new MavenToPlexusLogAdapter(ZipExtractor.this.log);
            }
        };
        targetFolder.mkdirs();
        FileSelector exclusionFilter = new FileSelector(){

            public boolean isSelected(FileInfo fileInfo) throws IOException {
                return !fileInfo.getName().endsWith(suffixToExclude);
            }
        };
        unArchiver.setDestDirectory(targetFolder);
        unArchiver.setFileSelectors(new FileSelector[]{exclusionFilter});
        this.log.debug((CharSequence)("Extracting archive to " + targetFolder));
        try {
            unArchiver.extract();
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("ArchiverException while extracting " + zipFile.getAbsolutePath() + ". Message: " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
    }
}

