/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.phase05compile;

import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.CommandExecutor;
import com.jayway.maven.plugins.android.ExecutionException;
import com.jayway.maven.plugins.android.common.NativeHelper;
import com.jayway.maven.plugins.android.config.PullParameter;
import com.jayway.maven.plugins.android.configuration.HeaderFilesDirective;
import com.jayway.maven.plugins.android.configuration.NDKArchitectureToolchainMappings;
import com.jayway.maven.plugins.android.phase05compile.MakefileHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.util.IOUtil;

@Mojo(name="ndk-build", defaultPhase=LifecyclePhase.COMPILE)
public class NdkBuildMojo
extends AbstractAndroidMojo {
    @PullParameter
    @Parameter(property="android.ndk.ndk-build-executable")
    private String ndkBuildExecutable;
    @PullParameter
    @Parameter(property="android.ndk.ndk-build-directory", defaultValue="${project.build.directory}/ndk-build", readonly=true)
    private File ndkBuildDirectory;
    @PullParameter
    @Parameter(property="android.ndk.build.native-classifier")
    private String ndkClassifier;
    @PullParameter
    @Parameter(property="android.ndk.build.command-line")
    protected String ndkBuildAdditionalCommandline;
    @PullParameter(defaultValue={"false"})
    @Parameter(property="android.ndk.build.attach-native-artifact", defaultValue="false")
    private Boolean attachNativeArtifacts;
    @Parameter(property="android.nativeLibrariesOutputDirectory", defaultValue="${project.basedir}/obj/local", readonly=true)
    private File nativeLibrariesOutputDirectory;
    @PullParameter
    @Parameter(property="android.nativeTarget")
    private String target;
    @PullParameter
    @Parameter(property="android.ndk.build.architecture")
    private String ndkArchitecture;
    @PullParameter
    @Parameter(property="android.ndk.build.architectures")
    private String ndkArchitectures;
    @PullParameter
    @Parameter
    private NDKArchitectureToolchainMappings ndkArchitectureToolchainMappings;
    @PullParameter(defaultValue={"true"})
    @Parameter(property="android.ndk.build.attach-header-files", defaultValue="true")
    private Boolean attachHeaderFiles;
    @PullParameter(defaultValue={"false"})
    @Parameter(property="android.ndk.build.use-local-src-include-paths", defaultValue="false")
    private Boolean useLocalSrcIncludePaths;
    @PullParameter
    @Parameter
    private List<HeaderFilesDirective> headerFilesDirectives;
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver jarArchiver;
    @Component(role=ArtifactHandler.class, hint="har")
    private ArtifactHandler harArtifactHandler;
    @PullParameter(defaultValue={"true"})
    @Parameter(property="android.ndk.build.use-header-archive", defaultValue="true")
    private Boolean useHeaderArchives;
    @PullParameter
    @Parameter
    private Map<String, String> systemProperties;
    @PullParameter(defaultValue={"true"})
    @Parameter(property="android.ndk.build.ignore-build-warnings", defaultValue="true")
    private Boolean ignoreBuildWarnings;
    @PullParameter(defaultValue={".*[warning|note]: .*"})
    @Parameter(property="android.ndk.build.build-warnings-regular-expression", defaultValue=".*[warning|note]: .*")
    private String buildWarningsRegularExpression;
    @PullParameter(defaultValue={"false"})
    @Parameter(property="android.ndk.build.skip-native-library-stripping", defaultValue="false")
    private Boolean skipStripping;
    @PullParameter
    @Parameter(property="android.ndk.build.ndk-toolchain")
    private String ndkToolchain;
    @PullParameter
    @Parameter(property="android.ndk.build.build.final-library-name")
    private String ndkFinalLibraryName;
    @PullParameter
    @Parameter
    private String makefile;
    @PullParameter
    @Parameter
    private String applicationMakefile;
    @PullParameter(defaultValue={"false"})
    @Parameter(property="android.ndk.build.maxJobs", defaultValue="false")
    private Boolean maxJobs;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String[] resolvedNDKArchitectures;
        File ndkBuildFile = new File(this.getAndroidNdk().getNdkBuildPath());
        NativeHelper.validateNDKVersion(ndkBuildFile.getParentFile());
        this.validateMakefile(this.project, this.makefile);
        for (String architecture : resolvedNDKArchitectures = NativeHelper.getNdkArchitectures(this.ndkArchitecture != null ? this.ndkArchitecture : this.ndkArchitectures, this.applicationMakefile, this.project.getBasedir())) {
            try {
                this.compileForArchitecture(architecture);
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Error while executing: " + e.getMessage()));
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            catch (ExecutionException e) {
                this.getLog().error((CharSequence)("Error while executing: " + e.getMessage()));
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileForArchitecture(String architecture) throws MojoExecutionException, IOException, ExecutionException {
        this.getLog().debug((CharSequence)("Resolving for NDK architecture : " + architecture));
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setErrorListener(this.getNdkErrorListener());
        Set<Artifact> nativeLibraryArtifacts = this.findNativeLibraryDependencies();
        Set<Artifact> resolveNativeLibraryArtifacts = this.getArtifactResolverHelper().resolveArtifacts(nativeLibraryArtifacts);
        this.getLog().debug((CharSequence)("resolveArtifacts found " + resolveNativeLibraryArtifacts.size() + ": " + resolveNativeLibraryArtifacts.toString()));
        File buildFolder = new File(this.ndkBuildDirectory, architecture);
        buildFolder.mkdirs();
        File androidMavenMakefile = new File(buildFolder, "android_maven_plugin_makefile.mk");
        MakefileHelper makefileHelper = new MakefileHelper(this.getLog(), this.getArtifactResolverHelper(), this.harArtifactHandler, this.getUnpackedLibsDirectory());
        MakefileHelper.MakefileHolder makefileHolder = makefileHelper.createMakefileFromArtifacts(resolveNativeLibraryArtifacts, architecture, "armeabi", this.useHeaderArchives);
        FileOutputStream output = new FileOutputStream(androidMavenMakefile);
        try {
            IOUtil.copy((String)makefileHolder.getMakeFile(), (OutputStream)output);
        }
        finally {
            output.close();
        }
        executor.addEnvironment("ANDROID_MAVEN_PLUGIN_MAKEFILE", androidMavenMakefile.getAbsolutePath());
        this.setupNativeLibraryEnvironment(makefileHelper, executor, resolveNativeLibraryArtifacts, architecture);
        File makefileCaptureFile = File.createTempFile("android_maven_plugin_makefile_captures", ".tmp");
        makefileCaptureFile.deleteOnExit();
        executor.addEnvironment("ANDROID_MAVEN_PLUGIN_LOCAL_C_INCLUDES_FILE", makefileCaptureFile.getAbsolutePath());
        if (this.systemProperties != null && !this.systemProperties.isEmpty()) {
            for (Map.Entry<String, String> entry : this.systemProperties.entrySet()) {
                executor.addEnvironment(entry.getKey(), entry.getValue());
            }
        }
        executor.setLogger(this.getLog());
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("-C");
        commands.add(this.ndkBuildDirectory.getAbsolutePath());
        if (this.makefile != null) {
            File makeFile = new File(this.project.getBasedir(), this.makefile);
            if (!makeFile.exists()) {
                this.getLog().error((CharSequence)("Specified makefile " + makeFile + " does not exist"));
                throw new MojoExecutionException("Specified makefile " + makeFile + " does not exist");
            }
            commands.add("-f");
            commands.add(this.makefile);
        }
        this.configureApplicationMakefile(commands);
        this.configureMaxJobs(commands);
        this.configureNdkToolchain(architecture, commands);
        this.configureAdditionalCommands(commands);
        if (this.target != null) {
            commands.add(this.target);
        } else {
            commands.add(this.project.getArtifactId());
        }
        String ndkBuildPath = this.resolveNdkBuildExecutable();
        this.getLog().debug((CharSequence)(ndkBuildPath + " " + ((Object)commands).toString()));
        this.getLog().info((CharSequence)("Executing NDK " + architecture + " make at : " + this.ndkBuildDirectory));
        executor.setCaptureStdOut(true);
        executor.executeCommand(ndkBuildPath, commands, this.ndkBuildDirectory, true);
        this.getLog().debug((CharSequence)("Executed NDK " + architecture + " make at : " + this.ndkBuildDirectory));
        File nativeLibOutputDirectory = new File(this.nativeLibrariesOutputDirectory, architecture);
        nativeLibOutputDirectory.mkdirs();
        File destinationDirectory = new File(this.ndkOutputDirectory, architecture);
        FileUtils.moveDirectory((File)nativeLibOutputDirectory, (File)destinationDirectory);
        if ("so".equals(this.project.getPackaging()) || "a".equals(this.project.getPackaging()) || this.attachNativeArtifacts.booleanValue()) {
            this.attachNativeLib(destinationDirectory, architecture);
        }
        if (this.attachHeaderFiles.booleanValue()) {
            this.attachHeaderFiles(makefileCaptureFile, architecture);
        }
        this.getLog().info((CharSequence)"Cleaning up extracted include directories used for build");
        MakefileHelper.cleanupAfterBuild(makefileHolder);
    }

    private void configureAdditionalCommands(List<String> commands) {
        if (this.ndkBuildAdditionalCommandline != null) {
            String[] additionalCommands = this.ndkBuildAdditionalCommandline.split(" ");
            commands.addAll(Arrays.asList(additionalCommands));
        }
    }

    private void configureApplicationMakefile(List<String> commands) throws MojoExecutionException {
        if (this.applicationMakefile != null) {
            File appMK = new File(this.project.getBasedir(), this.applicationMakefile);
            if (!appMK.exists()) {
                this.getLog().error((CharSequence)("Specified application makefile " + appMK + " does not exist"));
                throw new MojoExecutionException("Specified application makefile " + appMK + " does not exist");
            }
            commands.add("NDK_APPLICATION_MK=" + this.applicationMakefile);
        }
    }

    private void configureMaxJobs(List<String> commands) {
        if (this.maxJobs.booleanValue()) {
            String jobs = String.valueOf(Runtime.getRuntime().availableProcessors());
            this.getLog().info((CharSequence)("executing " + jobs + " parallel jobs"));
            commands.add("-j");
            commands.add(jobs);
        }
    }

    private void configureNdkToolchain(String architecture, List<String> commands) throws MojoExecutionException {
        if (this.ndkToolchain != null) {
            commands.add("NDK_TOOLCHAIN=" + this.ndkToolchain);
        } else {
            String toolchainFromArchitecture = this.getAndroidNdk().getToolchainFromArchitecture(architecture, this.ndkArchitectureToolchainMappings);
            this.getLog().debug((CharSequence)("Resolved toolchain for " + architecture + " to " + toolchainFromArchitecture));
            commands.add("NDK_TOOLCHAIN=" + toolchainFromArchitecture);
            commands.add("APP_ABI=" + architecture);
        }
    }

    private void attachNativeLib(File destinationDirectory, String architecture) throws IOException, MojoExecutionException {
        File nativeArtifactFile = this.ndkFinalLibraryName == null ? this.findNativeLibrary(destinationDirectory) : this.nativeLibraryFromName(destinationDirectory);
        String artifactType = this.resolveArtifactType(nativeArtifactFile);
        if (nativeArtifactFile.getName().endsWith(".so") && !this.skipStripping.booleanValue()) {
            this.getLog().debug((CharSequence)("Post processing (stripping) native compiled artifact: " + nativeArtifactFile));
            this.invokeNDKStripper(nativeArtifactFile);
        }
        this.getLog().debug((CharSequence)("Adding native compiled artifact: " + nativeArtifactFile));
        String classifier = this.ndkClassifier == null ? architecture : architecture + "-" + this.ndkClassifier;
        this.projectHelper.attachArtifact(this.project, artifactType, classifier, nativeArtifactFile);
    }

    private File findNativeLibrary(File nativeLibDirectory) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Searching " + nativeLibDirectory + " for built library"));
        File[] files = nativeLibDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String libraryName = NdkBuildMojo.this.ndkFinalLibraryName;
                if (libraryName == null || libraryName.isEmpty()) {
                    libraryName = NdkBuildMojo.this.project.getArtifactId();
                }
                if ("a".equals(NdkBuildMojo.this.project.getPackaging())) {
                    return name.startsWith("lib" + libraryName) && name.endsWith(".a");
                }
                return name.startsWith("lib" + libraryName) && name.endsWith(".so");
            }
        });
        if (files == null || files.length != 1) {
            this.getLog().warn((CharSequence)("Error while detecting native compile artifacts: " + (files == null || files.length == 0 ? "None found" : "Found more than 1 artifact")));
            if (this.target != null) {
                this.getLog().warn((CharSequence)"Using the 'target' configuration option to specify the output file name is no longer supported, use 'ndkFinalLibraryName' instead.");
            }
            if (files != null && files.length > 1) {
                this.getLog().debug((CharSequence)("List of files found: " + Arrays.asList(files)));
                this.getLog().error((CharSequence)"Currently, only a single, final native library is supported by the build");
                throw new MojoExecutionException("Currently, only a single, final native library is supported by the build");
            }
            this.getLog().error((CharSequence)"No native compiled library found, did the native compile complete successfully?");
            throw new MojoExecutionException("No native compiled library found, did the native compile complete successfully?");
        }
        return files[0];
    }

    private File nativeLibraryFromName(File nativeLibDirectory) throws MojoExecutionException {
        File staticLib;
        File libraryFile = "so".equals(this.project.getPackaging()) || "a".equals(this.project.getPackaging()) ? new File(nativeLibDirectory, "lib" + this.ndkFinalLibraryName + "." + this.project.getPackaging()) : ((staticLib = new File(nativeLibDirectory, "lib" + this.ndkFinalLibraryName + ".a")).exists() ? staticLib : new File(nativeLibDirectory, "lib" + this.ndkFinalLibraryName + ".so"));
        if (!libraryFile.exists()) {
            this.getLog().error((CharSequence)("Could not locate final native library using the provided ndkFinalLibraryName " + this.ndkFinalLibraryName + " (tried " + libraryFile.getAbsolutePath() + ")"));
            throw new MojoExecutionException("Could not locate final native library using the provided ndkFinalLibraryName " + this.ndkFinalLibraryName + " (tried " + libraryFile.getAbsolutePath() + ")");
        }
        return libraryFile;
    }

    private CommandExecutor.ErrorListener getNdkErrorListener() {
        return new CommandExecutor.ErrorListener(){

            @Override
            public boolean isError(String error) {
                if (NdkBuildMojo.this.ignoreBuildWarnings.booleanValue()) {
                    return false;
                }
                Pattern pattern = Pattern.compile(NdkBuildMojo.this.buildWarningsRegularExpression);
                Matcher matcher = pattern.matcher(error);
                return !matcher.matches();
            }
        };
    }

    private void validateMakefile(MavenProject project, String file) {
    }

    private void invokeNDKStripper(File file) throws MojoExecutionException {
        try {
            this.getLog().debug((CharSequence)"Detected shared library artifact, will now strip it");
            CommandExecutor stripCommandExecutor = CommandExecutor.Factory.createDefaultCommmandExecutor();
            stripCommandExecutor.setErrorListener(new CommandExecutor.ErrorListener(){

                @Override
                public boolean isError(String error) {
                    NdkBuildMojo.this.getLog().error((CharSequence)("Error while stripping binary: " + error));
                    return true;
                }
            });
            stripCommandExecutor.setLogger(this.getLog());
            stripCommandExecutor.setCaptureStdOut(true);
            stripCommandExecutor.executeCommand(this.resolveNdkStripper(file).getAbsolutePath(), Arrays.asList(file.getAbsolutePath()));
        }
        catch (ExecutionException e) {
            this.getLog().error((CharSequence)"Error while attempting to strip shared library", (Throwable)e);
            throw new MojoExecutionException("Error while attempting to strip shared library");
        }
    }

    private String resolveNdkBuildExecutable() throws MojoExecutionException {
        if (this.ndkBuildExecutable != null) {
            this.getLog().debug((CharSequence)("ndk-build overriden, using " + this.ndkBuildExecutable));
            return this.ndkBuildExecutable;
        }
        return this.getAndroidNdk().getNdkBuildPath();
    }

    private File resolveNdkStripper(File nativeLibrary) throws MojoExecutionException {
        if (this.ndkToolchain != null) {
            return this.getAndroidNdk().getStripper(this.ndkToolchain);
        }
        return this.getAndroidNdk().getStripper(this.getAndroidNdk().getToolchain(nativeLibrary));
    }

    private void attachHeaderFiles(File localCIncludesFile, String architecture) throws MojoExecutionException, IOException {
        ArrayList<HeaderFilesDirective> finalHeaderFilesDirectives = new ArrayList<HeaderFilesDirective>();
        if (this.useLocalSrcIncludePaths.booleanValue()) {
            Properties props = new Properties();
            props.load(new FileInputStream(localCIncludesFile));
            String localCIncludes = props.getProperty("LOCAL_C_INCLUDES");
            if (localCIncludes != null && !localCIncludes.trim().isEmpty()) {
                String[] includes;
                for (String include : includes = localCIncludes.split(" ")) {
                    HeaderFilesDirective headerFilesDirective = new HeaderFilesDirective();
                    File includeDir = new File(this.project.getBasedir(), include);
                    headerFilesDirective.setDirectory(includeDir.getAbsolutePath());
                    headerFilesDirective.setIncludes(new String[]{"**/*.h"});
                    finalHeaderFilesDirectives.add(headerFilesDirective);
                }
            }
        } else if (this.headerFilesDirectives != null) {
            finalHeaderFilesDirectives.addAll(this.headerFilesDirectives);
        }
        if (finalHeaderFilesDirectives.isEmpty()) {
            this.getLog().debug((CharSequence)"No header files included, will add default set");
            HeaderFilesDirective e = new HeaderFilesDirective();
            e.setDirectory(new File(this.project.getBasedir() + "/jni").getAbsolutePath());
            e.setIncludes(new String[]{"**/*.h"});
            finalHeaderFilesDirectives.add(e);
        }
        this.createHeaderArchive(finalHeaderFilesDirectives, architecture);
    }

    private void createHeaderArchive(List<HeaderFilesDirective> finalHeaderFilesDirectives, String architecture) throws MojoExecutionException {
        try {
            MavenArchiver mavenArchiver = new MavenArchiver();
            mavenArchiver.setArchiver(this.jarArchiver);
            File jarFile = new File(new File(this.project.getBuild().getDirectory()), this.project.getBuild().getFinalName() + ".har");
            mavenArchiver.setOutputFile(jarFile);
            for (HeaderFilesDirective headerFilesDirective : finalHeaderFilesDirectives) {
                mavenArchiver.getArchiver().addDirectory(new File(headerFilesDirective.getDirectory()), headerFilesDirective.getIncludes(), headerFilesDirective.getExcludes());
            }
            MavenArchiveConfiguration mavenArchiveConfiguration = new MavenArchiveConfiguration();
            mavenArchiveConfiguration.setAddMavenDescriptor(false);
            mavenArchiver.createArchive(this.project, mavenArchiveConfiguration);
            String classifier = architecture;
            if (this.ndkClassifier != null) {
                classifier = classifier + "-" + this.ndkClassifier;
            }
            this.getLog().debug((CharSequence)("Attaching 'har' classifier=" + classifier + " file=" + jarFile));
            this.projectHelper.attachArtifact(this.project, "har", classifier, jarFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private void setupNativeLibraryEnvironment(MakefileHelper makefileHelper, CommandExecutor executor, Set<Artifact> resolveNativeLibraryArtifacts, String architecture) {
        if (NativeHelper.hasStaticNativeLibraryArtifact(resolveNativeLibraryArtifacts, this.getUnpackedLibsDirectory(), architecture)) {
            String staticlibs = makefileHelper.createLibraryList(resolveNativeLibraryArtifacts, architecture, true);
            executor.addEnvironment("ANDROID_MAVEN_PLUGIN_LOCAL_STATIC_LIBRARIES", staticlibs);
            this.getLog().debug((CharSequence)("Set ANDROID_MAVEN_PLUGIN_LOCAL_STATIC_LIBRARIES = " + staticlibs));
        }
        if (NativeHelper.hasSharedNativeLibraryArtifact(resolveNativeLibraryArtifacts, this.getUnpackedLibsDirectory(), architecture)) {
            String sharedlibs = makefileHelper.createLibraryList(resolveNativeLibraryArtifacts, architecture, false);
            executor.addEnvironment("ANDROID_MAVEN_PLUGIN_LOCAL_SHARED_LIBRARIES", sharedlibs);
            this.getLog().debug((CharSequence)("Set ANDROID_MAVEN_PLUGIN_LOCAL_SHARED_LIBRARIES = " + sharedlibs));
        }
    }

    private Set<Artifact> findNativeLibraryDependencies() throws MojoExecutionException {
        NativeHelper nativeHelper = this.getNativeHelper();
        Set<Artifact> staticLibraryArtifacts = nativeHelper.getNativeDependenciesArtifacts(this, this.getUnpackedLibsDirectory(), false);
        Set<Artifact> sharedLibraryArtifacts = nativeHelper.getNativeDependenciesArtifacts(this, this.getUnpackedLibsDirectory(), true);
        LinkedHashSet<Artifact> mergedArtifacts = new LinkedHashSet<Artifact>();
        this.filterNativeDependencies(mergedArtifacts, staticLibraryArtifacts);
        this.filterNativeDependencies(mergedArtifacts, sharedLibraryArtifacts);
        this.getLog().debug((CharSequence)("findNativeLibraryDependencies found " + mergedArtifacts.size() + ": " + ((Object)mergedArtifacts).toString()));
        return mergedArtifacts;
    }

    private void filterNativeDependencies(Set<Artifact> targetSet, Set<Artifact> source) {
        for (Artifact a : source) {
            if (this.project.getGroupId().equals(a.getGroupId()) && this.project.getArtifactId().equals(a.getArtifactId())) {
                this.getLog().warn((CharSequence)"Excluding native dependency attached by this build");
                continue;
            }
            targetSet.add(a);
        }
    }

    private String resolveArtifactType(File file) {
        if ("so".equals(this.project.getPackaging()) || "a".equals(this.project.getPackaging())) {
            return this.project.getPackaging();
        }
        return file.getName().endsWith("so") ? "so" : "a";
    }
}

