/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.phase09package;

import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.CommandExecutor;
import com.jayway.maven.plugins.android.ExecutionException;
import com.jayway.maven.plugins.android.common.AaptCommandBuilder;
import com.jayway.maven.plugins.android.common.NativeHelper;
import com.jayway.maven.plugins.android.config.PullParameter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.archiver.zip.ZipArchiver;

@Mojo(name="aar", defaultPhase=LifecyclePhase.VERIFY, requiresDependencyResolution=ResolutionScope.COMPILE)
public class AarMojo
extends AbstractAndroidMojo {
    public static final String NATIVE_LIBRARIES_FOLDER = "jni";
    @Parameter
    private String classifier;
    @PullParameter
    @Parameter
    private String applicationMakefile;
    @PullParameter
    @Parameter(property="android.ndk.build.architecture")
    private String ndkArchitecture;
    @PullParameter
    @Parameter(property="android.ndk.build.native-classifier")
    private String ndkClassifier;
    @PullParameter
    @Parameter
    private String[] classesJarIncludes = new String[]{"**/*"};
    @PullParameter
    @Parameter
    private String[] classesJarExcludes = new String[]{"**/R.class", "**/R$*.class"};
    private List<String> sourceFolders = new ArrayList<String>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        String out = this.project.getBuild().getDirectory();
        for (String src : this.project.getCompileSourceRoots()) {
            if (src.startsWith(out)) continue;
            this.sourceFolders.add(src);
        }
        this.getLog().info((CharSequence)("Generating AAR file : " + this.project.getArtifactId()));
        this.generateIntermediateApk();
        File outputFile = this.createAarLibraryFile(this.createAarClassesJar());
        if (this.classifier == null) {
            this.project.getArtifact().setFile(outputFile);
        } else {
            this.projectHelper.attachArtifact(this.project, outputFile, this.classifier);
        }
    }

    protected File createAarClassesJar() throws MojoExecutionException {
        File classesJar = new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + ".aar.classes.jar");
        try {
            JarArchiver jarArchiver = new JarArchiver();
            jarArchiver.setDestFile(classesJar);
            jarArchiver.addDirectory(new File(this.project.getBuild().getOutputDirectory()), this.classesJarIncludes, this.classesJarExcludes);
            jarArchiver.createArchive();
            return classesJar;
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("ArchiverException while creating ." + classesJar + " file.", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException while creating ." + classesJar + " file.", (Exception)e);
        }
    }

    protected File createAarLibraryFile(File classesJar) throws MojoExecutionException {
        File aarLibrary = new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + "." + "aar");
        FileUtils.deleteQuietly((File)aarLibrary);
        try {
            File[] overlayDirectories;
            ZipArchiver zipArchiver = new ZipArchiver();
            zipArchiver.setDestFile(aarLibrary);
            zipArchiver.addFile(this.androidManifestFile, "AndroidManifest.xml");
            this.addDirectory(zipArchiver, this.assetsDirectory, "assets");
            this.addDirectory(zipArchiver, this.resourceDirectory, "res");
            zipArchiver.addFile(classesJar, "classes.jar");
            for (File resOverlayDir : overlayDirectories = this.getResourceOverlayDirectories()) {
                if (resOverlayDir == null || !resOverlayDir.exists()) continue;
                this.addDirectory(zipArchiver, resOverlayDir, "res");
            }
            this.addR(zipArchiver);
            this.addNativeLibraries(zipArchiver);
            zipArchiver.createArchive();
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("ArchiverException while creating .aar file.", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException while creating .aar file.", (Exception)e);
        }
        return aarLibrary;
    }

    private void addR(ZipArchiver zipArchiver) throws MojoExecutionException {
        File rFile = new File(this.project.getBuild().getDirectory() + "/R.txt");
        if (rFile.exists()) {
            zipArchiver.addFile(rFile, "R.txt");
            this.getLog().debug((CharSequence)"Packaging R.txt in AAR");
        } else {
            this.getLog().debug((CharSequence)"Not packaging R.txt in AAR - it does not exist (no resources??)");
        }
    }

    private void addNativeLibraries(ZipArchiver zipArchiver) throws MojoExecutionException {
        try {
            if (this.nativeLibrariesDirectory.exists()) {
                this.getLog().info((CharSequence)(this.nativeLibrariesDirectory + " exists, adding libraries."));
                this.addDirectory(zipArchiver, this.nativeLibrariesDirectory, NATIVE_LIBRARIES_FOLDER);
            } else {
                String[] ndkArchitectures;
                this.getLog().info((CharSequence)(this.nativeLibrariesDirectory + " does not exist, looking for libraries in target directory."));
                for (String architecture : ndkArchitectures = NativeHelper.getNdkArchitectures(this.ndkArchitecture, this.applicationMakefile, this.project.getBasedir())) {
                    File ndkLibsDirectory = new File(this.ndkOutputDirectory, architecture);
                    this.addSharedLibraries(zipArchiver, ndkLibsDirectory, architecture);
                    for (Artifact libraryArtifact : this.getTransitiveDependencyArtifacts("apklib", "aar")) {
                        File apklibLibsDirectory = new File(this.getUnpackedLibNativesFolder(libraryArtifact), architecture);
                        if (!apklibLibsDirectory.exists()) continue;
                        this.addSharedLibraries(zipArchiver, apklibLibsDirectory, architecture);
                    }
                }
            }
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("IOException while creating .aar file.", (Exception)((Object)e));
        }
    }

    protected String endWithSlash(String prefix) {
        if (!(prefix = StringUtils.defaultIfEmpty((String)prefix, (String)"/")).endsWith("/")) {
            prefix = prefix + "/";
        }
        return prefix;
    }

    protected void addDirectory(ZipArchiver zipArchiver, File directory, String prefix) {
        if (directory != null && directory.exists()) {
            DefaultFileSet fileSet = new DefaultFileSet();
            fileSet.setPrefix(this.endWithSlash(prefix));
            fileSet.setDirectory(directory);
            zipArchiver.addFileSet((FileSet)fileSet);
            this.getLog().debug((CharSequence)("Added files from " + directory));
        }
    }

    protected void addSharedLibraries(ZipArchiver zipArchiver, File directory, String architecture) {
        this.getLog().debug((CharSequence)("Searching for shared libraries in " + directory));
        File[] libFiles = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("lib") && name.endsWith(".so");
            }
        });
        if (libFiles != null) {
            for (File libFile : libFiles) {
                String dest = "jni/" + architecture + "/" + libFile.getName();
                this.getLog().debug((CharSequence)("Adding " + libFile + " as " + dest));
                zipArchiver.addFile(libFile, dest);
            }
        }
    }

    private void generateIntermediateApk() throws MojoExecutionException {
        ArrayList<File> dependenciesResDirectories = new ArrayList<File>();
        for (Artifact libraryArtifact : this.getTransitiveDependencyArtifacts("apklib", "aar")) {
            File apkLibResDir = this.getUnpackedLibResourceFolder(libraryArtifact);
            if (!apkLibResDir.exists()) continue;
            dependenciesResDirectories.add(apkLibResDir);
        }
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        File outputFile = new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + ".ap_");
        AaptCommandBuilder.AaptPackageCommandBuilder commandBuilder = AaptCommandBuilder.packageResources(this.getLog()).makePackageDirectories().forceOverwriteExistingFiles().setPathToAndroidManifest(this.androidManifestFile).addResourceDirectoriesIfExists(this.getResourceOverlayDirectories()).addResourceDirectoryIfExists(this.resourceDirectory).addResourceDirectoriesIfExists(dependenciesResDirectories).autoAddOverlay().addRawAssetsDirectoryIfExists(this.combinedAssets).addExistingPackageToBaseIncludeSet(this.getAndroidSdk().getAndroidJar()).setOutputApkFile(outputFile).addConfigurations(this.configurations).setResourceConstantsFolder(this.genDirectory).makeResourcesNonConstant().generateRTextFile(new File(this.project.getBuild().getDirectory())).setVerbose(this.aaptVerbose);
        this.getLog().debug((CharSequence)(this.getAndroidSdk().getAaptPath() + " " + commandBuilder.toString()));
        this.getLog().info((CharSequence)"Generating aar");
        try {
            executor.setCaptureStdOut(true);
            List<String> commands = commandBuilder.build();
            executor.executeCommand(this.getAndroidSdk().getAaptPath(), commands, this.project.getBasedir(), false);
        }
        catch (ExecutionException e) {
            throw new MojoExecutionException("", (Exception)e);
        }
    }
}

