/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.matchers;

import com.jcabi.matchers.StringSource;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.JAXBIntrospector;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;

public final class JaxbConverter {
    private JaxbConverter() {
    }

    public static Source the(Object object, Class<?> ... deps) throws JAXBException {
        JAXBContext ctx;
        Class[] classes = new Class[deps.length + 1];
        classes[0] = object.getClass();
        System.arraycopy(deps, 0, classes, 1, deps.length);
        try {
            ctx = JAXBContext.newInstance((Class[])classes);
        }
        catch (JAXBException ex) {
            throw new IllegalArgumentException(ex);
        }
        JAXBIntrospector intro = ctx.createJAXBIntrospector();
        Object subject = object;
        if (intro.getElementName(object) == null) {
            Class<?> type = object.getClass();
            subject = new JAXBElement(JaxbConverter.qname(object), type, object);
        }
        Marshaller mrsh = JaxbConverter.marshaller(ctx);
        StringWriter writer = new StringWriter();
        try {
            mrsh.marshal(subject, (Writer)writer);
        }
        catch (JAXBException ex) {
            throw new AssertionError((Object)ex);
        }
        String xml = writer.toString();
        return new StringSource(xml);
    }

    private static Marshaller marshaller(JAXBContext ctx) throws JAXBException {
        Marshaller mrsh = ctx.createMarshaller();
        mrsh.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        return mrsh;
    }

    private static QName qname(Object obj) {
        XmlType type = (XmlType)XmlType.class.cast(obj.getClass().getAnnotation(XmlType.class));
        if (type == null) {
            throw new AssertionError((Object)String.format("@XmlType or @XmlRootElement annotation required at %s", obj.getClass().getName()));
        }
        QName qname = "##default".equals(type.namespace()) ? new QName(type.name()) : new QName(type.namespace(), type.name());
        return qname;
    }

    public String toString() {
        return "JaxbConverter()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof JaxbConverter;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }
}

