/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import com.jidesoft.converter.ObjectConverterManager;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ArrayConverter
implements ObjectConverter {
    private String _separator;
    private int _size;
    private Class<?> _elementClass;
    private Class<?>[] _elementClasses;

    public ArrayConverter(String separator, int size, Class<?> elementClass) {
        this._separator = separator;
        this._size = size;
        this._elementClass = elementClass;
    }

    public ArrayConverter(String separator, int size, Class<?>[] elementClasses) {
        if (separator == null || separator.trim().length() == 0) {
            throw new IllegalArgumentException("separator cannot be empty.");
        }
        if (elementClasses == null) {
            throw new IllegalArgumentException("elementClasses cannot be null.");
        }
        if (size != elementClasses.length) {
            throw new IllegalArgumentException("size must be equal to the length of elementClasses.");
        }
        this._separator = separator;
        this._size = size;
        this._elementClasses = elementClasses;
    }

    public String arrayToString(Object[] objects, ConverterContext context) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < objects.length; ++i) {
            Object o = objects[i];
            if (this._elementClass != null) {
                buffer.append(ObjectConverterManager.toString(o, this._elementClass, context));
            } else {
                buffer.append(ObjectConverterManager.toString(o, this._elementClasses[i], context));
            }
            if (i == objects.length - 1) continue;
            buffer.append(this._separator);
        }
        return new String(buffer);
    }

    public Object[] arrayFromString(String string, ConverterContext context) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        StringTokenizer token = new StringTokenizer(string, this._separator.trim());
        Object[] objects = new Object[this._size != -1 ? this._size : token.countTokens()];
        for (int i = 0; i < objects.length && token.hasMoreTokens(); ++i) {
            String s = token.nextToken().trim();
            objects[i] = this._elementClass != null ? ObjectConverterManager.fromString(s, this._elementClass, context) : ObjectConverterManager.fromString(s, this._elementClasses[i], context);
        }
        return objects;
    }

    public Class<?> getElementClass() {
        return this._elementClass;
    }
}

