/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.RegistrationEvent;
import com.jidesoft.converter.RegistrationListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheMap<T, K> {
    private HashMap<Class<?>, Cache<K, T>> _cache = new HashMap();
    private K _defaultContext;
    protected EventListenerList listenerList = new EventListenerList();

    public CacheMap(K defaultContext) {
        this._defaultContext = defaultContext;
    }

    protected Cache<K, T> getCache(Class<?> clazz) {
        if (clazz == null) {
            new IllegalArgumentException("Clazz cannot be null");
        }
        return this._cache.get(clazz);
    }

    public K[] getKeys(Class<?> clazz, K[] a) {
        Cache<K, T> cache = this.getCache(clazz);
        if (cache != null) {
            Set set = cache.keySet();
            return set.toArray(a);
        }
        return a;
    }

    protected Cache<K, T> initCache(Class<?> clazz) {
        Cache<K, T> editors = this.getCache(clazz);
        if (editors != null) {
            return editors;
        }
        editors = new Cache();
        this._cache.put(clazz, editors);
        return editors;
    }

    public void register(Class<?> clazz, T object, K context) {
        if (clazz == null) {
            throw new IllegalArgumentException("Parameter clazz cannot be null");
        }
        Cache<K, T> cache = this.initCache(clazz);
        cache.setObject(context, object);
        this.fireRegistrationChanged(new RegistrationEvent(this, 6099, object, clazz, context));
    }

    public void unregister(Class<?> clazz, K context) {
        Cache<K, T> cache = this.getCache(clazz);
        if (cache != null) {
            T object = cache.getObject(context);
            cache.setObject(context, null);
            this.fireRegistrationChanged(new RegistrationEvent(this, 6100, object, clazz, context));
        }
    }

    public T getRegisteredObject(Class<?> clazz, K context) {
        if (clazz == null) {
            return null;
        }
        Cache<K, T> cache = this.getCache(clazz);
        if (cache == null || !cache.containsKey(context)) {
            Class<?>[] interfaces;
            ArrayList classesToSearch = new ArrayList();
            for (Class<?> c : interfaces = clazz.getInterfaces()) {
                classesToSearch.add(c);
            }
            while (!clazz.isInterface() && (clazz = clazz.getSuperclass()) != null) {
                classesToSearch.add(clazz);
                for (Class<?> c : interfaces = clazz.getInterfaces()) {
                    classesToSearch.add(c);
                }
            }
            if (!classesToSearch.contains(Object.class)) {
                classesToSearch.add(Object.class);
            }
            for (Class clazz2 : classesToSearch) {
                cache = this.getCache(clazz2);
                if (cache == null) continue;
                T object = cache.getObject(context);
                if (object == null && !this._defaultContext.equals(context)) {
                    return this.getRegisteredObject(clazz2, this._defaultContext);
                }
                if (object == null) continue;
                return object;
            }
        } else {
            T object = cache.getObject(context);
            if (object == null && !this._defaultContext.equals(context)) {
                return this.getRegisteredObject(clazz, this._defaultContext);
            }
            if (object != null) {
                return object;
            }
        }
        return null;
    }

    public List<T> getValues() {
        ArrayList list = new ArrayList();
        Collection<Cache<K, T>> col = this._cache.values();
        for (Cache<K, T> o : col) {
            Collection col2 = o.values();
            for (Object o2 : col2) {
                if (list.contains(o2)) continue;
                list.add(o2);
            }
        }
        return list;
    }

    public void clear() {
        this._cache.clear();
        this.fireRegistrationChanged(new RegistrationEvent(this, 6101));
    }

    public void addRegistrationListener(RegistrationListener l) {
        this.listenerList.add(RegistrationListener.class, l);
    }

    public void removeRegistrationListener(RegistrationListener l) {
        this.listenerList.remove(RegistrationListener.class, l);
    }

    public RegistrationListener[] getRegistrationListeners() {
        return (RegistrationListener[])this.listenerList.getListeners(RegistrationListener.class);
    }

    public void fireRegistrationChanged(RegistrationEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != RegistrationListener.class) continue;
            ((RegistrationListener)listeners[i + 1]).registrationChanged(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Cache<K, T>
    extends HashMap<K, T> {
        Cache() {
        }

        public T getObject(K context) {
            return (T)this.get(context);
        }

        public void setObject(K context, T object) {
            if (object == null) {
                this.remove(context);
            } else {
                this.put(context, object);
            }
        }
    }
}

