/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import com.jidesoft.converter.Resource;
import java.awt.Font;
import java.util.Locale;
import java.util.ResourceBundle;

class FontConverter
implements ObjectConverter {
    FontConverter() {
    }

    public String toString(Object object, ConverterContext context) {
        if (object instanceof Font) {
            Font font = (Font)object;
            return font.getName() + ", " + this.getResourceString(font.getStyle()) + ", " + font.getSize();
        }
        return null;
    }

    protected String getResourceString(int style) {
        ResourceBundle resourceBundle = Resource.getResourceBundle(Locale.getDefault());
        switch (style) {
            case 0: {
                return resourceBundle.getString("Font.plain");
            }
            case 1: {
                return resourceBundle.getString("Font.bold");
            }
            case 2: {
                return resourceBundle.getString("Font.italic");
            }
            case 3: {
                return resourceBundle.getString("Font.boldItalic");
            }
        }
        return "";
    }

    protected int getStyleValue(String style) {
        ResourceBundle resourceBundle = Resource.getResourceBundle(Locale.getDefault());
        if (resourceBundle.getString("Font.italic").equalsIgnoreCase(style)) {
            return 2;
        }
        if (resourceBundle.getString("Font.bold").equalsIgnoreCase(style)) {
            return 1;
        }
        if (resourceBundle.getString("Font.boldItalic").equalsIgnoreCase(style)) {
            return 3;
        }
        return 0;
    }

    public boolean supportToString(Object object, ConverterContext context) {
        return true;
    }

    public Object fromString(String string, ConverterContext context) {
        if (string == null || string.length() == 0) {
            return null;
        }
        String fontFace = null;
        int style = 0;
        int size = 10;
        String[] strings = string.split(",");
        if (strings.length > 0) {
            fontFace = strings[0].trim();
        }
        if (strings.length > 1) {
            style = this.getStyleValue(strings[1].trim());
        }
        if (strings.length > 2) {
            try {
                size = Integer.parseInt(strings[2].trim());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (fontFace != null) {
            return new Font(fontFace, style, size);
        }
        return null;
    }

    public boolean supportFromString(String string, ConverterContext context) {
        return true;
    }
}

