/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.NumberConverter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;

public class NaturalNumberConverter
extends NumberConverter {
    public static ConverterContext CONTEXT = new ConverterContext("Natural Nunber");

    public NaturalNumberConverter() {
        this(DecimalFormat.getIntegerInstance());
    }

    public NaturalNumberConverter(NumberFormat format) {
        super(format);
    }

    public Object fromString(String string, ConverterContext context) {
        try {
            int value = this.getNumberFormat().parse(string).intValue();
            if (value < 0) {
                return 0;
            }
            return Integer.parseInt(string);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public boolean supportFromString(String string, ConverterContext context) {
        return true;
    }
}

