/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.BooleanConverter;
import com.jidesoft.converter.ByteConverter;
import com.jidesoft.converter.CacheMap;
import com.jidesoft.converter.CalendarConverter;
import com.jidesoft.converter.ColorConverter;
import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.CurrencyConverter;
import com.jidesoft.converter.DateConverter;
import com.jidesoft.converter.DefaultArrayConverter;
import com.jidesoft.converter.DefaultObjectConverter;
import com.jidesoft.converter.DimensionConverter;
import com.jidesoft.converter.DoubleConverter;
import com.jidesoft.converter.FileConverter;
import com.jidesoft.converter.FloatConverter;
import com.jidesoft.converter.FontConverter;
import com.jidesoft.converter.FontNameConverter;
import com.jidesoft.converter.HexColorConverter;
import com.jidesoft.converter.InsetsConverter;
import com.jidesoft.converter.IntegerConverter;
import com.jidesoft.converter.LongConverter;
import com.jidesoft.converter.MonthConverter;
import com.jidesoft.converter.MonthNameConverter;
import com.jidesoft.converter.NaturalNumberConverter;
import com.jidesoft.converter.ObjectConverter;
import com.jidesoft.converter.PasswordConverter;
import com.jidesoft.converter.PercentConverter;
import com.jidesoft.converter.PointConverter;
import com.jidesoft.converter.QuarterNameConverter;
import com.jidesoft.converter.RectangleConverter;
import com.jidesoft.converter.RegistrationListener;
import com.jidesoft.converter.RgbColorConverter;
import com.jidesoft.converter.ShortConverter;
import com.jidesoft.converter.StringArrayConverter;
import com.jidesoft.converter.YearNameConverter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.util.Calendar;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectConverterManager {
    private static CacheMap<ObjectConverter, ConverterContext> _cache = new CacheMap(ConverterContext.DEFAULT_CONTEXT);
    private static ObjectConverter _defaultConverter = new DefaultObjectConverter();
    private static boolean _inited = false;
    private static boolean _initing = false;
    private static boolean _autoInit = true;

    public static void registerConverter(Class<?> clazz, ObjectConverter converter, ConverterContext context) {
        if (clazz == null) {
            throw new IllegalArgumentException("Parameter class cannot be null");
        }
        if (context == null) {
            context = ConverterContext.DEFAULT_CONTEXT;
        }
        if (ObjectConverterManager.isAutoInit() && !_initing) {
            ObjectConverterManager.initDefaultConverter();
        }
        _cache.register(clazz, converter, context);
    }

    public static void registerConverter(Class<?> clazz, ObjectConverter converter) {
        ObjectConverterManager.registerConverter(clazz, converter, ConverterContext.DEFAULT_CONTEXT);
    }

    public static void unregisterConverter(Class<?> clazz, ConverterContext context) {
        if (context == null) {
            context = ConverterContext.DEFAULT_CONTEXT;
        }
        if (ObjectConverterManager.isAutoInit() && !_initing) {
            ObjectConverterManager.initDefaultConverter();
        }
        _cache.unregister(clazz, context);
    }

    public static void unregisterConverter(Class<?> clazz) {
        ObjectConverterManager.unregisterConverter(clazz, ConverterContext.DEFAULT_CONTEXT);
    }

    public static void unregisterAllConverters() {
        _cache.clear();
    }

    public static ObjectConverter getConverter(Class<?> clazz, ConverterContext context) {
        ObjectConverter converter;
        if (ObjectConverterManager.isAutoInit()) {
            ObjectConverterManager.initDefaultConverter();
        }
        if (context == null) {
            context = ConverterContext.DEFAULT_CONTEXT;
        }
        if ((converter = _cache.getRegisteredObject(clazz, context)) != null) {
            return converter;
        }
        return _defaultConverter;
    }

    public static ObjectConverter getConverter(Class<?> clazz) {
        return ObjectConverterManager.getConverter(clazz, ConverterContext.DEFAULT_CONTEXT);
    }

    public static String toString(Object object) {
        if (object != null) {
            return ObjectConverterManager.toString(object, object.getClass(), ConverterContext.DEFAULT_CONTEXT);
        }
        return "";
    }

    public static String toString(Object object, Class<?> clazz) {
        return ObjectConverterManager.toString(object, clazz, ConverterContext.DEFAULT_CONTEXT);
    }

    public static String toString(Object object, Class<?> clazz, ConverterContext context) {
        ObjectConverter converter = ObjectConverterManager.getConverter(clazz, context);
        if (converter != null && converter.supportToString(object, context)) {
            return converter.toString(object, context);
        }
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    public static Object fromString(String string, Class<?> clazz) {
        return ObjectConverterManager.fromString(string, clazz, ConverterContext.DEFAULT_CONTEXT);
    }

    public static Object fromString(String string, Class<?> clazz, ConverterContext context) {
        ObjectConverter converter = ObjectConverterManager.getConverter(clazz, context);
        if (converter != null && converter.supportFromString(string, context)) {
            return converter.fromString(string, context);
        }
        return null;
    }

    public static boolean isAutoInit() {
        return _autoInit;
    }

    public static void setAutoInit(boolean autoInit) {
        _autoInit = autoInit;
    }

    public static void addRegistrationListener(RegistrationListener l) {
        _cache.addRegistrationListener(l);
    }

    public static void removeRegistrationListener(RegistrationListener l) {
        _cache.removeRegistrationListener(l);
    }

    public static RegistrationListener[] getRegistrationListeners() {
        return _cache.getRegistrationListeners();
    }

    public static ConverterContext[] getConverterContexts(Class<?> clazz) {
        return _cache.getKeys(clazz, (ConverterContext[])new ConverterContext[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initDefaultConverter() {
        if (_inited) {
            return;
        }
        _initing = true;
        try {
            ObjectConverterManager.registerConverter(String.class, new DefaultObjectConverter());
            ObjectConverterManager.registerConverter(char[].class, new PasswordConverter(), PasswordConverter.CONTEXT);
            IntegerConverter integerConverter = new IntegerConverter();
            ObjectConverterManager.registerConverter(Integer.class, integerConverter);
            ObjectConverterManager.registerConverter(Integer.TYPE, integerConverter);
            NaturalNumberConverter naturalNumberConverter = new NaturalNumberConverter();
            ObjectConverterManager.registerConverter(Integer.class, naturalNumberConverter, NaturalNumberConverter.CONTEXT);
            ObjectConverterManager.registerConverter(Integer.TYPE, naturalNumberConverter, NaturalNumberConverter.CONTEXT);
            LongConverter longConverter = new LongConverter();
            ObjectConverterManager.registerConverter(Long.class, longConverter);
            ObjectConverterManager.registerConverter(Long.TYPE, longConverter);
            DoubleConverter doubleConverter = new DoubleConverter();
            ObjectConverterManager.registerConverter(Double.class, doubleConverter);
            ObjectConverterManager.registerConverter(Double.TYPE, doubleConverter);
            FloatConverter floatConverter = new FloatConverter();
            ObjectConverterManager.registerConverter(Float.class, floatConverter);
            ObjectConverterManager.registerConverter(Float.TYPE, floatConverter);
            ShortConverter shortConverter = new ShortConverter();
            ObjectConverterManager.registerConverter(Short.class, shortConverter);
            ObjectConverterManager.registerConverter(Short.TYPE, shortConverter);
            ByteConverter byteConverter = new ByteConverter();
            ObjectConverterManager.registerConverter(Byte.class, byteConverter);
            ObjectConverterManager.registerConverter(Byte.TYPE, byteConverter);
            ObjectConverterManager.registerConverter(Rectangle.class, new RectangleConverter());
            ObjectConverterManager.registerConverter(Point.class, new PointConverter());
            ObjectConverterManager.registerConverter(Insets.class, new InsetsConverter());
            ObjectConverterManager.registerConverter(Dimension.class, new DimensionConverter());
            BooleanConverter booleanConverter = new BooleanConverter();
            ObjectConverterManager.registerConverter(Boolean.class, booleanConverter);
            ObjectConverterManager.registerConverter(Boolean.TYPE, booleanConverter);
            ObjectConverterManager.registerConverter(File.class, new FileConverter());
            ObjectConverterManager.registerConverter(String.class, new FontNameConverter(), FontNameConverter.CONTEXT);
            DateConverter dateConverter = new DateConverter();
            ObjectConverterManager.registerConverter(Date.class, dateConverter);
            ObjectConverterManager.registerConverter(Date.class, dateConverter, DateConverter.DATETIME_CONTEXT);
            ObjectConverterManager.registerConverter(Date.class, dateConverter, DateConverter.TIME_CONTEXT);
            CalendarConverter calendarConverter = new CalendarConverter();
            ObjectConverterManager.registerConverter(Calendar.class, calendarConverter);
            ObjectConverterManager.registerConverter(Calendar.class, calendarConverter, DateConverter.DATETIME_CONTEXT);
            ObjectConverterManager.registerConverter(Calendar.class, calendarConverter, DateConverter.TIME_CONTEXT);
            ObjectConverterManager.registerConverter(Calendar.class, new MonthConverter(), MonthConverter.CONTEXT_MONTH);
            ObjectConverterManager.registerConverter(Color.class, new RgbColorConverter());
            ObjectConverterManager.registerConverter(Color.class, new HexColorConverter(), ColorConverter.CONTEXT_HEX);
            ObjectConverterManager.registerConverter(String[].class, new StringArrayConverter());
            QuarterNameConverter quarterNameConverter = new QuarterNameConverter();
            ObjectConverterManager.registerConverter(Integer.TYPE, quarterNameConverter, QuarterNameConverter.CONTEXT);
            ObjectConverterManager.registerConverter(Integer.class, quarterNameConverter, QuarterNameConverter.CONTEXT);
            ObjectConverterManager.registerConverter(Font.class, new FontConverter());
            CurrencyConverter currencyConverter = new CurrencyConverter();
            ObjectConverterManager.registerConverter(Float.class, currencyConverter, CurrencyConverter.CONTEXT);
            ObjectConverterManager.registerConverter(Float.TYPE, currencyConverter, CurrencyConverter.CONTEXT);
            ObjectConverterManager.registerConverter(Double.class, currencyConverter, CurrencyConverter.CONTEXT);
            ObjectConverterManager.registerConverter(Double.TYPE, currencyConverter, CurrencyConverter.CONTEXT);
            PercentConverter percentConverter = new PercentConverter();
            ObjectConverterManager.registerConverter(Float.class, percentConverter, PercentConverter.CONTEXT);
            ObjectConverterManager.registerConverter(Float.TYPE, percentConverter, PercentConverter.CONTEXT);
            ObjectConverterManager.registerConverter(Double.class, percentConverter, PercentConverter.CONTEXT);
            ObjectConverterManager.registerConverter(Double.TYPE, percentConverter, PercentConverter.CONTEXT);
            MonthNameConverter monthNameConverter = new MonthNameConverter();
            ObjectConverterManager.registerConverter(Integer.class, monthNameConverter, MonthNameConverter.CONTEXT);
            ObjectConverterManager.registerConverter(Integer.TYPE, monthNameConverter, MonthNameConverter.CONTEXT);
            YearNameConverter yearNameConverter = new YearNameConverter();
            ObjectConverterManager.registerConverter(Integer.class, yearNameConverter, YearNameConverter.CONTEXT);
            ObjectConverterManager.registerConverter(Integer.TYPE, yearNameConverter, YearNameConverter.CONTEXT);
            ObjectConverterManager.registerConverter(int[].class, new DefaultArrayConverter("; ", Integer.TYPE));
            ObjectConverterManager.registerConverter(Object[].class, new DefaultArrayConverter("; ", Object.class));
            ObjectConverterManager.registerConverter(String[].class, new DefaultArrayConverter("; ", String.class));
        }
        finally {
            _initing = false;
            _inited = true;
        }
    }

    public static void resetInit() {
        _inited = false;
    }
}

