/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.dialog;

import java.util.EventObject;

public class ButtonEvent
extends EventObject {
    public static final int BUTTON_EVENT_FIRST = 6999;
    public static final int BUTTON_EVENT_LAST = 7007;
    public static final int SHOW_BUTTON = 6999;
    public static final int HIDE_BUTTON = 7000;
    public static final int ENABLE_BUTTON = 7001;
    public static final int DISABLE_BUTTON = 7002;
    public static final int CHANGE_BUTTON_TEXT = 7003;
    public static final int CHANGE_BUTTON_MNEMONIC = 7004;
    public static final int CHANGE_BUTTON_TOOLTIP = 7005;
    public static final int CHANGE_BUTTON_FOCUS = 7006;
    public static final int SET_DEFAULT_BUTTON = 7007;
    private int _id;
    private String _buttonName;
    private String _userObject;

    public ButtonEvent(Object source, int id, String buttonName) {
        super(source);
        this._id = id;
        this._buttonName = buttonName;
        this.checkParam();
    }

    public ButtonEvent(Object source, int id, String buttonName, String userObject) {
        super(source);
        this._id = id;
        this._buttonName = buttonName;
        this._userObject = userObject;
        this.checkParam();
    }

    private void checkParam() {
        if (this.getID() < 6999 && this.getID() > 7007) {
            throw new IllegalArgumentException(this.getID() + " is an invalid event id for ButtonEvent");
        }
        if (this._buttonName == null || this._buttonName.trim().length() == 0) {
            throw new IllegalArgumentException("buttonName cannot be null or empty");
        }
        if (!(this._userObject != null && this._userObject.trim().length() != 0 || this.getID() != 7003 && this.getID() != 7004 && this.getID() != 7005)) {
            throw new IllegalArgumentException("userObject cannot be null or empty for " + this.paramString());
        }
    }

    public int getID() {
        return this._id;
    }

    public void setID(int id) {
        this._id = id;
    }

    public String getButtonName() {
        return this._buttonName;
    }

    public void setButtonName(String buttonName) {
        this._buttonName = buttonName;
    }

    public String getUserObject() {
        return this._userObject;
    }

    public void setUserObject(String userObject) {
        this._userObject = userObject;
    }

    public String paramString() {
        String typeStr;
        switch (this.getID()) {
            case 6999: {
                typeStr = "SHOW_BUTTON";
                break;
            }
            case 7000: {
                typeStr = "HIDE_BUTTON";
                break;
            }
            case 7001: {
                typeStr = "ENABLE_BUTTON";
                break;
            }
            case 7002: {
                typeStr = "DISABLE_BUTTON";
                break;
            }
            case 7003: {
                typeStr = "CHANGE_BUTTON_TEXT";
                break;
            }
            case 7004: {
                typeStr = "CHANGE_BUTTON_MNEMONIC";
                break;
            }
            case 7005: {
                typeStr = "CHANGE_BUTTON_TOOLTIP";
                break;
            }
            case 7006: {
                typeStr = "CHANGE_BUTTON_FOCUS";
                break;
            }
            case 7007: {
                typeStr = "SET_DEFAULT_BUTTON";
                break;
            }
            default: {
                typeStr = "BUTTON_EVENT_UNKNOWN";
            }
        }
        return typeStr;
    }
}

