/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.dialog;

import com.jidesoft.dialog.ButtonNames;
import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.dialog.StandardDialogPane;
import com.jidesoft.swing.DelegateAction;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;

public abstract class StandardDialog
extends JDialog
implements ButtonNames {
    private boolean _lazyConstructorCalled = false;
    protected StandardDialogPane _standardDialogPane = this.createStandardDialogPane();
    public static final int RESULT_CANCELLED = -1;
    public static final int RESULT_AFFIRMED = 0;
    private int _dialogResult = -1;
    public StandardDialogPropertyChangeListener _propertyChangeListener = new StandardDialogPropertyChangeListener();

    public StandardDialog() throws HeadlessException {
        this((Frame)null);
    }

    public StandardDialog(Frame owner) throws HeadlessException {
        this(owner, true);
    }

    public StandardDialog(Frame owner, boolean modal) throws HeadlessException {
        this(owner, "", modal);
    }

    public StandardDialog(Frame owner, String title) throws HeadlessException {
        this(owner, title, true);
    }

    public StandardDialog(Frame owner, String title, boolean modal) throws HeadlessException {
        super(owner, title, modal);
        this._standardDialogPane.addPropertyChangeListener(this._propertyChangeListener);
    }

    public StandardDialog(Dialog owner, boolean modal) throws HeadlessException {
        this(owner, "", modal);
    }

    public StandardDialog(Dialog owner, String title) throws HeadlessException {
        this(owner, title, true);
    }

    public StandardDialog(Dialog owner, String title, boolean modal) throws HeadlessException {
        super(owner, title, modal);
        this._standardDialogPane.addPropertyChangeListener(this._propertyChangeListener);
    }

    public StandardDialog(Dialog owner, String title, boolean modal, GraphicsConfiguration gc) throws HeadlessException {
        super(owner, title, modal, gc);
        this._standardDialogPane.addPropertyChangeListener(this._propertyChangeListener);
    }

    public int getDialogResult() {
        return this._dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this._dialogResult = dialogResult;
    }

    public Action getDefaultCancelAction() {
        return this._standardDialogPane.getDefaultCancelAction();
    }

    public void setDefaultCancelAction(Action defaultCancelAction) {
        this._standardDialogPane.setDefaultCancelAction(defaultCancelAction);
    }

    public Action getDefaultAction() {
        return this._standardDialogPane.getDefaultAction();
    }

    public void setDefaultAction(Action defaultAction) {
        this._standardDialogPane.setDefaultAction(defaultAction);
    }

    public void pack() {
        try {
            this.initialize();
        }
        catch (Exception e) {
            JideSwingUtilities.throwException(e);
        }
        super.pack();
    }

    public void show() {
        try {
            this.initialize();
        }
        catch (Exception e) {
            JideSwingUtilities.throwException(e);
        }
        super.show();
    }

    public final synchronized void initialize() {
        if (!this._lazyConstructorCalled && this.getParent() != null) {
            this.initComponents();
            this._lazyConstructorCalled = true;
            this.validate();
        }
    }

    protected void initComponents() {
        this.getContentPane().setLayout(new BorderLayout());
        this._standardDialogPane.initComponents();
        this.getContentPane().add(this._standardDialogPane);
        if (this.getInitFocusedComponent() != null) {
            this.addWindowListener(new WindowAdapter(){

                public void windowActivated(WindowEvent e) {
                    StandardDialog.this.getInitFocusedComponent().requestFocus();
                }
            });
        }
    }

    public Component getInitFocusedComponent() {
        return this._standardDialogPane.getInitFocusedComponent();
    }

    public void setInitFocusedComponent(Component initFocusedComponent) {
        this._standardDialogPane.setInitFocusedComponent(initFocusedComponent);
    }

    public JComponent getBannerPanel() {
        return this._standardDialogPane.getBannerPanel();
    }

    public JComponent getContentPanel() {
        return this._standardDialogPane.getContentPanel();
    }

    public ButtonPanel getButtonPanel() {
        return this._standardDialogPane.getButtonPanel();
    }

    public StandardDialogPane getStandardDialogPane() {
        return this._standardDialogPane;
    }

    public abstract JComponent createBannerPanel();

    public abstract JComponent createContentPanel();

    public abstract ButtonPanel createButtonPanel();

    protected StandardDialogPane createStandardDialogPane() {
        return new DefaultStandardDialogPane();
    }

    protected class DefaultStandardDialogPane
    extends StandardDialogPane {
        protected DefaultStandardDialogPane() {
        }

        public JComponent createBannerPanel() {
            return StandardDialog.this.createBannerPanel();
        }

        public JComponent createContentPanel() {
            return StandardDialog.this.createContentPanel();
        }

        public ButtonPanel createButtonPanel() {
            return StandardDialog.this.createButtonPanel();
        }
    }

    class StandardDialogPropertyChangeListener
    implements PropertyChangeListener {
        StandardDialogPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("defaultCancelAction".equals(evt.getPropertyName())) {
                DelegateAction delegateAction = new DelegateAction(StandardDialog.this.getDefaultCancelAction()){

                    public boolean delegateActionPerformed(ActionEvent e) {
                        MenuElement[] selectedPath = MenuSelectionManager.defaultManager().getSelectedPath();
                        if (selectedPath != null && selectedPath.length > 0) {
                            MenuSelectionManager.defaultManager().clearSelectedPath();
                            return true;
                        }
                        return false;
                    }
                };
                DelegateAction.replaceAction((JComponent)StandardDialog.this.getRootPane(), 2, KeyStroke.getKeyStroke(27, 0), delegateAction, false);
            } else if ("defaultAction".equals(evt.getPropertyName())) {
                StandardDialog.this.getRootPane().unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
                StandardDialog.this.getRootPane().registerKeyboardAction(StandardDialog.this.getDefaultAction(), KeyStroke.getKeyStroke(10, 0), 1);
            }
        }
    }
}

