/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.icons;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;

public class ColorFilter
extends RGBImageFilter {
    private boolean brighter;
    private int percent;
    private static ColorFilter _colorFilter = new ColorFilter(false, 0);

    public static ColorFilter getInstance(boolean brighter, int percent) {
        _colorFilter.setBrighter(brighter);
        _colorFilter.setPercent(percent);
        return _colorFilter;
    }

    public void setBrighter(boolean brighter) {
        this.brighter = brighter;
    }

    public void setPercent(int percent) {
        this.percent = percent;
    }

    public static Image createDimmedImage(Image i) {
        ColorFilter filter = ColorFilter.getInstance(true, 30);
        FilteredImageSource prod = new FilteredImageSource(i.getSource(), filter);
        Image image = Toolkit.getDefaultToolkit().createImage(prod);
        return image;
    }

    public static Image createBrighterImage(Image i) {
        ColorFilter filter = ColorFilter.getInstance(true, 30);
        FilteredImageSource prod = new FilteredImageSource(i.getSource(), filter);
        Image image = Toolkit.getDefaultToolkit().createImage(prod);
        return image;
    }

    public static Image createDarkerImage(Image i) {
        ColorFilter filter = ColorFilter.getInstance(false, 30);
        FilteredImageSource prod = new FilteredImageSource(i.getSource(), filter);
        Image image = Toolkit.getDefaultToolkit().createImage(prod);
        return image;
    }

    public ColorFilter(boolean b, int p) {
        this.brighter = b;
        this.percent = p;
        this.canFilterIndexColorModel = true;
    }

    public int filterRGB(int x, int y, int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        return rgb & 0xFF000000 | this.convert(r) << 16 | this.convert(g) << 8 | this.convert(b) << 0;
    }

    private int convert(int color) {
        color = this.brighter ? (color += (255 - color) * this.percent / 100) : (color -= (255 - color) * this.percent / 100);
        if (color < 0) {
            color = 0;
        }
        if (color > 255) {
            color = 255;
        }
        return color;
    }
}

