/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.icons;

import com.jidesoft.icons.ColorFilter;
import com.jidesoft.icons.MaskFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIDefaults;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IconsFactory {
    static Map<String, ImageIcon> icons = new HashMap<String, ImageIcon>();
    static Map<String, ImageIcon> disableIcons = new HashMap<String, ImageIcon>();
    static Map<String, ImageIcon> enhancedIcons = new HashMap<String, ImageIcon>();
    public static ImageIcon EMPTY_ICON = new ImageIcon(){

        public int getIconHeight() {
            return 16;
        }

        public int getIconWidth() {
            return 16;
        }

        public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
        }
    };

    public static ImageIcon getImageIcon(Class<?> clazz, String fileName) {
        String id = clazz.getName() + ":" + fileName;
        Icon saved = icons.get(id);
        if (saved != null) {
            return (ImageIcon)saved;
        }
        ImageIcon icon = IconsFactory.createImageIcon(clazz, fileName);
        icons.put(id, icon);
        return icon;
    }

    public static ImageIcon findImageIcon(Class<?> clazz, String fileName) throws IOException {
        String id = clazz.getName() + ":" + fileName;
        ImageIcon saved = icons.get(id);
        if (saved != null) {
            return saved;
        }
        ImageIcon icon = IconsFactory.createImageIconWithException(clazz, fileName);
        icons.put(id, icon);
        return icon;
    }

    public static ImageIcon getDisabledImageIcon(Class<?> clazz, String fileName) {
        String id = clazz.getName() + ":" + fileName;
        ImageIcon saved = disableIcons.get(id);
        if (saved != null) {
            return saved;
        }
        ImageIcon icon = IconsFactory.createGrayImage(IconsFactory.getImageIcon(clazz, fileName));
        disableIcons.put(id, icon);
        return icon;
    }

    public static ImageIcon getBrighterImageIcon(Class<?> clazz, String fileName) {
        String id = clazz.getName() + ":" + fileName;
        ImageIcon saved = enhancedIcons.get(id);
        if (saved != null) {
            return saved;
        }
        ImageIcon icon = IconsFactory.createBrighterImage(IconsFactory.getImageIcon(clazz, fileName));
        enhancedIcons.put(id, icon);
        return icon;
    }

    public static ImageIcon createGrayImage(Image image) {
        if (image == null) {
            return EMPTY_ICON;
        }
        return new ImageIcon(GrayFilter.createDisabledImage(image));
    }

    private static ImageIcon createGrayImage(ImageIcon icon) {
        if (icon == null) {
            return EMPTY_ICON;
        }
        return new ImageIcon(GrayFilter.createDisabledImage(icon.getImage()));
    }

    public static ImageIcon createGrayImage(Component c, Icon icon) {
        if (icon == null) {
            return EMPTY_ICON;
        }
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        if (w == 0 || h == 0) {
            return EMPTY_ICON;
        }
        BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        icon.paintIcon(c, image.getGraphics(), 0, 0);
        return new ImageIcon(GrayFilter.createDisabledImage(image));
    }

    public static ImageIcon createBrighterImage(Image image) {
        if (image == null) {
            return EMPTY_ICON;
        }
        return new ImageIcon(ColorFilter.createBrighterImage(image));
    }

    public static ImageIcon createBrighterImage(Component c, Icon icon) {
        if (icon == null) {
            return EMPTY_ICON;
        }
        BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        icon.paintIcon(c, image.getGraphics(), 0, 0);
        return new ImageIcon(ColorFilter.createBrighterImage(image));
    }

    private static ImageIcon createBrighterImage(ImageIcon icon) {
        if (icon == null) {
            return EMPTY_ICON;
        }
        return new ImageIcon(ColorFilter.createBrighterImage(icon.getImage()));
    }

    public static ImageIcon createNegativeImage(Image image) {
        if (image == null) {
            return EMPTY_ICON;
        }
        return new ImageIcon(MaskFilter.createNegativeImage(image));
    }

    private static ImageIcon createNegativeImage(ImageIcon icon) {
        return new ImageIcon(MaskFilter.createNegativeImage(icon.getImage()));
    }

    public static ImageIcon createMaskImage(Component c, Icon icon, Color oldColor, Color newColor) {
        BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        icon.paintIcon(c, image.getGraphics(), 0, 0);
        return new ImageIcon(MaskFilter.createImage(image, oldColor, newColor));
    }

    public static ImageIcon createNegativeImage(Component c, Icon icon) {
        BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        icon.paintIcon(c, image.getGraphics(), 0, 0);
        return new ImageIcon(MaskFilter.createNegativeImage(image));
    }

    private static void doPrivileged(final Runnable doRun) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                doRun.run();
                return null;
            }
        });
    }

    private static Object makeImageIcon(final Class<?> baseClass, final String gifFile) {
        return new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                final byte[][] buffer = new byte[1][];
                IconsFactory.doPrivileged(new Runnable(){

                    public void run() {
                        try {
                            int n;
                            InputStream resource = baseClass.getResourceAsStream(gifFile);
                            if (resource == null) {
                                return;
                            }
                            BufferedInputStream in = new BufferedInputStream(resource);
                            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
                            buffer[0] = new byte[1024];
                            while ((n = in.read(buffer[0])) > 0) {
                                out.write(buffer[0], 0, n);
                            }
                            in.close();
                            out.flush();
                            buffer[0] = out.toByteArray();
                        }
                        catch (IOException ioe) {
                            System.err.println(ioe.toString());
                        }
                    }
                });
                if (buffer[0] == null) {
                    System.err.println(baseClass.getName() + "/" + gifFile + " not found.");
                    return null;
                }
                if (buffer[0].length == 0) {
                    System.err.println("Warning: " + gifFile + " is zero-length");
                    return null;
                }
                return new ImageIcon(Toolkit.getDefaultToolkit().createImage(buffer[0]));
            }
        };
    }

    private static ImageIcon createImageIcon(Class<?> baseClass, String file) {
        try {
            return IconsFactory.createImageIconWithException(baseClass, file);
        }
        catch (IOException e) {
            System.err.println(e.getLocalizedMessage());
            return null;
        }
    }

    private static ImageIcon createImageIconWithException(Class<?> baseClass, String file) throws IOException {
        int n;
        InputStream resource = baseClass.getResourceAsStream(file);
        byte[][] buffer = new byte[1][];
        if (resource == null) {
            throw new IOException("File " + file + " not found");
        }
        BufferedInputStream in = new BufferedInputStream(resource);
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        buffer[0] = new byte[1024];
        while ((n = in.read(buffer[0])) > 0) {
            out.write(buffer[0], 0, n);
        }
        in.close();
        out.flush();
        buffer[0] = out.toByteArray();
        if (buffer[0] == null) {
            throw new IOException(baseClass.getName() + "/" + file + " not found.");
        }
        if (buffer[0].length == 0) {
            throw new IOException("Warning: " + file + " is zero-length");
        }
        return new ImageIcon(Toolkit.getDefaultToolkit().createImage(buffer[0]));
    }

    public static void generateHTML(Class<?> clazz) {
        String fullClassName = clazz.getName();
        String className = IconsFactory.getClassName(fullClassName);
        File file = new File(fullClassName + ".html");
        try {
            FileWriter writer = new FileWriter(file);
            writer.write("<html>\n<body>\n<p><b><font size=\"5\" face=\"Verdana\">Icons in " + fullClassName + "</font></b></p>");
            writer.write("<p><b><font size=\"3\" face=\"Verdana\">Generated by JIDE Icons</font></b></p>");
            writer.write("<p><b><font size=\"3\" color=\"#AAAAAA\" face=\"Verdana\">1. If you cannot view the images in this page, make sure the file is at the same directory as " + className + ".java</font></b></p>");
            writer.write("<p><b><font size=\"3\" color=\"#AAAAAA\" face=\"Verdana\">2. To get a particular icon in your code, call " + className + ".getImageIcon(FULL_CONSTANT_NAME). Replace FULL_CONSTANT_NAME with the actual " + "full constant name as in the table below" + "</font></b></p>");
            IconsFactory.generate(clazz, writer, className);
            writer.write("\n</body>\n</html>");
            writer.close();
            System.out.println("File is generated at \"" + file.getAbsolutePath() + "\". Please copy it to the same directory as " + className + ".java");
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    private static String getClassName(String fullName) {
        int last = fullName.lastIndexOf(".");
        if (last != -1) {
            fullName = fullName.substring(last + 1);
        }
        StringTokenizer tokenizer = new StringTokenizer(fullName, "$");
        StringBuffer buffer = new StringBuffer();
        while (tokenizer.hasMoreTokens()) {
            buffer.append(tokenizer.nextToken());
            buffer.append(".");
        }
        return buffer.substring(0, buffer.length() - 1);
    }

    private static void generate(Class<?> aClass, FileWriter writer, String prefix) throws IOException {
        Class<?>[] classes = aClass.getDeclaredClasses();
        for (int i = classes.length - 1; i >= 0; --i) {
            Class<?> clazz = classes[i];
            IconsFactory.generate(clazz, writer, IconsFactory.getClassName(clazz.getName()));
        }
        Field[] fields = aClass.getFields();
        writer.write("<p><font face=\"Verdana\"><b>" + prefix + "</b></font></p>");
        writer.write("<table border=\"1\" cellpadding=\"0\" cellspacing=\"0\" bordercolor=\"#CCCCCC\" width=\"66%\">");
        writer.write("<tr>\n");
        writer.write("<td width=\"24%\" align=\"center\"><b><font face=\"Verdana\" color=\"#003399\">Name</font></b></td>\n");
        writer.write("<td width=\"13%\" align=\"center\"><b><font face=\"Verdana\" color=\"#003399\">Image</font></b></td>\n");
        writer.write("<td width=\"32%\" align=\"center\"><b><font face=\"Verdana\" color=\"#003399\">File Name</font></b></td>\n");
        writer.write("<td width=\"31%\" align=\"center\"><b><font face=\"Verdana\" color=\"#003399\">Full Constant Name</font></b></td>\n");
        writer.write("</tr>\n");
        for (Field field : fields) {
            try {
                String name = field.getName();
                Object value = field.get(aClass);
                writer.write("<tr>\n");
                writer.write("<td align=\"left\"><font face=\"Verdana\">" + name + "</font></td>\n");
                writer.write("<td align=\"center\"><font face=\"Verdana\"><img border=\"0\" src=\"" + value + "\"></font></td>\n");
                writer.write("<td align=\"left\"><font face=\"Verdana\">" + value + "</font></td>\n");
                writer.write("<td align=\"left\"><font face=\"Verdana\">" + prefix + "." + name + "</font></td>\n");
                writer.write("</tr>\n");
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        writer.write("</table><br><p>\n");
    }

    public static ImageIcon getIcon(Component c, ImageIcon icon, int x, int y, int width, int height) {
        return IconsFactory.getIcon(c, icon, x, y, width, height, width, height);
    }

    public static ImageIcon getIcon(Component c, ImageIcon icon, int x, int y, int width, int height, int destWidth, int destHeight) {
        return IconsFactory.getIcon(c, icon, x, y, width, height, 2, destWidth, destHeight);
    }

    public static ImageIcon getIcon(Component c, ImageIcon icon, int x, int y, int width, int height, int imageType) {
        return IconsFactory.getIcon(c, icon, x, y, width, height, imageType, width, height);
    }

    public static ImageIcon getIcon(Component c, ImageIcon icon, int x, int y, int width, int height, int imageType, int destWidth, int destHeight) {
        if (icon == null || x < 0 || x + width > icon.getIconWidth() || y < 0 || y + height > icon.getIconHeight()) {
            return EMPTY_ICON;
        }
        BufferedImage image = new BufferedImage(destWidth, destHeight, imageType);
        image.getGraphics().drawImage(icon.getImage(), 0, 0, destWidth, destHeight, x, y, x + width, y + height, c);
        return new ImageIcon(image);
    }

    public static ImageIcon getOverlayIcon(Component c, ImageIcon icon, ImageIcon overlayIcon, int location) {
        return IconsFactory.getOverlayIcon(c, icon, overlayIcon, location, new Insets(0, 0, 0, 0));
    }

    public static ImageIcon getOverlayIcon(Component c, ImageIcon icon, ImageIcon overlayIcon, int location, Insets insets) {
        int x = -1;
        int y = -1;
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        int sw = overlayIcon.getIconWidth();
        int sh = overlayIcon.getIconHeight();
        switch (location) {
            case 0: {
                x = (w - sw) / 2;
                y = (h - sh) / 2;
                break;
            }
            case 1: {
                x = (w - sw) / 2;
                y = insets.top;
                break;
            }
            case 5: {
                x = (w - sw) / 2;
                y = h - insets.bottom - sh;
                break;
            }
            case 7: {
                x = insets.left;
                y = (h - sh) / 2;
                break;
            }
            case 3: {
                x = w - insets.right - sw;
                y = (h - sh) / 2;
                break;
            }
            case 2: {
                x = w - insets.top - sw;
                y = insets.right;
                break;
            }
            case 8: {
                x = insets.top;
                y = insets.left;
                break;
            }
            case 6: {
                x = insets.left;
                y = h - insets.bottom - sh;
                break;
            }
            case 4: {
                x = w - insets.right - sw;
                y = h - insets.bottom - sh;
            }
        }
        return IconsFactory.getOverlayIcon(c, icon, overlayIcon, x, y);
    }

    public static ImageIcon getOverlayIcon(Component c, ImageIcon icon, ImageIcon overlayIcon, int x, int y) {
        int w = icon == null ? overlayIcon.getIconWidth() : icon.getIconWidth();
        int h = icon == null ? overlayIcon.getIconHeight() : icon.getIconHeight();
        int sw = overlayIcon.getIconWidth();
        int sh = overlayIcon.getIconHeight();
        if (x != -1 && y != -1) {
            BufferedImage image = new BufferedImage(w, h, 2);
            if (icon != null) {
                image.getGraphics().drawImage(icon.getImage(), 0, 0, w, h, c);
            }
            image.getGraphics().drawImage(overlayIcon.getImage(), x, y, sw, sh, c);
            return new ImageIcon(image);
        }
        return icon;
    }
}

