/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf;

import com.jidesoft.icons.IconsFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.XPUtils;
import com.jidesoft.plaf.basic.Painter;
import com.jidesoft.plaf.eclipse.Eclipse3xMetalUtils;
import com.jidesoft.plaf.eclipse.Eclipse3xWindowsUtils;
import com.jidesoft.plaf.eclipse.EclipseMetalUtils;
import com.jidesoft.plaf.eclipse.EclipseWindowsUtils;
import com.jidesoft.plaf.office2003.Office2003Painter;
import com.jidesoft.plaf.office2003.Office2003WindowsUtils;
import com.jidesoft.plaf.vsnet.VsnetMetalUtils;
import com.jidesoft.plaf.vsnet.VsnetWindowsUtils;
import com.jidesoft.plaf.xerto.XertoMetalUtils;
import com.jidesoft.plaf.xerto.XertoWindowsUtils;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.ProductNames;
import com.jidesoft.utils.SecurityUtils;
import com.jidesoft.utils.SystemInfo;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class LookAndFeelFactory
implements ProductNames {
    public static final String WINDOWS_LNF = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    public static final String METAL_LNF = "javax.swing.plaf.metal.MetalLookAndFeel";
    public static final String AQUA_LNF = "apple.laf.AquaLookAndFeel";
    public static final String QUAQUA_LNF = "ch.randelshofer.quaqua.QuaquaLookAndFeel";
    public static final String ALLOY_LNF = "com.incors.plaf.alloy.AlloyLookAndFeel";
    public static final String SYNTHETICA_LNF = "de.javasoft.plaf.synthetica.SyntheticaStandardLookAndFeel";
    private static final String SYNTHETICA_LNF_PREFIX = "de.javasoft.plaf.synthetica.Synthetica";
    public static final String PLASTIC3D_LNF = "com.jgoodies.plaf.plastic.Plastic3DLookAndFeel";
    public static final String PLASTIC3D_LNF_1_3 = "com.jgoodies.looks.plastic.Plastic3DLookAndFeel";
    public static final String PLASTICXP_LNF = "com.jgoodies.looks.plastic.PlasticXPLookAndFeel";
    public static final String TONIC_LNF = "com.digitprop.tonic.TonicLookAndFeel";
    public static final String A03_LNF = "apprising.api.swing.plaf.a03.A03LookAndFeel";
    public static final String PGS_LNF = "com.pagosoft.plaf.PgsLookAndFeel";
    public static final String GTK_LNF = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
    public static final int VSNET_STYLE_WITHOUT_MENU = 0;
    public static final int VSNET_STYLE = 1;
    public static final int ECLIPSE_STYLE = 2;
    public static final int OFFICE2003_STYLE = 3;
    public static final int XERTO_STYLE = 4;
    public static final int XERTO_STYLE_WITHOUT_MENU = 6;
    public static final int ECLIPSE3X_STYLE = 5;
    private static int _style = -1;
    private static int _defaultStyle = -1;
    private static LookAndFeel _lookAndFeel;
    public static final String JIDE_EXTENSION_INSTALLLED = "jidesoft.extendsionInstalled";
    public static final String JIDE_STYLE_INSTALLED = "jidesoft.extendsionStyle";
    public static final String JIDE_STYLE = "jidesoft.extendsionStyle";
    private static List<UIDefaultsCustomizer> _uiDefaultsCustomizers;
    private static List<UIDefaultsInitializer> _uiDefaultsInitializers;
    private static int _productsUsed;

    protected LookAndFeelFactory() {
    }

    public static int getDefaultStyle() {
        if (_defaultStyle == -1) {
            int suggestedStyle;
            try {
                suggestedStyle = XPUtils.isXPStyleOn() && UIManager.getLookAndFeel() instanceof WindowsLookAndFeel ? 3 : 1;
            }
            catch (UnsupportedOperationException e) {
                suggestedStyle = 1;
            }
            return suggestedStyle;
        }
        return _defaultStyle;
    }

    public static void setDefaultStyle(int defaultStyle) {
        _defaultStyle = defaultStyle;
    }

    public static void installJideExtension() {
        LookAndFeelFactory.installJideExtension(LookAndFeelFactory.getDefaultStyle());
    }

    public static void installJideExtension(int style) {
        LookAndFeelFactory.installJideExtension(UIManager.getLookAndFeelDefaults(), UIManager.getLookAndFeel(), style);
    }

    public static boolean isJideExtensionInstalled() {
        return UIDefaultsLookup.getBoolean(JIDE_EXTENSION_INSTALLLED);
    }

    public static void installJideExtension(UIDefaults uiDefaults, LookAndFeel lnf, int style) {
        UIDefaultsCustomizer[] customizers;
        UIDefaultsInitializer[] initializers;
        if (LookAndFeelFactory.isJideExtensionInstalled() && _style == style && _lookAndFeel == lnf) {
            return;
        }
        _style = style;
        uiDefaults.put("jidesoft.extendsionStyle", (Object)_style);
        _lookAndFeel = lnf;
        for (UIDefaultsInitializer initializer : initializers = LookAndFeelFactory.getUIDefaultsInitializers()) {
            if (initializer == null) continue;
            initializer.initialize(uiDefaults);
        }
        if (lnf.getClass().getName().equals(ALLOY_LNF) && LookAndFeelFactory.isAlloyLnfInstalled() || lnf.getClass().getName().equals(PLASTIC3D_LNF) && LookAndFeelFactory.isPlastic3DLnfInstalled() || lnf.getClass().getName().equals(PLASTIC3D_LNF_1_3) && LookAndFeelFactory.isPlastic3D13LnfInstalled() || lnf.getClass().getName().equals(PLASTICXP_LNF) && LookAndFeelFactory.isPlasticXPLnfInstalled() || lnf.getClass().getName().equals(PGS_LNF) && LookAndFeelFactory.isPgsLnfInstalled() || lnf.getClass().getName().equals(TONIC_LNF) && LookAndFeelFactory.isTonicLnfInstalled()) {
            switch (style) {
                case 3: {
                    VsnetWindowsUtils.initComponentDefaults(uiDefaults);
                    Office2003WindowsUtils.initComponentDefaults(uiDefaults);
                    Office2003WindowsUtils.initClassDefaults(uiDefaults, false);
                    break;
                }
                case 0: 
                case 1: {
                    VsnetMetalUtils.initComponentDefaults(uiDefaults);
                    VsnetMetalUtils.initClassDefaults(uiDefaults);
                    Painter gripperPainter = new Painter(){

                        public void paint(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
                            Office2003Painter.getInstance().paintGripper(c, g, rect, orientation, state);
                        }
                    };
                    uiDefaults.put("Gripper.painter", gripperPainter);
                    uiDefaults.put("JideTabbedPane.gripperPainter", gripperPainter);
                    uiDefaults.put("JideTabbedPane.defaultTabShape", (Object)4);
                    uiDefaults.put("JideTabbedPane.defaultTabColorTheme", (Object)4);
                    uiDefaults.put("JideTabbedPane.selectedTabTextForeground", UIDefaultsLookup.getColor("controlText"));
                    uiDefaults.put("JideTabbedPane.unselectedTabTextForeground", UIDefaultsLookup.getColor("controlText"));
                    uiDefaults.put("JideTabbedPane.foreground", UIDefaultsLookup.getColor("controlText"));
                    uiDefaults.put("JideTabbedPane.light", UIDefaultsLookup.getColor("control"));
                    uiDefaults.put("JideSplitPaneDivider.gripperPainter", gripperPainter);
                    int products = LookAndFeelFactory.getProductsUsed();
                    if ((products & 1) == 0) break;
                    ImageIcon titleButtonImage = IconsFactory.getImageIcon(VsnetWindowsUtils.class, "icons/title_buttons_windows.gif");
                    int titleButtonSize = 10;
                    uiDefaults.put("DockableFrameUI", "com.jidesoft.plaf.vsnet.VsnetDockableFrameUI");
                    uiDefaults.put("DockableFrameTitlePane.hideIcon", IconsFactory.getIcon(null, titleButtonImage, 0, 0, 10, 10));
                    uiDefaults.put("DockableFrameTitlePane.unfloatIcon", IconsFactory.getIcon(null, titleButtonImage, 0, 10, 10, 10));
                    uiDefaults.put("DockableFrameTitlePane.floatIcon", IconsFactory.getIcon(null, titleButtonImage, 0, 20, 10, 10));
                    uiDefaults.put("DockableFrameTitlePane.autohideIcon", IconsFactory.getIcon(null, titleButtonImage, 0, 30, 10, 10));
                    uiDefaults.put("DockableFrameTitlePane.stopAutohideIcon", IconsFactory.getIcon(null, titleButtonImage, 0, 40, 10, 10));
                    uiDefaults.put("DockableFrameTitlePane.hideAutohideIcon", IconsFactory.getIcon(null, titleButtonImage, 0, 50, 10, 10));
                    uiDefaults.put("DockableFrameTitlePane.maximizeIcon", IconsFactory.getIcon(null, titleButtonImage, 0, 60, 10, 10));
                    uiDefaults.put("DockableFrameTitlePane.restoreIcon", IconsFactory.getIcon(null, titleButtonImage, 0, 70, 10, 10));
                    uiDefaults.put("DockableFrameTitlePane.buttonGap", (Object)4);
                    uiDefaults.put("DockableFrame.titleBorder", new BorderUIResource(BorderFactory.createEmptyBorder(1, 0, 3, 0)));
                    uiDefaults.put("DockableFrame.border", new BorderUIResource(BorderFactory.createEmptyBorder(2, 0, 0, 0)));
                    uiDefaults.put("DockableFrameTitlePane.gripperPainter", gripperPainter);
                    break;
                }
                case 2: {
                    EclipseMetalUtils.initComponentDefaults(uiDefaults);
                    EclipseMetalUtils.initClassDefaults(uiDefaults);
                    break;
                }
                case 5: {
                    Eclipse3xMetalUtils.initComponentDefaults(uiDefaults);
                    Eclipse3xMetalUtils.initClassDefaults(uiDefaults);
                    break;
                }
                case 4: 
                case 6: {
                    XertoMetalUtils.initComponentDefaults(uiDefaults);
                    XertoMetalUtils.initClassDefaults(uiDefaults);
                }
            }
        } else if (lnf.getClass().equals(MetalLookAndFeel.class.getName())) {
            switch (style) {
                case 1: 
                case 3: {
                    VsnetMetalUtils.initComponentDefaults(uiDefaults);
                    VsnetMetalUtils.initClassDefaultsWithMenu(uiDefaults);
                    break;
                }
                case 2: {
                    EclipseMetalUtils.initComponentDefaults(uiDefaults);
                    EclipseMetalUtils.initClassDefaults(uiDefaults);
                    break;
                }
                case 5: {
                    Eclipse3xMetalUtils.initComponentDefaults(uiDefaults);
                    Eclipse3xMetalUtils.initClassDefaults(uiDefaults);
                    break;
                }
                case 0: {
                    VsnetMetalUtils.initComponentDefaults(uiDefaults);
                    VsnetMetalUtils.initClassDefaults(uiDefaults);
                    break;
                }
                case 4: 
                case 6: {
                    XertoMetalUtils.initComponentDefaults(uiDefaults);
                    XertoMetalUtils.initClassDefaults(uiDefaults);
                    break;
                }
            }
        } else if (lnf instanceof MetalLookAndFeel) {
            switch (style) {
                case 3: {
                    VsnetMetalUtils.initComponentDefaults(uiDefaults);
                    VsnetMetalUtils.initClassDefaults(uiDefaults);
                    break;
                }
                case 2: {
                    EclipseMetalUtils.initClassDefaults(uiDefaults);
                    EclipseMetalUtils.initComponentDefaults(uiDefaults);
                    break;
                }
                case 5: {
                    Eclipse3xMetalUtils.initClassDefaults(uiDefaults);
                    Eclipse3xMetalUtils.initComponentDefaults(uiDefaults);
                    break;
                }
                case 0: 
                case 1: {
                    VsnetMetalUtils.initComponentDefaults(uiDefaults);
                    VsnetMetalUtils.initClassDefaults(uiDefaults);
                    break;
                }
                case 4: {
                    XertoMetalUtils.initComponentDefaults(uiDefaults);
                    XertoMetalUtils.initClassDefaults(uiDefaults);
                    break;
                }
            }
        } else if (lnf instanceof WindowsLookAndFeel) {
            switch (style) {
                case 3: {
                    VsnetWindowsUtils.initComponentDefaultsWithMenu(uiDefaults);
                    VsnetWindowsUtils.initClassDefaultsWithMenu(uiDefaults);
                    Office2003WindowsUtils.initClassDefaults(uiDefaults);
                    Office2003WindowsUtils.initComponentDefaults(uiDefaults);
                    break;
                }
                case 2: {
                    EclipseWindowsUtils.initClassDefaultsWithMenu(uiDefaults);
                    EclipseWindowsUtils.initComponentDefaultsWithMenu(uiDefaults);
                    break;
                }
                case 5: {
                    Eclipse3xWindowsUtils.initClassDefaultsWithMenu(uiDefaults);
                    Eclipse3xWindowsUtils.initComponentDefaultsWithMenu(uiDefaults);
                    break;
                }
                case 1: {
                    VsnetWindowsUtils.initComponentDefaultsWithMenu(uiDefaults);
                    VsnetWindowsUtils.initClassDefaultsWithMenu(uiDefaults);
                    break;
                }
                case 0: {
                    VsnetWindowsUtils.initComponentDefaults(uiDefaults);
                    VsnetWindowsUtils.initClassDefaults(uiDefaults);
                    break;
                }
                case 4: {
                    XertoWindowsUtils.initComponentDefaultsWithMenu(uiDefaults);
                    XertoWindowsUtils.initClassDefaultsWithMenu(uiDefaults);
                    break;
                }
                case 6: {
                    XertoWindowsUtils.initComponentDefaults(uiDefaults);
                    XertoWindowsUtils.initClassDefaults(uiDefaults);
                    break;
                }
            }
        } else if (lnf.getClass().getName().equals(AQUA_LNF) && LookAndFeelFactory.isAquaLnfInstalled() || lnf.getClass().getName().equals(QUAQUA_LNF) && LookAndFeelFactory.isQuaquaLnfInstalled()) {
            try {
                Class<?> aquaJideUtils = LookAndFeelFactory.getValidClassLoader().loadClass("com.jidesoft.plaf.aqua.AquaJideUtils");
                aquaJideUtils.getMethod("initComponentDefaults", UIDefaults.class).invoke(null, uiDefaults);
                aquaJideUtils.getMethod("initClassDefaults", UIDefaults.class).invoke(null, uiDefaults);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                JideSwingUtilities.throwInvocationTargetException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
        } else {
            if (lnf.getClass().getName().equals(GTK_LNF) && LookAndFeelFactory.isGTKLnfInstalled()) {
                new GTKInitializer().initialize(uiDefaults);
            } else if (lnf.getClass().getName().startsWith(SYNTHETICA_LNF_PREFIX) && LookAndFeelFactory.isSyntheticaLnfInstalled()) {
                new SyntheticaInitializer().initialize(uiDefaults);
            }
            switch (style) {
                case 3: {
                    if (SystemInfo.isWindows()) {
                        VsnetWindowsUtils.initComponentDefaultsWithMenu(uiDefaults);
                        Office2003WindowsUtils.initComponentDefaults(uiDefaults);
                        Office2003WindowsUtils.initClassDefaults(uiDefaults);
                        break;
                    }
                    VsnetMetalUtils.initComponentDefaults(uiDefaults);
                    VsnetMetalUtils.initClassDefaults(uiDefaults);
                    break;
                }
                case 2: {
                    if (SystemInfo.isWindows()) {
                        EclipseWindowsUtils.initClassDefaultsWithMenu(uiDefaults);
                        EclipseWindowsUtils.initComponentDefaultsWithMenu(uiDefaults);
                        break;
                    }
                    EclipseMetalUtils.initClassDefaults(uiDefaults);
                    EclipseMetalUtils.initComponentDefaults(uiDefaults);
                    break;
                }
                case 5: {
                    if (SystemInfo.isWindows()) {
                        Eclipse3xWindowsUtils.initClassDefaultsWithMenu(uiDefaults);
                        Eclipse3xWindowsUtils.initComponentDefaultsWithMenu(uiDefaults);
                        break;
                    }
                    Eclipse3xMetalUtils.initClassDefaults(uiDefaults);
                    Eclipse3xMetalUtils.initComponentDefaults(uiDefaults);
                    break;
                }
                case 1: {
                    if (SystemInfo.isWindows()) {
                        VsnetWindowsUtils.initClassDefaultsWithMenu(uiDefaults);
                        VsnetWindowsUtils.initComponentDefaultsWithMenu(uiDefaults);
                        break;
                    }
                    VsnetMetalUtils.initComponentDefaults(uiDefaults);
                    VsnetMetalUtils.initClassDefaults(uiDefaults);
                    break;
                }
                case 0: {
                    if (SystemInfo.isWindows()) {
                        VsnetWindowsUtils.initClassDefaults(uiDefaults);
                        VsnetWindowsUtils.initComponentDefaults(uiDefaults);
                        break;
                    }
                    VsnetMetalUtils.initComponentDefaults(uiDefaults);
                    VsnetMetalUtils.initClassDefaults(uiDefaults);
                    break;
                }
                case 4: {
                    if (SystemInfo.isWindows()) {
                        XertoWindowsUtils.initClassDefaultsWithMenu(uiDefaults);
                        XertoWindowsUtils.initComponentDefaultsWithMenu(uiDefaults);
                        break;
                    }
                    XertoMetalUtils.initComponentDefaults(uiDefaults);
                    XertoMetalUtils.initClassDefaults(uiDefaults);
                    break;
                }
                case 6: {
                    if (SystemInfo.isWindows()) {
                        XertoWindowsUtils.initClassDefaults(uiDefaults);
                        XertoWindowsUtils.initComponentDefaults(uiDefaults);
                        break;
                    }
                    XertoMetalUtils.initComponentDefaults(uiDefaults);
                    XertoMetalUtils.initClassDefaults(uiDefaults);
                    break;
                }
            }
            if (lnf.getClass().getName().startsWith(SYNTHETICA_LNF_PREFIX) && LookAndFeelFactory.isSyntheticaLnfInstalled()) {
                new SyntheticaCustomizer().customize(uiDefaults);
            }
        }
        UIManager.put(JIDE_EXTENSION_INSTALLLED, Boolean.TRUE);
        for (UIDefaultsCustomizer customizer : customizers = LookAndFeelFactory.getUIDefaultsCustomizers()) {
            if (customizer == null) continue;
            customizer.customize(uiDefaults);
        }
    }

    public static boolean isAquaLnfInstalled() {
        try {
            LookAndFeelFactory.getValidClassLoader().loadClass(AQUA_LNF);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static ClassLoader getValidClassLoader() {
        ClassLoader classLoader = LookAndFeelFactory.class.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    public static boolean isQuaquaLnfInstalled() {
        try {
            LookAndFeelFactory.getValidClassLoader().loadClass(QUAQUA_LNF);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isAlloyLnfInstalled() {
        try {
            LookAndFeelFactory.getValidClassLoader().loadClass(ALLOY_LNF);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isGTKLnfInstalled() {
        try {
            LookAndFeelFactory.getValidClassLoader().loadClass(GTK_LNF);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isPlastic3DLnfInstalled() {
        try {
            LookAndFeelFactory.getValidClassLoader().loadClass(PLASTIC3D_LNF);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isPlastic3D13LnfInstalled() {
        try {
            LookAndFeelFactory.getValidClassLoader().loadClass(PLASTIC3D_LNF_1_3);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isPlasticXPLnfInstalled() {
        try {
            LookAndFeelFactory.getValidClassLoader().loadClass(PLASTICXP_LNF);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isTonicLnfInstalled() {
        try {
            LookAndFeelFactory.getValidClassLoader().loadClass(TONIC_LNF);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isA03LnfInstalled() {
        try {
            LookAndFeelFactory.getValidClassLoader().loadClass(A03_LNF);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isPgsLnfInstalled() {
        try {
            LookAndFeelFactory.getValidClassLoader().loadClass(PGS_LNF);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isSyntheticaLnfInstalled() {
        try {
            LookAndFeelFactory.getValidClassLoader().loadClass(SYNTHETICA_LNF);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static void installDefaultLookAndFeelAndExtension() {
        LookAndFeelFactory.installDefaultLookAndFeel();
        LookAndFeelFactory.installJideExtension();
    }

    public static void installDefaultLookAndFeel() {
        try {
            String lnfName = SecurityUtils.getProperty("swing.defaultlaf", null);
            Class<?> lnfClass = null;
            if (lnfName != null) {
                try {
                    lnfClass = LookAndFeelFactory.getValidClassLoader().loadClass(lnfName);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (lnfClass == null) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel(lnfName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static LookAndFeel getLookAndFeel() {
        return _lookAndFeel;
    }

    public static int getStyle() {
        return _style;
    }

    public static UIDefaultsCustomizer[] getUIDefaultsCustomizers() {
        return _uiDefaultsCustomizers.toArray(new UIDefaultsCustomizer[_uiDefaultsCustomizers.size()]);
    }

    public static void addUIDefaultsCustomizer(UIDefaultsCustomizer uiDefaultsCustomizer) {
        if (!_uiDefaultsCustomizers.contains(uiDefaultsCustomizer)) {
            _uiDefaultsCustomizers.add(uiDefaultsCustomizer);
        }
    }

    public static void removeUIDefaultsCustomizer(UIDefaultsCustomizer uiDefaultsCustomizer) {
        _uiDefaultsCustomizers.remove(uiDefaultsCustomizer);
    }

    public static UIDefaultsInitializer[] getUIDefaultsInitializers() {
        return _uiDefaultsInitializers.toArray(new UIDefaultsInitializer[_uiDefaultsInitializers.size()]);
    }

    public static void addUIDefaultsInitializer(UIDefaultsInitializer uiDefaultsInitializer) {
        if (!_uiDefaultsInitializers.contains(uiDefaultsInitializer)) {
            _uiDefaultsInitializers.add(uiDefaultsInitializer);
        }
    }

    public static void removeUIDefaultsInitializer(UIDefaultsInitializer uiDefaultsInitializer) {
        _uiDefaultsInitializers.remove(uiDefaultsInitializer);
    }

    public static void verifyDefaults(UIDefaults table, Object[] keyValueList) {
        int max = keyValueList.length;
        for (int i = 0; i < max; i += 2) {
            Object value = keyValueList[i + 1];
            if (value == null) {
                System.out.println("The value for " + keyValueList[i] + " is null");
                continue;
            }
            Object oldValue = table.get(keyValueList[i]);
            if (oldValue == null) continue;
            System.out.println("The value for " + keyValueList[i] + " exists which is " + oldValue);
        }
    }

    public static void putDefaults(UIDefaults table, Object[] keyValueArray) {
        int max = keyValueArray.length;
        for (int i = 0; i < max; i += 2) {
            Object value = keyValueArray[i + 1];
            if (value == null) {
                table.remove(keyValueArray[i]);
                continue;
            }
            if (table.get(keyValueArray[i]) != null) continue;
            table.put(keyValueArray[i], value);
        }
    }

    public static void overwriteDefaults(UIDefaults table, Object[] keyValueArray) {
        int max = keyValueArray.length;
        for (int i = 0; i < max; i += 2) {
            Object value = keyValueArray[i + 1];
            if (value == null) {
                table.remove(keyValueArray[i]);
                continue;
            }
            table.put(keyValueArray[i], value);
        }
    }

    public static int getProductsUsed() {
        if (_productsUsed == -1) {
            _productsUsed = 0;
            try {
                Class.forName("com.jidesoft.docking.Product");
                _productsUsed |= 1;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            try {
                Class.forName("com.jidesoft.action.Product");
                _productsUsed |= 0x10;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            try {
                Class.forName("com.jidesoft.document.Product");
                _productsUsed |= 2;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            try {
                Class.forName("com.jidesoft.grid.Product");
                _productsUsed |= 4;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            try {
                Class.forName("com.jidesoft.wizard.Product");
                _productsUsed |= 8;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            try {
                Class.forName("com.jidesoft.pivot.Product");
                _productsUsed |= 0x20;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            try {
                Class.forName("com.jidesoft.shortcut.Product");
                _productsUsed |= 0x40;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            try {
                Class.forName("com.jidesoft.editor.Product");
                _productsUsed |= 0x80;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            try {
                Class.forName("com.jidesoft.rss.Product");
                _productsUsed |= 0x100;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return _productsUsed;
    }

    public static void setProductsUsed(int productsUsed) {
        _productsUsed = productsUsed;
    }

    static {
        _uiDefaultsCustomizers = new Vector<UIDefaultsCustomizer>();
        _uiDefaultsInitializers = new Vector<UIDefaultsInitializer>();
        _productsUsed = -1;
    }

    public static class SyntheticaCustomizer
    implements UIDefaultsCustomizer {
        public void customize(UIDefaults defaults) {
            Object[] uiDefaults = new Object[]{"DockableFrame.activeTitleForeground", UIDefaultsLookup.getColor("InternalFrame.activeTitleForeground")};
            LookAndFeelFactory.overwriteDefaults(defaults, uiDefaults);
        }
    }

    public static class SyntheticaInitializer
    implements UIDefaultsInitializer {
        public void initialize(UIDefaults defaults) {
            Object[] uiDefaults = new Object[]{"textHighlight", UIDefaultsLookup.getColor("InternalFrame.activeTitleBackground"), "controlText", UIDefaultsLookup.getColor("Label.foreground"), "activeCaptionText", UIDefaultsLookup.getColor("InternalFrame.activeTitleForeground"), "MenuItem.acceleratorFont", UIDefaultsLookup.getFont("Label.font"), "ComboBox.background", new ColorUIResource(Color.WHITE), "ComboBox.disabledForeground", defaults.get("Synthetica.comboBox.disabled.textColor"), "ComboBox.disabledBackground", defaults.get("Synthetica.comboBox.disabled.backgroundColor"), "activeCaption", UIDefaultsLookup.getColor("InternalFrame.activeTitleBackground"), "inactiveCaption", UIDefaultsLookup.getColor("InternalFrame.inactiveTitleBackground"), "control", new ColorUIResource(Color.WHITE), "controlLtHighlight", new ColorUIResource(Color.WHITE), "controlHighlight", new ColorUIResource(Color.LIGHT_GRAY), "controlShadow", new ColorUIResource(Color.DARK_GRAY), "controlDkShadow", new ColorUIResource(Color.BLACK), "MenuItem.background", new ColorUIResource(Color.GRAY), "SplitPane.background", UIDefaultsLookup.getColor("Label.background"), "Tree.hash", new ColorUIResource(Color.GRAY), "TextField.foreground", UIDefaultsLookup.getColor("Label.foreground"), "TextField.inactiveForeground", UIDefaultsLookup.getColor("Label.foreground"), "TextField.selectionForeground", UIDefaultsLookup.getColor("List.selectionForeground"), "TextField.selectionBackground", UIDefaultsLookup.getColor("List.selectionBackground"), "Table.gridColor", UIDefaultsLookup.getColor("Label.foreground"), "TextField.background", new ColorUIResource(Color.WHITE)};
            LookAndFeelFactory.putDefaults(defaults, uiDefaults);
        }
    }

    public static class GTKInitializer
    implements UIDefaultsInitializer {
        public void initialize(UIDefaults defaults) {
            Object[] uiDefaults = new Object[]{"activeCaption", defaults.getColor("textHighlight"), "activeCaptionText", defaults.getColor("textHighlightText"), "inactiveCaptionBorder", defaults.getColor("controlShadowtextHighlightText")};
            LookAndFeelFactory.putDefaults(defaults, uiDefaults);
        }
    }

    public static interface UIDefaultsInitializer {
        public void initialize(UIDefaults var1);
    }

    public static interface UIDefaultsCustomizer {
        public void customize(UIDefaults var1);
    }
}

