/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf;

import com.jidesoft.plaf.UIDefaultsLookup;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;

public class WindowsDesktopProperty
implements UIDefaults.ActiveValue {
    private static boolean updatePending;
    private WeakPCL pcl;
    private String key;
    private Object value;
    private Object fallback;
    private Toolkit toolkit;
    private float fontSize = -1.0f;
    private int fontStyle = -1;

    private static synchronized void setUpdatePending(boolean update) {
        updatePending = update;
    }

    private static synchronized boolean isUpdatePending() {
        return updatePending;
    }

    private static void updateAllUIs() {
        Frame[] appFrames = Frame.getFrames();
        for (int j = 0; j < appFrames.length; ++j) {
            WindowsDesktopProperty.updateWindowUI(appFrames[j]);
        }
    }

    private static void updateWindowUI(Window window) {
        SwingUtilities.updateComponentTreeUI(window);
        Window[] ownedWins = window.getOwnedWindows();
        for (int i = 0; i < ownedWins.length; ++i) {
            WindowsDesktopProperty.updateWindowUI(ownedWins[i]);
        }
    }

    public WindowsDesktopProperty(String key, Object fallback, Toolkit toolkit) {
        this.key = key;
        this.fallback = fallback;
        this.toolkit = toolkit;
    }

    public WindowsDesktopProperty(String key, Object fallback, Toolkit toolkit, float fontSize) {
        this.key = key;
        this.fallback = fallback;
        this.toolkit = toolkit;
        this.fontSize = fontSize;
    }

    public WindowsDesktopProperty(String key, Object fallback, Toolkit toolkit, float fontSize, int fontStyle) {
        this.key = key;
        this.fallback = fallback;
        this.toolkit = toolkit;
        this.fontSize = fontSize;
        this.fontStyle = fontStyle;
    }

    public Object createValue(UIDefaults table) {
        if (this.value == null) {
            this.value = this.configureValue(this.getValueFromDesktop());
            if (this.value == null) {
                this.value = this.configureValue(this.getDefaultValue());
            }
        }
        return this.value;
    }

    protected Object getValueFromDesktop() {
        if (this.toolkit == null) {
            this.toolkit = Toolkit.getDefaultToolkit();
        }
        Object value = this.toolkit.getDesktopProperty(this.getKey());
        this.pcl = new WeakPCL(this, this.toolkit);
        this.toolkit.addPropertyChangeListener(this.getKey(), this.pcl);
        return value;
    }

    protected Object getDefaultValue() {
        if (this.fallback instanceof String) {
            return UIDefaultsLookup.get(this.fallback);
        }
        return this.fallback;
    }

    public void invalidate() {
        if (this.pcl != null) {
            this.toolkit.removePropertyChangeListener(this.getKey(), this.pcl);
            this.toolkit = null;
            this.pcl = null;
            this.value = null;
        }
    }

    protected void updateUI() {
        if (!WindowsDesktopProperty.isUpdatePending()) {
            WindowsDesktopProperty.setUpdatePending(true);
            Runnable uiUpdater = new Runnable(){

                public void run() {
                    WindowsDesktopProperty.updateAllUIs();
                    WindowsDesktopProperty.setUpdatePending(false);
                }
            };
            SwingUtilities.invokeLater(uiUpdater);
        }
    }

    protected Object configureValue(Object value) {
        if (value != null) {
            if (value instanceof Color) {
                return new ColorUIResource((Color)value);
            }
            if (value instanceof Font) {
                if (this.fontSize != -1.0f && (float)this.fontStyle != -1.0f) {
                    return new FontUIResource(((Font)value).deriveFont(this.fontStyle, this.fontSize));
                }
                if (this.fontSize != -1.0f) {
                    return new FontUIResource(((Font)value).deriveFont(this.fontSize));
                }
                if ((float)this.fontStyle != -1.0f) {
                    return new FontUIResource(((Font)value).deriveFont(this.fontStyle));
                }
                return new FontUIResource((Font)value);
            }
            if (value instanceof UIDefaults.ProxyLazyValue) {
                value = ((UIDefaults.ProxyLazyValue)value).createValue(null);
            } else if (value instanceof UIDefaults.ActiveValue) {
                value = ((UIDefaults.ActiveValue)value).createValue(null);
            }
        }
        return value;
    }

    protected String getKey() {
        return this.key;
    }

    private static class WeakPCL
    extends WeakReference
    implements PropertyChangeListener {
        private Toolkit kit;

        WeakPCL(Object target, Toolkit kit) {
            super(target);
            this.kit = kit;
        }

        public void propertyChange(PropertyChangeEvent pce) {
            WindowsDesktopProperty property = (WindowsDesktopProperty)this.get();
            if (property == null) {
                this.kit.removePropertyChangeListener(pce.getPropertyName(), this);
            } else {
                property.invalidate();
                property.updateUI();
            }
        }
    }
}

