/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.icons.IconsFactory;
import com.jidesoft.plaf.JideButtonUI;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicJideButtonListener;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.ComponentStateSupport;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.SecurityUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class BasicJideButtonUI
extends JideButtonUI {
    protected int defaultTextIconGap;
    private int shiftOffset = 0;
    protected int defaultTextShiftOffset;
    private boolean defaults_initialized = false;
    private static final String propertyPrefix = "JideButton.";
    protected ThemePainter _painter;
    protected Color _shadowColor;
    protected Color _darkShadowColor;
    protected Color _highlight;
    protected Color _lightHighlightColor;
    protected Color _focusColor;
    protected boolean _isFloatingIcon = false;
    protected static Rectangle viewRect = new Rectangle();
    protected static Rectangle textRect = new Rectangle();
    protected static Rectangle iconRect = new Rectangle();

    public static ComponentUI createUI(JComponent c) {
        return new BasicJideButtonUI();
    }

    protected String getPropertyPrefix() {
        return propertyPrefix;
    }

    public void installUI(JComponent c) {
        this.installDefaults((AbstractButton)c);
        this.installListeners((AbstractButton)c);
        this.installKeyboardActions((AbstractButton)c);
        BasicHTML.updateRenderer(c, ((AbstractButton)c).getText());
    }

    protected void installDefaults(AbstractButton b) {
        this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        String pp = this.getPropertyPrefix();
        if (!this.defaults_initialized) {
            this.defaultTextIconGap = (Integer)UIDefaultsLookup.get(pp + "textIconGap");
            this.defaultTextShiftOffset = (Integer)UIDefaultsLookup.get(pp + "textShiftOffset");
            this._focusColor = UIDefaultsLookup.getColor("Button.focus");
            this._shadowColor = UIDefaultsLookup.getColor("controlShadow");
            this._darkShadowColor = UIDefaultsLookup.getColor("controlDkShadow");
            this._highlight = UIDefaultsLookup.getColor("controlHighlight");
            this._lightHighlightColor = UIDefaultsLookup.getColor("controlLtHighlight");
            this.defaults_initialized = true;
        }
        if (b.getMargin() == null || b.getMargin() instanceof UIResource) {
            b.setMargin(UIDefaultsLookup.getInsets(pp + "margin"));
        }
        LookAndFeel.installColorsAndFont(b, pp + "background", pp + "foreground", pp + "font");
        LookAndFeel.installBorder(b, pp + "border");
        this._isFloatingIcon = UIDefaultsLookup.getBoolean("Icon.floating");
    }

    protected void installListeners(AbstractButton b) {
        BasicButtonListener listener = this.createButtonListener(b);
        if (listener != null) {
            b.putClientProperty(this, listener);
            b.addMouseListener(listener);
            b.addMouseMotionListener(listener);
            b.addFocusListener(listener);
            b.addPropertyChangeListener(listener);
            b.addChangeListener(listener);
        }
    }

    protected void installKeyboardActions(AbstractButton b) {
        BasicButtonListener listener = (BasicButtonListener)b.getClientProperty(this);
        if (listener != null) {
            listener.installKeyboardActions(b);
        }
    }

    public void uninstallUI(JComponent c) {
        this.uninstallKeyboardActions((AbstractButton)c);
        this.uninstallListeners((AbstractButton)c);
        this.uninstallDefaults((AbstractButton)c);
        BasicHTML.updateRenderer(c, "");
    }

    protected void uninstallKeyboardActions(AbstractButton b) {
        BasicButtonListener listener = (BasicButtonListener)b.getClientProperty(this);
        if (listener != null) {
            listener.uninstallKeyboardActions(b);
        }
    }

    protected void uninstallListeners(AbstractButton b) {
        BasicButtonListener listener = (BasicButtonListener)b.getClientProperty(this);
        b.putClientProperty(this, null);
        if (listener != null) {
            b.removeMouseListener(listener);
            b.removeMouseMotionListener(listener);
            b.removeFocusListener(listener);
            b.removeChangeListener(listener);
            b.removePropertyChangeListener(listener);
        }
    }

    protected void uninstallDefaults(AbstractButton b) {
        this._painter = null;
        this._focusColor = null;
        this._shadowColor = null;
        this._highlight = null;
        this._lightHighlightColor = null;
        this._darkShadowColor = null;
        this.defaults_initialized = false;
    }

    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new BasicJideButtonListener(b);
    }

    public int getDefaultTextIconGap(AbstractButton b) {
        return this.defaultTextIconGap;
    }

    protected Color getFocusColor() {
        return this._focusColor;
    }

    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        boolean isHorizontal = true;
        if (JideSwingUtilities.getOrientationOf(c) == 1) {
            isHorizontal = false;
        }
        FontMetrics fm = g.getFontMetrics();
        Insets i = c.getInsets();
        BasicJideButtonUI.viewRect.x = i.left;
        BasicJideButtonUI.viewRect.y = i.top;
        BasicJideButtonUI.viewRect.width = b.getWidth() - (i.right + BasicJideButtonUI.viewRect.x);
        BasicJideButtonUI.viewRect.height = b.getHeight() - (i.bottom + BasicJideButtonUI.viewRect.y);
        BasicJideButtonUI.textRect.height = 0;
        BasicJideButtonUI.textRect.width = 0;
        BasicJideButtonUI.textRect.y = 0;
        BasicJideButtonUI.textRect.x = 0;
        BasicJideButtonUI.iconRect.height = 0;
        BasicJideButtonUI.iconRect.width = 0;
        BasicJideButtonUI.iconRect.y = 0;
        BasicJideButtonUI.iconRect.x = 0;
        this.paintBackground(g, b, viewRect, textRect, iconRect);
        Font f = c.getFont();
        g.setFont(f);
        String text = JideSwingUtilities.layoutCompoundLabel(c, fm, b.getText(), b.getIcon(), isHorizontal, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
        this.clearTextShiftOffset();
        this.paintIcon(b, g);
        if (text != null && !text.equals("")) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                this.paintText(g, b, textRect, text);
            }
        }
    }

    protected void paintIcon(AbstractButton b, Graphics g) {
        if (b.getIcon() != null) {
            Icon icon = this.getIcon(b);
            ButtonModel model = b.getModel();
            if (icon != null) {
                if (this.isFloatingIcon() && model.isEnabled()) {
                    if (model.isRollover() && !model.isPressed() && !model.isSelected()) {
                        if (!"true".equals(SecurityUtils.getProperty("shadingtheme", "false")) && b instanceof JideButton && ((JideButton)b).getButtonStyle() == 0) {
                            if (icon instanceof ImageIcon) {
                                ImageIcon shadow = IconsFactory.createGrayImage(((ImageIcon)icon).getImage());
                                shadow.paintIcon(b, g, BasicJideButtonUI.iconRect.x + 1, BasicJideButtonUI.iconRect.y + 1);
                            } else {
                                ImageIcon shadow = IconsFactory.createGrayImage(b, icon);
                                shadow.paintIcon(b, g, BasicJideButtonUI.iconRect.x + 1, BasicJideButtonUI.iconRect.y + 1);
                            }
                            icon.paintIcon(b, g, BasicJideButtonUI.iconRect.x - 1, BasicJideButtonUI.iconRect.y - 1);
                        } else {
                            icon.paintIcon(b, g, BasicJideButtonUI.iconRect.x, BasicJideButtonUI.iconRect.y);
                        }
                    } else {
                        icon.paintIcon(b, g, BasicJideButtonUI.iconRect.x, BasicJideButtonUI.iconRect.y);
                    }
                } else {
                    icon.paintIcon(b, g, BasicJideButtonUI.iconRect.x, BasicJideButtonUI.iconRect.y);
                }
            }
        }
    }

    protected Icon getIcon(AbstractButton b) {
        ButtonModel model = b.getModel();
        Icon icon = b.getIcon();
        Icon tmpIcon = null;
        if (!model.isEnabled()) {
            tmpIcon = model.isSelected() ? b.getDisabledSelectedIcon() : b.getDisabledIcon();
            if (tmpIcon == null) {
                icon = icon instanceof ImageIcon ? IconsFactory.createGrayImage(((ImageIcon)icon).getImage()) : IconsFactory.createGrayImage(b, icon);
            }
        } else if (model.isPressed() && model.isArmed()) {
            tmpIcon = b.getPressedIcon();
            if (tmpIcon != null) {
                this.clearTextShiftOffset();
            }
        } else if (b.isRolloverEnabled() && model.isRollover()) {
            tmpIcon = model.isSelected() ? b.getRolloverSelectedIcon() : b.getRolloverIcon();
        } else if (model.isSelected()) {
            tmpIcon = b.getSelectedIcon();
        }
        if (tmpIcon != null) {
            icon = tmpIcon;
        }
        return icon;
    }

    protected boolean isFloatingIcon() {
        return this._isFloatingIcon;
    }

    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        AbstractButton b = (AbstractButton)c;
        boolean isHorizontal = true;
        if (JideSwingUtilities.getOrientationOf(c) == 1) {
            isHorizontal = false;
        }
        ButtonModel model = b.getModel();
        FontMetrics fm = g.getFontMetrics();
        int mnemonicIndex = b.getDisplayedMnemonicIndex();
        if (!isHorizontal) {
            Graphics2D g2d = (Graphics2D)g;
            AffineTransform oldAt = g2d.getTransform();
            g2d.rotate(1.5707963267948966);
            g2d.translate(0, -c.getWidth() + 1);
            if (model.isEnabled()) {
                int state = JideSwingUtilities.getButtonState(b);
                Color foreground = null;
                if (b instanceof ComponentStateSupport) {
                    foreground = ((ComponentStateSupport)((Object)b)).getForegroundOfState(state);
                }
                if (foreground == null || foreground instanceof UIResource) {
                    foreground = b.getForeground();
                }
                g2d.setColor(foreground);
                JideSwingUtilities.drawStringUnderlineCharAt(b, g2d, text, mnemonicIndex, textRect.y + this.getTextShiftOffset(), textRect.x + fm.getAscent() + this.getTextShiftOffset());
            } else {
                Color color = UIDefaultsLookup.getColor("Button.disabledForeground");
                g.setColor(color == null ? b.getBackground().darker() : color);
                JideSwingUtilities.drawStringUnderlineCharAt(b, g2d, text, mnemonicIndex, textRect.y, textRect.x + fm.getAscent());
            }
            g2d.setTransform(oldAt);
        } else if (model.isEnabled()) {
            int state = JideSwingUtilities.getButtonState(b);
            Color foreground = null;
            if (b instanceof ComponentStateSupport) {
                foreground = ((ComponentStateSupport)((Object)b)).getForegroundOfState(state);
            }
            if (foreground == null || foreground instanceof UIResource) {
                foreground = b.getForeground();
            }
            g.setColor(foreground);
            JideSwingUtilities.drawStringUnderlineCharAt(b, g, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset());
            if (b instanceof JideButton && ((JideButton)b).getButtonStyle() == 3 && (((JideButton)b).isAlwaysShowHyperlink() || b.getModel().isRollover())) {
                g.drawLine(textRect.x, textRect.y + textRect.height - 2, textRect.x + textRect.width, textRect.y + textRect.height - 2);
            }
        } else {
            Color color = UIDefaultsLookup.getColor("Button.disabledForeground");
            g.setColor(color == null ? b.getBackground().darker() : color);
            JideSwingUtilities.drawStringUnderlineCharAt(b, g, text, mnemonicIndex, textRect.x, textRect.y + fm.getAscent());
        }
    }

    protected void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text) {
        this.paintText(g, (JComponent)b, textRect, text);
    }

    protected void paintBackground(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        boolean paintDefaultBorder = true;
        Object o = b.getClientProperty("JideButton.paintDefaultBorder");
        if (o instanceof Boolean) {
            paintDefaultBorder = (Boolean)o;
        }
        boolean paintBackground = (o = b.getClientProperty("JideButton.alwaysPaintBackground")) instanceof Boolean ? ((Boolean)o).booleanValue() : b.isOpaque();
        Rectangle rect = new Rectangle(0, 0, b.getWidth(), b.getHeight());
        if (paintBackground) {
            g.setColor(b.getBackground());
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
        }
        if (b.isContentAreaFilled()) {
            if (b instanceof JideButton && ((JideButton)b).getButtonStyle() == 0) {
                int state = JideSwingUtilities.getButtonState(b);
                if (state != 0) {
                    this.getPainter().paintButtonBackground(b, g, rect, 0, state);
                } else if (paintBackground) {
                    this.getPainter().paintButtonBackground(b, g, rect, 0, state);
                    if ("true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
                        JideSwingUtilities.fillGradient(g, rect, 0);
                    }
                }
            } else if (b instanceof JideButton && ((JideButton)b).getButtonStyle() == 2) {
                if (b.getModel().isSelected() && b.getModel().isPressed()) {
                    g.setColor(this._shadowColor);
                    g.drawLine(0, 0, b.getWidth() - 1, 0);
                    g.drawLine(0, 0, 0, b.getHeight() - 1);
                    g.setColor(this._lightHighlightColor);
                    g.drawLine(0, b.getHeight() - 1, b.getWidth() - 1, b.getHeight() - 1);
                    g.drawLine(b.getWidth() - 1, 0, b.getWidth() - 1, b.getHeight() - 1);
                } else if (b.getModel().isSelected()) {
                    JideSwingUtilities.paintBackground(g, rect, this._highlight, this._highlight);
                    g.setColor(this._shadowColor);
                    g.drawLine(0, 0, b.getWidth() - 1, 0);
                    g.drawLine(0, 0, 0, b.getHeight() - 1);
                    g.setColor(this._lightHighlightColor);
                    g.drawLine(0, b.getHeight() - 1, b.getWidth() - 1, b.getHeight() - 1);
                    g.drawLine(b.getWidth() - 1, 0, b.getWidth() - 1, b.getHeight() - 1);
                } else if (b.getModel().isPressed()) {
                    JideSwingUtilities.paintBackground(g, rect, this._highlight, this._highlight);
                    g.setColor(this._shadowColor);
                    g.drawLine(0, 0, b.getWidth() - 1, 0);
                    g.drawLine(0, 0, 0, b.getHeight() - 1);
                    g.setColor(this._lightHighlightColor);
                    g.drawLine(0, b.getHeight() - 1, b.getWidth() - 1, b.getHeight() - 1);
                    g.drawLine(b.getWidth() - 1, 0, b.getWidth() - 1, b.getHeight() - 1);
                } else if (b.getModel().isRollover() || b.hasFocus() && b.isFocusPainted()) {
                    JideSwingUtilities.paintBackground(g, rect, this._highlight, this._highlight);
                    g.setColor(this._lightHighlightColor);
                    g.drawLine(0, 0, b.getWidth() - 1, 0);
                    g.drawLine(0, 0, 0, b.getHeight() - 1);
                    g.setColor(this._shadowColor);
                    g.drawLine(0, b.getHeight() - 1, b.getWidth() - 1, b.getHeight() - 1);
                    g.drawLine(b.getWidth() - 1, 0, b.getWidth() - 1, b.getHeight() - 1);
                } else if (paintBackground) {
                    this.getPainter().paintButtonBackground(b, g, rect, 0, 0);
                }
            } else if (b instanceof JideButton && ((JideButton)b).getButtonStyle() == 1) {
                if (b.getModel().isPressed()) {
                    this.getPainter().paintButtonBackground(b, g, rect, 0, 1);
                    if (paintDefaultBorder) {
                        g.setColor(this._darkShadowColor);
                        g.drawLine(0, 0, b.getWidth() - 2, 0);
                        g.drawLine(0, 0, 0, b.getHeight() - 2);
                        g.setColor(this._shadowColor);
                        g.drawLine(1, 1, b.getWidth() - 3, 1);
                        g.drawLine(1, 1, 1, b.getHeight() - 3);
                        g.setColor(this._lightHighlightColor);
                        g.drawLine(0, b.getHeight() - 1, b.getWidth() - 1, b.getHeight() - 1);
                        g.drawLine(b.getWidth() - 1, 0, b.getWidth() - 1, b.getHeight() - 1);
                    }
                } else if (b.getModel().isSelected() && b.getModel().isRollover()) {
                    this.getPainter().paintButtonBackground(b, g, rect, 0, 1);
                    if (paintDefaultBorder) {
                        g.setColor(this._darkShadowColor);
                        g.drawLine(0, 0, b.getWidth() - 2, 0);
                        g.drawLine(0, 0, 0, b.getHeight() - 2);
                        g.setColor(this._shadowColor);
                        g.drawLine(1, 1, b.getWidth() - 3, 1);
                        g.drawLine(1, 1, 1, b.getHeight() - 3);
                        g.setColor(this._lightHighlightColor);
                        g.drawLine(0, b.getHeight() - 1, b.getWidth() - 1, b.getHeight() - 1);
                        g.drawLine(b.getWidth() - 1, 0, b.getWidth() - 1, b.getHeight() - 1);
                    }
                } else if (b.getModel().isSelected()) {
                    this.getPainter().paintButtonBackground(b, g, rect, 0, 3);
                    if (paintDefaultBorder) {
                        g.setColor(this._darkShadowColor);
                        g.drawLine(0, 0, b.getWidth() - 2, 0);
                        g.drawLine(0, 0, 0, b.getHeight() - 2);
                        g.setColor(this._shadowColor);
                        g.drawLine(1, 1, b.getWidth() - 3, 1);
                        g.drawLine(1, 1, 1, b.getHeight() - 3);
                        g.setColor(this._lightHighlightColor);
                        g.drawLine(0, b.getHeight() - 1, b.getWidth() - 1, b.getHeight() - 1);
                        g.drawLine(b.getWidth() - 1, 0, b.getWidth() - 1, b.getHeight() - 1);
                    }
                } else if (b.getModel().isRollover() || b.hasFocus() && b.isFocusPainted()) {
                    this.getPainter().paintButtonBackground(b, g, rect, 0, 2);
                    if (paintDefaultBorder) {
                        g.setColor(this._lightHighlightColor);
                        g.drawLine(0, 0, b.getWidth() - 1, 0);
                        g.drawLine(0, 0, 0, b.getHeight() - 1);
                        g.setColor(this._shadowColor);
                        g.drawLine(1, b.getHeight() - 2, b.getWidth() - 2, b.getHeight() - 2);
                        g.drawLine(b.getWidth() - 2, 1, b.getWidth() - 2, b.getHeight() - 2);
                        g.setColor(this._darkShadowColor);
                        g.drawLine(0, b.getHeight() - 1, b.getWidth() - 1, b.getHeight() - 1);
                        g.drawLine(b.getWidth() - 1, 0, b.getWidth() - 1, b.getHeight() - 1);
                    }
                } else if (paintBackground) {
                    this.getPainter().paintButtonBackground(b, g, rect, 0, 0);
                } else {
                    g.setColor(this._lightHighlightColor);
                    g.drawLine(0, 0, b.getWidth() - 1, 0);
                    g.drawLine(0, 0, 0, b.getHeight() - 1);
                    g.setColor(this._shadowColor);
                    g.drawLine(0, b.getHeight() - 1, b.getWidth() - 1, b.getHeight() - 1);
                    g.drawLine(b.getWidth() - 1, 0, b.getWidth() - 1, b.getHeight() - 1);
                }
                if (paintBackground) {
                    g.setColor(this._lightHighlightColor);
                    g.drawLine(0, 0, b.getWidth() - 1, 0);
                    g.drawLine(0, 0, 0, b.getHeight() - 1);
                    g.setColor(this._shadowColor);
                    g.drawLine(0, b.getHeight() - 1, b.getWidth() - 1, b.getHeight() - 1);
                    g.drawLine(b.getWidth() - 1, 0, b.getWidth() - 1, b.getHeight() - 1);
                }
            }
        }
    }

    protected void clearTextShiftOffset() {
        this.shiftOffset = 0;
    }

    protected void setTextShiftOffset() {
        this.shiftOffset = this.defaultTextShiftOffset;
    }

    protected int getTextShiftOffset() {
        return this.shiftOffset;
    }

    public Dimension getMinimumSize(JComponent c) {
        Dimension d = this.getPreferredSize(c);
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            if (JideSwingUtilities.getOrientationOf(c) == 0) {
                d.width = (int)((float)d.width - (v.getPreferredSpan(0) - v.getMinimumSpan(0)));
            } else {
                d.height = (int)((float)d.height - (v.getPreferredSpan(0) - v.getMinimumSpan(0)));
            }
        }
        return d;
    }

    public Dimension getPreferredSize(JComponent c) {
        AbstractButton b = (AbstractButton)c;
        Dimension d = BasicGraphicsUtils.getPreferredButtonSize(b, b.getIconTextGap());
        if (JideSwingUtilities.getOrientationOf(c) == 0) {
            return d;
        }
        return new Dimension(d.height, d.width);
    }

    public Dimension getMaximumSize(JComponent c) {
        Dimension d = this.getPreferredSize(c);
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            d.width = (int)((float)d.width + (v.getMaximumSpan(0) - v.getPreferredSpan(0)));
        }
        return d;
    }

    public ThemePainter getPainter() {
        return this._painter;
    }
}

