/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.eclipse;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicPainter;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.plaf.eclipse.EclipseUtils;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class EclipsePainter
extends BasicPainter {
    private static EclipsePainter _instance;
    protected Color _shadowColor = UIDefaultsLookup.getColor("controlShadow");
    protected Color _darkShadowColor = UIDefaultsLookup.getColor("controlDkShadow");
    protected Color _highlight = UIDefaultsLookup.getColor("controlHighlight");
    protected Color _lightHighlightColor = UIDefaultsLookup.getColor("controlLtHighlight");

    public static ThemePainter getInstance() {
        if (_instance == null) {
            _instance = new EclipsePainter();
        }
        return _instance;
    }

    protected EclipsePainter() {
    }

    public void paintButtonBackground(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        Color oldColor = g.getColor();
        if (state != 0) {
            if (state == 2) {
                if (orientation == 0) {
                    g.setColor(this._lightHighlightColor);
                    g.drawLine(rect.x, rect.y, rect.x + rect.width - 1, rect.y);
                    g.drawLine(rect.x, rect.y, rect.x, rect.y + rect.height - 1);
                    g.setColor(this._shadowColor);
                    g.drawLine(rect.x, rect.y + rect.height - 1, rect.x + rect.width - 1, rect.y + rect.height - 1);
                    g.drawLine(rect.x + rect.width - 1, rect.y, rect.x + rect.width - 1, rect.x + rect.height - 1);
                } else {
                    g.setColor(this._lightHighlightColor);
                    g.drawLine(rect.x, rect.y, rect.x, rect.y + rect.height - 1);
                    g.drawLine(rect.x, rect.y + rect.height - 1, rect.x + rect.width - 1, rect.y + rect.height - 1);
                    g.setColor(this._shadowColor);
                    g.drawLine(rect.x, rect.y, rect.x + rect.width - 1, rect.y);
                    g.drawLine(rect.x + rect.width - 1, rect.y, rect.x + rect.width - 1, rect.x + rect.height - 1);
                }
            } else if (state == 3) {
                EclipseUtils.fillRectWithHatch((Graphics2D)g, new Rectangle(2, 2, rect.width - 4, rect.height - 4), UIDefaultsLookup.getColor("JideButton.background"));
                if (orientation == 0) {
                    g.setColor(this._shadowColor);
                    g.drawLine(rect.x, rect.y, rect.x + rect.width - 1, rect.y);
                    g.drawLine(rect.x, rect.y, rect.x, rect.y + rect.height - 1);
                    g.setColor(this._lightHighlightColor);
                    g.drawLine(rect.x, rect.y + rect.height - 1, rect.x + rect.width - 1, rect.y + rect.height - 1);
                    g.drawLine(rect.x + rect.width - 1, rect.y, rect.x + rect.width - 1, rect.y + rect.height - 1);
                } else {
                    g.setColor(this._shadowColor);
                    g.drawLine(rect.x, rect.y, rect.x, rect.y + rect.height - 1);
                    g.drawLine(rect.x, rect.y + rect.height - 1, rect.x + rect.width - 1, rect.y + rect.height - 1);
                    g.setColor(this._lightHighlightColor);
                    g.drawLine(rect.x, rect.y, rect.x + rect.width - 1, rect.y);
                    g.drawLine(rect.x + rect.width - 1, rect.y, rect.x + rect.width - 1, rect.y + rect.height - 1);
                }
            } else if (state == 1) {
                g.setColor(this._shadowColor);
                g.drawLine(rect.x, rect.y, rect.x + rect.width - 1, rect.y);
                g.drawLine(rect.x, rect.y, rect.x, rect.y + rect.height - 1);
                g.setColor(this._lightHighlightColor);
                g.drawLine(rect.x, rect.y + rect.height - 1, rect.x + rect.width - 1, rect.y + rect.height - 1);
                g.drawLine(rect.x + rect.width - 1, rect.y, rect.x + rect.width - 1, rect.y + rect.height - 1);
            }
        }
        g.setColor(oldColor);
    }

    public void paintSelectedMenu(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
    }

    public void paintGripper(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        int h = orientation == 0 ? rect.height : rect.width;
        h -= 4;
        int y = rect.y + 2;
        int x = rect.x + 2;
        Color oldColor = g.getColor();
        if (orientation == 0) {
            g.setColor(this._lightHighlightColor);
            g.drawLine(x, y, x, y + h);
            g.drawLine(x, y, x + 2, y);
            g.setColor(this._shadowColor);
            g.drawLine(x + 2, y, x + 2, y + h);
            g.drawLine(x, y + h, x + 2, y + h);
            g.setColor(UIDefaultsLookup.getColor("JideButton.background"));
            g.drawLine(x + 1, y + 1, x + 1, y + h - 1);
        } else {
            g.setColor(this._lightHighlightColor);
            g.drawLine(x, y, x + h, y);
            g.drawLine(x, y, x, y + 2);
            g.setColor(this._shadowColor);
            g.drawLine(x, y + 2, x + h, y + 2);
            g.drawLine(x + h, y, x + h, y + 2);
            g.setColor(UIDefaultsLookup.getColor("JideButton.background"));
            g.drawLine(x + 1, y + 1, x + h - 1, y + 1);
        }
        g.setColor(oldColor);
    }

    public void paintDockableFrameTitlePane(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        int x = rect.x;
        int y = rect.y;
        int w = c.getWidth();
        int h = rect.height;
        if (c.getBorder() != null) {
            Insets insets = c.getBorder().getBorderInsets(c);
            x += insets.left;
            y += insets.top;
            w -= insets.right + insets.left;
            h -= insets.top + insets.bottom;
        }
        g.setColor(Color.white);
        g.drawLine(x, y, x + w, y);
        g.drawLine(x, y, x, y + h - 1);
        g.setColor(Color.gray);
        g.drawLine(x, y + h - 1, x + w, y + h - 1);
        if (state == 3) {
            int width = rect.width;
            Graphics2D g2d = (Graphics2D)g;
            JideSwingUtilities.fillGradient(g2d, new Rectangle(x + 1, y + 1, width / 2, h - 2), UIDefaultsLookup.getColor("DockableFrame.activeTitleBackground"), UIDefaultsLookup.getColor("DockableFrame.activeTitleBackground2"), false);
            JideSwingUtilities.fillGradient(g2d, new Rectangle(x + 1 + width / 2, y + 1, width / 2, h - 2), UIDefaultsLookup.getColor("DockableFrame.activeTitleBackground2"), UIDefaultsLookup.getColor("DockableFrame.background"), false);
        }
    }
}

