/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.vsnet;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicJideTabbedPaneUI;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.JideTabbedPane;
import com.jidesoft.utils.ColorUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class VsnetJideTabbedPaneUI
extends BasicJideTabbedPaneUI {
    protected Color _backgroundSelectedColorStart;
    protected Color _backgroundSelectedColorEnd;
    protected Color _backgroundUnselectedColorStart;
    protected Color _backgroundUnselectedColorEnd;

    public static ComponentUI createUI(JComponent c) {
        return new VsnetJideTabbedPaneUI();
    }

    public void installColorTheme() {
        super.installColorTheme();
        int tabStyle = this.getTabShape();
        int colorTheme = this.getColorTheme();
        switch (tabStyle) {
            case 3: {
                if (colorTheme == 3) {
                    this._selectColor2 = this._selectColor1 = this._shadow;
                } else if (colorTheme == 4) {
                    this._selectColor2 = this._selectColor1 = UIDefaultsLookup.getColor("TextArea.selectionBackground");
                }
                this._unselectColor1 = this.getPainter().getControlShadow();
                this._unselectColor2 = this._lightHighlight;
                break;
            }
            case 8: {
                if (this._tabPane.getColorTheme() != 3) break;
                this._selectColor2 = null;
                this._selectColor3 = null;
                this._unselectColor2 = this._lightHighlight;
                this._unselectColor3 = this._shadow;
                break;
            }
            case 1: 
            case 11: {
                if (this._tabPane.getColorTheme() == 3) {
                    this._selectColor1 = this.getPainter().getTabbedPaneSelectDk();
                    this._selectColor2 = this.getPainter().getTabbedPaneSelectLt();
                    this._selectColor3 = this.getPainter().getControlDk();
                    this._unselectColor1 = this.getPainter().getControlDk();
                    this._unselectColor2 = null;
                    this._unselectColor3 = null;
                }
                if (this._tabPane.getColorTheme() != 4) break;
                this._selectColor1 = this.getPainter().getTabbedPaneSelectDk();
                this._selectColor2 = this.getPainter().getTabbedPaneSelectLt();
                this._selectColor3 = this.getPainter().getControlDk();
                this._unselectColor1 = this.getPainter().getControlDk();
                this._unselectColor2 = null;
                this._unselectColor3 = null;
            }
        }
        this.installBackgroundColor();
    }

    protected void installBackgroundColor() {
        int colorTheme = this.getColorTheme();
        switch (this.getTabShape()) {
            case 2: {
                this._backgroundSelectedColorStart = this._highlight;
                this._backgroundSelectedColorEnd = this._highlight;
                this._backgroundUnselectedColorStart = null;
                this._backgroundUnselectedColorEnd = null;
                break;
            }
            case 9: {
                if (colorTheme == 1) {
                    this._backgroundSelectedColorStart = this._highlight;
                    this._backgroundSelectedColorEnd = this._highlight;
                    this._backgroundUnselectedColorStart = null;
                    this._backgroundUnselectedColorEnd = null;
                    break;
                }
                this._backgroundSelectedColorStart = this._background;
                this._backgroundSelectedColorEnd = this._highlight;
                this._backgroundUnselectedColorStart = null;
                this._backgroundUnselectedColorEnd = null;
                break;
            }
            case 5: 
            case 10: {
                this._backgroundSelectedColorStart = this._highlight;
                this._backgroundSelectedColorEnd = this._highlight;
                this._backgroundUnselectedColorStart = this._highlight;
                this._backgroundUnselectedColorEnd = this._highlight;
                break;
            }
            case 3: {
                if (colorTheme == 1) {
                    this._backgroundSelectedColorStart = this._highlight;
                    this._backgroundSelectedColorEnd = this._highlight;
                    this._backgroundUnselectedColorStart = null;
                    this._backgroundUnselectedColorEnd = null;
                    break;
                }
                if (this._tabPane.getColorTheme() == 3) {
                    this._backgroundSelectedColorStart = this._lightHighlight;
                    this._backgroundSelectedColorEnd = this._lightHighlight;
                    this._backgroundUnselectedColorStart = null;
                    this._backgroundUnselectedColorEnd = null;
                    break;
                }
                if (this._tabPane.getColorTheme() != 4) break;
                this._backgroundSelectedColorStart = this._lightHighlight;
                this._backgroundSelectedColorEnd = this._highlight;
                this._backgroundUnselectedColorStart = null;
                this._backgroundUnselectedColorEnd = null;
                break;
            }
            case 8: {
                if (this._tabPane.getColorTheme() == 1) {
                    this._backgroundSelectedColorStart = this._highlight;
                    this._backgroundSelectedColorEnd = this._highlight;
                    this._backgroundUnselectedColorStart = this._lightHighlight;
                    this._backgroundUnselectedColorEnd = this._lightHighlight;
                    break;
                }
                if (this._tabPane.getColorTheme() == 3) {
                    this._backgroundSelectedColorStart = this._lightHighlight;
                    this._backgroundSelectedColorEnd = this._lightHighlight;
                    this._backgroundUnselectedColorStart = this._highlight;
                    this._backgroundUnselectedColorEnd = this._highlight;
                    break;
                }
                this._backgroundSelectedColorStart = this._lightHighlight;
                this._backgroundSelectedColorEnd = this._lightHighlight;
                this._backgroundUnselectedColorStart = this._lightHighlight;
                this._backgroundUnselectedColorEnd = this._highlight;
                break;
            }
            case 1: 
            case 11: {
                if (colorTheme == 3 || colorTheme == 4) {
                    this._backgroundSelectedColorStart = this._lightHighlight;
                    this._backgroundSelectedColorEnd = this._lightHighlight;
                    this._backgroundUnselectedColorStart = this._lightHighlight;
                    this._backgroundUnselectedColorEnd = this._highlight;
                    break;
                }
                this._backgroundSelectedColorStart = this._highlight;
                this._backgroundSelectedColorEnd = this._highlight;
                this._backgroundUnselectedColorStart = this._highlight;
                this._backgroundUnselectedColorEnd = this._highlight;
                break;
            }
            case 4: {
                if (colorTheme == 1) {
                    this._backgroundSelectedColorStart = this._highlight;
                    this._backgroundSelectedColorEnd = this._highlight;
                    this._backgroundUnselectedColorStart = this._highlight;
                    this._backgroundUnselectedColorEnd = this._highlight;
                    break;
                }
                if (colorTheme == 4) {
                    this._backgroundSelectedColorStart = this._lightHighlight;
                    this._backgroundSelectedColorEnd = this._lightHighlight;
                    this._backgroundUnselectedColorStart = this._lightHighlight;
                    this._backgroundUnselectedColorEnd = this._highlight;
                    break;
                }
                this._backgroundSelectedColorStart = this._lightHighlight;
                this._backgroundSelectedColorEnd = this._lightHighlight;
                this._backgroundUnselectedColorStart = this._lightHighlight;
                this._backgroundUnselectedColorEnd = this._highlight;
            }
        }
    }

    public void uninstallColorTheme() {
        super.uninstallColorTheme();
        this._backgroundSelectedColorStart = null;
        this._backgroundSelectedColorEnd = null;
        this._backgroundUnselectedColorStart = null;
        this._backgroundUnselectedColorEnd = null;
    }

    public void paintBackground(Graphics g, Component c) {
        if (this._tabPane.isOpaque()) {
            int width = c.getWidth();
            int height = c.getHeight();
            int h = 0;
            int w = 0;
            if (this._tabPane.getTabCount() <= 0) {
                return;
            }
            h = this._tabPane.getBoundsAt((int)0).height;
            w = this._tabPane.getBoundsAt((int)0).width;
            int temp1 = -1;
            int temp2 = -1;
            if (this.isTabLeadingComponentVisible()) {
                if (h < this._tabLeadingComponent.getSize().height) {
                    h = this._tabLeadingComponent.getSize().height;
                    temp1 = this._tabLeadingComponent.getSize().height;
                }
                if (w < this._tabLeadingComponent.getSize().width) {
                    w = this._tabLeadingComponent.getSize().width;
                    temp2 = this._tabLeadingComponent.getSize().width;
                }
            }
            if (this.isTabTrailingComponentVisible()) {
                if (h < this._tabTrailingComponent.getSize().height && temp1 < this._tabTrailingComponent.getSize().height) {
                    h = this._tabTrailingComponent.getSize().height;
                }
                if (w < this._tabTrailingComponent.getSize().width && temp2 < this._tabTrailingComponent.getSize().width) {
                    w = this._tabTrailingComponent.getSize().width;
                }
            }
            if (this.getTabShape() == 3) {
                g.setColor(UIDefaultsLookup.getColor("control"));
                g.fillRect(0, 0, width, height);
            } else if (this.getColorTheme() == 3) {
                g.setColor(this._background);
                g.fillRect(0, 0, width, height);
            } else {
                g.setColor(UIDefaultsLookup.getColor("control"));
                g.fillRect(0, 0, width, height);
            }
        }
    }

    protected void paintTabAreaBackground(Graphics g, Rectangle rect, int tabPlacement) {
        if (this._tabPane.isOpaque()) {
            int tabShape = this.getTabShape();
            if (tabShape != 3) {
                if (this.getColorTheme() == 1) {
                    g.setColor(UIDefaultsLookup.getColor("control"));
                    g.fillRect(rect.x, rect.y, rect.width, rect.height);
                } else if (this.getColorTheme() == 3) {
                    super.paintTabAreaBackground(g, rect, tabPlacement);
                } else {
                    g.setColor(UIDefaultsLookup.getColor("control"));
                    g.fillRect(rect.x, rect.y, rect.width, rect.height);
                }
            } else {
                g.setColor(UIDefaultsLookup.getColor("control"));
                g.fillRect(rect.x, rect.y, rect.width, rect.height);
            }
        }
    }

    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        super.paintTabBackground(g, tabPlacement, tabIndex, x, y, w, h, isSelected);
        Graphics2D g2d = (Graphics2D)g;
        if (this.tabRegion != null) {
            Color[] colors = this.getGradientColors(tabIndex, isSelected);
            Color backgroundStart = colors[0];
            Color backgroundEnd = colors[1];
            if (backgroundEnd != null && backgroundStart != null) {
                switch (tabPlacement) {
                    case 2: {
                        JideSwingUtilities.fillGradient(g2d, this.tabRegion, backgroundStart, backgroundEnd, false);
                        break;
                    }
                    case 4: {
                        JideSwingUtilities.fillGradient(g2d, this.tabRegion, backgroundEnd, backgroundStart, false);
                        break;
                    }
                    case 3: {
                        JideSwingUtilities.fillGradient(g2d, this.tabRegion, backgroundEnd, backgroundStart, true);
                        break;
                    }
                    default: {
                        JideSwingUtilities.fillGradient(g2d, this.tabRegion, backgroundStart, backgroundEnd, true);
                    }
                }
            }
        }
        if (this.getTabShape() == 11 && this._mouseEnter && tabIndex == this._indexMouseOver && !isSelected && this._tabPane.isEnabledAt(this._indexMouseOver)) {
            this.paintTabBackgroundMouseOver(g, tabPlacement, tabIndex, x, y, w, h, isSelected, this._backgroundUnselectedColorStart, this._backgroundUnselectedColorEnd);
        }
    }

    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (selectedIndex < 0) {
            return;
        }
        Rectangle selRect = this.getTabBounds(selectedIndex, this._calcRect);
        Rectangle viewRect = this._tabScroller.viewport.getViewRect();
        Rectangle r = this._rects[selectedIndex];
        int tabShape = this.getTabShape();
        Insets contentInsets = this.getContentBorderInsets(tabPlacement);
        if (tabShape == 4) {
            if (this._tabPane.getColorTheme() == 1) {
                g.setColor(this._shadow);
            } else {
                g.setColor(this._selectColor1);
            }
            if (contentInsets.left > 0) {
                g.drawLine(x, y, x, y + h - 1);
            }
            if (contentInsets.right > 0) {
                g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
            }
            if (contentInsets.bottom > 0) {
                g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
            }
            if (!this._tabPane.isTabShown() || r.x >= viewRect.x + viewRect.width) {
                g.drawLine(x, y, x + w - 1, y);
            } else {
                g.drawLine(x, y, selRect.x - selRect.height + 2, y);
                g.drawLine(selRect.x + selRect.width, y, x + w - 1, y);
            }
        } else if (tabShape == 8) {
            if (this._tabPane.getColorTheme() == 1) {
                g.setColor(Color.BLACK);
            } else {
                g.setColor(this.getPainter().getControlShadow());
            }
            g.drawLine(x, y, selRect.x - selRect.height / 2 + 4, y);
            if (contentInsets.left > 0) {
                g.drawLine(x, y, x, y + h - 1);
            }
            if (contentInsets.right > 0) {
                g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
            }
            if (contentInsets.bottom > 0) {
                g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
            }
            if (!this._tabPane.isTabShown() || r.x >= viewRect.x + viewRect.width) {
                g.drawLine(x, y, x + w - 1, y);
            } else if (!this._tabPane.isShowIconsOnTab() && !this._tabPane.isUseDefaultShowIconsOnTab()) {
                g.drawLine(selRect.x + selRect.width + selRect.height / 2 - 4, y, x + w - 1, y);
            } else {
                g.drawLine(selRect.x + selRect.width + selRect.height / 2 - 6, y, x + w - 1, y);
            }
        } else if (tabShape == 1 || tabShape == 11) {
            if (this._tabPane.getColorTheme() == 3 || this._tabPane.getColorTheme() == 4) {
                g.setColor(this.getPainter().getControlDk());
            } else {
                g.setColor(this.getBorderEdgeColor());
            }
            if (this._tabPane.getColorTheme() == 3 || this._tabPane.getColorTheme() == 4) {
                g.drawLine(x, y, selRect.x - 1, y);
            } else {
                g.drawLine(x, y, selRect.x - 1, y);
            }
            if (contentInsets.left > 0) {
                g.drawLine(x, y, x, y + h - 1);
            }
            if (!this._tabPane.isTabShown() || r.x >= viewRect.x + viewRect.width) {
                if (this._tabPane.getColorTheme() == 3 || this._tabPane.getColorTheme() == 4) {
                    g.setColor(this.getPainter().getControlDk());
                } else {
                    g.setColor(this._lightHighlight);
                }
                g.drawLine(x, y, x + w - 1, y);
            } else if (this._tabPane.getColorTheme() == 3 || this._tabPane.getColorTheme() == 4) {
                g.setColor(this.getPainter().getControlDk());
                g.drawLine(selRect.x + selRect.width + 2, y, x + w - 1, y);
            } else {
                g.setColor(this._lightHighlight);
                g.drawLine(selRect.x + selRect.width + 2, y, x + w - 1, y);
            }
            if (this._tabPane.getColorTheme() == 1) {
                g.setColor(new Color(115, 109, 99));
                g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
                g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
            } else {
                g.setColor(this.getPainter().getControlDk());
                if (contentInsets.left > 0) {
                    g.drawLine(x, y, x, y + h - 1);
                }
                if (contentInsets.right > 0) {
                    g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
                }
                if (contentInsets.bottom > 0) {
                    g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
                }
            }
        } else if (tabShape == 2) {
            g.setColor(this._selectColor1);
            g.drawLine(x, y, selRect.x, y);
            if (contentInsets.left > 0) {
                g.drawLine(x, y, x, y + h - 1);
            }
            if (!this._tabPane.isTabShown() || r.x >= viewRect.x + viewRect.width) {
                g.setColor(this._selectColor1);
                g.drawLine(x, y, x + w - 1, y);
            } else {
                g.setColor(this._selectColor2);
                g.drawLine(selRect.x + selRect.width - 1, y, selRect.x + selRect.width - 1, y);
                g.setColor(this._selectColor1);
                g.drawLine(selRect.x, y, selRect.x, y);
                g.setColor(this._selectColor1);
                g.drawLine(selRect.x + selRect.width, y, x + w - 1, y);
            }
            g.setColor(this._selectColor2);
            if (contentInsets.right > 0) {
                g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
            }
            if (contentInsets.bottom > 0) {
                g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
            }
        } else if (tabShape == 9) {
            g.setColor(this._selectColor1);
            g.drawLine(x, y, selRect.x, y);
            if (contentInsets.left > 0) {
                g.drawLine(x, y, x, y + h - 1);
            }
            if (!this._tabPane.isTabShown() || r.x >= viewRect.x + viewRect.width) {
                g.drawLine(x, y, x + w - 1, y);
            } else {
                g.drawLine(selRect.x + selRect.width - 1, y, selRect.x + selRect.width - 1, y);
                g.drawLine(selRect.x, y, selRect.x, y);
                g.drawLine(selRect.x + selRect.width, y, x + w - 1, y);
            }
            g.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 1);
            g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
        } else if (tabShape == 5 || tabShape == 10) {
            g.setColor(this._shadow);
            if (contentInsets.left > 0) {
                g.drawLine(x, y, x, y + h - 1);
            }
            if (contentInsets.right > 0) {
                g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
            }
            if (contentInsets.bottom > 0) {
                g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
            }
            g.drawLine(x, y, selRect.x, y);
            if (!this._tabPane.isTabShown() || r.x >= viewRect.x + viewRect.width) {
                g.drawLine(x, y, x + w - 1, y);
            } else {
                g.drawLine(selRect.x + selRect.width, y, x + w - 1, y);
            }
        } else {
            super.paintContentBorderTopEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        }
    }

    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (selectedIndex < 0) {
            return;
        }
        Rectangle selRect = this.getTabBounds(selectedIndex, this._calcRect);
        Rectangle viewRect = this._tabScroller.viewport.getViewRect();
        Rectangle r = this._rects[selectedIndex];
        int tabShape = this.getTabShape();
        Insets contentInsets = this.getContentBorderInsets(tabPlacement);
        if (tabShape == 4) {
            if (this._tabPane.getColorTheme() == 1) {
                g.setColor(this._shadow);
            } else {
                g.setColor(this._selectColor1);
            }
            if (contentInsets.left > 0) {
                g.drawLine(x, y, x, y + h - 1);
            }
            if (contentInsets.right > 0) {
                g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
            }
            if (contentInsets.top > 0) {
                g.drawLine(x, y, x + w - 1, y);
            }
            if (!this._tabPane.isTabShown() || r.x >= viewRect.x + viewRect.width) {
                g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
            } else if (!this._tabPane.isTabShown()) {
                g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
            } else {
                g.drawLine(x, y + h - 1, selRect.x - selRect.height + 2, y + h - 1);
                g.drawLine(selRect.x + selRect.width, y + h - 1, x + w - 1, y + h - 1);
            }
        } else if (tabShape == 8) {
            if (this._tabPane.getColorTheme() == 1) {
                g.setColor(Color.BLACK);
            } else {
                g.setColor(this.getPainter().getControlShadow());
            }
            g.drawLine(x, y + h - 1, selRect.x - selRect.height / 2 + 4, y + h - 1);
            if (contentInsets.left > 0) {
                g.drawLine(x, y, x, y + h - 1);
            }
            if (contentInsets.right > 0) {
                g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
            }
            if (contentInsets.top > 0) {
                g.drawLine(x, y, x + w - 1, y);
            }
            if (!this._tabPane.isTabShown() || r.x >= viewRect.x + viewRect.width) {
                g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
            } else if (!this._tabPane.isShowIconsOnTab() && !this._tabPane.isUseDefaultShowIconsOnTab()) {
                g.drawLine(selRect.x + selRect.width + selRect.height / 2 - 4, y + h - 1, x + w - 1, y + h - 1);
            } else {
                g.drawLine(selRect.x + selRect.width + selRect.height / 2 - 6, y + h - 1, x + w - 1, y + h - 1);
            }
        } else if (tabShape == 1 || tabShape == 11) {
            if (this._tabPane.getColorTheme() == 1) {
                g.setColor(new Color(113, 111, 100));
                g.drawLine(x, y + h - 1, selRect.x - 2, y + h - 1);
                if (contentInsets.right > 0) {
                    g.drawLine(x + w - 1, y + h - 1, x + w - 1, y);
                }
                if (!this._tabPane.isTabShown() || r.x >= viewRect.x + viewRect.width) {
                    g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
                } else {
                    g.drawLine(selRect.x + selRect.width, y + h - 1, x + w - 1, y + h - 1);
                    g.setColor(UIDefaultsLookup.getColor("control"));
                    g.drawLine(selRect.x, y + h - 1, selRect.x + selRect.width - 2, y + h - 1);
                    g.drawLine(selRect.x, y + h - 2, selRect.x + selRect.width, y + h - 2);
                }
                g.setColor(new Color(255, 255, 255));
                if (contentInsets.left > 0) {
                    g.drawLine(x, y, x, y + h - 2);
                }
                if (contentInsets.top > 0) {
                    g.drawLine(x, y, x + w - 2, y);
                }
            } else {
                g.setColor(this.getPainter().getControlDk());
                g.drawLine(x, y + h - 1, selRect.x - 1, y + h - 1);
                if (!this._tabPane.isTabShown() || r.x >= viewRect.x + viewRect.width) {
                    g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
                } else {
                    g.drawLine(selRect.x + selRect.width + 2, y + h - 1, x + w - 1, y + h - 1);
                }
                g.drawLine(selRect.x - 1, y + h - 1, selRect.x - 1, y + h - 1);
                g.drawLine(selRect.x + selRect.width + 2, y + h - 1, selRect.x + selRect.width + 2, y + h - 1);
                if (contentInsets.left > 0) {
                    g.drawLine(x, y, x, y + h - 2);
                }
                if (contentInsets.top > 0) {
                    g.drawLine(x, y, x + w - 2, y);
                }
                if (contentInsets.left > 0) {
                    g.drawLine(x + w - 1, y + h - 1, x + w - 1, y);
                }
            }
        } else if (tabShape == 2) {
            g.setColor(this._selectColor2);
            g.drawLine(x, y + h - 1, selRect.x - 1, y + h - 1);
            g.setColor(this._selectColor1);
            g.drawLine(selRect.x, y + h - 1, selRect.x, y + h - 1);
            if (!this._tabPane.isTabShown() || r.x >= viewRect.x + viewRect.width) {
                g.setColor(this._selectColor2);
                g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
            } else {
                g.setColor(this._selectColor2);
                g.drawLine(selRect.x + selRect.width - 1, y + h - 1, x + w - 2, y + h - 1);
            }
            g.setColor(this._selectColor2);
            if (contentInsets.right > 0) {
                g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
            }
            g.setColor(this._selectColor1);
            if (contentInsets.left > 0) {
                g.drawLine(x, y, x, y + h - 2);
            }
            if (contentInsets.top > 0) {
                g.drawLine(x, y, x + w - 2, y);
            }
        } else if (tabShape == 9) {
            g.setColor(this._selectColor1);
            g.drawLine(x, y + h - 1, selRect.x - 1, y + h - 1);
            g.drawLine(selRect.x, y + h - 1, selRect.x, y + h - 1);
            if (!this._tabPane.isTabShown() || r.x >= viewRect.x + viewRect.width) {
                g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
            } else {
                g.drawLine(selRect.x + selRect.width - 1, y + h - 1, x + w - 2, y + h - 1);
            }
            if (contentInsets.left > 0) {
                g.drawLine(x, y, x, y + h - 2);
            }
            if (contentInsets.right > 0) {
                g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
            }
            if (contentInsets.top > 0) {
                g.drawLine(x, y, x + w - 2, y);
            }
        } else if (tabShape == 5 || tabShape == 10) {
            g.setColor(this._shadow);
            g.drawLine(x, y + h - 1, selRect.x - 1, y + h - 1);
            if (contentInsets.left > 0) {
                g.drawLine(x, y, x, y + h - 1);
            }
            if (contentInsets.right > 0) {
                g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
            }
            if (contentInsets.top > 0) {
                g.drawLine(x, y, x + w - 1, y);
            }
            g.drawLine(selRect.x, y + h - 1, selRect.x, y + h - 1);
            if (!this._tabPane.isTabShown() || r.x >= viewRect.x + viewRect.width) {
                g.drawLine(x, y + h - 1, x + w - 2, y + h - 1);
            } else {
                g.drawLine(selRect.x + selRect.width, y + h - 1, x + w - 2, y + h - 1);
            }
        } else {
            super.paintContentBorderBottomEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        }
    }

    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (selectedIndex < 0) {
            return;
        }
        Rectangle selRect = this.getTabBounds(selectedIndex, this._calcRect);
        Rectangle viewRect = this._tabScroller.viewport.getViewRect();
        Rectangle r = this._rects[selectedIndex];
        int tabShape = this.getTabShape();
        Insets contentInsets = this.getContentBorderInsets(tabPlacement);
        if (tabShape == 4) {
            if (this._tabPane.getColorTheme() == 1) {
                g.setColor(this._shadow);
            } else {
                g.setColor(this._selectColor1);
            }
            if (contentInsets.top > 0) {
                g.drawLine(x, y, x + w - 1, y);
            }
            if (contentInsets.right > 0) {
                g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
            }
            if (contentInsets.bottom > 0) {
                g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
            }
            if (!this._tabPane.isTabShown() || r.y >= viewRect.y + viewRect.height) {
                g.drawLine(x, y, x, y + h - 1);
            } else {
                g.drawLine(x, y, x, selRect.y - selRect.width + 2);
                g.drawLine(x, selRect.y + selRect.height, x, y + h - 1);
            }
        } else if (tabShape == 8) {
            if (this._tabPane.getColorTheme() == 1) {
                g.setColor(Color.BLACK);
            } else {
                g.setColor(this.getPainter().getControlShadow());
            }
            g.drawLine(x, y, x, selRect.y - selRect.width / 2 + 4);
            if (contentInsets.top > 0) {
                g.drawLine(x, y, x + w - 1, y);
            }
            if (contentInsets.right > 0) {
                g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
            }
            if (contentInsets.bottom > 0) {
                g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
            }
            if (!this._tabPane.isTabShown() || r.y >= viewRect.y + viewRect.height) {
                g.drawLine(x, y, x, y + h - 1);
            } else {
                g.drawLine(x, selRect.y + selRect.height + selRect.width / 2 - 4, x, y + h - 1);
            }
        } else if (tabShape == 1 || tabShape == 11) {
            if (this._tabPane.getColorTheme() == 1) {
                g.setColor(new Color(115, 109, 99));
                if (contentInsets.right > 0) {
                    g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
                }
                if (contentInsets.bottom > 0) {
                    g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
                }
                g.setColor(new Color(255, 255, 255));
                if (contentInsets.top > 0) {
                    g.drawLine(x, y, x + w - 2, y);
                }
                g.drawLine(x, y, x, selRect.y - 1);
                if (!this._tabPane.isTabShown() || r.y >= viewRect.y + viewRect.height) {
                    g.drawLine(x, y, x, y + h - 2);
                } else {
                    g.drawLine(x, selRect.y + selRect.height + 1, x, y + h - 2);
                }
            } else {
                g.setColor(this.getPainter().getControlDk());
                if (contentInsets.top > 0) {
                    g.drawLine(x, y, x + w - 1, y);
                }
                if (contentInsets.right > 0) {
                    g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
                }
                if (contentInsets.bottom > 0) {
                    g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
                }
                g.drawLine(x, y, x, selRect.y - 2);
                if (!this._tabPane.isTabShown() || r.y >= viewRect.y + viewRect.height) {
                    g.drawLine(x, y, x, y + h - 2);
                } else {
                    g.drawLine(x, selRect.y + selRect.height + 2, x, y + h - 2);
                }
            }
        } else if (tabShape == 2) {
            g.setColor(this._selectColor1);
            g.drawLine(x, y, x, selRect.y);
            if (contentInsets.top > 0) {
                g.drawLine(x, y, x + w - 1, y);
            }
            if (!this._tabPane.isTabShown() || r.x >= viewRect.x + viewRect.width) {
                g.setColor(this._selectColor1);
                g.drawLine(x, y, x, y + h - 1);
            } else {
                g.setColor(this._selectColor1);
                g.drawLine(x, selRect.y, x, selRect.y);
                g.setColor(this._selectColor2);
                g.drawLine(x, selRect.y + selRect.height - 1, x, selRect.y + selRect.height - 1);
                g.setColor(this._selectColor1);
                g.drawLine(x, selRect.y + selRect.height, x, y + h - 1);
            }
            g.setColor(this._selectColor2);
            if (contentInsets.right > 0) {
                g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
            }
            if (contentInsets.bottom > 0) {
                g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
            }
        } else if (tabShape == 9) {
            g.setColor(this._selectColor1);
            g.drawLine(x, y, x, selRect.y);
            if (!this._tabPane.isTabShown() || r.x >= viewRect.x + viewRect.width) {
                g.drawLine(x, y, x, y + h - 1);
            } else {
                g.drawLine(x, selRect.y, x, selRect.y);
                g.drawLine(x, selRect.y + selRect.height - 1, x, selRect.y + selRect.height - 1);
                g.drawLine(x, selRect.y + selRect.height, x, y + h - 1);
            }
            if (contentInsets.top > 0) {
                g.drawLine(x, y, x + w - 1, y);
            }
            if (contentInsets.right > 0) {
                g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
            }
            if (contentInsets.bottom > 0) {
                g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
            }
        } else if (tabShape == 5 || tabShape == 10) {
            g.setColor(this._shadow);
            if (contentInsets.top > 0) {
                g.drawLine(x, y, x + w - 1, y);
            }
            if (contentInsets.right > 0) {
                g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
            }
            if (contentInsets.bottom > 0) {
                g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
            }
            g.drawLine(x, y, x, selRect.y);
            if (!this._tabPane.isTabShown() || r.y >= viewRect.y + viewRect.height) {
                g.drawLine(x, y, x, y + h - 1);
            } else {
                g.drawLine(x, selRect.y + selRect.height, x, y + h - 1);
            }
        } else {
            super.paintContentBorderLeftEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        }
    }

    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (selectedIndex < 0) {
            return;
        }
        Rectangle selRect = this.getTabBounds(selectedIndex, this._calcRect);
        Rectangle viewRect = this._tabScroller.viewport.getViewRect();
        Rectangle r = this._rects[selectedIndex];
        int tabShape = this.getTabShape();
        Insets contentInsets = this.getContentBorderInsets(tabPlacement);
        if (tabShape == 4) {
            if (this._tabPane.getColorTheme() == 1) {
                g.setColor(this._shadow);
            } else {
                g.setColor(this._selectColor1);
            }
            if (contentInsets.top > 0) {
                g.drawLine(x, y, x + w - 1, y);
            }
            if (contentInsets.left > 0) {
                g.drawLine(x, y, x, y + h - 1);
            }
            if (contentInsets.bottom > 0) {
                g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
            }
            if (!this._tabPane.isTabShown() || r.y >= viewRect.y + viewRect.height) {
                g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
            } else {
                g.drawLine(x + w - 1, y, x + w - 1, selRect.y - selRect.width + 2);
                g.drawLine(x + w - 1, selRect.y + selRect.height, x + w - 1, y + h - 1);
            }
        } else if (tabShape == 8) {
            if (this._tabPane.getColorTheme() == 1) {
                g.setColor(Color.BLACK);
            } else {
                g.setColor(this.getPainter().getControlShadow());
            }
            g.drawLine(x + w - 1, y, x + w - 1, selRect.y - selRect.width / 2 + 4);
            if (contentInsets.top > 0) {
                g.drawLine(x, y, x + w - 1, y);
            }
            if (contentInsets.left > 0) {
                g.drawLine(x, y, x, y + h - 1);
            }
            if (contentInsets.bottom > 0) {
                g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
            }
            if (!this._tabPane.isTabShown() || r.y >= viewRect.y + viewRect.height) {
                g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
            } else {
                g.drawLine(x + w - 1, selRect.y + selRect.height + selRect.width / 2 - 4, x + w - 1, y + h - 1);
            }
        } else if (tabShape == 1 || tabShape == 11) {
            if (this._tabPane.getColorTheme() == 1) {
                g.setColor(new Color(115, 109, 99));
                g.drawLine(x + w - 1, y, x + w - 1, selRect.y - 2);
                if (contentInsets.bottom > 0) {
                    g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
                }
                if (!this._tabPane.isTabShown() || r.y >= viewRect.y + viewRect.height) {
                    g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
                    g.setColor(new Color(173, 170, 156));
                    g.drawLine(x + w - 2, y + 1, x + w - 2, y + h - 2);
                } else {
                    g.drawLine(x + w - 1, selRect.y + selRect.height + 1, x + w - 1, y + h - 1);
                    g.setColor(UIDefaultsLookup.getColor("control"));
                    g.drawLine(x + w - 1, selRect.y, x + w - 1, selRect.y + selRect.height - 1);
                    g.drawLine(x + w - 2, selRect.y, x + w - 2, selRect.y + selRect.height + 1);
                }
                g.setColor(new Color(255, 255, 255));
                if (contentInsets.top > 0) {
                    g.drawLine(x, y, x + w - 2, y);
                }
                if (contentInsets.left > 0) {
                    g.drawLine(x, y, x, y + h - 2);
                }
            } else {
                g.setColor(this.getPainter().getControlDk());
                if (contentInsets.top > 0) {
                    g.drawLine(x, y, x + w - 1, y);
                }
                if (contentInsets.left > 0) {
                    g.drawLine(x, y, x, y + h - 1);
                }
                if (contentInsets.bottom > 0) {
                    g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
                }
                g.drawLine(x + w - 1, y, x + w - 1, selRect.y - 2);
                if (!this._tabPane.isTabShown() || r.y >= viewRect.y + viewRect.height) {
                    g.drawLine(x + w - 1, y, x + w - 1, y + h - 2);
                } else {
                    g.drawLine(x + w - 1, selRect.y + selRect.height + 2, x + w - 1, y + h - 2);
                }
            }
        } else if (tabShape == 2) {
            g.setColor(this.getBorderEdgeColor());
            g.setColor(this._selectColor2);
            g.drawLine(x + w - 1, y, x + w - 1, selRect.y);
            if (contentInsets.bottom > 0) {
                g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
            }
            if (!this._tabPane.isTabShown() || r.x >= viewRect.x + viewRect.width) {
                g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
            } else {
                g.setColor(this._selectColor2);
                g.drawLine(x + w - 1, selRect.y + selRect.height - 1, x + w - 1, selRect.y + selRect.height - 1);
                g.drawLine(x + w - 1, selRect.y + selRect.height, x + w - 1, y + h - 1);
            }
            g.setColor(this._selectColor1);
            if (contentInsets.top > 0) {
                g.drawLine(x, y, x + w - 2, y);
            }
            if (contentInsets.left > 0) {
                g.drawLine(x, y, x, y + h - 2);
            }
        } else if (tabShape == 9) {
            g.setColor(this._selectColor1);
            g.drawLine(x + w - 1, y, x + w - 1, selRect.y - 1);
            if (!this._tabPane.isTabShown() || r.x >= viewRect.x + viewRect.width) {
                g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
            } else {
                g.drawLine(x + w - 1, selRect.y, x + w - 1, selRect.y);
                g.drawLine(x + w - 1, selRect.y + selRect.height - 1, x + w - 1, selRect.y + selRect.height - 1);
                g.drawLine(x + w - 1, selRect.y + selRect.height, x + w - 1, y + h - 1);
            }
            if (contentInsets.top > 0) {
                g.drawLine(x, y, x + w - 1, y);
            }
            if (contentInsets.left > 0) {
                g.drawLine(x, y, x, y + h - 2);
            }
            if (contentInsets.bottom > 0) {
                g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
            }
        } else if (tabShape == 5 || tabShape == 10) {
            g.setColor(this._shadow);
            if (contentInsets.top > 0) {
                g.drawLine(x, y, x + w - 1, y);
            }
            if (contentInsets.left > 0) {
                g.drawLine(x, y, x, y + h - 1);
            }
            if (contentInsets.bottom > 0) {
                g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
            }
            g.drawLine(x + w - 1, y, x + w - 1, selRect.y);
            if (!this._tabPane.isTabShown() || r.y >= viewRect.y + viewRect.height) {
                g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
            } else {
                g.drawLine(x + w - 1, selRect.y + selRect.height, x + w - 1, y + h - 1);
            }
        } else {
            super.paintContentBorderRightEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        }
    }

    protected void paintContentBorder(Graphics g, int x, int y, int w, int h) {
        Color backgroundAt;
        Insets insets = this.getContentBorderInsets(this._tabPane.getTabPlacement());
        JideTabbedPane.ColorProvider colorProvider = this._tabPane.getTabColorProvider();
        boolean useDefault = true;
        if (colorProvider != null && (backgroundAt = colorProvider.getBackgroundAt(this._tabPane.getSelectedIndex())) != null) {
            g.setColor(backgroundAt);
            g.fillRect(x, y, w, h);
            useDefault = false;
        }
        if (useDefault) {
            Color[] colors = this.getGradientColors(this._tabPane.getSelectedIndex(), true);
            g.setColor(colors[1]);
            g.fillRect(x, y, w, insets.top);
            g.fillRect(x, y, insets.left, h);
            g.fillRect(x, y + h - insets.bottom, w, insets.bottom);
            g.fillRect(x + w - insets.right, y, insets.right, h);
        }
    }

    protected Color[] getGradientColors(int tabIndex, boolean isSelected) {
        Color backgroundEnd = null;
        Color backgroundStart = null;
        JideTabbedPane.ColorProvider colorProvider = this._tabPane.getTabColorProvider();
        if (colorProvider != null) {
            backgroundEnd = colorProvider.getBackgroundAt(tabIndex);
            backgroundStart = colorProvider instanceof JideTabbedPane.GradientColorProvider ? ((JideTabbedPane.GradientColorProvider)colorProvider).getTopBackgroundAt(tabIndex) : (backgroundEnd != null ? ColorUtils.getDerivedColor(backgroundEnd, colorProvider.getGradientRatio(tabIndex)) : null);
        } else {
            Color color = this._tabPane.getBackgroundAt(tabIndex);
            if (!(color instanceof UIResource) && color != this._tabPane.getBackground()) {
                backgroundEnd = color;
                backgroundStart = this.getColorTheme() == 2 ? ColorUtils.getDerivedColor(color, 0.8f) : color;
            }
        }
        if (isSelected) {
            if (this.showFocusIndicator()) {
                if (backgroundEnd == null) {
                    backgroundEnd = this._backgroundSelectedColorEnd;
                }
                if (backgroundStart == null) {
                    backgroundStart = this._backgroundSelectedColorStart;
                }
            } else if (this.getColorTheme() == 3) {
                if (backgroundEnd == null) {
                    backgroundEnd = this._backgroundSelectedColorEnd;
                }
                if (backgroundStart == null) {
                    backgroundStart = this._backgroundSelectedColorStart;
                }
            } else {
                if (backgroundEnd == null) {
                    backgroundEnd = ColorUtils.getDerivedColor(this._backgroundUnselectedColorEnd, 0.7f);
                }
                if (backgroundStart == null) {
                    backgroundStart = ColorUtils.getDerivedColor(this._backgroundUnselectedColorStart, 0.8f);
                }
            }
        } else if (this.getTabShape() != 11) {
            if (backgroundEnd == null) {
                backgroundEnd = this._backgroundUnselectedColorEnd;
            }
            if (backgroundStart == null) {
                backgroundStart = this._backgroundUnselectedColorStart;
            }
        }
        return new Color[]{backgroundStart, backgroundEnd};
    }
}

