/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.NullPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.AbstractButton;
import javax.swing.JPanel;

public class ButtonPanel
extends JPanel {
    public static final int DEFAULT_SPACING = 4;
    private JPanel _buttons;

    public ButtonPanel() {
        this(4, 4);
    }

    public ButtonPanel(int alignment) {
        this(alignment, 4);
    }

    public ButtonPanel(int alignment, int spacing) {
        if (alignment != 2 && alignment != 4 && alignment != 1 && alignment != 3) {
            throw new IllegalArgumentException("Invalid alignment");
        }
        this.setLayout(new BorderLayout());
        this._buttons = new NullPanel();
        if (alignment == 1 || alignment == 3) {
            this._buttons.setLayout(new GridLayout(0, 1, 0, spacing));
        } else {
            this._buttons.setLayout(new GridLayout(1, 0, spacing, 0));
        }
        switch (alignment) {
            case 2: {
                this.add((Component)this._buttons, "West");
                break;
            }
            case 4: {
                this.add((Component)this._buttons, "East");
                break;
            }
            case 1: {
                this.add((Component)this._buttons, "North");
                break;
            }
            case 3: {
                this.add((Component)this._buttons, "South");
            }
        }
    }

    public void addButton(AbstractButton button) {
        if (button.getParent() != this._buttons) {
            this._buttons.add(button);
        }
    }

    public void addButton(AbstractButton button, int pos) throws IllegalArgumentException {
        if (button.getParent() != this._buttons) {
            this._buttons.add((Component)button, pos);
        }
    }

    public void removeButton(AbstractButton button) {
        if (button.getParent() == this._buttons) {
            this._buttons.remove(button);
        }
    }

    public void removeButton(int position) {
        this._buttons.remove(position);
    }

    public AbstractButton getButton(int position) {
        return (AbstractButton)this._buttons.getComponent(position);
    }

    public int getButtonCount() {
        return this._buttons.getComponentCount();
    }

    public JPanel getButtons() {
        return this._buttons;
    }
}

