/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.CheckBoxListCellRenderer;
import com.jidesoft.swing.CheckBoxListSelectionModel;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckBoxList
extends JList {
    protected CheckBoxListCellRenderer _listCellRenderer;
    public static final String PROPERTY_CHECKBOX_ENABLED = "checkBoxEnabled";
    private boolean _checkBoxEnabled = true;
    private CheckBoxListSelectionModel _checkBoxListSelectionModel;
    protected Handler _handler;

    public CheckBoxList() {
        this.init();
    }

    public CheckBoxList(Vector<?> listData) {
        super(listData);
        this.init();
    }

    public CheckBoxList(Object[] listData) {
        super(listData);
        this.init();
    }

    public CheckBoxList(ListModel dataModel) {
        super(dataModel);
        this.init();
    }

    protected void init() {
        this._checkBoxListSelectionModel = this.createCheckBoxListSelectionModel(this.getModel());
        this.setSelectionMode(2);
        this._listCellRenderer = this.createCellRenderer();
        this._handler = this.createHandler();
        this._checkBoxListSelectionModel.addListSelectionListener(this._handler);
        JideSwingUtilities.insertMouseListener(this, this._handler, 0);
        this.addKeyListener(this._handler);
        this.addPropertyChangeListener("model", this._handler);
        ListModel model = this.getModel();
        if (model != null) {
            model.addListDataListener(this._handler);
        }
    }

    protected CheckBoxListSelectionModel createCheckBoxListSelectionModel(ListModel model) {
        return new CheckBoxListSelectionModel(model);
    }

    protected CheckBoxListCellRenderer createCellRenderer() {
        return new CheckBoxListCellRenderer();
    }

    protected Handler createHandler() {
        return new Handler(this);
    }

    public ListCellRenderer getCellRenderer() {
        if (this._listCellRenderer != null) {
            this._listCellRenderer.setActualListRenderer(super.getCellRenderer());
            return this._listCellRenderer;
        }
        return super.getCellRenderer();
    }

    public ListCellRenderer getActualCellRenderer() {
        return super.getCellRenderer();
    }

    @Override
    public int getNextMatch(String prefix, int startIndex, Position.Bias bias) {
        return -1;
    }

    public boolean isCheckBoxEnabled() {
        return this._checkBoxEnabled;
    }

    public boolean isCheckBoxEnabled(int index) {
        return true;
    }

    public boolean isCheckBoxVisible(int index) {
        return true;
    }

    public void setCheckBoxEnabled(boolean checkBoxEnabled) {
        if (checkBoxEnabled != this._checkBoxEnabled) {
            Boolean oldValue = this._checkBoxEnabled ? Boolean.TRUE : Boolean.FALSE;
            Boolean newValue = checkBoxEnabled ? Boolean.TRUE : Boolean.FALSE;
            this._checkBoxEnabled = checkBoxEnabled;
            this.firePropertyChange(PROPERTY_CHECKBOX_ENABLED, oldValue, newValue);
            this.repaint();
        }
    }

    public CheckBoxListSelectionModel getCheckBoxListSelectionModel() {
        return this._checkBoxListSelectionModel;
    }

    public void setCheckBoxListSelectionModel(CheckBoxListSelectionModel checkBoxListSelectionModel) {
        this._checkBoxListSelectionModel = checkBoxListSelectionModel;
        this._checkBoxListSelectionModel.setModel(this.getModel());
    }

    public int[] getCheckBoxListSelectedIndices() {
        CheckBoxListSelectionModel sm = this.getCheckBoxListSelectionModel();
        int iMin = sm.getMinSelectionIndex();
        int iMax = sm.getMaxSelectionIndex();
        if (iMin < 0 || iMax < 0) {
            return new int[0];
        }
        int[] rvTmp = new int[1 + (iMax - iMin)];
        int n = 0;
        for (int i = iMin; i <= iMax; ++i) {
            if (!sm.isSelectedIndex(i)) continue;
            rvTmp[n++] = i;
        }
        int[] rv = new int[n];
        System.arraycopy(rvTmp, 0, rv, 0, n);
        return rv;
    }

    public void setCheckBoxListSelectedIndex(int index) {
        if (index >= 0 && index < this.getModel().getSize()) {
            this.getCheckBoxListSelectionModel().setSelectionInterval(index, index);
        }
    }

    public void addCheckBoxListSelectedIndex(int index) {
        if (index >= 0 && index < this.getModel().getSize()) {
            this.getCheckBoxListSelectionModel().addSelectionInterval(index, index);
        }
    }

    public void removeCheckBoxListSelectedIndex(int index) {
        if (index >= 0 && index < this.getModel().getSize()) {
            this.getCheckBoxListSelectionModel().removeSelectionInterval(index, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCheckBoxListSelectedIndices(int[] indices) {
        CheckBoxListSelectionModel sm = this.getCheckBoxListSelectionModel();
        try {
            sm.setValueIsAdjusting(true);
            sm.clearSelection();
            int size = this.getModel().getSize();
            for (int indice : indices) {
                if (indice < 0 || indice >= size) continue;
                sm.addSelectionInterval(indice, indice);
            }
        }
        finally {
            sm.setValueIsAdjusting(false);
        }
    }

    public void setSelectedObjects(Object[] elements) {
        HashMap<Object, String> selected = new HashMap<Object, String>();
        for (Object element : elements) {
            selected.put(element, "");
        }
        this.setSelectedObjects(selected);
    }

    public void setSelectedObjects(Vector<?> elements) {
        HashMap<Object, String> selected = new HashMap<Object, String>();
        for (Object element : elements) {
            selected.put(element, "");
        }
        this.setSelectedObjects(selected);
    }

    private void setSelectedObjects(Map<Object, String> selected) {
        int[] indices = new int[selected.size()];
        Arrays.fill(indices, -1);
        int index = 0;
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            Object elementAt = this.getModel().getElementAt(i);
            if (selected.get(elementAt) == null) continue;
            indices[index++] = i;
        }
        this.setCheckBoxListSelectedIndices(indices);
    }

    public Object[] getSelectedObjects() {
        return this.getCheckBoxListSelectedValues();
    }

    public Object[] getCheckBoxListSelectedValues() {
        CheckBoxListSelectionModel sm = this.getCheckBoxListSelectionModel();
        ListModel dm = this.getModel();
        int iMin = sm.getMinSelectionIndex();
        int iMax = sm.getMaxSelectionIndex();
        if (iMin < 0 || iMax < 0) {
            return new Object[0];
        }
        Object[] rvTmp = new Object[1 + (iMax - iMin)];
        int n = 0;
        for (int i = iMin; i <= iMax; ++i) {
            if (!sm.isSelectedIndex(i)) continue;
            rvTmp[n++] = dm.getElementAt(i);
        }
        Object[] rv = new Object[n];
        System.arraycopy(rvTmp, 0, rv, 0, n);
        return rv;
    }

    public int getCheckBoxListSelectedIndex() {
        return this.getCheckBoxListSelectionModel().getMinSelectionIndex();
    }

    public Object getCheckBoxListSelectedValue() {
        int i = this.getCheckBoxListSelectionModel().getMinSelectionIndex();
        return i == -1 ? null : this.getModel().getElementAt(i);
    }

    public void setCheckBoxListSelectedValue(Object anObject, boolean shouldScroll) {
        if (anObject == null) {
            this.setSelectedIndex(-1);
        } else {
            ListModel dm = this.getModel();
            int c = dm.getSize();
            for (int i = 0; i < c; ++i) {
                if (!anObject.equals(dm.getElementAt(i))) continue;
                this.setCheckBoxListSelectedIndex(i);
                if (shouldScroll) {
                    this.ensureIndexIsVisible(i);
                }
                this.repaint();
                return;
            }
            this.setCheckBoxListSelectedIndex(-1);
        }
        this.repaint();
    }

    public void addCheckBoxListSelectedValue(Object anObject, boolean shouldScroll) {
        if (anObject != null) {
            ListModel dm = this.getModel();
            int c = dm.getSize();
            for (int i = 0; i < c; ++i) {
                if (!anObject.equals(dm.getElementAt(i))) continue;
                this.addCheckBoxListSelectedIndex(i);
                if (shouldScroll) {
                    this.ensureIndexIsVisible(i);
                }
                this.repaint();
                return;
            }
        }
    }

    public void removeCheckBoxListSelectedValue(Object anObject, boolean shouldScroll) {
        if (anObject != null) {
            ListModel dm = this.getModel();
            int c = dm.getSize();
            for (int i = 0; i < c; ++i) {
                if (!anObject.equals(dm.getElementAt(i))) continue;
                this.removeCheckBoxListSelectedIndex(i);
                if (shouldScroll) {
                    this.ensureIndexIsVisible(i);
                }
                this.repaint();
                return;
            }
        }
    }

    public void clearCheckBoxListSelection() {
        this.getCheckBoxListSelectionModel().clearSelection();
    }

    public void selectAll() {
        this.getCheckBoxListSelectionModel().setSelectionInterval(0, this.getModel().getSize() - 1);
    }

    public void selectNone() {
        this.getCheckBoxListSelectionModel().removeIndexInterval(0, this.getModel().getSize() - 1);
    }

    protected static class Handler
    implements MouseListener,
    KeyListener,
    ListSelectionListener,
    PropertyChangeListener,
    ListDataListener {
        protected CheckBoxList _list;
        int _hotspot;

        public Handler(CheckBoxList list) {
            this._hotspot = new JCheckBox().getPreferredSize().width;
            this._list = list;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getOldValue() instanceof ListModel) {
                ((ListModel)evt.getOldValue()).removeListDataListener(this);
            }
            if (evt.getNewValue() instanceof ListModel) {
                this._list.getCheckBoxListSelectionModel().setModel((ListModel)evt.getNewValue());
                ((ListModel)evt.getNewValue()).addListDataListener(this);
            }
        }

        protected boolean clicksInCheckBox(MouseEvent e) {
            int index = this._list.locationToIndex(e.getPoint());
            Rectangle bounds = this._list.getCellBounds(index, index);
            if (bounds != null) {
                if (this._list.getComponentOrientation().isLeftToRight()) {
                    return e.getX() < bounds.x + this._hotspot;
                }
                return e.getX() > bounds.x + bounds.width - this._hotspot;
            }
            return false;
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            if (!this._list.isCheckBoxEnabled()) {
                return;
            }
            if (this.clicksInCheckBox(e)) {
                int index = this._list.locationToIndex(e.getPoint());
                this.toggleSelection(index);
                e.consume();
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (!this._list.isCheckBoxEnabled()) {
                return;
            }
            if (this.clicksInCheckBox(e)) {
                e.consume();
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            if (e.isConsumed()) {
                return;
            }
            if (!this._list.isCheckBoxEnabled()) {
                return;
            }
            if (e.getModifiers() == 0 && e.getKeyChar() == ' ') {
                this.toggleSelections();
            }
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void toggleSelections() {
            int[] indices = this._list.getSelectedIndices();
            CheckBoxListSelectionModel selectionModel = this._list.getCheckBoxListSelectionModel();
            selectionModel.removeListSelectionListener(this);
            selectionModel.setValueIsAdjusting(true);
            try {
                for (int index : indices) {
                    if (!this._list.isCheckBoxEnabled(index)) continue;
                    boolean selected = selectionModel.isSelectedIndex(index);
                    if (selected) {
                        selectionModel.removeSelectionInterval(index, index);
                        continue;
                    }
                    selectionModel.addSelectionInterval(index, index);
                }
            }
            finally {
                selectionModel.setValueIsAdjusting(false);
                selectionModel.addListSelectionListener(this);
                this._list.repaint();
            }
        }

        public void valueChanged(ListSelectionEvent e) {
            this._list.repaint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void toggleSelection(int index) {
            if (!this._list.isEnabled() || !this._list.isCheckBoxEnabled(index)) {
                return;
            }
            CheckBoxListSelectionModel selectionModel = this._list.getCheckBoxListSelectionModel();
            boolean selected = selectionModel.isSelectedIndex(index);
            selectionModel.removeListSelectionListener(this);
            try {
                if (selected) {
                    selectionModel.removeSelectionInterval(index, index);
                } else {
                    selectionModel.addSelectionInterval(index, index);
                }
            }
            finally {
                selectionModel.addListSelectionListener(this);
                this._list.repaint();
            }
        }

        protected void toggleSelection() {
            int index = this._list.getSelectedIndex();
            this.toggleSelection(index);
        }

        public void intervalAdded(ListDataEvent e) {
            int minIndex = Math.min(e.getIndex0(), e.getIndex1());
            int maxIndex = Math.max(e.getIndex0(), e.getIndex1());
            CheckBoxListSelectionModel sm = this._list.getCheckBoxListSelectionModel();
            if (sm != null) {
                sm.insertIndexInterval(minIndex, maxIndex - minIndex + 1, true);
            }
        }

        public void intervalRemoved(ListDataEvent e) {
            CheckBoxListSelectionModel sm = this._list.getCheckBoxListSelectionModel();
            if (sm != null) {
                sm.removeIndexInterval(e.getIndex0(), e.getIndex1());
            }
        }

        public void contentsChanged(ListDataEvent e) {
        }
    }
}

