/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.CheckBoxTree;
import com.jidesoft.swing.CheckBoxTreeSelectionModel;
import com.jidesoft.swing.NullLabel;
import com.jidesoft.swing.NullPanel;
import com.jidesoft.swing.NullTristateCheckBox;
import com.jidesoft.swing.TristateCheckBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class CheckBoxTreeCellRenderer
extends NullPanel
implements TreeCellRenderer,
Serializable {
    protected static Border noFocusBorder;
    protected TristateCheckBox _checkBox = new NullTristateCheckBox();
    protected JCheckBox PROTOTYPE = new TristateCheckBox();
    protected JLabel _label = new NullLabel();
    protected TreeCellRenderer _actualTreeRenderer;

    public CheckBoxTreeCellRenderer() {
        this((TreeCellRenderer)null);
    }

    public CheckBoxTreeCellRenderer(TreeCellRenderer renderer) {
        if (noFocusBorder == null) {
            noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        }
        this._checkBox.setOpaque(false);
        this.setBorder(noFocusBorder);
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this._checkBox, "Before");
        this._actualTreeRenderer = renderer;
    }

    public TreeCellRenderer getActualTreeRenderer() {
        return this._actualTreeRenderer;
    }

    public void setActualTreeRenderer(TreeCellRenderer actualTreeRenderer) {
        this._actualTreeRenderer = actualTreeRenderer;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        CheckBoxTreeSelectionModel selectionModel;
        this._checkBox.setPreferredSize(new Dimension(this.PROTOTYPE.getPreferredSize().width, 0));
        this.setComponentOrientation(tree.getComponentOrientation());
        TreePath path = tree.getPathForRow(row);
        if (path != null && tree instanceof CheckBoxTree && (selectionModel = ((CheckBoxTree)tree).getCheckBoxTreeSelectionModel()) != null) {
            this._checkBox.setEnabled(((CheckBoxTree)tree).isCheckBoxEnabled() && ((CheckBoxTree)tree).isCheckBoxEnabled(path));
            if (selectionModel.isPathSelected(path, selectionModel.isDigIn())) {
                this._checkBox.setState(TristateCheckBox.SELECTED);
            } else {
                this._checkBox.setState((TristateCheckBox.State)(selectionModel.isDigIn() && selectionModel.isPartiallySelected(path) ? null : TristateCheckBox.NOT_SELECTED));
            }
        }
        if (this._actualTreeRenderer != null) {
            JComponent treeCellRendererComponent = (JComponent)this._actualTreeRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (path != null && tree instanceof CheckBoxTree && !((CheckBoxTree)tree).isCheckBoxVisible(path)) {
                return treeCellRendererComponent;
            }
            Border border = treeCellRendererComponent.getBorder();
            this.setBorder(border);
            treeCellRendererComponent.setBorder(BorderFactory.createEmptyBorder());
            if (this.getComponentCount() == 2) {
                this.remove(1);
            }
            this.add(treeCellRendererComponent);
        }
        return this;
    }

    public String getToolTipText(MouseEvent event) {
        if (this._actualTreeRenderer instanceof JComponent) {
            Point p = event.getPoint();
            p.translate(-this._checkBox.getWidth(), 0);
            MouseEvent newEvent = new MouseEvent((JComponent)((Object)this._actualTreeRenderer), event.getID(), event.getWhen(), event.getModifiers(), p.x, p.y, event.getClickCount(), event.isPopupTrigger());
            String tip = ((JComponent)((Object)this._actualTreeRenderer)).getToolTipText(newEvent);
            if (tip != null) {
                return tip;
            }
        }
        return super.getToolTipText(event);
    }
}

