/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.CheckBoxTree;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class CheckBoxTreeSelectionModel
extends DefaultTreeSelectionModel {
    private TreeModel _model;
    private boolean _digIn = true;
    private CheckBoxTree _tree;
    private boolean _singleEventMode = false;
    private boolean _fireEvent = true;
    private boolean _batchMode = false;
    private List<TreePath> _toBeAdded = new ArrayList<TreePath>();
    private List<TreePath> _toBeRemoved = new ArrayList<TreePath>();

    public CheckBoxTreeSelectionModel(TreeModel model) {
        this._model = model;
        this.setSelectionMode(4);
    }

    void setTree(CheckBoxTree tree) {
        this._tree = tree;
    }

    public CheckBoxTreeSelectionModel(TreeModel model, boolean digIn) {
        this._model = model;
        this._digIn = digIn;
    }

    public TreeModel getModel() {
        return this._model;
    }

    public void setModel(TreeModel model) {
        this._model = model;
    }

    public boolean isDigIn() {
        return this._digIn;
    }

    public void setDigIn(boolean digIn) {
        this._digIn = digIn;
    }

    public boolean isPartiallySelected(TreePath path) {
        if (this.isPathSelected(path, true)) {
            return false;
        }
        TreePath[] selectionPaths = this.getSelectionPaths();
        if (selectionPaths == null) {
            return false;
        }
        for (TreePath selectionPath : selectionPaths) {
            if (!this.isDescendant(selectionPath, path)) continue;
            return true;
        }
        return false;
    }

    public boolean isPathSelected(TreePath path, boolean digIn) {
        if (!digIn) {
            return super.isPathSelected(path);
        }
        while (path != null && !super.isPathSelected(path)) {
            path = path.getParentPath();
        }
        return path != null;
    }

    private boolean isDescendant(TreePath path1, TreePath path2) {
        Object[] obj1 = path1.getPath();
        Object[] obj2 = path2.getPath();
        for (int i = 0; i < obj2.length; ++i) {
            if (obj1[i] == obj2[i]) continue;
            return false;
        }
        return true;
    }

    protected void notifyPathChange(Vector changedPaths, TreePath oldLeadSelection) {
        if (this._fireEvent) {
            super.notifyPathChange(changedPaths, oldLeadSelection);
        }
    }

    public void setSelectionPaths(TreePath[] pPaths) {
        if (!this.isDigIn()) {
            super.setSelectionPaths(pPaths);
        } else {
            this.clearSelection();
            this.addSelectionPaths(pPaths);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelectionPaths(TreePath[] paths) {
        if (!this.isDigIn()) {
            super.addSelectionPaths(paths);
            return;
        }
        boolean fireEventAtTheEnd = false;
        if (this.isSingleEventMode() && this._fireEvent) {
            this._fireEvent = false;
            fireEventAtTheEnd = true;
        }
        try {
            ArrayList<TreePath> toBeRemoved = new ArrayList<TreePath>();
            for (TreePath path : paths) {
                TreePath[] selectionPaths = this.getSelectionPaths();
                if (selectionPaths == null) break;
                for (TreePath selectionPath : selectionPaths) {
                    if (!this.isDescendant(selectionPath, path)) continue;
                    toBeRemoved.add(selectionPath);
                }
            }
            if (toBeRemoved.size() > 0) {
                this.delegateRemoveSelectionPaths(toBeRemoved.toArray(new TreePath[toBeRemoved.size()]));
            }
            for (TreePath path : paths) {
                TreePath temp = null;
                while (this.areSiblingsSelected(path)) {
                    temp = path;
                    if (path.getParentPath() == null) break;
                    path = path.getParentPath();
                }
                if (temp != null) {
                    if (temp.getParentPath() != null) {
                        this.addSelectionPath(temp.getParentPath());
                        continue;
                    }
                    if (!this.isSelectionEmpty()) {
                        this.removeSelectionPaths(this.getSelectionPaths());
                    }
                    this.delegateAddSelectionPaths(new TreePath[]{temp});
                    continue;
                }
                this.delegateAddSelectionPaths(new TreePath[]{path});
            }
        }
        finally {
            this._fireEvent = true;
            if (this.isSingleEventMode() && fireEventAtTheEnd) {
                this.notifyPathChange(paths, true, paths[0]);
            }
        }
    }

    private boolean areSiblingsSelected(TreePath path) {
        TreePath parent = path.getParentPath();
        if (parent == null) {
            return true;
        }
        Object node = path.getLastPathComponent();
        Object parentNode = parent.getLastPathComponent();
        int childCount = this._model.getChildCount(parentNode);
        for (int i = 0; i < childCount; ++i) {
            Object childNode = this._model.getChild(parentNode, i);
            if (childNode == node) continue;
            TreePath childPath = parent.pathByAddingChild(childNode);
            if (this._tree != null && !this._tree.isCheckBoxVisible(childPath) || this.isPathSelected(childPath)) continue;
            return false;
        }
        return true;
    }

    public void removeSelectionPaths(TreePath[] paths) {
        if (!this.isDigIn()) {
            super.removeSelectionPaths(paths);
            return;
        }
        ArrayList<TreePath> toBeRemoved = new ArrayList<TreePath>();
        for (TreePath path : paths) {
            if (path.getPathCount() == 1) {
                toBeRemoved.add(path);
                continue;
            }
            this.toggleRemoveSelection(path);
        }
        if (toBeRemoved.size() > 0) {
            this.delegateRemoveSelectionPaths(toBeRemoved.toArray(new TreePath[toBeRemoved.size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void toggleRemoveSelection(TreePath path) {
        TreePath parent;
        Stack<TreePath> stack;
        boolean fireEventAtTheEnd;
        block9: {
            fireEventAtTheEnd = false;
            if (this.isSingleEventMode() && this._fireEvent) {
                this._fireEvent = false;
                fireEventAtTheEnd = true;
            }
            stack = new Stack<TreePath>();
            for (parent = path.getParentPath(); parent != null && !this.isPathSelected(parent); parent = parent.getParentPath()) {
                stack.push(parent);
            }
            if (parent != null) {
                stack.push(parent);
                break block9;
            }
            this.delegateRemoveSelectionPaths(new TreePath[]{path});
            this._fireEvent = true;
            if (!this.isSingleEventMode() || !fireEventAtTheEnd) return;
            this.notifyPathChange(new TreePath[]{path}, false, path);
            return;
        }
        try {
            ArrayList<TreePath> toBeAdded = new ArrayList<TreePath>();
            while (!stack.isEmpty()) {
                TreePath temp = (TreePath)stack.pop();
                TreePath peekPath = stack.isEmpty() ? path : (TreePath)stack.peek();
                Object node = temp.getLastPathComponent();
                Object peekNode = peekPath.getLastPathComponent();
                int childCount = this._model.getChildCount(node);
                for (int i = 0; i < childCount; ++i) {
                    TreePath treePath;
                    Object childNode = this._model.getChild(node, i);
                    if (childNode == peekNode || !this._tree.isCheckBoxVisible(treePath = temp.pathByAddingChild(childNode)) || !this._tree.isCheckBoxEnabled(treePath)) continue;
                    toBeAdded.add(treePath);
                }
            }
            if (toBeAdded.size() > 0) {
                this.delegateAddSelectionPaths(toBeAdded.toArray(new TreePath[toBeAdded.size()]));
            }
            this.delegateRemoveSelectionPaths(new TreePath[]{parent});
            this._fireEvent = true;
            if (!this.isSingleEventMode() || !fireEventAtTheEnd) return;
        }
        catch (Throwable throwable) {
            this._fireEvent = true;
            if (!this.isSingleEventMode() || !fireEventAtTheEnd) throw throwable;
            this.notifyPathChange(new TreePath[]{path}, false, path);
            throw throwable;
        }
        this.notifyPathChange(new TreePath[]{path}, false, path);
    }

    public boolean isSingleEventMode() {
        return this._singleEventMode;
    }

    public void setSingleEventMode(boolean singleEventMode) {
        this._singleEventMode = singleEventMode;
    }

    protected void notifyPathChange(TreePath[] changedPaths, boolean isNew, TreePath oldLeadSelection) {
        int cPathCount = changedPaths.length;
        boolean[] newness = new boolean[cPathCount];
        for (int counter = 0; counter < cPathCount; ++counter) {
            newness[counter] = isNew;
        }
        TreeSelectionEvent event = new TreeSelectionEvent((Object)this, changedPaths, newness, oldLeadSelection, this.leadPath);
        this.fireValueChanged(event);
    }

    private boolean isBatchMode() {
        return this._batchMode;
    }

    public void setBatchMode(boolean batchMode) {
        this._batchMode = batchMode;
        if (!this._batchMode) {
            super.addSelectionPaths(this._toBeAdded.toArray(new TreePath[this._toBeAdded.size()]));
            this._toBeAdded.clear();
            super.removeSelectionPaths(this._toBeRemoved.toArray(new TreePath[this._toBeRemoved.size()]));
            this._toBeRemoved.clear();
        }
    }

    private void delegateRemoveSelectionPaths(TreePath[] paths) {
        if (!this.isBatchMode()) {
            super.removeSelectionPaths(paths);
        } else {
            for (TreePath path : paths) {
                this._toBeRemoved.add(path);
                this._toBeAdded.remove(path);
            }
        }
    }

    private void delegateRemoveSelectionPath(TreePath path) {
        if (!this.isBatchMode()) {
            super.removeSelectionPath(path);
        } else {
            this._toBeRemoved.add(path);
            this._toBeAdded.remove(path);
        }
    }

    private void delegateAddSelectionPaths(TreePath[] paths) {
        if (!this.isBatchMode()) {
            super.addSelectionPaths(paths);
        } else {
            for (TreePath path : paths) {
                this._toBeAdded.add(path);
                this._toBeRemoved.remove(path);
            }
        }
    }

    private void delegateAddSelectionPath(TreePath path) {
        if (!this.isBatchMode()) {
            super.addSelectionPath(path);
        } else {
            this._toBeAdded.add(path);
            this._toBeRemoved.remove(path);
        }
    }
}

