/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.event.SearchableEvent;
import java.awt.IllegalComponentStateException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ComboBoxSearchable
extends Searchable
implements ListDataListener,
PropertyChangeListener {
    private boolean _showPopupDuringSearching = true;

    public ComboBoxSearchable(JComboBox comboBox) {
        super(comboBox);
        comboBox.setKeySelectionManager(new JComboBox.KeySelectionManager(){

            public int selectionForKey(char aKey, ComboBoxModel aModel) {
                return -1;
            }
        });
        comboBox.getModel().addListDataListener(this);
        comboBox.addPropertyChangeListener("model", this);
    }

    public void uninstallListeners() {
        super.uninstallListeners();
        if (this._component instanceof JComboBox) {
            ((JComboBox)this._component).getModel().removeListDataListener(this);
        }
        this._component.removePropertyChangeListener("model", this);
    }

    public boolean isShowPopupDuringSeaching() {
        return this._showPopupDuringSearching;
    }

    public void setShowPopupDuringSeaching(boolean showPopupDuringSeaching) {
        this._showPopupDuringSearching = showPopupDuringSeaching;
    }

    public boolean isShowPopupDuringSearching() {
        return this._showPopupDuringSearching;
    }

    public void setShowPopupDuringSearching(boolean showPopupDuringSearching) {
        this._showPopupDuringSearching = showPopupDuringSearching;
    }

    protected void setSelectedIndex(int index, boolean incremental) {
        if (this.isShowPopupDuringSearching()) {
            try {
                ((JComboBox)this._component).showPopup();
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
        if (((JComboBox)this._component).getSelectedIndex() != index) {
            ((JComboBox)this._component).setSelectedIndex(index);
        }
    }

    protected int getSelectedIndex() {
        return ((JComboBox)this._component).getSelectedIndex();
    }

    protected Object getElementAt(int index) {
        ComboBoxModel comboBoxModel = ((JComboBox)this._component).getModel();
        return comboBoxModel.getElementAt(index);
    }

    protected int getElementCount() {
        ComboBoxModel comboBoxModel = ((JComboBox)this._component).getModel();
        return comboBoxModel.getSize();
    }

    protected String convertElementToString(Object object) {
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    public void contentsChanged(ListDataEvent e) {
        if (e.getIndex0() != -1 || e.getIndex1() != -1) {
            this.hidePopup();
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    public void intervalAdded(ListDataEvent e) {
        this.hidePopup();
        this.fireSearchableEvent(new SearchableEvent(this, 3005));
    }

    public void intervalRemoved(ListDataEvent e) {
        this.hidePopup();
        this.fireSearchableEvent(new SearchableEvent(this, 3005));
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("model".equals(evt.getPropertyName())) {
            this.hidePopup();
            if (evt.getOldValue() instanceof ComboBoxModel) {
                ((ComboBoxModel)evt.getOldValue()).removeListDataListener(this);
            }
            if (evt.getNewValue() instanceof ComboBoxModel) {
                ((ComboBoxModel)evt.getNewValue()).addListDataListener(this);
            }
        }
        this.fireSearchableEvent(new SearchableEvent(this, 3005));
    }
}

