/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.Animator;
import com.jidesoft.swing.AnimatorListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.Timer;

public abstract class Flashable {
    public static final String CLIENT_PROPERTY_FLASHABLE = "jide.flashable";
    private int _interval = 500;
    protected JComponent _component;
    protected Animator _animator;
    protected Timer _timer = null;
    private static boolean _synchonizedFlashFlag;
    private static Timer _synchonizedFlashTimer;

    public Flashable(JComponent component) {
        this._component = component;
        this.install(this._component);
    }

    public boolean getSynchonizedFlashFlag() {
        return _synchonizedFlashFlag;
    }

    private void install(JComponent component) {
        this._animator = new Animator(component, 0, this.getInterval(), -1){

            protected Timer createTimer(int delay, ActionListener listener) {
                if (_synchonizedFlashTimer == null) {
                    _synchonizedFlashTimer = new FlashTimer(delay, listener);
                }
                _synchonizedFlashTimer.addActionListener(listener);
                return _synchonizedFlashTimer;
            }
        };
        this._animator.setAnimatorListener(new AnimatorListener(){

            public void animationStarts(Component component) {
            }

            public void animationFrame(Component component, int totalStep, int step) {
                Flashable.this.flash();
            }

            public void animationEnds(Component component) {
            }
        });
        component.putClientProperty(CLIENT_PROPERTY_FLASHABLE, this);
    }

    public JComponent getComponent() {
        return this._component;
    }

    public void setComponent(JComponent component) {
        JComponent old = this._component;
        if (old != component) {
            this._component.putClientProperty(CLIENT_PROPERTY_FLASHABLE, null);
            this._component = component;
            this._component.putClientProperty(CLIENT_PROPERTY_FLASHABLE, this);
        }
    }

    public int getInterval() {
        return this._interval;
    }

    public void setInterval(int interval) {
        int old = this._interval;
        if (old != interval) {
            this._interval = interval;
            this.getAnimator().setDelay(interval);
        }
    }

    public abstract void flash();

    public abstract void clearFlashing();

    protected Animator getAnimator() {
        return this._animator;
    }

    public void startFlashing() {
        this.clearFlashing();
        this.getAnimator().start();
    }

    public void stopFlashing() {
        this.clearFlashing();
        this.getAnimator().stop();
    }

    public void uninstall() {
        this.stopFlashing();
        this._animator.dispose();
        this._animator = null;
        this.getComponent().putClientProperty(CLIENT_PROPERTY_FLASHABLE, null);
    }

    public boolean isFlashing() {
        return this.getAnimator().isRunning();
    }

    public static boolean isFlashableInstalled(JComponent component) {
        Object flashable = component.getClientProperty(CLIENT_PROPERTY_FLASHABLE);
        return flashable instanceof Flashable;
    }

    public static Flashable getFlashable(JComponent component) {
        Object flashable = component.getClientProperty(CLIENT_PROPERTY_FLASHABLE);
        if (flashable instanceof Flashable) {
            return (Flashable)flashable;
        }
        return null;
    }

    static class FlashTimer
    extends Timer
    implements ActionListener {
        public FlashTimer(int delay, ActionListener listener) {
            super(delay, listener);
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent e) {
            _synchonizedFlashFlag = !_synchonizedFlashFlag;
        }
    }
}

