/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.Timer;

public class InfiniteProgressPanel
extends JComponent
implements ActionListener {
    private static final int DEFAULT_NUMBER_OF_BARS = 12;
    private int numBars = 12;
    private double dScale = 1.2;
    private Area[] bars;
    private Rectangle barsBounds = null;
    private Rectangle barsScreenBounds = null;
    private AffineTransform centerAndScaleTransform = null;
    private Timer timer = new Timer(62, this);
    private Color[] colors = new Color[this.numBars * 2];
    private int colorOffset = 0;
    private boolean tempHide = false;
    private String text;

    public InfiniteProgressPanel() {
        int i;
        this.bars = InfiniteProgressPanel.buildTicker(this.numBars);
        this.barsBounds = new Rectangle();
        for (i = 0; i < this.bars.length; ++i) {
            this.barsBounds = this.barsBounds.union(this.bars[i].getBounds());
        }
        for (i = 0; i < this.bars.length; ++i) {
            int channel = 224 - 128 / (i + 1);
            this.colors[i] = new Color(channel, channel, channel);
            this.colors[this.numBars + i] = this.colors[i];
        }
        this.setOpaque(true);
    }

    public void actionPerformed(ActionEvent e) {
        this.colorOffset = this.colorOffset == this.numBars - 1 ? 0 : ++this.colorOffset;
        if (this.barsScreenBounds != null) {
            this.repaint(this.barsScreenBounds);
        } else {
            this.repaint();
        }
    }

    public void setVisible(boolean i_bIsVisible) {
        this.setOpaque(false);
        if (i_bIsVisible) {
            this.timer.start();
        } else {
            this.timer.stop();
        }
        super.setVisible(i_bIsVisible);
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.centerAndScaleTransform = new AffineTransform();
        this.centerAndScaleTransform.translate((double)this.getWidth() / 2.0, (double)this.getHeight() / 2.0);
        this.centerAndScaleTransform.scale(this.dScale, this.dScale);
        if (this.barsBounds != null) {
            Area oBounds = new Area(this.barsBounds);
            oBounds.transform(this.centerAndScaleTransform);
            this.barsScreenBounds = oBounds.getBounds();
        }
    }

    protected void paintComponent(Graphics g) {
        if (!this.tempHide) {
            Rectangle oClip = g.getClipBounds();
            if (this.isOpaque()) {
                g.setColor(this.getBackground());
                g.fillRect(oClip.x, oClip.y, oClip.width, oClip.height);
            }
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.transform(this.centerAndScaleTransform);
            for (int i = 0; i < this.bars.length; ++i) {
                g2.setColor(this.colors[i + this.colorOffset]);
                g2.fill(this.bars[i]);
            }
        }
    }

    private static Area[] buildTicker(int i_iBarCount) {
        Area[] ticker = new Area[i_iBarCount];
        Point2D.Double center = new Point2D.Double(0.0, 0.0);
        double fixedAngle = Math.PI * 2 / (double)i_iBarCount;
        for (double i = 0.0; i < (double)i_iBarCount; i += 1.0) {
            Area primitive = InfiniteProgressPanel.buildPrimitive();
            AffineTransform toCenter = AffineTransform.getTranslateInstance(center.getX(), center.getY());
            AffineTransform toBorder = AffineTransform.getTranslateInstance(2.0, -0.4);
            AffineTransform toCircle = AffineTransform.getRotateInstance(-i * fixedAngle, center.getX(), center.getY());
            AffineTransform toWheel = new AffineTransform();
            toWheel.concatenate(toCenter);
            toWheel.concatenate(toBorder);
            primitive.transform(toWheel);
            primitive.transform(toCircle);
            ticker[(int)i] = primitive;
        }
        return ticker;
    }

    private static Area buildPrimitive() {
        Rectangle2D.Double body = new Rectangle2D.Double(0.0, 0.0, 6.0, 1.0);
        Area tick = new Area(body);
        return tick;
    }

    public void start() {
        this.setVisible(true);
    }

    public void stop() {
        this.setVisible(false);
    }
}

