/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.SimpleScrollPane;
import com.jidesoft.utils.PortingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.PopupMenuUI;

public class JidePopupMenu
extends JPopupMenu
implements Scrollable {
    private static final String uiClassID = "JidePopupMenuUI";
    private boolean _useLightWeightPopup;

    public JidePopupMenu() {
        this.setupPopupMenu();
    }

    public JidePopupMenu(String label) {
        super(label);
        this.setupPopupMenu();
    }

    public String getUIClassID() {
        return uiClassID;
    }

    private void setupPopupMenu() {
        this.addPopupMenuListener(new ToolTipSwitchPopupMenuListener());
    }

    public void updateUI() {
        if (UIDefaultsLookup.get(uiClassID) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        this.setUI((PopupMenuUI)UIManager.getUI(this));
    }

    public void show(Component invoker, int x, int y) {
        Point p = this.getPopupMenuOrigin(invoker, x, y);
        super.show(invoker, p.x, p.y);
    }

    protected Point getPopupMenuOrigin(Component invoker, int x, int y) {
        Rectangle bounds = PortingUtils.getScreenBounds(invoker);
        Dimension size = this.getSize();
        if (size.width == 0) {
            size = this.getPreferredSize();
        }
        Point p = new Point(x, y);
        SwingUtilities.convertPointToScreen(p, invoker);
        int left = p.x + size.width;
        int bottom = p.y + size.height;
        if (x < bounds.x) {
            x = bounds.x;
        }
        if (left > bounds.width) {
            x -= size.width;
        }
        if (bottom > bounds.height) {
            y -= size.height;
        }
        if (y < bounds.y) {
            y = bounds.y;
        }
        return new Point(x, y);
    }

    public void setLocation(int x, int y) {
        if (this.isVisible() && y <= 0) {
            this.move(x, y);
        } else {
            super.setLocation(x, y);
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        Dimension size = this.getPreferredSize();
        Dimension screenSize = PortingUtils.getLocalScreenSize(this);
        Container container = SwingUtilities.getAncestorOfClass(SimpleScrollPane.class, this);
        if (container instanceof SimpleScrollPane) {
            SimpleScrollPane scrollPane = (SimpleScrollPane)container;
            size.height = Math.min(size.height, screenSize.height - scrollPane.getScrollUpButton().getPreferredSize().height - scrollPane.getScrollDownButton().getPreferredSize().height);
        }
        return size;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return new JMenuItem((String)"ABC").getPreferredSize().height;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return new JMenuItem((String)"ABC").getPreferredSize().height * 5;
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    private class ToolTipSwitchPopupMenuListener
    implements PopupMenuListener {
        private ToolTipSwitchPopupMenuListener() {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            JidePopupMenu.this._useLightWeightPopup = ToolTipManager.sharedInstance().isLightWeightPopupEnabled();
            ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            ToolTipManager.sharedInstance().setLightWeightPopupEnabled(JidePopupMenu.this._useLightWeightPopup);
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
            ToolTipManager.sharedInstance().setLightWeightPopupEnabled(JidePopupMenu.this._useLightWeightPopup);
        }
    }
}

