/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideScrollPane;
import com.jidesoft.swing.JideScrollPaneConstants;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ScrollPaneLayout;
import javax.swing.Scrollable;
import javax.swing.border.Border;

class JideScrollPaneLayout
extends ScrollPaneLayout
implements JideScrollPaneConstants {
    protected JViewport _rowFoot;
    protected JViewport _colFoot;
    protected Component _hLeft;
    protected Component _hRight;
    protected Component _vTop;
    protected Component _vBottom;

    JideScrollPaneLayout() {
    }

    public void syncWithScrollPane(JScrollPane sp) {
        super.syncWithScrollPane(sp);
        if (sp instanceof JideScrollPane) {
            this._rowFoot = ((JideScrollPane)sp).getRowFooter();
            this._colFoot = ((JideScrollPane)sp).getColumnFooter();
            this._hLeft = ((JideScrollPane)sp).getScrollBarCorner("HORIZONTAL_LEFT");
            this._hRight = ((JideScrollPane)sp).getScrollBarCorner("HORIZONTAL_RIGHT");
            this._vTop = ((JideScrollPane)sp).getScrollBarCorner("VERTICAL_TOP");
            this._vBottom = ((JideScrollPane)sp).getScrollBarCorner("VERTICAL_BOTTOM");
        }
    }

    protected boolean isHsbCoversWholeWidth(JScrollPane sp) {
        if (sp instanceof JideScrollPane) {
            return ((JideScrollPane)sp).isHorizontalScrollBarCoversWholeWidth();
        }
        return false;
    }

    protected boolean isVsbCoversWholeHeight(JScrollPane sp) {
        if (sp instanceof JideScrollPane) {
            return ((JideScrollPane)sp).isVerticalScrollBarCoversWholeHeight();
        }
        return false;
    }

    public void addLayoutComponent(String s, Component c) {
        if (s.equals("ROW_FOOTER")) {
            this._rowFoot = (JViewport)this.addSingletonComponent(this._rowFoot, c);
        } else if (s.equals("COLUMN_FOOTER")) {
            this._colFoot = (JViewport)this.addSingletonComponent(this._colFoot, c);
        } else if (s.equals("HORIZONTAL_LEFT")) {
            this._hLeft = this.addSingletonComponent(this._hLeft, c);
        } else if (s.equals("HORIZONTAL_RIGHT")) {
            this._hRight = this.addSingletonComponent(this._hRight, c);
        } else if (s.equals("VERTICAL_TOP")) {
            this._vTop = this.addSingletonComponent(this._vTop, c);
        } else if (s.equals("VERTICAL_BOTTOM")) {
            this._vBottom = this.addSingletonComponent(this._vBottom, c);
        } else {
            super.addLayoutComponent(s, c);
        }
    }

    public void removeLayoutComponent(Component c) {
        if (c == this._rowFoot) {
            this._rowFoot = null;
        } else if (c == this._colFoot) {
            this._colFoot = null;
        } else if (c == this._hLeft) {
            this._hLeft = null;
        } else if (c == this._hRight) {
            this._hRight = null;
        } else if (c == this._vTop) {
            this._vTop = null;
        } else if (c == this._vBottom) {
            this._vBottom = null;
        } else {
            super.removeLayoutComponent(c);
        }
    }

    public JViewport getRowFooter() {
        return this._rowFoot;
    }

    public JViewport getColumnFooter() {
        return this._colFoot;
    }

    public Component getScrollBarCorner(String key) {
        if (key.equals("HORIZONTAL_LEFT")) {
            return this._hLeft;
        }
        if (key.equals("HORIZONTAL_RIGHT")) {
            return this._hRight;
        }
        if (key.equals("VERTICAL_BOTTOM")) {
            return this._vBottom;
        }
        if (key.equals("VERTICAL_TOP")) {
            return this._vTop;
        }
        return super.getCorner(key);
    }

    public Dimension preferredLayoutSize(Container parent) {
        boolean canScroll;
        Border viewportBorder;
        JScrollPane scrollPane = (JScrollPane)parent;
        this.vsbPolicy = scrollPane.getVerticalScrollBarPolicy();
        this.hsbPolicy = scrollPane.getHorizontalScrollBarPolicy();
        Insets insets = parent.getInsets();
        int prefWidth = insets.left + insets.right;
        int prefHeight = insets.top + insets.bottom;
        Dimension extentSize = null;
        Dimension viewSize = null;
        Component view = null;
        if (this.viewport != null) {
            extentSize = this.viewport.getPreferredSize();
            viewSize = this.viewport.getViewSize();
            view = this.viewport.getView();
        }
        if (extentSize != null) {
            prefWidth += extentSize.width;
            prefHeight += extentSize.height;
        }
        if ((viewportBorder = scrollPane.getViewportBorder()) != null) {
            Insets vpbInsets = viewportBorder.getBorderInsets(parent);
            prefWidth += vpbInsets.left + vpbInsets.right;
            prefHeight += vpbInsets.top + vpbInsets.bottom;
        }
        int rowHeaderWidth = 0;
        if (this.rowHead != null && this.rowHead.isVisible()) {
            rowHeaderWidth = this.rowHead.getPreferredSize().width;
        }
        if (this.upperLeft != null && this.upperLeft.isVisible()) {
            rowHeaderWidth = Math.max(rowHeaderWidth, this.upperLeft.getPreferredSize().width);
        }
        if (this.lowerLeft != null && this.lowerLeft.isVisible()) {
            rowHeaderWidth = Math.max(rowHeaderWidth, this.lowerLeft.getPreferredSize().width);
        }
        prefWidth += rowHeaderWidth;
        int upperHeight = this.getUpperHeight();
        prefHeight += upperHeight;
        if (this._rowFoot != null && this._rowFoot.isVisible()) {
            prefWidth += this._rowFoot.getPreferredSize().width;
        }
        int lowerHeight = this.getLowerHeight();
        prefHeight += lowerHeight;
        if (this.vsb != null && this.vsbPolicy != 21) {
            if (this.vsbPolicy == 22) {
                prefWidth += this.vsb.getPreferredSize().width;
            } else if (viewSize != null && extentSize != null) {
                canScroll = true;
                if (view instanceof Scrollable) {
                    boolean bl = canScroll = !((Scrollable)((Object)view)).getScrollableTracksViewportHeight();
                }
                if (canScroll && viewSize.height > extentSize.height) {
                    prefWidth += this.vsb.getPreferredSize().width;
                }
            }
        }
        if (this.hsb != null && this.hsbPolicy != 31) {
            if (this.hsbPolicy == 32) {
                prefHeight += this.hsb.getPreferredSize().height;
            } else if (viewSize != null && extentSize != null) {
                canScroll = true;
                if (view instanceof Scrollable) {
                    boolean bl = canScroll = !((Scrollable)((Object)view)).getScrollableTracksViewportWidth();
                }
                if (canScroll && viewSize.width > extentSize.width) {
                    prefHeight += this.hsb.getPreferredSize().height;
                }
            }
        }
        return new Dimension(prefWidth, prefHeight);
    }

    private int getUpperHeight() {
        int upperHeight = 0;
        if (this.upperLeft != null && this.upperLeft.isVisible()) {
            upperHeight = this.upperLeft.getPreferredSize().height;
        }
        if (this.upperRight != null && this.upperRight.isVisible()) {
            upperHeight = Math.max(this.upperRight.getPreferredSize().height, upperHeight);
        }
        if (this.colHead != null && this.colHead.isVisible()) {
            upperHeight = Math.max(this.colHead.getPreferredSize().height, upperHeight);
        }
        return upperHeight;
    }

    private int getLowerHeight() {
        int lowerHeight = 0;
        if (this.lowerLeft != null && this.lowerLeft.isVisible()) {
            lowerHeight = this.lowerLeft.getPreferredSize().height;
        }
        if (this.lowerRight != null && this.lowerRight.isVisible()) {
            lowerHeight = Math.max(this.lowerRight.getPreferredSize().height, lowerHeight);
        }
        if (this._colFoot != null && this._colFoot.isVisible()) {
            lowerHeight = Math.max(this._colFoot.getPreferredSize().height, lowerHeight);
        }
        return lowerHeight;
    }

    public Dimension minimumLayoutSize(Container parent) {
        Dimension size;
        Border viewportBorder;
        JScrollPane scrollPane = (JScrollPane)parent;
        this.vsbPolicy = scrollPane.getVerticalScrollBarPolicy();
        this.hsbPolicy = scrollPane.getHorizontalScrollBarPolicy();
        Insets insets = parent.getInsets();
        int minWidth = insets.left + insets.right;
        int minHeight = insets.top + insets.bottom;
        if (this.viewport != null) {
            Dimension size2 = this.viewport.getMinimumSize();
            minWidth += size2.width;
            minHeight += size2.height;
        }
        if ((viewportBorder = scrollPane.getViewportBorder()) != null) {
            Insets vpbInsets = viewportBorder.getBorderInsets(parent);
            minWidth += vpbInsets.left + vpbInsets.right;
            minHeight += vpbInsets.top + vpbInsets.bottom;
        }
        int rowHeaderWidth = 0;
        if (this.rowHead != null && this.rowHead.isVisible()) {
            Dimension size3 = this.rowHead.getMinimumSize();
            rowHeaderWidth = size3.width;
            minHeight = Math.max(minHeight, size3.height);
        }
        if (this.upperLeft != null && this.upperLeft.isVisible()) {
            rowHeaderWidth = Math.max(rowHeaderWidth, this.upperLeft.getMinimumSize().width);
        }
        if (this.lowerLeft != null && this.lowerLeft.isVisible()) {
            rowHeaderWidth = Math.max(rowHeaderWidth, this.lowerLeft.getMinimumSize().width);
        }
        minWidth += rowHeaderWidth;
        int upperHeight = 0;
        if (this.upperLeft != null && this.upperLeft.isVisible()) {
            upperHeight = this.upperLeft.getMinimumSize().height;
        }
        if (this.upperRight != null && this.upperRight.isVisible()) {
            upperHeight = Math.max(this.upperRight.getMinimumSize().height, upperHeight);
        }
        if (this.colHead != null && this.colHead.isVisible()) {
            Dimension size4 = this.colHead.getMinimumSize();
            minWidth = Math.max(minWidth, size4.width);
            upperHeight = Math.max(size4.height, upperHeight);
        }
        minHeight += upperHeight;
        int lowerHeight = 0;
        if (this.lowerLeft != null && this.lowerLeft.isVisible()) {
            lowerHeight = this.lowerLeft.getMinimumSize().height;
        }
        if (this.lowerRight != null && this.lowerRight.isVisible()) {
            lowerHeight = Math.max(this.lowerRight.getMinimumSize().height, lowerHeight);
        }
        if (this._colFoot != null && this._colFoot.isVisible()) {
            size = this._colFoot.getMinimumSize();
            minWidth = Math.max(minWidth, size.width);
            lowerHeight = Math.max(size.height, lowerHeight);
        }
        minHeight += lowerHeight;
        if (this._rowFoot != null && this._rowFoot.isVisible()) {
            size = this._rowFoot.getMinimumSize();
            minWidth = Math.max(minWidth, size.width);
            minHeight += size.height;
        }
        if (this.vsb != null && this.vsbPolicy != 21) {
            size = this.vsb.getMinimumSize();
            minWidth += size.width;
            minHeight = Math.max(minHeight, size.height);
        }
        if (this.hsb != null && this.hsbPolicy != 31) {
            size = this.hsb.getMinimumSize();
            minWidth = Math.max(minWidth, size.width);
            minHeight += size.height;
        }
        return new Dimension(minWidth, minHeight);
    }

    public void layoutContainer(Container parent) {
        int height;
        boolean hsbNeeded;
        boolean vsbNeeded;
        Scrollable sv;
        boolean isEmpty;
        Insets vpbInsets;
        Border viewportBorder;
        JScrollPane scrollPane = (JScrollPane)parent;
        this.vsbPolicy = scrollPane.getVerticalScrollBarPolicy();
        this.hsbPolicy = scrollPane.getHorizontalScrollBarPolicy();
        Rectangle availR = scrollPane.getBounds();
        availR.y = 0;
        availR.x = 0;
        Insets insets = parent.getInsets();
        availR.x = insets.left;
        availR.y = insets.top;
        availR.width -= insets.left + insets.right;
        availR.height -= insets.top + insets.bottom;
        boolean leftToRight = scrollPane.getComponentOrientation().isLeftToRight();
        Rectangle colHeadR = new Rectangle(0, availR.y, 0, 0);
        int upperHeight = this.getUpperHeight();
        if (this.colHead != null && this.colHead.isVisible()) {
            int colHeadHeight;
            colHeadR.height = colHeadHeight = Math.min(availR.height, upperHeight);
            availR.y += colHeadHeight;
            availR.height -= colHeadHeight;
        }
        Rectangle rowHeadR = new Rectangle(0, 0, 0, 0);
        if (this.rowHead != null && this.rowHead.isVisible()) {
            int rowHeadWidth = this.rowHead.getPreferredSize().width;
            if (this.upperLeft != null && this.upperLeft.isVisible()) {
                rowHeadWidth = Math.max(rowHeadWidth, this.upperLeft.getPreferredSize().width);
            }
            if (this.lowerLeft != null && this.lowerLeft.isVisible()) {
                rowHeadWidth = Math.max(rowHeadWidth, this.lowerLeft.getPreferredSize().width);
            }
            rowHeadR.width = rowHeadWidth = Math.min(availR.width, rowHeadWidth);
            availR.width -= rowHeadWidth;
            if (leftToRight) {
                rowHeadR.x = availR.x;
                availR.x += rowHeadWidth;
            } else {
                rowHeadR.x = availR.x + availR.width;
            }
        }
        if ((viewportBorder = scrollPane.getViewportBorder()) != null) {
            vpbInsets = viewportBorder.getBorderInsets(parent);
            availR.x += vpbInsets.left;
            availR.y += vpbInsets.top;
            availR.width -= vpbInsets.left + vpbInsets.right;
            availR.height -= vpbInsets.top + vpbInsets.bottom;
        } else {
            vpbInsets = new Insets(0, 0, 0, 0);
        }
        Rectangle rowFootR = new Rectangle(0, 0, 0, 0);
        if (this._rowFoot != null && this._rowFoot.isVisible()) {
            int rowFootWidth;
            rowFootR.width = rowFootWidth = Math.min(availR.width, this._rowFoot.getPreferredSize().width);
            availR.width -= rowFootWidth;
            if (leftToRight) {
                rowFootR.x = availR.x + availR.width;
            } else {
                rowFootR.x = availR.x;
                availR.x += rowFootWidth;
            }
        }
        Rectangle colFootR = new Rectangle(0, availR.y, 0, 0);
        int lowerHeight = this.getLowerHeight();
        if (this._colFoot != null && this._colFoot.isVisible()) {
            int colFootHeight;
            colFootR.height = colFootHeight = Math.min(availR.height, lowerHeight);
            availR.height -= colFootHeight;
            colFootR.y = availR.y + availR.height;
        }
        Component view = this.viewport != null ? this.viewport.getView() : null;
        Dimension viewPrefSize = view != null ? view.getPreferredSize() : new Dimension(0, 0);
        Dimension extentSize = this.viewport != null ? this.viewport.toViewCoordinates(availR.getSize()) : new Dimension(0, 0);
        boolean viewTracksViewportWidth = false;
        boolean viewTracksViewportHeight = false;
        boolean bl = isEmpty = availR.width < 0 || availR.height < 0;
        if (!isEmpty && view instanceof Scrollable) {
            sv = (Scrollable)((Object)view);
            viewTracksViewportWidth = sv.getScrollableTracksViewportWidth();
            viewTracksViewportHeight = sv.getScrollableTracksViewportHeight();
        } else {
            sv = null;
        }
        Rectangle vsbR = new Rectangle(0, this.isVsbCoversWholeHeight(scrollPane) ? -vpbInsets.top : availR.y - vpbInsets.top, 0, 0);
        if (isEmpty) {
            vsbNeeded = false;
        } else if (this.vsbPolicy == 22) {
            vsbNeeded = true;
        } else if (this.vsbPolicy == 21) {
            vsbNeeded = false;
        } else {
            boolean bl2 = vsbNeeded = !viewTracksViewportHeight && (viewPrefSize.height > extentSize.height || this.rowHead != null && this.rowHead.getView().getPreferredSize().height > extentSize.height);
        }
        if (this.vsb != null && vsbNeeded) {
            this.adjustForVSB(true, availR, vsbR, vpbInsets, leftToRight);
            extentSize = this.viewport.toViewCoordinates(availR.getSize());
        }
        Rectangle hsbR = new Rectangle(this.isHsbCoversWholeWidth(scrollPane) ? -vpbInsets.left : availR.x - vpbInsets.left, 0, 0, 0);
        if (isEmpty) {
            hsbNeeded = false;
        } else if (this.hsbPolicy == 32) {
            hsbNeeded = true;
        } else if (this.hsbPolicy == 31) {
            hsbNeeded = false;
        } else {
            boolean bl3 = hsbNeeded = !viewTracksViewportWidth && (viewPrefSize.width > extentSize.width || this.colHead != null && this.colHead.getView().getPreferredSize().width > extentSize.width);
        }
        if (this.hsb != null && hsbNeeded) {
            this.adjustForHSB(true, availR, hsbR, vpbInsets);
            if (this.vsb != null && !vsbNeeded && this.vsbPolicy != 21) {
                extentSize = this.viewport.toViewCoordinates(availR.getSize());
                boolean bl4 = vsbNeeded = viewPrefSize.height > extentSize.height;
                if (vsbNeeded) {
                    this.adjustForVSB(true, availR, vsbR, vpbInsets, leftToRight);
                }
            }
        }
        if (this.viewport != null) {
            this.viewport.setBounds(availR);
            if (sv != null) {
                extentSize = this.viewport.toViewCoordinates(availR.getSize());
                boolean oldHSBNeeded = hsbNeeded;
                boolean oldVSBNeeded = vsbNeeded;
                viewTracksViewportWidth = sv.getScrollableTracksViewportWidth();
                viewTracksViewportHeight = sv.getScrollableTracksViewportHeight();
                if (this.vsb != null && this.vsbPolicy == 20) {
                    boolean newVSBNeeded;
                    boolean bl5 = newVSBNeeded = !viewTracksViewportHeight && (viewPrefSize.height > extentSize.height || this.rowHead != null && this.rowHead.getView().getPreferredSize().height > extentSize.height);
                    if (newVSBNeeded != vsbNeeded) {
                        vsbNeeded = newVSBNeeded;
                        this.adjustForVSB(vsbNeeded, availR, vsbR, vpbInsets, leftToRight);
                        extentSize = this.viewport.toViewCoordinates(availR.getSize());
                    }
                }
                if (this.hsb != null && this.hsbPolicy == 30) {
                    boolean newHSBbNeeded;
                    boolean bl6 = newHSBbNeeded = !viewTracksViewportWidth && (viewPrefSize.width > extentSize.width || this.colHead != null && this.colHead.getView().getPreferredSize().width > extentSize.width);
                    if (newHSBbNeeded != hsbNeeded) {
                        hsbNeeded = newHSBbNeeded;
                        this.adjustForHSB(hsbNeeded, availR, hsbR, vpbInsets);
                        if (this.vsb != null && !vsbNeeded && this.vsbPolicy != 21) {
                            extentSize = this.viewport.toViewCoordinates(availR.getSize());
                            boolean bl7 = vsbNeeded = viewPrefSize.height > extentSize.height;
                            if (vsbNeeded) {
                                this.adjustForVSB(true, availR, vsbR, vpbInsets, leftToRight);
                            }
                        }
                        if (this._rowFoot != null && this._rowFoot.isVisible()) {
                            vsbR.x += rowFootR.width;
                        }
                    }
                }
                if (oldHSBNeeded != hsbNeeded || oldVSBNeeded != vsbNeeded) {
                    this.viewport.setBounds(availR);
                }
            }
        }
        vsbR.height = this.isVsbCoversWholeHeight(scrollPane) ? scrollPane.getHeight() - 1 : availR.height + vpbInsets.top + vpbInsets.bottom;
        hsbR.width = this.isHsbCoversWholeWidth(scrollPane) ? scrollPane.getWidth() - vsbR.width : availR.width + vpbInsets.left + vpbInsets.right;
        rowHeadR.height = availR.height + vpbInsets.top + vpbInsets.bottom;
        rowHeadR.y = availR.y - vpbInsets.top;
        colHeadR.width = availR.width + vpbInsets.left + vpbInsets.right;
        colHeadR.x = availR.x - vpbInsets.left;
        colFootR.x = availR.x;
        colFootR.y = rowHeadR.y + rowHeadR.height;
        colFootR.width = availR.width;
        rowFootR.x = availR.x + availR.width;
        rowFootR.y = availR.y;
        rowFootR.height = availR.height;
        vsbR.x += rowFootR.width;
        hsbR.y += colFootR.height;
        if (this.rowHead != null) {
            this.rowHead.setBounds(rowHeadR);
        }
        if (this._rowFoot != null) {
            this._rowFoot.setBounds(rowFootR);
        }
        if (this.colHead != null) {
            height = Math.min(colHeadR.height, this.colHead.getPreferredSize().height);
            this.colHead.setBounds(new Rectangle(colHeadR.x, colHeadR.y + colHeadR.height - height, colHeadR.width, height));
        }
        if (this._colFoot != null) {
            height = Math.min(colFootR.height, this._colFoot.getPreferredSize().height);
            this._colFoot.setBounds(new Rectangle(colFootR.x, colFootR.y, colFootR.width, height));
        }
        if (this.vsb != null) {
            if (vsbNeeded) {
                this.vsb.setVisible(true);
                if (this._vTop == null && this._vBottom == null) {
                    this.vsb.setBounds(vsbR);
                } else {
                    Rectangle rect = new Rectangle(vsbR);
                    if (this._vTop != null) {
                        Dimension dim = this._vTop.getPreferredSize();
                        rect.y += dim.height;
                        rect.height -= dim.height;
                        this._vTop.setVisible(true);
                        this._vTop.setBounds(vsbR.x, vsbR.y, vsbR.width, dim.height);
                    }
                    if (this._vBottom != null) {
                        Dimension dim = this._vBottom.getPreferredSize();
                        rect.height -= dim.height;
                        this._vBottom.setVisible(true);
                        this._vBottom.setBounds(vsbR.x, vsbR.y + vsbR.height - dim.height, vsbR.width, dim.height);
                    }
                    this.vsb.setBounds(rect);
                }
            } else {
                if (viewPrefSize.height > extentSize.height) {
                    this.vsb.setVisible(true);
                    this.vsb.setBounds(vsbR.x, vsbR.y, 0, vsbR.height);
                } else {
                    this.vsb.setVisible(false);
                }
                if (this._vTop != null) {
                    this._vTop.setVisible(false);
                }
                if (this._vBottom != null) {
                    this._vBottom.setVisible(false);
                }
            }
        }
        if (this.hsb != null) {
            if (hsbNeeded) {
                this.hsb.setVisible(true);
                if (this._hLeft == null && this._hRight == null) {
                    this.hsb.setBounds(hsbR);
                } else {
                    Rectangle rect = new Rectangle(hsbR);
                    if (this._hLeft != null) {
                        Dimension dim = this._hLeft.getPreferredSize();
                        rect.x += dim.width;
                        rect.width -= dim.width;
                        this._hLeft.setVisible(true);
                        this._hLeft.setBounds(hsbR.x, hsbR.y, dim.width, hsbR.height);
                        this._hLeft.doLayout();
                    }
                    if (this._hRight != null) {
                        Dimension dim = this._hRight.getPreferredSize();
                        rect.width -= dim.width;
                        this._hRight.setVisible(true);
                        this._hRight.setBounds(hsbR.x + hsbR.width - dim.width, hsbR.y, dim.width, hsbR.height);
                    }
                    this.hsb.setBounds(rect);
                }
            } else {
                if (viewPrefSize.width > extentSize.width) {
                    this.hsb.setVisible(true);
                    this.hsb.setBounds(hsbR.x, hsbR.y, hsbR.width, 0);
                } else {
                    this.hsb.setVisible(false);
                }
                if (this._hLeft != null) {
                    this._hLeft.setVisible(false);
                }
                if (this._hRight != null) {
                    this._hRight.setVisible(false);
                }
            }
        }
        if (this.lowerLeft != null && this.lowerLeft.isVisible()) {
            int height2 = Math.min(this.lowerLeft.getPreferredSize().height, colFootR.height);
            this.lowerLeft.setBounds(leftToRight ? rowHeadR.x : vsbR.x, colFootR.y != 0 ? colFootR.y : hsbR.y, leftToRight ? rowHeadR.width : vsbR.width, height2);
        }
        if (this.lowerRight != null && this.lowerRight.isVisible()) {
            int height3 = Math.min(this.lowerRight.getPreferredSize().height, colFootR.height);
            this.lowerRight.setBounds(leftToRight ? rowFootR.x : rowHeadR.x, colFootR.y != 0 ? colFootR.y : hsbR.y, leftToRight ? rowFootR.width + (this.isVsbCoversWholeHeight(scrollPane) ? 0 : vsbR.width) : rowHeadR.width, height3);
        }
        if (this.upperLeft != null && this.upperLeft.isVisible()) {
            int height4 = Math.min(this.upperLeft.getPreferredSize().height, colHeadR.height);
            this.upperLeft.setBounds(leftToRight ? rowHeadR.x : vsbR.x, colHeadR.y + colHeadR.height - height4, leftToRight ? rowHeadR.width : vsbR.width, height4);
        }
        if (this.upperRight != null && this.upperRight.isVisible()) {
            int height5 = Math.min(this.upperRight.getPreferredSize().height, colHeadR.height);
            this.upperRight.setBounds(leftToRight ? rowFootR.x : rowHeadR.x, colHeadR.y + colHeadR.height - height5, leftToRight ? rowFootR.width + (this.isVsbCoversWholeHeight(scrollPane) ? 0 : vsbR.width) : rowHeadR.width, height5);
        }
    }

    private void adjustForVSB(boolean wantsVSB, Rectangle available, Rectangle vsbR, Insets vpbInsets, boolean leftToRight) {
        int oldWidth = vsbR.width;
        if (wantsVSB) {
            int vsbWidth = Math.max(0, Math.min(this.vsb.getPreferredSize().width, available.width));
            available.width -= vsbWidth;
            vsbR.width = vsbWidth;
            if (leftToRight) {
                vsbR.x = available.x + available.width + vpbInsets.right;
            } else {
                vsbR.x = available.x - vpbInsets.left;
                available.x += vsbWidth;
            }
        } else {
            available.width += oldWidth;
        }
    }

    private void adjustForHSB(boolean wantsHSB, Rectangle available, Rectangle hsbR, Insets vpbInsets) {
        int oldHeight = hsbR.height;
        if (wantsHSB) {
            int hsbHeight = Math.max(0, Math.min(available.height, this.hsb.getPreferredSize().height));
            available.height -= hsbHeight;
            hsbR.y = available.y + available.height + vpbInsets.bottom;
            hsbR.height = hsbHeight;
        } else {
            available.height += oldHeight;
        }
    }

    static class UIResource
    extends JideScrollPaneLayout
    implements javax.swing.plaf.UIResource {
        UIResource() {
        }
    }
}

