/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.Painter;
import com.jidesoft.swing.JideCursors;
import com.jidesoft.swing.JideSplitPane;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;

public class JideSplitPaneDivider
extends JPanel
implements PropertyChangeListener {
    protected DragController _dragger;
    protected int _dividerSize = UIDefaultsLookup.getInt("JideSplitPane.dividerSize");
    protected JideSplitPane _jideSplitPane;
    protected MouseHandler _mouseHandler;
    protected int _orientation;
    static final Cursor HORIZONTAL_CURSOR = JideCursors.getPredefinedCursor(20);
    static final Cursor VERTICAL_CURSOR = JideCursors.getPredefinedCursor(21);
    static final Cursor DEFAULT_CURSOR = Cursor.getDefaultCursor();
    private Painter _gripperPainter;

    public JideSplitPaneDivider(JideSplitPane splitPane) {
        this.setJideSplitPane(splitPane);
        this._orientation = this._jideSplitPane.getOrientation();
        this.setDividerSize(splitPane.getDividerSize());
        this.setDefaultResizeCursor();
        this.setBackground(UIDefaultsLookup.getColor("JideSplitPaneDivider.background"));
        this.setBorder(UIDefaultsLookup.getBorder("JideSplitPaneDivider.border"));
        this._gripperPainter = (Painter)UIDefaultsLookup.get("JideSplitPaneDivider.gripperPainter");
        this.setOpaque(false);
    }

    public void setDefaultResizeCursor() {
        this.setCursor(this._orientation == 1 ? HORIZONTAL_CURSOR : VERTICAL_CURSOR);
    }

    public JideSplitPane getJideSplitPane() {
        return this._jideSplitPane;
    }

    public void setJideSplitPane(JideSplitPane newPane) {
        this.uninstallListeners();
        this._jideSplitPane = newPane;
        this.installListeners();
    }

    private void installListeners() {
        if (this._jideSplitPane != null) {
            if (this._mouseHandler == null) {
                this._mouseHandler = this.createMouseHandler();
            }
            this._jideSplitPane.addMouseListener(this._mouseHandler);
            this._jideSplitPane.addMouseMotionListener(this._mouseHandler);
            this.addMouseListener(this._mouseHandler);
            this.addMouseMotionListener(this._mouseHandler);
            this._jideSplitPane.addPropertyChangeListener(this);
        }
    }

    private void uninstallListeners() {
        if (this._jideSplitPane != null) {
            this._jideSplitPane.removePropertyChangeListener(this);
            if (this._mouseHandler != null) {
                this._jideSplitPane.removeMouseListener(this._mouseHandler);
                this._jideSplitPane.removeMouseMotionListener(this._mouseHandler);
                this.removeMouseListener(this._mouseHandler);
                this.removeMouseMotionListener(this._mouseHandler);
                this._mouseHandler = null;
            }
        }
    }

    protected MouseHandler createMouseHandler() {
        return new MouseHandler();
    }

    public void setDividerSize(int newSize) {
        this._dividerSize = newSize;
    }

    public int getDividerSize() {
        return this._dividerSize;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getDividerSize(), this.getDividerSize());
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getSource() == this._jideSplitPane && e.getPropertyName().equals("orientation")) {
            this._orientation = this._jideSplitPane.getOrientation();
            this.setCursor(this._orientation == 1 ? HORIZONTAL_CURSOR : VERTICAL_CURSOR);
            this.invalidate();
            this.validate();
        }
    }

    public void updateUI() {
        super.updateUI();
        this.setBackground(UIDefaultsLookup.getColor("JideSplitPaneDivider.background"));
        this.setBorder(UIDefaultsLookup.getBorder("JideSplitPaneDivider.border"));
        this._gripperPainter = (Painter)UIDefaultsLookup.get("JideSplitPaneDivider.gripperPainter");
    }

    public void paint(Graphics g) {
        super.paint(g);
        Border border = this.getBorder();
        Dimension size = this.getSize();
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, size.width, size.height);
        }
        if (border != null) {
            border.paintBorder(this, g, 0, 0, size.width, size.height);
        }
        if (this._jideSplitPane.isShowGripper()) {
            Rectangle rect = new Rectangle(size);
            if (this._gripperPainter != null) {
                if (rect.width > rect.height) {
                    rect.x = rect.x + rect.width / 2 - 10;
                    rect.width = 22;
                    this._gripperPainter.paint(this, g, rect, 1, 0);
                } else {
                    rect.y = rect.y + rect.height / 2 - 10;
                    rect.height = 22;
                    this._gripperPainter.paint(this, g, rect, 0, 0);
                }
            } else {
                ++rect.x;
                ++rect.y;
                JideSwingUtilities.drawGrip(g, rect, 9, UIDefaultsLookup.getInt("JideSplitPane.dividerSize") / 3);
            }
        }
    }

    protected void prepareForDragging() {
        this._jideSplitPane.startDragging(this);
    }

    protected void dragDividerTo(int location) {
        this._jideSplitPane.dragDividerTo(this, location);
    }

    protected void finishDraggingTo(int location) {
        this._jideSplitPane.finishDraggingTo(this, location);
    }

    protected int getPreviousDividerLocation(boolean ignoreVisibility) {
        return this._jideSplitPane.getPreviousDividerLocation(this, ignoreVisibility);
    }

    protected int getNextDividerLocation(boolean ignoreVisibility) {
        return this._jideSplitPane.getNextDividerLocation(this, ignoreVisibility);
    }

    public Component getFirstComponent(boolean ignoreVisibility) {
        int index = this._jideSplitPane.indexOf(this);
        if (index - 1 >= 0) {
            for (int i = index - 1; i >= 0; --i) {
                if (!ignoreVisibility && !this._jideSplitPane.getComponent(i).isVisible()) continue;
                return this._jideSplitPane.getComponent(i);
            }
            return this._jideSplitPane.getComponent(index - 1);
        }
        throw new IndexOutOfBoundsException("There is no component before divider " + index);
    }

    public Component getSecondComponent(boolean ignoreVisibility) {
        int index = this._jideSplitPane.indexOf(this);
        if (index + 1 < this._jideSplitPane.getComponentCount()) {
            for (int i = index + 1; i >= 0; ++i) {
                if (!ignoreVisibility && !this._jideSplitPane.getComponent(i).isVisible()) continue;
                return this._jideSplitPane.getComponent(i);
            }
            return this._jideSplitPane.getComponent(index + 1);
        }
        throw new IndexOutOfBoundsException("There is no component before divider " + index);
    }

    protected class VerticalDragController
    extends DragController {
        protected VerticalDragController(MouseEvent e) {
            super(e);
            Component leftC = JideSplitPaneDivider.this.getFirstComponent(false);
            Component rightC = JideSplitPaneDivider.this.getSecondComponent(false);
            this.initialX = JideSplitPaneDivider.this.getLocation().y;
            this.offset = e.getSource() == JideSplitPaneDivider.this ? e.getY() : e.getY() - this.initialX;
            if (leftC == null || rightC == null || this.offset < -1 || this.offset >= JideSplitPaneDivider.this._jideSplitPane.getSize().height) {
                this.maxX = -1;
            } else {
                Insets insets = JideSplitPaneDivider.this._jideSplitPane.getInsets();
                if (leftC.isVisible()) {
                    this.minX = JideSplitPaneDivider.this.getPreviousDividerLocation(false) + leftC.getMinimumSize().height;
                    if (insets != null) {
                        this.minX += insets.top;
                    }
                } else {
                    this.minX = 0;
                }
                if (rightC.isVisible()) {
                    int right = insets != null ? insets.top : 0;
                    this.maxX = Math.max(0, JideSplitPaneDivider.this.getNextDividerLocation(false) - (JideSplitPaneDivider.this.getSize().height + right) - rightC.getMinimumSize().height);
                } else {
                    int right = insets != null ? insets.top : 0;
                    this.maxX = Math.max(0, JideSplitPaneDivider.this.getNextDividerLocation(true) - (JideSplitPaneDivider.this.getSize().height + right));
                }
                if (this.maxX < this.minX) {
                    this.maxX = 0;
                    this.minX = 0;
                }
            }
        }

        protected int getNeededLocation(int x, int y) {
            int newY = Math.min(this.maxX, Math.max(this.minX, y - this.offset));
            return newY;
        }

        protected int positionForMouseEvent(MouseEvent e) {
            int newY = e.getSource() == JideSplitPaneDivider.this ? e.getY() + JideSplitPaneDivider.this.getLocation().y : e.getY();
            newY = Math.min(this.maxX, Math.max(this.minX, newY - this.offset));
            return newY;
        }
    }

    protected class DragController {
        int initialX;
        int maxX;
        int minX;
        int offset;

        protected DragController(MouseEvent e) {
            Component leftC = JideSplitPaneDivider.this.getFirstComponent(false);
            Component rightC = JideSplitPaneDivider.this.getSecondComponent(false);
            this.initialX = JideSplitPaneDivider.this.getLocation().x;
            this.offset = e.getSource() == JideSplitPaneDivider.this ? e.getX() : e.getX() - this.initialX;
            if (leftC == null || rightC == null || this.offset < -1 || this.offset >= JideSplitPaneDivider.this._jideSplitPane.getSize().width) {
                this.maxX = -1;
            } else {
                Insets insets = JideSplitPaneDivider.this._jideSplitPane.getInsets();
                if (leftC.isVisible()) {
                    this.minX = JideSplitPaneDivider.this.getPreviousDividerLocation(false) + leftC.getMinimumSize().width;
                    if (insets != null) {
                        this.minX += insets.left;
                    }
                } else {
                    this.minX = JideSplitPaneDivider.this.getPreviousDividerLocation(true);
                    if (insets != null) {
                        this.minX += insets.left;
                    }
                }
                if (rightC.isVisible()) {
                    int right = insets != null ? insets.right : 0;
                    this.maxX = Math.max(0, JideSplitPaneDivider.this.getNextDividerLocation(false) - (JideSplitPaneDivider.this.getSize().width + right) - rightC.getMinimumSize().width);
                } else {
                    int right = insets != null ? insets.right : 0;
                    this.maxX = Math.max(0, JideSplitPaneDivider.this.getNextDividerLocation(true) - (JideSplitPaneDivider.this.getSize().width + right));
                }
                if (this.maxX < this.minX) {
                    this.maxX = 0;
                    this.minX = 0;
                }
            }
        }

        protected boolean isValid() {
            return this.maxX > 0;
        }

        protected int positionForMouseEvent(MouseEvent e) {
            int newX = e.getSource() == JideSplitPaneDivider.this ? e.getX() + JideSplitPaneDivider.this.getLocation().x : e.getX();
            newX = Math.min(this.maxX, Math.max(this.minX, newX - this.offset));
            return newX;
        }

        protected int getNeededLocation(int x, int y) {
            int newX = Math.min(this.maxX, Math.max(this.minX, x - this.offset));
            return newX;
        }

        protected void continueDrag(int newX, int newY) {
            JideSplitPaneDivider.this.dragDividerTo(this.getNeededLocation(newX, newY));
        }

        protected void continueDrag(MouseEvent e) {
            JideSplitPaneDivider.this.dragDividerTo(this.positionForMouseEvent(e));
        }

        protected void completeDrag(int x, int y) {
            JideSplitPaneDivider.this.finishDraggingTo(this.getNeededLocation(x, y));
        }

        protected void completeDrag(MouseEvent e) {
            JideSplitPaneDivider.this.finishDraggingTo(this.positionForMouseEvent(e));
        }
    }

    protected class MouseHandler
    extends MouseInputAdapter {
        protected MouseHandler() {
        }

        public void mousePressed(MouseEvent e) {
            if (e.getSource() == JideSplitPaneDivider.this && JideSplitPaneDivider.this._dragger == null && JideSplitPaneDivider.this._jideSplitPane.isEnabled()) {
                if (JideSplitPaneDivider.this.getFirstComponent(true) != null && JideSplitPaneDivider.this.getSecondComponent(true) != null) {
                    JideSplitPaneDivider.this._dragger = JideSplitPaneDivider.this._orientation == 1 ? new DragController(e) : new VerticalDragController(e);
                    if (!JideSplitPaneDivider.this._dragger.isValid()) {
                        JideSplitPaneDivider.this._dragger = null;
                    } else {
                        JideSplitPaneDivider.this.prepareForDragging();
                        JideSplitPaneDivider.this._dragger.continueDrag(e);
                    }
                }
                e.consume();
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (JideSplitPaneDivider.this._dragger != null) {
                if (e.getSource() == JideSplitPaneDivider.this._jideSplitPane) {
                    JideSplitPaneDivider.this._dragger.completeDrag(e.getX(), e.getY());
                } else if (e.getSource() == JideSplitPaneDivider.this) {
                    Point ourLoc = JideSplitPaneDivider.this.getLocation();
                    JideSplitPaneDivider.this._dragger.completeDrag(e.getX() + ourLoc.x, e.getY() + ourLoc.y);
                }
                JideSplitPaneDivider.this._dragger = null;
                e.consume();
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (JideSplitPaneDivider.this._dragger != null) {
                if (e.getSource() == JideSplitPaneDivider.this._jideSplitPane) {
                    JideSplitPaneDivider.this._dragger.continueDrag(e.getX(), e.getY());
                } else if (e.getSource() == JideSplitPaneDivider.this) {
                    Point ourLoc = JideSplitPaneDivider.this.getLocation();
                    JideSplitPaneDivider.this._dragger.continueDrag(e.getX() + ourLoc.x, e.getY() + ourLoc.y);
                }
                e.consume();
            }
        }
    }
}

