/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.WindowsDesktopProperty;
import com.jidesoft.swing.Alignable;
import com.jidesoft.swing.FastGradientPainter;
import com.jidesoft.swing.JideSplitButton;
import com.jidesoft.swing.NullPanel;
import com.jidesoft.swing.ShadowFactory;
import com.jidesoft.swing.SplitButtonModel;
import com.jidesoft.utils.SecurityUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JideSwingUtilities
implements SwingConstants {
    private static final boolean AA_TEXT;
    private static final boolean AA_TEXT_DEFINED;
    public static final Object AA_TEXT_PROPERTY_KEY;
    private static PropertyChangeListener _setOpaqueTrueListener;
    private static PropertyChangeListener _setOpaqueFalseListener;
    private static final String OPAQUE_LISTENER = "setOpaqueRecursively.opaqueListener";
    public static final String SET_OPAQUE_RECURSIVELY_EXCLUDED = "setOpaqueRecursively.excluded";
    static RenderingHints renderingHints;

    public static JPanel createLeftPanel(Component object) {
        NullPanel ret = new NullPanel(new BorderLayout());
        ret.setOpaque(false);
        ret.add(object, "Before");
        return ret;
    }

    public static JPanel createRightPanel(Component object) {
        NullPanel ret = new NullPanel(new BorderLayout());
        ret.setOpaque(false);
        ret.add(object, "After");
        return ret;
    }

    public static JPanel createTopPanel(Component object) {
        NullPanel ret = new NullPanel(new BorderLayout());
        ret.setOpaque(false);
        ret.add(object, "First");
        return ret;
    }

    public static JPanel createBottomPanel(Component object) {
        NullPanel ret = new NullPanel(new BorderLayout());
        ret.setOpaque(false);
        ret.add(object, "Last");
        return ret;
    }

    public static JPanel createCenterPanel(Component object) {
        NullPanel ret = new NullPanel(new GridBagLayout());
        ret.setOpaque(false);
        ret.add(object, new GridBagConstraints());
        return ret;
    }

    public static void centerWindow(Window childToCenter) {
        childToCenter.setLocationRelativeTo(childToCenter.getParent());
    }

    public static void globalCenterWindow(Window childToCenter) {
        childToCenter.setLocationRelativeTo(null);
    }

    public static void paintArrow(Graphics g, Color color, int startX, int startY, int width, int orientation) {
        Color oldColor = g.getColor();
        g.setColor(color);
        width = width / 2 * 2 + 1;
        if (orientation == 0) {
            for (int i = 0; i < (width + 1) / 2; ++i) {
                g.drawLine(startX + i, startY + i, startX + width - i - 1, startY + i);
            }
        } else {
            for (int i = 0; i < (width + 1) / 2; ++i) {
                g.drawLine(startX + i, startY + i, startX + i, startY + width - i - 1);
            }
        }
        g.setColor(oldColor);
    }

    public static void paintCross(Graphics g, Color color, int centerX, int centerY, int size, int width) {
        g.setColor(color);
        size /= 2;
        for (int i = 0; i < width; ++i) {
            g.drawLine(centerX - size, centerY - size, centerX + size, centerY + size);
            g.drawLine(centerX + size, centerY - size, centerX - size, centerY + size);
            ++centerX;
        }
    }

    public static Frame getFrame(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof Frame) {
            return (Frame)component;
        }
        for (Container p = component.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof Frame)) continue;
            return (Frame)p;
        }
        return null;
    }

    public static void toggleRTLnLTR(Component topContainer) {
        ComponentOrientation co = topContainer.getComponentOrientation();
        co = co == ComponentOrientation.RIGHT_TO_LEFT ? ComponentOrientation.LEFT_TO_RIGHT : ComponentOrientation.RIGHT_TO_LEFT;
        topContainer.applyComponentOrientation(co);
    }

    public static void synchonizeView(JViewport view1, JViewport view2, int orientation) {
        JideSwingUtilities.synchronizeView(view1, view2, orientation);
    }

    public static void synchronizeView(final JViewport view1, final JViewport view2, final int orientation) {
        ChangeListener c1 = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (orientation == 0) {
                    Point v1 = view1.getViewPosition();
                    Point v2 = view2.getViewPosition();
                    if (v1.x != v2.x) {
                        view2.setViewPosition(new Point(v1.x, v2.y));
                    }
                } else if (orientation == 1) {
                    Point v1 = view1.getViewPosition();
                    Point v2 = view2.getViewPosition();
                    if (v1.y != v2.y) {
                        view2.setViewPosition(new Point(v2.x, v1.y));
                    }
                }
            }
        };
        ChangeListener c2 = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (orientation == 0) {
                    Point v1 = view1.getViewPosition();
                    Point v2 = view2.getViewPosition();
                    if (v1.x != v2.x) {
                        view1.setViewPosition(new Point(v2.x, v1.y));
                    }
                } else if (orientation == 1) {
                    Point v1 = view1.getViewPosition();
                    Point v2 = view2.getViewPosition();
                    if (v1.y != v2.y) {
                        view1.setViewPosition(new Point(v1.x, v2.y));
                    }
                }
            }
        };
        view1.addChangeListener(c1);
        view2.addChangeListener(c2);
    }

    public static int getButtonState(AbstractButton b) {
        ButtonModel model = b.getModel();
        if (!model.isEnabled()) {
            if (model.isSelected()) {
                return 5;
            }
            return 4;
        }
        if (b.hasFocus() && b.isFocusPainted()) {
            if (model.isSelected()) {
                return 1;
            }
            return 2;
        }
        if (model.isPressed() && model.isArmed()) {
            if (model.isRollover()) {
                return 1;
            }
        } else {
            if (b.isRolloverEnabled() && model.isRollover()) {
                if (model.isSelected()) {
                    return 1;
                }
                return 2;
            }
            if (model.isSelected()) {
                return 3;
            }
        }
        return 0;
    }

    public static int[] getButtonState(JideSplitButton b) {
        int[] states = new int[2];
        SplitButtonModel model = (SplitButtonModel)b.getModel();
        if (!model.isEnabled()) {
            states[0] = model.isButtonSelected() ? 5 : 4;
        } else if (b.hasFocus() && b.isFocusPainted()) {
            if (model.isButtonSelected()) {
                states[0] = 3;
                states[1] = 7;
            } else if (model.isSelected()) {
                states[0] = 7;
                states[1] = 3;
            } else {
                states[0] = 2;
                states[1] = 7;
            }
        } else if (model.isPressed() && model.isArmed()) {
            if (model.isButtonRollover()) {
                states[0] = 1;
                states[1] = 7;
            } else if (model.isRollover()) {
                states[0] = 7;
                states[1] = 2;
            }
        } else if (b.isRolloverEnabled() && model.isButtonRollover()) {
            if (model.isButtonSelected()) {
                states[0] = 1;
                states[1] = 7;
            } else if (model.isSelected()) {
                states[0] = 2;
                states[1] = 1;
            } else {
                states[0] = 2;
                states[1] = 7;
            }
        } else if (b.isRolloverEnabled() && model.isRollover()) {
            if (model.isButtonSelected()) {
                states[0] = 1;
                states[1] = 2;
            } else if (model.isSelected()) {
                states[0] = 7;
                states[1] = 1;
            } else {
                states[0] = 7;
                states[1] = 2;
            }
        } else if (model.isButtonSelected()) {
            states[0] = 3;
            states[1] = 7;
        } else if (model.isSelected()) {
            states[0] = 7;
            states[1] = 3;
        } else {
            states[0] = 0;
            states[1] = 0;
        }
        return states;
    }

    public static boolean equals(Object o1, Object o2) {
        return JideSwingUtilities.equals(o1, o2, false);
    }

    public static boolean equals(Object o1, Object o2, boolean considerArray) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 != null && o2 == null) {
            return false;
        }
        if (o1 == null) {
            return false;
        }
        if (o1 instanceof Comparable && o2 instanceof Comparable && o1.getClass().isAssignableFrom(o2.getClass())) {
            return ((Comparable)o1).compareTo(o2) == 0;
        }
        if (o1 instanceof Comparable && o2 instanceof Comparable && o2.getClass().isAssignableFrom(o1.getClass())) {
            return ((Comparable)o2).compareTo(o1) == 0;
        }
        if (considerArray && o1.getClass().isArray() && o2.getClass().isArray()) {
            int length2;
            int length1 = Array.getLength(o1);
            if (length1 != (length2 = Array.getLength(o2))) {
                return false;
            }
            for (int i = 0; i < length1; ++i) {
                boolean equals = JideSwingUtilities.equals(Array.get(o1, i), Array.get(o1, i));
                if (equals) continue;
                return false;
            }
            return true;
        }
        return o1.equals(o2);
    }

    public static BufferedImage getFasterScaledInstance(BufferedImage img, int targetWidth, int targetHeight, Object hint, boolean progressiveBilinear) {
        int h;
        int w;
        boolean isTranslucent;
        int type = img.getTransparency() == 1 ? 1 : 2;
        BufferedImage ret = img;
        BufferedImage scratchImage = null;
        Graphics2D g2 = null;
        int prevW = ret.getWidth();
        int prevH = ret.getHeight();
        boolean bl = isTranslucent = img.getTransparency() != 1;
        if (progressiveBilinear) {
            w = img.getWidth();
            h = img.getHeight();
        } else {
            w = targetWidth;
            h = targetHeight;
        }
        do {
            if (progressiveBilinear && w > targetWidth && (w /= 2) < targetWidth) {
                w = targetWidth;
            }
            if (progressiveBilinear && h > targetHeight && (h /= 2) < targetHeight) {
                h = targetHeight;
            }
            if (scratchImage == null || isTranslucent) {
                scratchImage = new BufferedImage(w, h, type);
                g2 = scratchImage.createGraphics();
            }
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
            g2.drawImage(ret, 0, 0, w, h, 0, 0, prevW, prevH, null);
            prevW = w;
            prevH = h;
            ret = scratchImage;
        } while (w != targetWidth || h != targetHeight);
        if (g2 != null) {
            g2.dispose();
        }
        if (targetWidth != ret.getWidth() || targetHeight != ret.getHeight()) {
            scratchImage = new BufferedImage(targetWidth, targetHeight, type);
            g2 = scratchImage.createGraphics();
            g2.drawImage((Image)ret, 0, 0, null);
            g2.dispose();
            ret = scratchImage;
        }
        return ret;
    }

    public static boolean shouldUseSystemFont() {
        boolean useSystemFontSettings;
        if (SystemInfo.isJdk15Above() || SystemInfo.isCJKLocale()) {
            return true;
        }
        String systemFonts = null;
        try {
            systemFonts = (String)AccessController.doPrivileged(new GetPropertyAction("swing.useSystemFontSettings"));
        }
        catch (AccessControlException e) {
            // empty catch block
        }
        boolean bl = useSystemFontSettings = systemFonts != null && Boolean.valueOf(systemFonts) != false;
        if (useSystemFontSettings) {
            Object value = UIDefaultsLookup.get("Application.useSystemFontSettings");
            useSystemFontSettings = value != null || Boolean.TRUE.equals(value);
        }
        return "true".equals(SecurityUtils.getProperty("defaultFont", "false")) || useSystemFontSettings;
    }

    public static void printUIDefaults() {
        Enumeration e = UIManager.getDefaults().keys();
        ArrayList list = new ArrayList();
        System.out.println("Non-string keys ---");
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            if (key instanceof String) {
                list.add(key);
                continue;
            }
            System.out.println(key + " => " + UIDefaultsLookup.get(key));
        }
        System.out.println();
        Object[] array = list.toArray(new Object[list.size()]);
        Arrays.sort(array);
        System.out.println("String keys ---");
        for (int i = 0; i < array.length; ++i) {
            Object key = array[i];
            System.out.println(key + " => " + UIDefaultsLookup.get(key));
        }
    }

    public static void setRecursively(Component c, Handler handler) {
        JideSwingUtilities.setRecursively0(c, handler);
        handler.postAction(c);
    }

    private static void setRecursively0(Component c, Handler handler) {
        if (handler.condition(c)) {
            handler.action(c);
        }
        if (handler instanceof ConditionHandler && ((ConditionHandler)handler).stopCondition(c)) {
            return;
        }
        Component[] children = null;
        if (c instanceof JMenu) {
            children = ((JMenu)c).getMenuComponents();
        } else if (c instanceof JTabbedPane) {
            JTabbedPane tabbedPane = (JTabbedPane)c;
            children = new Component[tabbedPane.getTabCount()];
            for (int i = 0; i < children.length; ++i) {
                children[i] = tabbedPane.getComponentAt(i);
            }
        } else if (c instanceof Container) {
            children = ((Container)c).getComponents();
        }
        if (children != null) {
            for (Component child : children) {
                JideSwingUtilities.setRecursively0(child, handler);
            }
        }
    }

    public static Component getRecursively(Component c, GetHandler handler) {
        return JideSwingUtilities.getRecursively0(c, handler);
    }

    private static Component getRecursively0(Component c, GetHandler handler) {
        if (handler.condition(c)) {
            return handler.action(c);
        }
        Component[] children = null;
        if (c instanceof JMenu) {
            children = ((JMenu)c).getMenuComponents();
        } else if (c instanceof Container) {
            children = ((Container)c).getComponents();
        }
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                Component result = JideSwingUtilities.getRecursively0(children[i], handler);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public static void setEnabledRecursively(Component c, final boolean enabled) {
        JideSwingUtilities.setRecursively(c, new Handler(){

            public boolean condition(Component c) {
                return true;
            }

            public void action(Component c) {
                c.setEnabled(enabled);
            }

            public void postAction(Component c) {
            }
        });
    }

    public static void setRequestFocusEnabledRecursively(Component c, final boolean enabled) {
        JideSwingUtilities.setRecursively(c, new Handler(){

            public boolean condition(Component c) {
                return true;
            }

            public void action(Component c) {
                if (c instanceof JComponent) {
                    ((JComponent)c).setRequestFocusEnabled(enabled);
                }
            }

            public void postAction(Component c) {
            }
        });
    }

    public static void setOpaqueRecursively(Component c, final boolean opaque) {
        JideSwingUtilities.setRecursively(c, new Handler(){

            public boolean condition(Component c) {
                return !(c instanceof JComboBox) && !(c instanceof JButton) && !(c instanceof JTextComponent);
            }

            public void action(Component c) {
                if (c instanceof JComponent) {
                    JComponent jc = (JComponent)c;
                    if (Boolean.TRUE.equals(jc.getClientProperty(JideSwingUtilities.SET_OPAQUE_RECURSIVELY_EXCLUDED))) {
                        return;
                    }
                    jc.setOpaque(opaque);
                    if (jc.getClientProperty(JideSwingUtilities.OPAQUE_LISTENER) == null) {
                        if (opaque) {
                            if (_setOpaqueTrueListener == null) {
                                _setOpaqueTrueListener = new PropertyChangeListener(){

                                    public void propertyChange(PropertyChangeEvent evt) {
                                        if (evt.getSource() instanceof JComponent) {
                                            ((JComponent)evt.getSource()).setOpaque(true);
                                        }
                                    }
                                };
                            }
                            jc.addPropertyChangeListener("opaque", _setOpaqueTrueListener);
                            jc.putClientProperty("opaqueListener", _setOpaqueTrueListener);
                        } else {
                            if (_setOpaqueFalseListener == null) {
                                _setOpaqueFalseListener = new PropertyChangeListener(){

                                    public void propertyChange(PropertyChangeEvent evt) {
                                        if (evt.getSource() instanceof JComponent) {
                                            ((JComponent)evt.getSource()).setOpaque(false);
                                        }
                                    }
                                };
                            }
                            jc.addPropertyChangeListener("opaque", _setOpaqueFalseListener);
                            jc.putClientProperty(JideSwingUtilities.OPAQUE_LISTENER, _setOpaqueFalseListener);
                        }
                    }
                }
            }

            public void postAction(Component c) {
            }
        });
    }

    public static Dimension getPreferredButtonSize(AbstractButton b, int textIconGap, boolean isHorizontal) {
        if (b.getComponentCount() > 0) {
            return null;
        }
        Icon icon = b.getIcon();
        String text = b.getText();
        Font font = b.getFont();
        FontMetrics fm = b.getFontMetrics(font);
        Rectangle iconR = new Rectangle();
        Rectangle textR = new Rectangle();
        Rectangle viewR = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        JideSwingUtilities.layoutCompoundLabel(b, fm, text, icon, isHorizontal, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewR, iconR, textR, text == null ? 0 : textIconGap);
        Rectangle r = iconR.union(textR);
        Insets insets = b.getInsets();
        r.width += insets.left + insets.right;
        r.height += insets.top + insets.bottom;
        return r.getSize();
    }

    public static String layoutCompoundLabel(JComponent c, FontMetrics fm, String text, Icon icon, boolean isHorizontal, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        boolean orientationIsLeftToRight = true;
        int hAlign = horizontalAlignment;
        int hTextPos = horizontalTextPosition;
        if (c != null && !c.getComponentOrientation().isLeftToRight()) {
            orientationIsLeftToRight = false;
        }
        switch (horizontalAlignment) {
            case 10: {
                hAlign = orientationIsLeftToRight ? 2 : 4;
                break;
            }
            case 11: {
                hAlign = orientationIsLeftToRight ? 4 : 2;
            }
        }
        switch (horizontalTextPosition) {
            case 10: {
                hTextPos = orientationIsLeftToRight ? 2 : 4;
                break;
            }
            case 11: {
                hTextPos = orientationIsLeftToRight ? 4 : 2;
            }
        }
        return JideSwingUtilities.layoutCompoundLabelImpl(c, fm, text, icon, isHorizontal, verticalAlignment, hAlign, verticalTextPosition, hTextPos, viewR, iconR, textR, textIconGap);
    }

    public static String layoutCompoundLabel(FontMetrics fm, String text, Icon icon, boolean isHorizontal, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        return JideSwingUtilities.layoutCompoundLabelImpl(null, fm, text, icon, isHorizontal, verticalAlignment, horizontalAlignment, verticalTextPosition, horizontalTextPosition, viewR, iconR, textR, textIconGap);
    }

    private static String layoutCompoundLabelImpl(JComponent c, FontMetrics fm, String text, Icon icon, boolean isHorizontal, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        if (isHorizontal) {
            return JideSwingUtilities.layoutCompoundLabelImplHorizontal(c, fm, text, icon, verticalAlignment, horizontalAlignment, verticalTextPosition, horizontalTextPosition, viewR, iconR, textR, textIconGap);
        }
        return JideSwingUtilities.layoutCompoundLabelImplVertical(c, fm, text, icon, verticalAlignment, horizontalAlignment, verticalTextPosition, horizontalTextPosition, viewR, iconR, textR, textIconGap);
    }

    private static String getMaxLengthWord(String text) {
        if (text.indexOf(32) == -1) {
            return text;
        }
        int minDiff = text.length();
        int minPos = -1;
        int mid = text.length() / 2;
        int pos = -1;
        while ((pos = text.indexOf(32, pos + 1)) != -1) {
            int diff = Math.abs(pos - mid);
            if (diff >= minDiff) continue;
            minDiff = diff;
            minPos = pos;
        }
        return minPos >= mid ? text.substring(0, minPos) : text.substring(minPos + 1);
    }

    private static String layoutCompoundLabelImplHorizontal(JComponent c, FontMetrics fm, String text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        int availTextWidth;
        int gap;
        if (icon != null) {
            iconR.width = icon.getIconWidth();
            iconR.height = icon.getIconHeight();
        } else {
            iconR.height = 0;
            iconR.width = 0;
        }
        boolean textIsEmpty = text == null || text.equals("");
        View v = null;
        if (textIsEmpty) {
            textR.height = 0;
            textR.width = 0;
            text = "";
        } else {
            View view = v = c != null ? (View)c.getClientProperty("html") : null;
            if (v != null) {
                textR.width = (int)v.getPreferredSpan(0);
                textR.height = (int)v.getPreferredSpan(1);
            } else {
                textR.width = SwingUtilities.computeStringWidth(fm, text);
                textR.height = fm.getHeight();
            }
        }
        int n = gap = textIsEmpty || icon == null ? 0 : textIconGap;
        if (!textIsEmpty && textR.width > (availTextWidth = horizontalTextPosition == 0 ? viewR.width : viewR.width - (iconR.width + gap))) {
            if (v != null) {
                textR.width = availTextWidth;
            } else {
                int nChars;
                String clipString = "...";
                int totalWidth = SwingUtilities.computeStringWidth(fm, clipString);
                for (nChars = 0; nChars < text.length() && (totalWidth += fm.charWidth(text.charAt(nChars))) <= availTextWidth; ++nChars) {
                }
                text = text.substring(0, nChars) + clipString;
                textR.width = SwingUtilities.computeStringWidth(fm, text);
            }
        }
        textR.y = verticalTextPosition == 1 ? (horizontalTextPosition != 0 ? 0 : -(textR.height + gap)) : (verticalTextPosition == 0 ? (iconR.height >> 1) - (textR.height >> 1) : (horizontalTextPosition != 0 ? iconR.height - textR.height : iconR.height + gap));
        textR.x = horizontalTextPosition == 2 ? -(textR.width + gap) : (horizontalTextPosition == 0 ? (iconR.width >> 1) - (textR.width >> 1) : iconR.width + gap);
        int labelR_x = Math.min(iconR.x, textR.x);
        int labelR_width = Math.max(iconR.x + iconR.width, textR.x + textR.width) - labelR_x;
        int labelR_y = Math.min(iconR.y, textR.y);
        int labelR_height = Math.max(iconR.y + iconR.height, textR.y + textR.height) - labelR_y;
        int dy = verticalAlignment == 1 ? viewR.y - labelR_y : (verticalAlignment == 0 ? viewR.y + (viewR.height >> 1) - (labelR_y + (labelR_height >> 1)) : viewR.y + viewR.height - (labelR_y + labelR_height));
        int dx = horizontalAlignment == 2 ? viewR.x - labelR_x : (horizontalAlignment == 4 ? viewR.x + viewR.width - (labelR_x + labelR_width) : viewR.x + (viewR.width >> 1) - (labelR_x + (labelR_width >> 1)));
        textR.x += dx;
        textR.y += dy;
        iconR.x += dx;
        iconR.y += dy;
        return text;
    }

    private static String layoutCompoundLabelImplVertical(JComponent c, FontMetrics fm, String text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        int dIcony;
        int dy;
        int availTextHeight;
        int gap;
        if (icon != null) {
            iconR.width = icon.getIconWidth();
            iconR.height = icon.getIconHeight();
        } else {
            iconR.height = 0;
            iconR.width = 0;
        }
        boolean textIsEmpty = text == null || text.equals("");
        View v = null;
        if (textIsEmpty) {
            textR.height = 0;
            textR.width = 0;
            text = "";
        } else {
            View view = v = c != null ? (View)c.getClientProperty("html") : null;
            if (v != null) {
                textR.height = (int)v.getPreferredSpan(0);
                textR.width = (int)v.getPreferredSpan(1);
            } else {
                textR.height = SwingUtilities.computeStringWidth(fm, text);
                textR.width = fm.getHeight();
            }
        }
        int n = gap = textIsEmpty || icon == null ? 0 : textIconGap;
        if (!textIsEmpty && textR.height > (availTextHeight = horizontalTextPosition == 0 ? viewR.height : viewR.height - (iconR.height + gap))) {
            if (v != null) {
                textR.height = availTextHeight;
            } else {
                int nChars;
                String clipString = "...";
                int totalHeight = SwingUtilities.computeStringWidth(fm, clipString);
                for (nChars = 0; nChars < text.length() && (totalHeight += fm.charWidth(text.charAt(nChars))) <= availTextHeight; ++nChars) {
                }
                text = text.substring(0, nChars) + clipString;
                textR.height = SwingUtilities.computeStringWidth(fm, text);
            }
        }
        if (verticalTextPosition == 1) {
            textR.x = horizontalTextPosition != 0 ? 0 : -(textR.width + gap);
        } else if (verticalTextPosition == 0) {
            textR.y = (iconR.width >> 1) - (textR.width >> 1);
        } else {
            textR.x = horizontalTextPosition != 0 ? iconR.width - textR.width : iconR.width + gap;
        }
        textR.y = horizontalTextPosition == 2 ? -(textR.height + gap) : (horizontalTextPosition == 0 ? (iconR.height >> 1) - (textR.height >> 1) : iconR.height + gap);
        int labelR_x = Math.min(iconR.y, textR.y);
        int labelR_width = Math.max(iconR.y + iconR.height, textR.y + textR.height) - labelR_x;
        int labelR_y = Math.min(iconR.x, textR.x);
        int labelR_height = Math.max(iconR.x + iconR.width, textR.x + textR.width) - labelR_y;
        if (verticalAlignment == 1) {
            dy = viewR.x - labelR_y;
            dIcony = viewR.x + viewR.width - (labelR_y + labelR_height);
        } else if (verticalAlignment == 0) {
            dIcony = dy = viewR.x + (viewR.width >> 1) - (labelR_y + (labelR_height >> 1));
        } else {
            dy = viewR.x + viewR.width - (labelR_y + labelR_height);
            dIcony = viewR.x - labelR_y;
        }
        int dx = horizontalAlignment == 2 ? viewR.y - labelR_x : (horizontalAlignment == 4 ? viewR.y + viewR.height - (labelR_x + labelR_width) : viewR.y + (viewR.height >> 1) - (labelR_x + (labelR_width >> 1)));
        textR.y += dx;
        textR.x += dy;
        iconR.y += dx;
        iconR.x += dIcony;
        return text;
    }

    public static int getOrientationOf(Component component) {
        Integer value;
        if (component instanceof Alignable) {
            return ((Alignable)((Object)component)).getOrientation();
        }
        if (component instanceof JComponent && (value = (Integer)((JComponent)component).getClientProperty("orientation")) != null) {
            return value;
        }
        return 0;
    }

    public static void setOrientationOf(Component component, int orientation) {
        int old = JideSwingUtilities.getOrientationOf(component);
        if (orientation != old) {
            if (component instanceof Alignable) {
                ((Alignable)((Object)component)).setOrientation(orientation);
            } else if (component instanceof JComponent) {
                ((JComponent)component).putClientProperty("orientation", orientation);
            }
        }
    }

    public static void setChildrenOrientationOf(Container c, int orientation) {
        Component[] components = c.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component component = components[i];
            JideSwingUtilities.setOrientationOf(component, orientation);
        }
    }

    public static Map<Component, Boolean> disableDoubleBuffered(Component c) {
        final HashMap<Component, Boolean> map = new HashMap<Component, Boolean>();
        if (c instanceof JComponent) {
            JideSwingUtilities.setRecursively(c, new Handler(){

                public boolean condition(Component c) {
                    return c instanceof JComponent && ((JComponent)c).isDoubleBuffered();
                }

                public void action(Component c) {
                    map.put(c, Boolean.TRUE);
                    ((JComponent)c).setDoubleBuffered(false);
                }

                public void postAction(Component c) {
                }
            });
        }
        return map;
    }

    public static Map<Component, Boolean> enableDoubleBuffered(Component c) {
        final HashMap<Component, Boolean> map = new HashMap<Component, Boolean>();
        if (c instanceof JComponent) {
            JideSwingUtilities.setRecursively(c, new Handler(){

                public boolean condition(Component c) {
                    return c instanceof JComponent && !c.isDoubleBuffered();
                }

                public void action(Component c) {
                    map.put(c, Boolean.FALSE);
                    ((JComponent)c).setDoubleBuffered(true);
                }

                public void postAction(Component c) {
                }
            });
        }
        return map;
    }

    public static void restoreDoubleBuffered(Component c, final Map<Component, Boolean> map) {
        JideSwingUtilities.setRecursively(c, new Handler(){

            public boolean condition(Component c) {
                return c instanceof JComponent;
            }

            public void action(Component c) {
                Boolean value = (Boolean)map.get(c);
                if (value != null) {
                    ((JComponent)c).setDoubleBuffered(Boolean.TRUE.equals(value));
                }
            }

            public void postAction(Component c) {
            }
        });
    }

    public static void paintBackground(Graphics g, Rectangle rect, Color border, Color bk) {
        Color old = g.getColor();
        g.setColor(bk);
        g.fillRect(rect.x + 1, rect.y + 1, rect.width - 2, rect.height - 2);
        g.setColor(border);
        g.drawRect(rect.x, rect.y, rect.width - 1, rect.height - 1);
        g.setColor(old);
    }

    public static void paintBackground(Graphics2D g2d, Rectangle rect, Color border, Paint paint) {
        Color old = g2d.getColor();
        g2d.setPaint(paint);
        g2d.fillRect(rect.x + 1, rect.y + 1, rect.width - 2, rect.height - 2);
        g2d.setColor(border);
        g2d.drawRect(rect.x, rect.y, rect.width - 1, rect.height - 1);
        g2d.setColor(old);
    }

    private static boolean drawTextAntialiased(Component c) {
        if (!AA_TEXT_DEFINED) {
            if (c != null) {
                if (c instanceof JComponent) {
                    Boolean aaProperty = (Boolean)((JComponent)c).getClientProperty(AA_TEXT_PROPERTY_KEY);
                    return aaProperty != null ? aaProperty : false;
                }
                return false;
            }
            return false;
        }
        return AA_TEXT;
    }

    public static boolean drawTextAntialiased(boolean aaText) {
        if (!AA_TEXT_DEFINED) {
            return aaText;
        }
        return AA_TEXT;
    }

    public static void drawStringUnderlineCharAt(JComponent c, Graphics g, String text, int underlinedIndex, int x, int y) {
        JideSwingUtilities.drawString(c, g, text, x, y);
        if (underlinedIndex >= 0 && underlinedIndex < text.length()) {
            FontMetrics fm = g.getFontMetrics();
            int underlineRectX = x + fm.stringWidth(text.substring(0, underlinedIndex));
            int underlineRectY = y;
            int underlineRectWidth = fm.charWidth(text.charAt(underlinedIndex));
            int underlineRectHeight = 1;
            g.fillRect(underlineRectX, underlineRectY + fm.getDescent() - 1, underlineRectWidth, underlineRectHeight);
        }
    }

    private static RenderingHints getRenderingHints(Graphics2D g2d, RenderingHints hintsToSave, RenderingHints savedHints) {
        if (savedHints == null) {
            savedHints = new RenderingHints(null);
        } else {
            savedHints.clear();
        }
        if (hintsToSave == null || hintsToSave.size() == 0) {
            return savedHints;
        }
        Set<Object> objects = hintsToSave.keySet();
        for (Object o : objects) {
            RenderingHints.Key key = (RenderingHints.Key)o;
            Object value = g2d.getRenderingHint(key);
            savedHints.put(key, value);
        }
        return savedHints;
    }

    public static void drawString(JComponent c, Graphics g, String text, int x, int y) {
        if (SystemInfo.isJdk6Above()) {
            Graphics2D g2d = (Graphics2D)g;
            RenderingHints oldHints = null;
            if (renderingHints != null) {
                oldHints = JideSwingUtilities.getRenderingHints(g2d, renderingHints, null);
                g2d.addRenderingHints(renderingHints);
            }
            g2d.drawString(text, x, y);
            if (oldHints != null) {
                g2d.addRenderingHints(oldHints);
            }
        } else if (JideSwingUtilities.drawTextAntialiased(c) && g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g;
            Object oldAAValue = g2.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.drawString(text, x, y);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldAAValue);
        } else {
            g.drawString(text, x, y);
        }
    }

    public static Object setupAntialiasing(Component c, Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Object oldHints = null;
        if (SystemInfo.isJdk6Above()) {
            oldHints = JideSwingUtilities.getRenderingHints(g2d, renderingHints, null);
            if (renderingHints != null) {
                g2d.addRenderingHints(renderingHints);
            }
        } else {
            oldHints = g2d.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            if (JideSwingUtilities.drawTextAntialiased(c)) {
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
        }
        return oldHints;
    }

    public static void restoreAntialiasing(Component c, Graphics g, Object oldHints) {
        Graphics2D g2d = (Graphics2D)g;
        if (SystemInfo.isJdk6Above()) {
            if (oldHints != null) {
                g2d.addRenderingHints((RenderingHints)oldHints);
            }
        } else {
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldHints);
        }
    }

    public static Object setupShapeAntialiasing(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Object oldHints = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return oldHints;
    }

    public static void restoreShapeAntialiasing(Graphics g, Object oldHints) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHints);
    }

    public static void drawGrip(Graphics g, Rectangle rectangle, int maxLength, int maxThickness) {
        JideSwingUtilities.drawGrip(g, rectangle, maxLength, maxThickness, true);
    }

    public static void drawGrip(Graphics g, Rectangle rectangle, int maxLength, int maxThickness, boolean isSelected) {
        if (rectangle.width > rectangle.height) {
            int count = maxLength;
            if (maxLength * 3 > rectangle.width) {
                count = rectangle.width / 3;
            }
            int startX = rectangle.x + (rectangle.width - count * 3 >> 1);
            int startY = rectangle.y + (rectangle.height - maxThickness * 3 >> 1);
            for (int i = 0; i < maxThickness; ++i) {
                for (int j = 0; j < count; ++j) {
                    if (isSelected) {
                        g.setColor(UIDefaultsLookup.getColor("controlLtHighlight"));
                        g.drawLine(startX + j * 3, startY + i * 3, startX + j * 3, startY + i * 3);
                    }
                    g.setColor(UIDefaultsLookup.getColor("controlShadow"));
                    g.drawLine(startX + j * 3 + 1, startY + i * 3 + 1, startX + j * 3 + 1, startY + i * 3 + 1);
                }
            }
        } else {
            int count = maxLength;
            if (maxLength * 3 > rectangle.height) {
                count = rectangle.height / 3;
            }
            int startX = rectangle.x + (rectangle.width - maxThickness * 3 >> 1);
            int startY = rectangle.y + (rectangle.height - count * 3 >> 1);
            for (int i = 0; i < maxThickness; ++i) {
                for (int j = 0; j < count; ++j) {
                    if (isSelected) {
                        g.setColor(UIDefaultsLookup.getColor("controlLtHighlight"));
                        g.drawLine(startX + i * 3, startY + j * 3, startX + i * 3, startY + j * 3);
                    }
                    g.setColor(UIDefaultsLookup.getColor("controlShadow"));
                    g.drawLine(startX + i * 3 + 1, startY + j * 3 + 1, startX + i * 3 + 1, startY + j * 3 + 1);
                }
            }
        }
    }

    public static void registerTabKey(Container container) {
        if (container instanceof JComponent) {
            ((JComponent)container).registerKeyboardAction(new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                }
            }, KeyStroke.getKeyStroke(9, 0), 0);
        } else {
            for (int i = 0; i < container.getComponentCount(); ++i) {
                Component c = container.getComponent(i);
                if (!(c instanceof JComponent) || !c.isFocusable()) continue;
                ((JComponent)container).registerKeyboardAction(new AbstractAction(){

                    public void actionPerformed(ActionEvent e) {
                        DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                    }
                }, KeyStroke.getKeyStroke(9, 0), 0);
            }
        }
    }

    public static void fillGradient(Graphics g, Rectangle rect, int orientation) {
        Graphics2D g2d = (Graphics2D)g;
        Color col1 = new Color(255, 255, 255, 0);
        Color col2 = new Color(255, 255, 255, 48);
        Color col3 = new Color(0, 0, 0, 0);
        Color col4 = new Color(0, 0, 0, 32);
        if (orientation == 0) {
            JideSwingUtilities.fillGradient(g2d, new Rectangle(rect.x, rect.y, rect.width, rect.height >> 1), col2, col1, true);
            JideSwingUtilities.fillGradient(g2d, new Rectangle(rect.x, rect.y + (rect.height >> 1), rect.width, rect.height >> 1), col3, col4, true);
        } else {
            JideSwingUtilities.fillGradient(g2d, new Rectangle(rect.x, rect.y, rect.width >> 1, rect.height), col2, col1, false);
            JideSwingUtilities.fillGradient(g2d, new Rectangle(rect.x + (rect.width >> 1), rect.y, rect.width >> 1, rect.height), col3, col4, false);
        }
    }

    public static void fillSingleGradient(Graphics g, Rectangle rect, int orientation) {
        JideSwingUtilities.fillSingleGradient(g, rect, orientation, 127);
    }

    public static void fillSingleGradient(Graphics g, Rectangle rect, int orientation, int level) {
        Graphics2D g2d = (Graphics2D)g;
        Color col1 = new Color(255, 255, 255, 0);
        Color col2 = new Color(255, 255, 255, level);
        if (orientation == 5) {
            JideSwingUtilities.fillGradient(g2d, new Rectangle(rect.x, rect.y, rect.width, rect.height), col2, col1, true);
        } else if (orientation == 1) {
            JideSwingUtilities.fillGradient(g2d, new Rectangle(rect.x, rect.y, rect.width, rect.height), col1, col2, true);
        } else if (orientation == 3) {
            JideSwingUtilities.fillGradient(g2d, new Rectangle(rect.x, rect.y, rect.width, rect.height), col2, col1, false);
        } else if (orientation == 7) {
            JideSwingUtilities.fillGradient(g2d, new Rectangle(rect.x, rect.y, rect.width, rect.height), col1, col2, false);
        }
    }

    public static boolean containerContainsFocus(Container cont) {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        Component permFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        boolean focusOwned = false;
        boolean bl = focusOwned = focusOwner != null && SwingUtilities.isDescendingFrom(focusOwner, cont);
        if (!focusOwned) {
            focusOwned = permFocusOwner != null && SwingUtilities.isDescendingFrom(permFocusOwner, cont);
        }
        return focusOwned;
    }

    public static boolean componentIsPermanentFocusOwner(Component comp) {
        return comp != null && KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner() == comp;
    }

    public static void installColorsAndFont(Component c, Color background, Color foreground, Font font) {
        JideSwingUtilities.installFont(c, font);
        JideSwingUtilities.installColors(c, background, foreground);
    }

    public static void installFont(Component c, Font font) {
        Font f = c.getFont();
        if (f == null || f instanceof UIResource) {
            c.setFont(font);
        }
    }

    public static void installColors(Component c, Color background, Color foreground) {
        Color bg = c.getBackground();
        if (background != null && (bg == null || bg instanceof UIResource)) {
            c.setBackground(background);
        }
        Color fg = c.getForeground();
        if (foreground != null && (fg == null || fg instanceof UIResource)) {
            c.setForeground(foreground);
        }
    }

    public static void installBorder(JComponent c, Border defaultBorder) {
        Border border = c.getBorder();
        if (border == null || border instanceof UIResource) {
            c.setBorder(defaultBorder);
        }
    }

    public static void fillNormalGradient(Graphics2D g2d, Shape s, Color startColor, Color endColor, boolean isVertical) {
        Rectangle rect = s.getBounds();
        GradientPaint paint = null;
        paint = isVertical ? new GradientPaint(rect.x, rect.y, startColor, rect.x, rect.height + rect.y, endColor, true) : new GradientPaint(rect.x, rect.y, startColor, rect.width + rect.x, rect.y, endColor, true);
        Paint old = g2d.getPaint();
        g2d.setPaint(paint);
        g2d.fill(s);
        g2d.setPaint(old);
    }

    public static void fillGradient(Graphics2D g2d, Shape s, Color startColor, Color endColor, boolean isVertical) {
        if ("true".equals(SecurityUtils.getProperty("normalGradientPaint", "false"))) {
            JideSwingUtilities.fillNormalGradient(g2d, s, startColor, endColor, isVertical);
        } else {
            FastGradientPainter.drawGradient(g2d, s, startColor, endColor, isVertical);
        }
    }

    public static Window getTopModalDialog(Window w) {
        Window[] ws = w.getOwnedWindows();
        for (int i = 0; i < ws.length; ++i) {
            if (!ws[i].isVisible() || !(ws[i] instanceof Dialog) || !((Dialog)ws[i]).isModal()) continue;
            return JideSwingUtilities.getTopModalDialog(ws[i]);
        }
        return w;
    }

    public static void traceFocus() {
        PropertyChangeListener listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String oldName = evt.getOldValue() == null ? "null" : evt.getOldValue().getClass().getName();
                System.out.println(evt.getPropertyName() + ": " + oldName + " ==> " + (evt.getNewValue() == null ? "null" : evt.getNewValue().getClass().getName()));
            }
        };
        DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", listener);
        DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("permanentFocusOwner", listener);
        DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("activeWindow", listener);
    }

    public static JPanel createTableModelModifier(final DefaultTableModel tableModel) {
        JPanel tableModelPanel = new JPanel(new BorderLayout(6, 6));
        final JTable table = new JTable(tableModel);
        tableModelPanel.add(new JScrollPane(table));
        ButtonPanel buttonPanel = new ButtonPanel();
        JButton insert = new JButton("Insert");
        insert.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Vector<Vector> rowData = tableModel.getDataVector();
                int index = table.getSelectedRow();
                if (index != -1) {
                    Vector v = rowData.get(index);
                    Vector<Object> clone = new Vector<Object>();
                    for (int i = 0; i < v.size(); ++i) {
                        if (i == 0) {
                            clone.add((int)(Math.random() * 10.0));
                            continue;
                        }
                        clone.add("" + v.get(i));
                    }
                    tableModel.insertRow(index, clone);
                }
            }
        });
        JButton delete = new JButton("Delete");
        delete.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                int[] rows = table.getSelectedRows();
                for (int i = rows.length - 1; i >= 0; --i) {
                    int row = rows[i];
                    tableModel.removeRow(row);
                }
            }
        });
        JButton clear = new JButton("Clear");
        clear.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < tableModel.getRowCount(); ++i) {
                    tableModel.removeRow(0);
                }
            }
        });
        buttonPanel.add(insert);
        buttonPanel.add(delete);
        buttonPanel.add(clear);
        tableModelPanel.add((Component)buttonPanel, "Last");
        return tableModelPanel;
    }

    public static Component findSomethingFocusable(Container container) {
        if (JideSwingUtilities.passesFocusabilityTest(container)) {
            container.requestFocusInWindow();
            return container;
        }
        Component[] comps = container.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            Component comp;
            if (JideSwingUtilities.passesFocusabilityTest(comps[i])) {
                container.requestFocusInWindow();
                return container;
            }
            if (!(comps[i] instanceof Container) || (comp = JideSwingUtilities.findSomethingFocusable((Container)comps[i])) == null) continue;
            return comp;
        }
        return null;
    }

    public static boolean passesFocusabilityTest(Component comp) {
        return comp != null && comp.isEnabled() && comp.isDisplayable() && comp.isVisible() && comp.isFocusable();
    }

    public static void ignoreException(Exception e) {
    }

    public static void printException(Exception e) {
        System.err.println(e.getLocalizedMessage());
    }

    public static void throwException(Exception e) {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new RuntimeException(e);
    }

    public static void throwInvocationTargetException(InvocationTargetException e) {
        if (e.getTargetException() instanceof RuntimeException) {
            throw (RuntimeException)e.getTargetException();
        }
        if (e.getTargetException() instanceof Error) {
            throw (Error)e.getTargetException();
        }
        throw new RuntimeException(e.getTargetException());
    }

    public static int findDisplayedMnemonicIndex(String text, int mnemonic) {
        if (text == null || mnemonic == 0) {
            return -1;
        }
        char uc = Character.toUpperCase((char)mnemonic);
        char lc = Character.toLowerCase((char)mnemonic);
        int uci = text.indexOf(uc);
        int lci = text.indexOf(lc);
        if (uci == -1) {
            return lci;
        }
        if (lci == -1) {
            return uci;
        }
        return lci < uci ? lci : uci;
    }

    public static Component getDescendantOfClass(Class c, Container container) {
        if (container == null || c == null) {
            return null;
        }
        Component[] components = container.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component found;
            Component component = components[i];
            if (c.isInstance(component)) {
                return component;
            }
            if (!(component instanceof Container) || (found = JideSwingUtilities.getDescendantOfClass(c, (Container)component)) == null) continue;
            return found;
        }
        return null;
    }

    public static float getDefaultFontSize() {
        String fontSize = SecurityUtils.getProperty("jide.fontSize", null);
        float defaultFontSize = -1.0f;
        try {
            if (fontSize != null) {
                defaultFontSize = Float.parseFloat(fontSize);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultFontSize;
    }

    public static Object getMenuFont(Toolkit toolkit, UIDefaults table) {
        Object menuFont = null;
        float defaultFontSize = JideSwingUtilities.getDefaultFontSize();
        menuFont = JideSwingUtilities.shouldUseSystemFont() ? (defaultFontSize == -1.0f ? table.getFont("ToolBar.font") : new WindowsDesktopProperty("win.menu.font", table.getFont("ToolBar.font"), toolkit, defaultFontSize)) : SecurityUtils.createFontUIResource("Tahoma", 0, defaultFontSize != -1.0f ? (int)defaultFontSize : 11);
        if (menuFont == null) {
            return JideSwingUtilities.getControlFont(toolkit, table);
        }
        return menuFont;
    }

    public static Object getControlFont(Toolkit toolkit, UIDefaults table) {
        Object controlFont = null;
        float defaultFontSize = JideSwingUtilities.getDefaultFontSize();
        if (JideSwingUtilities.shouldUseSystemFont()) {
            Font font = table.getFont("Label.font");
            if (font == null) {
                font = new Font("Tahoma", 0, 12);
            }
            controlFont = defaultFontSize == -1.0f ? font : new WindowsDesktopProperty("win.defaultGUI.font", font, toolkit, defaultFontSize);
        } else {
            controlFont = SecurityUtils.createFontUIResource("Tahoma", 0, defaultFontSize != -1.0f ? (int)defaultFontSize : 11);
        }
        return controlFont;
    }

    public static Object getBoldFont(Toolkit toolkit, UIDefaults table) {
        if (SystemInfo.isCJKLocale()) {
            return JideSwingUtilities.getControlFont(toolkit, table);
        }
        Object boldFont = null;
        float defaultFontSize = JideSwingUtilities.getDefaultFontSize();
        if (JideSwingUtilities.shouldUseSystemFont()) {
            Font font = table.getFont("Label.font");
            if (font == null) {
                font = new Font("Tahoma", 0, 12);
            }
            boldFont = defaultFontSize == -1.0f ? new FontUIResource(font.deriveFont(1)) : new WindowsDesktopProperty("win.defaultGUI.font", font, toolkit, defaultFontSize, 1);
        } else {
            boldFont = SecurityUtils.createFontUIResource("Tahoma", 1, defaultFontSize != -1.0f ? (int)defaultFontSize : 11);
        }
        return boldFont;
    }

    public static void drawShadow(Graphics g, Component c, int x, int y, int w, int h) {
        ShadowFactory factory = new ShadowFactory(6, 0.7f, Color.GRAY);
        BufferedImage temp = new BufferedImage(w, h, 2);
        Graphics2D g2 = temp.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.setColor(Color.BLACK);
        g2.fillRect(0, 0, temp.getWidth(), temp.getHeight());
        g2.dispose();
        BufferedImage shadow = factory.createShadow(temp);
        g.drawImage(shadow, x, y, c);
    }

    public static void drawImageBorder(Graphics g, ImageIcon img, Rectangle rect, Insets ins, boolean drawCenter) {
        int left = ins.left;
        int right = ins.right;
        int top = ins.top;
        int bottom = ins.bottom;
        int x = rect.x;
        int y = rect.y;
        int w = rect.width;
        int h = rect.height;
        g.drawImage(img.getImage(), x, y, x + left, y + top, 0, 0, left, top, null);
        g.drawImage(img.getImage(), x + left, y, x + w - right, y + top, left, 0, img.getIconWidth() - right, top, null);
        g.drawImage(img.getImage(), x + w - right, y, x + w, y + top, img.getIconWidth() - right, 0, img.getIconWidth(), top, null);
        g.drawImage(img.getImage(), x, y + top, x + left, y + h - bottom, 0, top, left, img.getIconHeight() - bottom, null);
        g.drawImage(img.getImage(), x + left, y + top, x + w - right, y + h - bottom, left, top, img.getIconWidth() - right, img.getIconHeight() - bottom, null);
        g.drawImage(img.getImage(), x + w - right, y + top, x + w, y + h - bottom, img.getIconWidth() - right, top, img.getIconWidth(), img.getIconHeight() - bottom, null);
        g.drawImage(img.getImage(), x, y + h - bottom, x + left, y + h, 0, img.getIconHeight() - bottom, left, img.getIconHeight(), null);
        g.drawImage(img.getImage(), x + left, y + h - bottom, x + w - right, y + h, left, img.getIconHeight() - bottom, img.getIconWidth() - right, img.getIconHeight(), null);
        g.drawImage(img.getImage(), x + w - right, y + h - bottom, x + w, y + h, img.getIconWidth() - right, img.getIconHeight() - bottom, img.getIconWidth(), img.getIconHeight(), null);
        if (drawCenter) {
            g.drawImage(img.getImage(), x + left, y + top, x + w - right, y + h - bottom, left, top, img.getIconWidth() - right, img.getIconHeight() - bottom, null);
        }
    }

    public static boolean compositeRequestFocus(Component component) {
        if (component instanceof Container) {
            FocusTraversalPolicy policy;
            Component comp;
            FocusTraversalPolicy policy2;
            Component comp2;
            Container container = (Container)component;
            if (container.isFocusCycleRoot() && (comp2 = (policy2 = container.getFocusTraversalPolicy()).getDefaultComponent(container)) != null) {
                comp2.requestFocus();
                return true;
            }
            Container rootAncestor = container.getFocusCycleRootAncestor();
            if (rootAncestor != null && (comp = (policy = rootAncestor.getFocusTraversalPolicy()).getComponentAfter(rootAncestor, container)) != null && SwingUtilities.isDescendingFrom(comp, container)) {
                comp.requestFocus();
                return true;
            }
        }
        if (component.isFocusable()) {
            component.requestFocus();
            return true;
        }
        return false;
    }

    public static boolean isAncestorOfFocusOwner(Component component) {
        boolean hasFocus = false;
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component == focusOwner || component instanceof Container && ((Container)component).isAncestorOf(focusOwner)) {
            hasFocus = true;
        }
        return hasFocus;
    }

    public static Window getWindow(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof Window) {
            return (Window)component;
        }
        for (Container p = component.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof Window)) continue;
            return (Window)p;
        }
        return null;
    }

    public static Window getWindowForComponent(Component parentComponent) throws HeadlessException {
        if (parentComponent == null) {
            return JOptionPane.getRootFrame();
        }
        if (parentComponent instanceof Frame || parentComponent instanceof Dialog) {
            return (Window)parentComponent;
        }
        return JideSwingUtilities.getWindowForComponent(parentComponent.getParent());
    }

    public static boolean isKeyListenerRegistered(Component component, KeyListener l) {
        KeyListener[] listeners;
        for (KeyListener listener : listeners = component.getKeyListeners()) {
            if (listener != l) continue;
            return true;
        }
        return false;
    }

    public static void insertKeyListener(Component component, KeyListener l, int index) {
        KeyListener[] listeners;
        for (KeyListener listener : listeners = component.getKeyListeners()) {
            component.removeKeyListener(listener);
        }
        for (int i = 0; i < listeners.length; ++i) {
            KeyListener listener = listeners[i];
            if (index == i) {
                component.addKeyListener(l);
            }
            component.addKeyListener(listener);
        }
        if (index > listeners.length - 1) {
            component.addKeyListener(l);
        }
    }

    public static boolean isMouseListenerRegistered(Component component, MouseListener l) {
        MouseListener[] listeners;
        for (MouseListener listener : listeners = component.getMouseListeners()) {
            if (listener != l) continue;
            return true;
        }
        return false;
    }

    public static void insertMouseListener(Component component, MouseListener l, int index) {
        MouseListener[] listeners;
        for (MouseListener listener : listeners = component.getMouseListeners()) {
            component.removeMouseListener(listener);
        }
        for (int i = 0; i < listeners.length; ++i) {
            MouseListener listener = listeners[i];
            if (index == i) {
                component.addMouseListener(l);
            }
            component.addMouseListener(listener);
        }
        if (index > listeners.length - 1) {
            component.addMouseListener(l);
        }
    }

    public static boolean isMouseMotionListenerRegistered(Component component, MouseMotionListener l) {
        MouseMotionListener[] listeners;
        for (MouseMotionListener listener : listeners = component.getMouseMotionListeners()) {
            if (listener != l) continue;
            return true;
        }
        return false;
    }

    public static void insertMouseMotionListener(Component component, MouseMotionListener l, int index) {
        MouseMotionListener[] listeners;
        for (MouseMotionListener listener : listeners = component.getMouseMotionListeners()) {
            component.removeMouseMotionListener(listener);
        }
        for (int i = 0; i < listeners.length; ++i) {
            MouseMotionListener listener = listeners[i];
            if (index == i) {
                component.addMouseMotionListener(l);
            }
            component.addMouseMotionListener(listener);
        }
        if (index > listeners.length - 1) {
            component.addMouseMotionListener(l);
        }
    }

    public static Component getScrollPane(Component innerComponent) {
        Component component = innerComponent;
        if (component.getParent() != null && component.getParent().getParent() != null && component.getParent().getParent() instanceof JScrollPane) {
            component = (JComponent)component.getParent().getParent();
            return component;
        }
        return null;
    }

    public static boolean isListenerRegistered(EventListenerList list, Class t, EventListener l) {
        Object[] objects = list.getListenerList();
        return JideSwingUtilities.isListenerRegistered(objects, t, l);
    }

    public static boolean isListenerRegistered(Component component, Class t, EventListener l) {
        Object[] objects = component.getListeners(t);
        return JideSwingUtilities.isListenerRegistered(objects, t, l);
    }

    private static boolean isListenerRegistered(Object[] objects, Class t, EventListener l) {
        for (int i = 0; i < objects.length; ++i) {
            Object listener = objects[i];
            if (!t.isAssignableFrom(listener.getClass()) || listener != l) continue;
            return true;
        }
        return false;
    }

    public static Component getFirstChildOf(final Class clazz, Component c) {
        return JideSwingUtilities.getRecursively(c, new GetHandler(){

            public boolean condition(Component c) {
                return clazz.isAssignableFrom(c.getClass());
            }

            public Component action(Component c) {
                return c;
            }
        });
    }

    public static Vector convertDefaultComboBoxModelToVector(DefaultComboBoxModel model) {
        Vector v = new Vector();
        for (int i = 0; i < model.getSize(); ++i) {
            v.add(model.getElementAt(i));
        }
        return v;
    }

    public static void ensureRowVisible(JTable table, int row) {
        Rectangle rScrollTo;
        Rectangle r = table.getVisibleRect();
        Rectangle rMid = table.getCellRect(row, 0, true);
        Rectangle rBefore = null;
        Rectangle rAfter = null;
        if (row < table.getModel().getRowCount() - 1) {
            rAfter = table.getCellRect(row + 1, 0, true);
        }
        if (row > 0) {
            rBefore = table.getCellRect(row - 1, 0, true);
        }
        int yLow = (int)rMid.getMinY();
        int yHi = (int)rMid.getMaxY();
        int xLow = r.x;
        int xHi = r.x + r.width;
        if (rBefore != null) {
            yLow = (int)rBefore.getMinY();
        }
        if (rAfter != null) {
            yHi = (int)rAfter.getMaxY();
        }
        if (!r.contains(rScrollTo = new Rectangle(xLow, yLow, xHi - xLow, yHi - yLow)) && rScrollTo.height != 0) {
            table.scrollRectToVisible(rScrollTo);
        }
    }

    public static void retargetMouseEvent(int id, MouseEvent e, Component target) {
        if (target == null || target == e.getSource()) {
            return;
        }
        if (e.isConsumed()) {
            return;
        }
        Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getX(), e.getY(), target);
        MouseEvent retargeted = new MouseEvent(target, id, e.getWhen(), e.getModifiersEx() | e.getModifiers(), p.x, p.y, e.getClickCount(), e.isPopupTrigger());
        target.dispatchEvent(retargeted);
    }

    public static JRootPane getOutermostRootPane(Component c) {
        if (c instanceof RootPaneContainer && c.getParent() == null) {
            return ((RootPaneContainer)((Object)c)).getRootPane();
        }
        JRootPane lastRootPane = null;
        while (c != null) {
            if (c instanceof JRootPane) {
                lastRootPane = (JRootPane)c;
                if (c.getParent().getParent() == null) {
                    return lastRootPane;
                }
                c = c.getParent();
            }
            c = SwingUtilities.getRootPane(c);
        }
        return null;
    }

    static {
        AA_TEXT_PROPERTY_KEY = new StringBuffer("AATextPropertyKey");
        String aa = SecurityUtils.getProperty("swing.aatext", "false");
        AA_TEXT_DEFINED = aa != null;
        AA_TEXT = "true".equals(aa);
        _setOpaqueTrueListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getSource() instanceof JComponent) {
                    ((JComponent)evt.getSource()).setOpaque(true);
                }
            }
        };
        renderingHints = null;
        if (SystemInfo.isJdk6Above()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            renderingHints = (RenderingHints)tk.getDesktopProperty("awt.font.desktophints");
            tk.addPropertyChangeListener("awt.font.desktophints", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getNewValue() instanceof RenderingHints) {
                        renderingHints = (RenderingHints)evt.getNewValue();
                    }
                }
            });
        }
        Font.getFont("defaultFont");
        Font.getFont("emphasizedFont");
    }

    public static interface GetHandler {
        public boolean condition(Component var1);

        public Component action(Component var1);
    }

    public static interface ConditionHandler
    extends Handler {
        public boolean stopCondition(Component var1);
    }

    public static interface Handler {
        public boolean condition(Component var1);

        public void action(Component var1);

        public void postAction(Component var1);
    }

    private static class GetPropertyAction
    implements PrivilegedAction {
        private String theProp;
        private String defaultVal;

        public GetPropertyAction(String theProp) {
            this.theProp = theProp;
        }

        public GetPropertyAction(String theProp, String defaultVal) {
            this.theProp = theProp;
            this.defaultVal = defaultVal;
        }

        public Object run() {
            String value = System.getProperty(this.theProp);
            return value == null ? this.defaultVal : value;
        }
    }
}

