/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.JideTabbedPaneUI;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicJideTabbedPaneUI;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.StringConverter;
import com.jidesoft.swing.TabEditingEvent;
import com.jidesoft.swing.TabEditingListener;
import com.jidesoft.utils.JideFocusTracker;
import com.jidesoft.utils.SystemInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.UIResource;

public class JideTabbedPane
extends JTabbedPane {
    private boolean _hideOneTab = false;
    private boolean _showTabButtons = false;
    private boolean _showCloseButton = false;
    private boolean _showCloseButtonOnTab = false;
    private boolean _useDefaultShowCloseButtonOnTab = false;
    private boolean _showTabArea = true;
    private boolean _showTabContent = true;
    private boolean _showIconsOnTab = true;
    private boolean _useDefaultShowIconsOnTab = true;
    private boolean _rightClickSelect;
    private boolean _dragOverDisabled;
    public static final String SHRINK_TAB_PROPERTY = "shrinkTab";
    public static final String HIDE_IF_ONE_TAB_PROPERTY = "hideIfOneTab";
    public static final String SHOW_TAB_BUTTONS_PROPERTY = "showTabButtons";
    public static final String BOX_STYLE_PROPERTY = "boxStyle";
    public static final String SHOW_ICONS_PROPERTY = "showIconsOnTab";
    public static final String USE_DEFAULT_SHOW_ICONS_PROPERTY = "useDefaultShowIconsOnTab";
    public static final String SHOW_CLOSE_BUTTON_ON_TAB_PROPERTY = "showCloseButtonOnTab";
    public static final String SHOW_CLOSE_BUTTON_PROPERTY = "showCloseButton";
    public static final String SHOW_TAB_AREA_PROPERTY = "showTabArea";
    public static final String SHOW_TAB_CONTENT_PROPERTY = "showTabContent";
    public static final String TAB_CLOSABLE_PROPERTY = "tabClosable";
    public static final String USE_DEFAULT_SHOW_CLOSE_BUTTON_ON_TAB_PROPERTY = "useDefaultShowCloseButtonOnTab";
    public static final String BOLDACTIVETAB_PROPERTY = "boldActiveTab";
    public static final String GRIPPER_PROPERTY = "gripper";
    public static final String PROPERTY_TAB_SHAPE = "tabShape";
    public static final String PROPERTY_COLOR_THEME = "colorTheme";
    public static final String PROPERTY_TAB_RESIZE_MODE = "tabResizeMode";
    public static final String PROPERTY_TAB_LEADING_COMPONENT = "tabLeadingComponent";
    public static final String PROPERTY_TAB_TRAILING_COMPONENT = "tabTrailingComponent";
    public static final String PROPERTY_TAB_COLOR_PROVIDER = "tabColorProvider";
    public static final String PROPERTY_CONTENT_BORDER_INSETS = "contentBorderInsets";
    public static final String PROPERTY_DRAG_OVER_DISABLED = "dragOverDisabled";
    private static final String uiClassID = "JideTabbedPaneUI";
    private boolean _showGripper = false;
    private StringConverter _stringConverter;
    private boolean _boldActiveTab = false;
    private Map _closableMap = new Hashtable();
    private Hashtable _pageLastFocusTrackers = new Hashtable();
    private Font _selectedTabFont;
    public static final int RESIZE_MODE_DEFAULT = 0;
    public static final int RESIZE_MODE_NONE = 1;
    public static final int RESIZE_MODE_FIT = 2;
    public static final int RESIZE_MODE_FIXED = 3;
    public static final int RESIZE_MODE_COMPRESSED = 4;
    private int _tabResizeMode = 0;
    public static final int COLOR_THEME_DEFAULT = 0;
    public static final int COLOR_THEME_WIN2K = 1;
    public static final int COLOR_THEME_OFFICE2003 = 2;
    public static final int COLOR_THEME_VSNET = 3;
    public static final int COLOR_THEME_WINXP = 4;
    private int _colorTheme = 0;
    public static final int SHAPE_DEFAULT = 0;
    public static final int SHAPE_WINDOWS = 1;
    public static final int SHAPE_VSNET = 2;
    public static final int SHAPE_BOX = 3;
    public static final int SHAPE_OFFICE2003 = 4;
    public static final int SHAPE_FLAT = 5;
    public static final int SHAPE_ECLIPSE = 6;
    public static final int SHAPE_ECLIPSE3X = 7;
    public static final int SHAPE_EXCEL = 8;
    public static final int SHAPE_ROUNDED_VSNET = 9;
    public static final int SHAPE_ROUNDED_FLAT = 10;
    public static final int SHAPE_WINDOWS_SELECTED = 11;
    private int _tabShape = 0;
    private Component _tabLeadingComponent = null;
    private Component _tabTrailingComponent = null;
    private boolean _showCloseButtonOnSelectedTab = false;
    private ListCellRenderer _tabListCellRenderer;
    private Insets _contentBorderInsets;
    private static final Logger LOGGER_EVENT = Logger.getLogger(TabEditingEvent.class.getName());
    private Action _closeAction;
    private boolean _suppressStateChangedEvents = false;
    private boolean _suppressSetSelectedIndex = false;
    private boolean _autoRequestFocus = true;
    protected transient boolean _tabEditingAllowed = false;
    private ColorProvider _tabColorProvider;
    private static Color[] ONENOTE_COLORS = new Color[]{new Color(138, 168, 228), new Color(238, 149, 151), new Color(180, 158, 222), new Color(145, 186, 174), new Color(246, 176, 120), new Color(255, 216, 105), new Color(183, 201, 151)};
    public static ColorProvider ONENOTE_COLOR_PROVIDER = new OneNoteColorProvider();
    protected PropertyChangeListener _focusChangeListener;

    public JideTabbedPane() {
        this(1, 1);
    }

    public JideTabbedPane(int tabPlacement) {
        this(tabPlacement, 1);
    }

    public JideTabbedPane(int tabPlacement, int tabLayoutPolicy) {
        super(tabPlacement, tabLayoutPolicy);
        this.setModel(new IgnoreableSingleSelectionModel());
    }

    public TabbedPaneUI getUI() {
        return (TabbedPaneUI)this.ui;
    }

    public void setUI(TabbedPaneUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        if (UIDefaultsLookup.get(uiClassID) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        this.setUI((TabbedPaneUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public boolean isShrinkTabs() {
        return this.getTabResizeMode() == 2;
    }

    public void setShrinkTabs(boolean shrinkTab) {
        boolean oldValue = this.isShrinkTabs();
        if (oldValue != shrinkTab) {
            if (shrinkTab) {
                this.setTabResizeMode(shrinkTab ? 2 : 1);
            }
            this.firePropertyChange(SHRINK_TAB_PROPERTY, oldValue, this.isShrinkTabs());
        }
    }

    public boolean isHideOneTab() {
        return !this.isShowTabButtons() && this._hideOneTab;
    }

    public void setHideOneTab(boolean hideOne) {
        boolean oldValue = this._hideOneTab;
        if (oldValue != hideOne) {
            this._hideOneTab = hideOne;
            this.firePropertyChange(HIDE_IF_ONE_TAB_PROPERTY, oldValue, this._hideOneTab);
        }
    }

    public boolean isTabShown() {
        return this.isShowTabArea() && (!this.isHideOneTab() || this.getTabCount() > 1);
    }

    public boolean isShowTabButtons() {
        return this._showTabButtons;
    }

    public void setShowTabButtons(boolean showButtons) {
        boolean oldValue = this._showTabButtons;
        if (oldValue != showButtons) {
            this._showTabButtons = showButtons;
            this.firePropertyChange(SHOW_TAB_BUTTONS_PROPERTY, oldValue, this._showTabButtons);
        }
    }

    public boolean isBoxStyleTab() {
        return this.getTabShape() == 3;
    }

    public void setBoxStyleTab(boolean boxStyleTab) {
        boolean oldValue = this.isBoxStyleTab();
        if (oldValue != boxStyleTab) {
            this.setTabShape(3);
            this.firePropertyChange(BOX_STYLE_PROPERTY, oldValue, this.isBoxStyleTab());
        }
    }

    public void setCloseAction(Action action) {
        Action old = this._closeAction;
        if (old != action) {
            this._closeAction = action;
            this.firePropertyChange("closeTabAction", old, this._closeAction);
        }
    }

    public Action getCloseAction() {
        return this._closeAction;
    }

    public void resetDefaultCloseAction() {
        this.setCloseAction(null);
    }

    protected void fireStateChanged() {
        if (!this._suppressStateChangedEvents) {
            super.fireStateChanged();
        }
    }

    public void setSelectedIndex(int index) {
        if (!this._suppressSetSelectedIndex) {
            super.setSelectedIndex(index);
        }
    }

    public boolean isAutoRequestFocus() {
        return this._autoRequestFocus;
    }

    private void setAutoRequestFocus(boolean autoRequestFocus) {
        this._autoRequestFocus = autoRequestFocus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void moveSelectedTabTo(int tabIndex) {
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex == tabIndex) {
            return;
        }
        Component selectedComponent = this.getComponentAt(selectedIndex);
        boolean old = this.isAutoRequestFocus();
        boolean shouldChangeFocus = false;
        if (selectedComponent != null && JideSwingUtilities.isAncestorOfFocusOwner(selectedComponent)) {
            shouldChangeFocus = true;
        }
        try {
            Component frame;
            this._suppressStateChangedEvents = true;
            this.setAutoRequestFocus(false);
            if (selectedIndex - tabIndex == 1 || tabIndex - selectedIndex == 1) {
                frame = this.getComponentAt(tabIndex);
                String title = this.getTitleAt(tabIndex);
                String tooltip = this.getToolTipTextAt(tabIndex);
                Icon icon = this.getIconAt(tabIndex);
                this._suppressSetSelectedIndex = true;
                try {
                    if (tabIndex > selectedIndex) {
                        this.insertTab(title, icon, frame, tooltip, selectedIndex);
                    }
                    this.insertTab(title, icon, frame, tooltip, selectedIndex + 1);
                }
                finally {
                    this._suppressSetSelectedIndex = false;
                }
            } else {
                frame = this.getComponentAt(selectedIndex);
                String title = this.getTitleAt(selectedIndex);
                String tooltip = this.getToolTipTextAt(selectedIndex);
                Icon icon = this.getIconAt(selectedIndex);
                this._suppressSetSelectedIndex = true;
                try {
                    if (tabIndex > selectedIndex) {
                        this.insertTab(title, icon, frame, tooltip, tabIndex + 1);
                    } else {
                        this.insertTab(title, icon, frame, tooltip, tabIndex);
                    }
                }
                finally {
                    this._suppressSetSelectedIndex = false;
                }
            }
            if (!SystemInfo.isJdk15Above() && tabIndex == this.getTabCount() - 2) {
                this.setSelectedIndex(this.getTabCount() - 1);
            }
            this.setAutoRequestFocus(old);
            this.setSelectedIndex(tabIndex);
            this._suppressStateChangedEvents = false;
            if (!shouldChangeFocus) return;
        }
        catch (Throwable throwable) {
            this._suppressStateChangedEvents = false;
            if (!shouldChangeFocus) throw throwable;
            Runnable runnable = new Runnable(){

                public void run() {
                    if (!JideTabbedPane.this.requestFocusForVisibleComponent()) {
                        JideTabbedPane.this.requestFocusInWindow();
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
            throw throwable;
        }
        Runnable runnable = new /* invalid duplicate definition of identical inner class */;
        SwingUtilities.invokeLater(runnable);
    }

    protected boolean requestFocusForVisibleComponent() {
        Container nearestRoot;
        Component visibleComponent = this.getSelectedComponent();
        Component lastFocused = this.getLastFocusedComponent(visibleComponent);
        if (lastFocused != null && lastFocused.requestFocusInWindow()) {
            return true;
        }
        Container container = nearestRoot = this.isFocusCycleRoot() ? this : this.getFocusCycleRootAncestor();
        if (nearestRoot == null) {
            return false;
        }
        Component comp = nearestRoot.getFocusTraversalPolicy().getComponentAfter(nearestRoot, this);
        if (comp != null && comp.requestFocusInWindow()) {
            return true;
        }
        return JideSwingUtilities.compositeRequestFocus(visibleComponent);
    }

    public int getTabHeight() {
        if (this.getTabPlacement() == 1 || this.getTabPlacement() == 3) {
            return ((JideTabbedPaneUI)this.getUI()).getTabPanel().getHeight();
        }
        return ((JideTabbedPaneUI)this.getUI()).getTabPanel().getWidth();
    }

    public boolean isRightClickSelect() {
        return this._rightClickSelect;
    }

    public void setRightClickSelect(boolean rightClickSelect) {
        this._rightClickSelect = rightClickSelect;
    }

    public int getTabAtLocation(int x, int y) {
        int tabCount = this.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            if (!this.getUI().getTabBounds(this, i).contains(x, y)) continue;
            return i;
        }
        return -1;
    }

    public boolean isShowGripper() {
        return this._showGripper;
    }

    public void setShowGripper(boolean showGripper) {
        boolean oldShowGripper = this._showGripper;
        if (oldShowGripper != showGripper) {
            this._showGripper = showGripper;
            this.firePropertyChange(GRIPPER_PROPERTY, oldShowGripper, this._showGripper);
        }
    }

    public boolean isShowIconsOnTab() {
        return this._showIconsOnTab;
    }

    public void setShowIconsOnTab(boolean showIconsOnTab) {
        boolean oldShowIconsOnTab = this._showIconsOnTab;
        if (oldShowIconsOnTab != showIconsOnTab) {
            this._showIconsOnTab = showIconsOnTab;
            this.firePropertyChange(SHOW_ICONS_PROPERTY, oldShowIconsOnTab, this._showIconsOnTab);
        }
    }

    public boolean isUseDefaultShowIconsOnTab() {
        return this._useDefaultShowIconsOnTab;
    }

    public void setUseDefaultShowIconsOnTab(boolean useDefaultShowIconsOnTab) {
        boolean oldUseDefaultShowIconsOnTab = this._useDefaultShowIconsOnTab;
        if (oldUseDefaultShowIconsOnTab != useDefaultShowIconsOnTab) {
            this._useDefaultShowIconsOnTab = useDefaultShowIconsOnTab;
            this.firePropertyChange(USE_DEFAULT_SHOW_ICONS_PROPERTY, oldUseDefaultShowIconsOnTab, this._useDefaultShowIconsOnTab);
        }
    }

    public boolean isShowCloseButtonOnTab() {
        return this._showCloseButtonOnTab;
    }

    public void setShowCloseButtonOnTab(boolean showCloseButtonOnTab) {
        boolean oldShowCloseButtonOnTab = this._showCloseButtonOnTab;
        if (oldShowCloseButtonOnTab != showCloseButtonOnTab) {
            this._showCloseButtonOnTab = showCloseButtonOnTab;
            this.firePropertyChange(SHOW_CLOSE_BUTTON_ON_TAB_PROPERTY, oldShowCloseButtonOnTab, this._showCloseButtonOnTab);
        }
    }

    public boolean isUseDefaultShowCloseButtonOnTab() {
        return this._useDefaultShowCloseButtonOnTab;
    }

    public void setUseDefaultShowCloseButtonOnTab(boolean useDefaultShowCloseButtonOnTab) {
        boolean oldUseDefaultShowCloseButtonOnTab = this._useDefaultShowCloseButtonOnTab;
        if (oldUseDefaultShowCloseButtonOnTab != useDefaultShowCloseButtonOnTab) {
            this._useDefaultShowCloseButtonOnTab = useDefaultShowCloseButtonOnTab;
            this.firePropertyChange(USE_DEFAULT_SHOW_CLOSE_BUTTON_ON_TAB_PROPERTY, oldUseDefaultShowCloseButtonOnTab, this._useDefaultShowCloseButtonOnTab);
        }
    }

    public void setTabEditingAllowed(boolean allowed) {
        this._tabEditingAllowed = allowed;
    }

    public boolean isTabEditingAllowed() {
        return this._tabEditingAllowed && this.getTabLayoutPolicy() == 1;
    }

    public boolean isShowCloseButton() {
        return this._showCloseButton;
    }

    public void setShowCloseButton(boolean showCloseButton) {
        boolean oldShowCloseButton = this._showCloseButton;
        if (oldShowCloseButton != showCloseButton) {
            this._showCloseButton = showCloseButton;
            this.firePropertyChange(SHOW_CLOSE_BUTTON_PROPERTY, oldShowCloseButton, this._showCloseButton);
        }
    }

    public boolean isShowTabArea() {
        return this._showTabArea;
    }

    public void setShowTabArea(boolean showTabArea) {
        boolean oldShowTabArea = this._showTabArea;
        if (oldShowTabArea != showTabArea) {
            this._showTabArea = showTabArea;
            this.firePropertyChange(SHOW_TAB_AREA_PROPERTY, oldShowTabArea, this._showTabArea);
        }
    }

    public boolean isShowTabContent() {
        return this._showTabContent;
    }

    public void setShowTabContent(boolean showTabContent) {
        boolean oldShowTabContent = this._showTabContent;
        if (oldShowTabContent != showTabContent) {
            this._showTabContent = showTabContent;
            this.firePropertyChange(SHOW_TAB_CONTENT_PROPERTY, oldShowTabContent, this._showTabContent);
        }
    }

    public StringConverter getStringConverter() {
        return this._stringConverter;
    }

    public void setStringConverter(StringConverter stringConverter) {
        this._stringConverter = stringConverter;
    }

    public String getDisplayTitleAt(int index) {
        if (this._stringConverter != null) {
            return this._stringConverter.convert(super.getTitleAt(index));
        }
        return super.getTitleAt(index);
    }

    public boolean isBoldActiveTab() {
        return this._boldActiveTab;
    }

    public void setBoldActiveTab(boolean boldActiveTab) {
        boolean old = this._boldActiveTab;
        if (old != boldActiveTab) {
            this._boldActiveTab = boldActiveTab;
            this.firePropertyChange(BOLDACTIVETAB_PROPERTY, old, this._boldActiveTab);
        }
    }

    public void removeTabAt(int index) {
        int tabCount = this.getTabCount();
        int selected = this.getSelectedIndex();
        boolean enforce = false;
        if (selected == index && selected < tabCount - 1) {
            enforce = true;
        }
        boolean contains = false;
        String titleAt = this.getTitleAt(index);
        if (this._closableMap.containsKey(titleAt)) {
            contains = true;
        }
        Component component = this.getComponentAt(index);
        super.removeTabAt(index);
        if (contains) {
            this._closableMap.remove(titleAt);
        }
        if (component != null) {
            PageLastFocusTracker tracker = (PageLastFocusTracker)this._pageLastFocusTrackers.get(component);
            this._pageLastFocusTrackers.remove(component);
            if (tracker != null) {
                tracker.setHeighestComponent(null);
            }
        }
        if (enforce) {
            try {
                this.fireStateChanged();
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
    }

    public void setTitleAt(int index, String title) {
        boolean contains = false;
        if (this._closableMap.containsKey(this.getTitleAt(index))) {
            contains = true;
        }
        super.setTitleAt(index, title);
        if (contains) {
            this._closableMap.put(title, "");
        }
    }

    public boolean isTabClosableAt(int tabIndex) {
        return !this._closableMap.containsKey(tabIndex);
    }

    public void setTabClosableAt(int tabIndex, boolean closble) {
        if (closble) {
            this._closableMap.remove(tabIndex);
        } else {
            this._closableMap.put(tabIndex, Boolean.FALSE);
        }
        this.firePropertyChange(TAB_CLOSABLE_PROPERTY, !closble, closble);
    }

    protected Hashtable getPageLastFocusTrackers() {
        return this._pageLastFocusTrackers;
    }

    public Component getLastFocusedComponent(Component pageComponent) {
        if (pageComponent == null) {
            return null;
        }
        PageLastFocusTracker tracker = (PageLastFocusTracker)this.getPageLastFocusTrackers().get(pageComponent);
        return tracker != null ? tracker.getLastFocusedComponent() : null;
    }

    public void insertTab(String title, Icon icon, Component component, String tip, int index) {
        super.insertTab(title, icon, component, tip, index);
        if (component != null) {
            this._pageLastFocusTrackers.put(component, new PageLastFocusTracker(component));
        }
    }

    public Font getSelectedTabFont() {
        return this._selectedTabFont;
    }

    public void setSelectedTabFont(Font selectedTabFont) {
        this._selectedTabFont = selectedTabFont;
    }

    public int getColorTheme() {
        if (this._colorTheme == 0) {
            return this.getDefaultColorTheme();
        }
        return this._colorTheme;
    }

    public int getDefaultColorTheme() {
        return UIDefaultsLookup.getInt("JideTabbedPane.defaultTabColorTheme");
    }

    public void setColorTheme(int colorTheme) {
        int old = this._colorTheme;
        if (old != colorTheme) {
            this._colorTheme = colorTheme;
            this.firePropertyChange(PROPERTY_COLOR_THEME, old, colorTheme);
        }
    }

    public int getTabResizeMode() {
        if (this._tabResizeMode == 0) {
            return this.getDefaultTabResizeMode();
        }
        return this._tabResizeMode;
    }

    public void setTabResizeMode(int resizeMode) {
        int old = this._tabResizeMode;
        if (old != resizeMode) {
            this._tabResizeMode = resizeMode;
            this.firePropertyChange(PROPERTY_TAB_RESIZE_MODE, old, resizeMode);
        }
    }

    public int getDefaultTabResizeMode() {
        return UIDefaultsLookup.getInt("JideTabbedPane.defaultResizeMode");
    }

    public int getTabShape() {
        if (this._tabShape == 0) {
            return this.getDefaultTabStyle();
        }
        return this._tabShape;
    }

    public int getDefaultTabStyle() {
        return UIDefaultsLookup.getInt("JideTabbedPane.defaultTabShape");
    }

    public void setTabShape(int tabShape) {
        int old = this._tabShape;
        if (old != tabShape) {
            this._tabShape = tabShape;
            this.firePropertyChange(PROPERTY_TAB_SHAPE, old, this._tabShape);
        }
    }

    public void setTabLeadingComponent(Component component) {
        if (component != null) {
            if (!(component instanceof UIResource)) {
                throw new IllegalArgumentException("TabLeadingComponent must implement javax.swing.plaf.UIResource interface.");
            }
            component.setSize(component.getPreferredSize());
            component.setVisible(true);
        }
        Component old = this._tabLeadingComponent;
        this._tabLeadingComponent = component;
        this.firePropertyChange(PROPERTY_TAB_LEADING_COMPONENT, old, component);
    }

    public Component getTabLeadingComponent() {
        return this._tabLeadingComponent;
    }

    public void setTabTrailingComponent(Component component) {
        if (component != null) {
            if (!(component instanceof UIResource)) {
                throw new IllegalArgumentException("TabLeadingComponent must implement javax.swing.plaf.UIResource interface.");
            }
            component.setSize(component.getPreferredSize());
            component.setVisible(true);
        }
        Component old = this._tabTrailingComponent;
        this._tabTrailingComponent = component;
        this.firePropertyChange(PROPERTY_TAB_TRAILING_COMPONENT, old, component);
    }

    public Component getTabTrailingComponent() {
        return this._tabTrailingComponent;
    }

    public boolean isShowCloseButtonOnSelectedTab() {
        return this._showCloseButtonOnSelectedTab;
    }

    public void setShowCloseButtonOnSelectedTab(boolean i) {
        this._showCloseButtonOnSelectedTab = i;
    }

    public ColorProvider getTabColorProvider() {
        return this._tabColorProvider;
    }

    public void setTabColorProvider(ColorProvider tabColorProvider) {
        ColorProvider old = this._tabColorProvider;
        if (old != tabColorProvider) {
            this._tabColorProvider = tabColorProvider;
            this.firePropertyChange(PROPERTY_TAB_COLOR_PROVIDER, old, tabColorProvider);
        }
    }

    public void editTabAt(int tabIndex) {
        boolean started = ((JideTabbedPaneUI)this.getUI()).editTabAt(tabIndex);
        if (started) {
            this.fireTabEditing(3299, tabIndex, this.getTitleAt(tabIndex), null);
        }
    }

    public boolean isTabEditing() {
        return ((JideTabbedPaneUI)this.getUI()).isTabEditing();
    }

    public void stopTabEditing() {
        int tabIndex = this.getEditingTabIndex();
        if (tabIndex != -1) {
            String oldTitle = this.getTitleAt(tabIndex);
            ((JideTabbedPaneUI)this.getUI()).stopTabEditing();
            String newTitle = this.getTitleAt(tabIndex);
            this.fireTabEditing(3300, tabIndex, oldTitle, newTitle);
        }
    }

    public void cancelTabEditing() {
        int tabIndex = this.getEditingTabIndex();
        if (tabIndex != -1) {
            ((JideTabbedPaneUI)this.getUI()).cancelTabEditing();
            this.fireTabEditing(3299, tabIndex, this.getTitleAt(tabIndex), this.getTitleAt(tabIndex));
        }
    }

    public int getEditingTabIndex() {
        return ((JideTabbedPaneUI)this.getUI()).getEditingTabIndex();
    }

    protected PropertyChangeListener createFocusChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                boolean hasFocus;
                boolean hadFocus = JideTabbedPane.this.isAncestorOf((Component)evt.getOldValue()) || JideTabbedPane.this == evt.getOldValue();
                boolean bl = hasFocus = JideTabbedPane.this == evt.getNewValue() || JideTabbedPane.this.hasFocusComponent();
                if (hasFocus != hadFocus) {
                    JideTabbedPane.this.repaintTabAreaAndContentBorder();
                }
            }
        };
    }

    public void repaintTabAreaAndContentBorder() {
        Insets contentinsets;
        int delay = 200;
        ((JideTabbedPaneUI)this.getUI()).getTabPanel().repaint(delay);
        if (UIDefaultsLookup.get("JideTabbedPane.contentBorderInsets") == null) {
            LookAndFeelFactory.installJideExtension();
        }
        if ((contentinsets = UIDefaultsLookup.getInsets("JideTabbedPane.contentBorderInsets")) != null && (contentinsets.top != 0 || contentinsets.bottom != 0 || contentinsets.left != 0 || contentinsets.right != 0)) {
            Insets insets = new Insets(0, 0, 0, 0);
            BasicJideTabbedPaneUI.rotateInsets(contentinsets, insets, this.tabPlacement);
            if (insets.top != 0) {
                this.repaint(delay, 0, 0, this.getWidth(), insets.top);
            }
            if (insets.left != 0) {
                this.repaint(delay, 0, 0, insets.left, this.getHeight());
            }
            if (insets.right != 0) {
                this.repaint(delay, this.getWidth() - insets.right, 0, insets.right, this.getHeight());
            }
            if (insets.bottom != 0) {
                this.repaint(delay, 0, this.getHeight() - insets.bottom, this.getWidth(), insets.bottom);
            }
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this._focusChangeListener == null) {
            this._focusChangeListener = this.createFocusChangeListener();
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this._focusChangeListener);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        if (this._focusChangeListener != null) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("focusOwner", this._focusChangeListener);
            this._focusChangeListener = null;
        }
    }

    public ListCellRenderer getTabListCellRenderer() {
        if (this._tabListCellRenderer != null) {
            return this._tabListCellRenderer;
        }
        return new TabListCellRenderer();
    }

    public void setTabListCellRenderer(ListCellRenderer tabListCellRenderer) {
        this._tabListCellRenderer = tabListCellRenderer;
    }

    public boolean hasFocusComponent() {
        return JideSwingUtilities.isAncestorOfFocusOwner(this);
    }

    public Insets getContentBorderInsets() {
        return this._contentBorderInsets;
    }

    public void setContentBorderInsets(Insets contentBorderInsets) {
        Insets old = this._contentBorderInsets;
        this._contentBorderInsets = contentBorderInsets;
        this.firePropertyChange(PROPERTY_CONTENT_BORDER_INSETS, old, this._contentBorderInsets);
    }

    public boolean isDragOverDisabled() {
        return this._dragOverDisabled;
    }

    public void setDragOverDisabled(boolean dragOverDisabled) {
        boolean old = this._dragOverDisabled;
        if (old != dragOverDisabled) {
            this._dragOverDisabled = dragOverDisabled;
            this.firePropertyChange(PROPERTY_DRAG_OVER_DISABLED, old, dragOverDisabled);
        }
    }

    public void scrollSelectedTabToVisible(boolean scrollLeft) {
        ((JideTabbedPaneUI)this.getUI()).ensureActiveTabIsVisible(scrollLeft);
    }

    public void addTabEditingListener(TabEditingListener l) {
        this.listenerList.add(TabEditingListener.class, l);
    }

    public void removeTabEditingListener(TabEditingListener l) {
        this.listenerList.remove(TabEditingListener.class, l);
    }

    public TabEditingListener[] getTabEditingListeners() {
        return (TabEditingListener[])this.listenerList.getListeners(TabEditingListener.class);
    }

    protected void fireTabEditing(int id, int index, String oldTitle, String newTitle) {
        if (LOGGER_EVENT.isLoggable(Level.FINE)) {
            switch (id) {
                case 3299: {
                    LOGGER_EVENT.fine("TabEditing Started at tab \"" + index + "\"; the current title is " + oldTitle);
                    break;
                }
                case 3300: {
                    LOGGER_EVENT.fine("TabEditing Stopped at tab \"" + index + "\"; the old title is " + oldTitle + "; the new title is " + newTitle);
                    break;
                }
                case 3301: {
                    LOGGER_EVENT.fine("TabEditing Cancelled at tab \"" + index + "\"; the current title remains " + oldTitle);
                }
            }
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TabEditingListener.class) continue;
            TabEditingEvent tabEditingEvent = new TabEditingEvent(this, id, index, oldTitle, newTitle);
            if (id == 3299) {
                ((TabEditingListener)listeners[i + 1]).editingStarted(tabEditingEvent);
                continue;
            }
            if (id == 3301) {
                ((TabEditingListener)listeners[i + 1]).editingCanceled(tabEditingEvent);
                continue;
            }
            if (id != 3300) continue;
            ((TabEditingListener)listeners[i + 1]).editingStopped(tabEditingEvent);
        }
    }

    public static class TabListCellRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof JideTabbedPane) {
                JideTabbedPane tabbedPane = (JideTabbedPane)value;
                String title = tabbedPane.getTitleAt(index);
                String tooltip = tabbedPane.getToolTipTextAt(index);
                Icon icon = tabbedPane.getIconAt(index);
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, title, index, isSelected, cellHasFocus);
                label.setToolTipText(tooltip);
                label.setIcon(icon);
                label.setEnabled(tabbedPane.isEnabledAt(index));
                return label;
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }

    private static class OneNoteColorProvider
    implements ColorProvider {
        private OneNoteColorProvider() {
        }

        public Color getBackgroundAt(int index) {
            return ONENOTE_COLORS[index % ONENOTE_COLORS.length];
        }

        public Color getForegroudAt(int index) {
            return Color.BLACK;
        }

        public float getGradientRatio(int tabIndex) {
            return 0.86f;
        }
    }

    public static interface GradientColorProvider
    extends ColorProvider {
        public Color getTopBackgroundAt(int var1);
    }

    public static interface ColorProvider {
        public Color getBackgroundAt(int var1);

        public Color getForegroudAt(int var1);

        public float getGradientRatio(int var1);
    }

    protected class PageLastFocusTracker
    extends JideFocusTracker {
        private Component _lastFocusedComponent;
        private FocusListener _lastFocusedListener;

        protected PageLastFocusTracker(Component pageComp) {
            this.setHeighestComponent(pageComp);
        }

        protected Component getLastFocusedComponent() {
            return this._lastFocusedComponent;
        }

        public void setHeighestComponent(Component compHeighest) {
            if (compHeighest == null) {
                if (this._lastFocusedListener != null) {
                    this.removeFocusListener(this._lastFocusedListener);
                    this._lastFocusedListener = null;
                }
            } else if (this._lastFocusedListener == null) {
                this._lastFocusedListener = new FocusAdapter(){

                    public void focusGained(FocusEvent e) {
                        PageLastFocusTracker.this._lastFocusedComponent = e.getComponent();
                    }
                };
                this.addFocusListener(this._lastFocusedListener);
            }
            super.setHeighestComponent(compHeighest);
        }
    }

    class IgnoreableSingleSelectionModel
    extends DefaultSingleSelectionModel {
        IgnoreableSingleSelectionModel() {
        }

        protected void fireStateChanged() {
            if (!JideTabbedPane.this._suppressStateChangedEvents) {
                super.fireStateChanged();
            }
        }
    }
}

