/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideButton;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;

public class JideToggleButton
extends JideButton
implements Accessible {
    public JideToggleButton() {
        this(null, null, false);
    }

    public JideToggleButton(Icon icon) {
        this(null, icon, false);
    }

    public JideToggleButton(Icon icon, boolean selected) {
        this(null, icon, selected);
    }

    public JideToggleButton(String text) {
        this(text, null, false);
    }

    public JideToggleButton(String text, boolean selected) {
        this(text, null, selected);
    }

    public JideToggleButton(Action a) {
        this();
        this.setAction(a);
    }

    public JideToggleButton(String text, Icon icon) {
        this(text, icon, false);
    }

    public JideToggleButton(String text, Icon icon, boolean selected) {
        this.setModel(new ToggleButtonModel());
        this.model.setSelected(selected);
        this.init(text, icon);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJToggleButton();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJToggleButton
    extends AbstractButton.AccessibleAbstractButton
    implements ItemListener {
        public AccessibleJToggleButton() {
            super(JideToggleButton.this);
            JideToggleButton.this.addItemListener(this);
        }

        public void itemStateChanged(ItemEvent e) {
            JideToggleButton tb = (JideToggleButton)e.getSource();
            if (JideToggleButton.this.accessibleContext != null) {
                if (tb.isSelected()) {
                    JideToggleButton.this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.CHECKED);
                } else {
                    JideToggleButton.this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.CHECKED, null);
                }
            }
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TOGGLE_BUTTON;
        }
    }

    public static class ToggleButtonModel
    extends DefaultButtonModel {
        public boolean isSelected() {
            return (this.stateMask & 2) != 0;
        }

        public void setSelected(boolean b) {
            ButtonGroup group = this.getGroup();
            if (group != null) {
                group.setSelected(this, b);
                b = group.isSelected(this);
            }
            if (this.isSelected() == b) {
                return;
            }
            this.stateMask = b ? (this.stateMask |= 2) : (this.stateMask &= 0xFFFFFFFD);
            this.fireStateChanged();
            this.fireItemStateChanged(new ItemEvent(this, 701, this, this.isSelected() ? 1 : 2));
        }

        public void setPressed(boolean b) {
            if (this.isPressed() == b || !this.isEnabled()) {
                return;
            }
            if (!b && this.isArmed()) {
                this.setSelected(!this.isSelected());
            }
            this.stateMask = b ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
            this.fireStateChanged();
            if (!this.isPressed() && this.isArmed()) {
                int modifiers = 0;
                AWTEvent currentEvent = EventQueue.getCurrentEvent();
                if (currentEvent instanceof InputEvent) {
                    modifiers = ((InputEvent)currentEvent).getModifiers();
                } else if (currentEvent instanceof ActionEvent) {
                    modifiers = ((ActionEvent)currentEvent).getModifiers();
                }
                this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand(), EventQueue.getMostRecentEventTime(), modifiers));
            }
        }
    }
}

